<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$shopLogoFrm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$shopLogoFrm->developerTags['colClassPrefix'] = 'col-md-';
$shopLogoFrm->developerTags['fld_default_col'] = 12;
$ratioFld = $shopLogoFrm->getField('ratio_type');
$ratioFld->addFieldTagAttribute('class', 'prefRatio-js');
$ratioFld->addOptionListTagAttribute('class', 'list-radio');
$fld = $shopLogoFrm->getField('shop_logo');
$fld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld->addFieldTagAttribute('onChange', 'logoPopupImage(this)');
$langFld = $shopLogoFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'logo-language-js');

$preferredDimensionsStr = '<span class="gap"></span><small class="text--small form-text text-muted logoPreferredDimensions-js">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' 150 x 150' . '</small>';

$htmlAfterField = $preferredDimensionsStr;
$htmlAfterField .= '<div id="logo-image-listing"></div>';
$fld->htmlAfterField = $htmlAfterField;

$shopBannerFrm->setFormTagAttribute('class', 'form web_form  form_horizontal');
$shopBannerFrm->developerTags['colClassPrefix'] = 'col-md-';
$shopBannerFrm->developerTags['fld_default_col'] = 12;
$fld = $shopBannerFrm->getField('shop_banner');
$fld->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld->addFieldTagAttribute('onChange', 'bannerPopupImage(this)');
$langFld = $shopBannerFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'banner-language-js');
$screenFld = $shopBannerFrm->getField('slide_screen');
$screenFld->addFieldTagAttribute('class', 'prefDimensions-js');

$htmlAfterField = '<small  class="preferredDimensions-js form-text text-muted">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' 2000 x 500' . '</small>';
$htmlAfterField .= '<div id="banner-image-listing"></div>';
$fld->htmlAfterField = $htmlAfterField;

$recordId = $shop_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'shopForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'addShopLangForm(' . $recordId . ',' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . ')',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'shopMediaForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_MEDIA', $adminLangId),
        'isActive' => true
    ],
    [
        'attr' => [
            'onclick' => 'shopCollections(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Collections', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Collections', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'href' => 'javascript:void(0)',
            'onclick' => 'shopAgreement(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Shop_Agreement', $adminLangId),
        'isActive' => false
    ]
];
$formTitle = Labels::getLabel('LBL_Shop_Media_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');

?>
<div class="col-sm-12">
    <?php
    /* [ MEDIA INSTRUCTIONS START HERE */
    $tpl = new FatTemplate('', '');
    $tpl->set('adminLangId', $adminLangId);
    echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
    /* ] */ ?>
</div>
<div class="form-section">
    <?php echo $shopLogoFrm->getFormHtml(); ?>
</div>
<div class="form-section mt-4">
    <?php echo $shopBannerFrm->getFormHtml(); ?>
</div>
<script>
    $('input[name=banner_min_width]').val(2000);
    $('input[name=banner_min_height]').val(500);
    $('input[name=logo_min_width]').val(150);
    $('input[name=logo_min_height]').val(150);
    var ratioTypeSquare = <?php echo AttachedFile::RATIO_TYPE_SQUARE; ?>;
    var ratioTypeRectangular = <?php echo AttachedFile::RATIO_TYPE_RECTANGULAR; ?>;
    var aspectRatio = 4 / 1;
    $(document).on('change', '.prefDimensions-js', function () {
        var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
        var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

        if ($(this).val() == screenDesktop) {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 2000 x 500');
            $('input[name=banner_min_width]').val(2000);
            $('input[name=banner_min_height]').val(500);
            aspectRatio = 4 / 1;
        } else if ($(this).val() == screenIpad) {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 1024 x 360');
            $('input[name=banner_min_width]').val(1024);
            $('input[name=banner_min_height]').val(360);
            aspectRatio = 128 / 45;
        } else {
            $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 640 x 360');
            $('input[name=banner_min_width]').val(640);
            $('input[name=banner_min_height]').val(360);
            aspectRatio = 16 / 9;
        }
    });

    $(document).on('change', '.prefRatio-js', function () {
        if ($(this).val() == ratioTypeSquare) {
            $('input[name=logo_min_width]').val(150);
            $('input[name=logo_min_height]').val(150);
            $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 150 x 150');
        } else {
            $('input[name=logo_min_width]').val(150);
            $('input[name=logo_min_height]').val(85);
            $('.logoPreferredDimensions-js').html(langLbl.preferredDimensions + ' 150 x 85');
        }
    });
</script>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>