<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'scollection_identifier' => Labels::getLabel('LBL_Collection_Name', $adminLangId),
    'scollection_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement(
    'table',
    array('width' => '100%', 'class' => 'table table--orders table-justified', 'id' => 'options')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else {
        $th->appendElement('th', array(), $val);
    }
}
$sr_no = 0;
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');
    $tr->setAttribute("id", $row['scollection_id']);

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="scollection_ids[]" value=' . $row['scollection_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'scollection_identifier':
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
            case 'scollection_active':
                // $activeInactiveArr = applicationConstants::getActiveInactiveArr($adminLangId);

                $active = "";
                if ($row['scollection_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleCollectionStatus(event,this,' . applicationConstants::YES . ')' : 'toggleCollectionStatus(event,this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                     <input ' . $active . ' type="checkbox" id="switch' . $row['scollection_id'] . '" value="' . $row['scollection_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                    </label>';
                $td->appendElement('plaintext', array(), $str, true);
                break;

                // $td->appendElement('plaintext', array(), $activeInactiveArr[$row[$key]], true);
                break;
            case 'action':
                $actionArr = [
                    [
                        "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                        "onclick" => "getShopCollectionGeneralForm(" . $shopId . "," . $row['scollection_id'] . ")"
                    ],
                    [
                        "title" => Labels::getLabel('LBL_Delete', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                        "onclick" => "deleteShopCollection(" . $shopId . "," . $row['scollection_id'] . ")"
                    ]
                ];
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $key, false]);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}
if (count($arr_listing) == 0) { ?>
    <div class="card-head nopadding">
        <h4><?php echo Labels::getLabel('LBL_No_Collection_found', $adminLangId); ?></h4>
        <a href="javascript:void(0);" class="btn-default btn btn-brand btn-sm"
            onclick="getShopCollectionGeneralForm(<?php echo $shopId; ?>, 0)"><?php echo Labels::getLabel('LBL_Add_Collection', $adminLangId); ?></a>
    </div>
<?php } else { ?>
    <div class="card-head nopadding">
        <h4><?php echo Labels::getLabel('LBL_Shop_Collections', $adminLangId); ?></h4>
        <?php
        if ($canEdit) {
            $data = [
                'adminLangId' => $adminLangId,
                'otherButtons' => [
                    [
                        'attr' => [
                            'href' => 'javascript:void(0)',
                            'onclick' => "getShopCollectionGeneralForm(" . $shopId . ", 0)",
                            'title' => Labels::getLabel('LBL_Add_New_Collection', $adminLangId)
                        ],
                        'label' => '<svg class="svg bi-plus-circle" xmlns="http://www.w3.org/2000/svg" width="18" height="18" fill="currentColor" viewBox="0 0 16 16">
                                    <path d="M8 15A7 7 0 1 1 8 1a7 7 0 0 1 0 14m0 1A8 8 0 1 0 8 0a8 8 0 0 0 0 16"></path>
                                    <path d="M8 4a.5.5 0 0 1 .5.5v3h3a.5.5 0 0 1 0 1h-3v3a.5.5 0 0 1-1 0v-3h-3a.5.5 0 0 1 0-1h3v-3A.5.5 0 0 1 8 4"></path>
                                </svg>'
                    ]
                ]
            ];

            $this->includeTemplate('_partial/action-buttons.php', $data, false);
        }
        ?>
    </div>
    <?php
    $frm = new Form('frmCollectionsListing', array('id' => 'frmCollectionsListing'));
    $frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
    $frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadCollectionList ); return(false);');
    $frm->setFormTagAttribute('action', UrlHelper::generateUrl('Shops', 'toggleBulkCollectionStatuses'));
    $frm->addHiddenField('', 'status', '');
    $frm->addHiddenField('', 'collection_shopId', $shopId);

    echo $frm->getFormTag();
    echo $frm->getFieldHtml('status');
    echo $frm->getFieldHtml('collection_shopId');
    echo $tbl->getHtml(); ?>
    </form>
<?php } ?>