<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$slideMediaFrm->setFormTagAttribute('class', 'form web_form form_horizontal');
$slideMediaFrm->developerTags['colClassPrefix'] = 'col-md-';
$slideMediaFrm->developerTags['fld_default_col'] = 12;

$fld1 = $slideMediaFrm->getField('slide_image');
$fld1->addFieldTagAttribute('class', 'btn btn-brand btn-sm');
$fld1->addFieldTagAttribute('onChange', 'popupImage(this)');
$screenFld = $slideMediaFrm->getField('slide_screen');
$screenFld->addFieldTagAttribute('class', 'prefDimensions-js');
$langFld = $slideMediaFrm->getField('lang_id');
$langFld->addFieldTagAttribute('class', 'language-js');

$htmlAfterField = '<div class="preferredDimensions-js form-text text-muted">' . Labels::getLabel('LBL_Preferred_Dimensions', $adminLangId) . ' ' . $dimenssionSizeArr["width"] . ' x ' . $dimenssionSizeArr["height"] . '</div>';

$htmlAfterField .= '<div class="mt-3" id="image-listing"></div>';
$fld1->htmlAfterField = $htmlAfterField;
$frm = $slideMediaFrm;
$recordId = (int) $slide_id;
$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'slideForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => false,
        'isPrimary' => true
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'slideLangForm("' . $recordId . '","' . FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1) . '")' : '',
            'title' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Language_Data', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => (0 < $recordId) ? 'slideMediaForm("' . $recordId . '")' : '',
            'title' => Labels::getLabel('LBL_Media', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Media', $adminLangId),
        'isActive' => true
    ],
];
$formTitle = Labels::getLabel('LBL_Slide_Image_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<div class="">
    <div id="cropperBox-js"></div>
    <div id="mediaForm-js">
        <?php
        /* [ MEDIA INSTRUCTIONS START HERE */
        $tpl = new FatTemplate('', '');
        $tpl->set('adminLangId', $adminLangId);
        echo $tpl->render(false, false, '_partial/imageUploadInstructions.php', true, true);
        /* ] */
        ?>
        <?php echo $slideMediaFrm->getFormHtml(); ?>
    </div>
    <script>
        $('input[name=banner_min_width]').val(<?php echo $dimenssionSizeArr['width']; ?>);
        $('input[name=banner_min_height]').val(<?php echo $dimenssionSizeArr['height']; ?>);
        var aspectRatio = <?php echo $dimenssionSizeArr['width'] / $dimenssionSizeArr['height']; ?>;
        $(document).on('change', '.prefDimensions-js', function () {
            var screenDesktop = <?php echo applicationConstants::SCREEN_DESKTOP ?>;
            var screenIpad = <?php echo applicationConstants::SCREEN_IPAD ?>;

            if ($(this).val() == screenDesktop) {
               /* $('.preferredDimensions-js').html((langLbl.preferredDimensions).replace(/%s/g,
                    "<?php //echo $dimenssionSizeArr['width']; ?> x <?php //echo $dimenssionSizeArr['height']; ?>"
                )); */
                $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' ' + "<?php echo $dimenssionSizeArr['width']; ?> x <?php echo $dimenssionSizeArr['height']; ?>");

                $('input[name=banner_min_width]').val(<?php echo $dimenssionSizeArr['width']; ?>);
                $('input[name=banner_min_height]').val(<?php echo $dimenssionSizeArr['height']; ?>);
                aspectRatio = <?php echo $dimenssionSizeArr['width']; ?> /
                    <?php echo $dimenssionSizeArr['height']; ?>;
            } else if ($(this).val() == screenIpad) {
                $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 1024 x 576');
                $('input[name=banner_min_width]').val(1024);
                $('input[name=banner_min_height]').val(576);
                aspectRatio = 1024 / 576;
            } else {
                $('.preferredDimensions-js').html(langLbl.preferredDimensions + ' 640 x 360');
                $('input[name=banner_min_width]').val(640);
                $('input[name=banner_min_height]').val(360);
                aspectRatio = 640 / 360;
            }
        });
    </script>
</div>

<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>