<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'user' => Labels::getLabel('LBL_User', $adminLangId),
    'ureq_type' => Labels::getLabel('LBL_Request_Type', $adminLangId),
    'ureq_date' => Labels::getLabel('LBL_Request_Date', $adminLangId),
    'ureq_status' => Labels::getLabel('LBL_Request_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user':
                $userDetail = '<strong>' . Labels::getLabel('LBL_N:', $adminLangId) . ' </strong>' . "<a href='javascript:void(0)' onclick='redirectfunc(\"" . UrlHelper::generateUrl('Users') . "\", " . $row['user_id'] . ")'>" . $row['user_name'] . "</a>" . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_UN:', $adminLangId) . ' </strong>' . $row['credential_username'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_Email:', $adminLangId) . ' </strong>' . $row['credential_email'] . '<br/>';
                $userDetail .= '<strong>' . Labels::getLabel('LBL_User_ID:', $adminLangId) . ' </strong>' . $row['user_id'] . '<br/>';
                $td->appendElement('plaintext', array(), $userDetail, true);
                break;
            case 'ureq_date':
                $date = FatDate::format(
                    $row[$key],
                    true,
                    true,
                    FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                );
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'ureq_type':

                $str = $userRequestTypeArr[UserGdprRequest::TYPE_DATA_REQUEST];
                if ($row['ureq_type'] == UserGdprRequest::TYPE_TRUNCATE) {
                    $str = $userRequestTypeArr[UserGdprRequest::TYPE_TRUNCATE];
                }

                $td->appendElement('plaintext', array(), $str, true);

                break;
            case 'ureq_status':
                $str = $userRequestStatusArr[UserGdprRequest::STATUS_PENDING];
                if ($row['ureq_status'] == UserGdprRequest::STATUS_COMPLETE) {
                    $str = $userRequestStatusArr[UserGdprRequest::STATUS_COMPLETE];
                }
                $status = HtmlHelper::getStatusHtml($row['ureq_status'], $str);
                $td->appendElement('plaintext', [], $status, true);

                //  $td->appendElement('plaintext', array(), $str, true);

                break;
            case 'action':
                $actionArr = [];
                if ($canEdit && ($row['ureq_type'] == UserGdprRequest::TYPE_TRUNCATE || $row['ureq_type'] == UserGdprRequest::TYPE_DATA_REQUEST)) {
                    if ($row['ureq_status'] == UserGdprRequest::STATUS_PENDING) {

                        if ($row['ureq_type'] == UserGdprRequest::TYPE_TRUNCATE) {
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Truncate_User_Data', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#icon-user-truncate'></use></svg>",
                                "onclick" => "truncateUserData(" . $row['user_id'] . "," . $row['ureq_id'] . ")"
                            ];
                        }

                        if($row['ureq_type'] == UserGdprRequest::TYPE_DATA_REQUEST ){
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_Change_Status_To_Complete', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#icon-completed'></use></svg>",
                                "onclick" => "updateRequestStatus(" . $row['ureq_id'] . "," . UserGdprRequest::STATUS_COMPLETE . ")"
                            ];
                            $actionArr[] = [
                                "title" => Labels::getLabel('LBL_View_Purpose', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                                "onclick" => "viewRequestPurpose(" . $row['ureq_id'] . ")"
                            ];
                        }
                        $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['ureq_id']], false);
                    }
                }
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php

$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmUserSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>