<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$frm = $frmUser;

$dobFld = $frmUser->getField('user_dob');
$dobFld->setFieldTagAttribute('class', 'user_dob_js calender');

if ($user_id > 0) {
    $fld_credential_username = $frmUser->getField('credential_username');
    $fld_credential_username->setFieldTagAttribute('disabled', 'disabled');

    $user_email = $frmUser->getField('credential_email');
    if (!empty($data['credential_email'])) {
        $user_email->setFieldTagAttribute('disabled', 'disabled');
    }
    $user_email->setFieldTagAttribute('id', 'user-email');
    $user_email->setFieldTagAttribute('data-value', $data['credential_email']);
    /*$user_email->setFieldTagAttribute('data-encrypted-value', CommonHelper::displayEncryptedEmail($data['credential_email']));*/
    /* $user_email->htmlAfterField = '<span toggle="#user-email" onClick ="toggleEncryptedFields(this)" class="fa js-toggle-data fa-eye"></span>'; */
    if (!empty($data['user_dob']) && $data['user_dob'] != '0000-00-00') {
        $dobFld->setFieldTagAttribute('id', 'user-dob');
        $dobFld->setFieldTagAttribute('data-value', $data['user_dob']);
        /* $dobFld->setFieldTagAttribute('data-encrypted-value', CommonHelper::displayEncryptedDob($data['user_dob']));
        $dobFld->htmlAfterField = '<span toggle="#user-dob" onClick ="toggleEncryptedFields(this,1)" class="fa js-toggle-data fa-eye"></span>'; */
    }
    if (!empty($data['user_phone'])) {
        $phoneFld = $frmUser->getField('user_phone');
        $phoneFld->setFieldTagAttribute('id', 'user-phone');
        $phoneFld->setFieldTagAttribute('data-value', $data['user_phone']);
        /* $phoneFld->setFieldTagAttribute('data-encrypted-value', CommonHelper::displayEncryptedFieldData($data['user_phone']));
        $phoneFld->htmlAfterField = '<span toggle="#user-phone" onClick ="toggleEncryptedFields(this, 1, 1)" class="fa js-toggle-data fa-eye"></span>'; */
    }
    if (!empty($data['user_registered_initially_via_phone']) && !empty($data['user_phone'])) {
        $phoneFld->setFieldTagAttribute('disabled', 'disabled');
    }
}

$frmUser->developerTags['colClassPrefix'] = 'col-md-';
$frmUser->developerTags['fld_default_col'] = 12;

$frmUser->setFormTagAttribute('class', 'form web_form form_horizontal');
$frmUser->setFormTagAttribute('onsubmit', 'setupUsers(this); return(false);');

$countryFld = $frmUser->getField('user_country_id');
$countryFld->setFieldTagAttribute('id', 'user_country_id');
$countryFld->setFieldTagAttribute('onChange', 'getCountryStates(this.value,' . $stateId . ',\'#user_state_id\')');

$stateFld = $frmUser->getField('user_state_id');
$stateFld->setFieldTagAttribute('id', 'user_state_id');

$recordId = (int) $user_id;

$tabsButtons = [
    [
        'attr' => [
            'onclick' => 'userForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_General', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_General', $adminLangId),
        'isActive' => true,
        'isPrimary' => true
    ],
    [
        'attr' => [
            'onclick' => 'addBankInfoForm(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Bank_Info', $adminLangId),
        'isActive' => false
    ],
    [
        'attr' => [
            'onclick' => 'addUserAddress(' . $recordId . ')',
            'title' => Labels::getLabel('LBL_Addresses', $adminLangId),
        ],
        'label' => Labels::getLabel('LBL_Addresses', $adminLangId),
        'isActive' => false
    ],
];

$formTitle = Labels::getLabel('LBL_User_Setup', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<?php echo $frmUser->getFormHtml(); ?>
<?php
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/footer.php');
?>

<?php
/*
<section class="card section">
    <div class="card-head">
        <h4><?php echo Labels::getLabel('LBL_User_Setup', $adminLangId); ?></h4>
</div>
<div class="card-body extra">
    <div class="need-remove">

        <?php if ($user_id > 0) { ?>
        <ul class="nav-tabs nav-tabs-line tabs_nav">
            <li class="nav-tabs-item"><a class="nav-tabs-link active" href="javascript:void(0)"
                    onclick="userForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_General', $adminLangId); ?></a>
            </li>
            <?php if ($userParent == 0) { ?>
            <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
                    onclick="addBankInfoForm(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Bank_Info', $adminLangId); ?></a>
            </li>
            <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
                    onclick="addUserAddress(<?php echo $user_id ?>);"><?php echo Labels::getLabel('LBL_Addresses', $adminLangId); ?></a>
            </li>
            <?php } ?>
        </ul>
        <?php } ?>

        <div class="tabs_panel_wrap">
            <div class="tabs_panel">
                <?php echo $frmUser->getFormHtml(); ?>
            </div>
        </div>
    </div>
</div>
</section>
*/
?>
<script language="javascript">
    $(document).ready(function () {
        getCountryStates($("#user_country_id").val(), <?php echo $stateId; ?>, '#user_state_id');
        $('.user_dob_js').datepicker('option', {
            maxDate: new Date()
        });
        stylePhoneNumberFld();
    });
</script>

<?php
if (isset($countryIso) && !empty($countryIso)) { ?>
    <script>
        langLbl.defaultCountryCode = '<?php echo $countryIso; ?>';
    </script>
<?php } ?>