<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$recordId = (int) $userId;

$tabsButtons = [
	[
		'attr' => [
			'onclick' => 'addReward(' . $recordId . ')',
			'title' => Labels::getLabel('LBL_Reward_Points', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Reward_Points', $adminLangId),
		'isActive' => true,
		'isPrimary' => true
	],
	[
		'attr' => [
			'onclick' => 'addUserRewardPoints(' . $recordId . ')',
			'title' => Labels::getLabel('LBL_Add_New', $adminLangId),
		],
		'label' => Labels::getLabel('LBL_Add_New', $adminLangId),
		'isActive' => false
	]
];

$formType = 'table';
$formTitle = Labels::getLabel('LBL_User_Reward_Points', $adminLangId);
require_once(CONF_THEME_PATH . 'default/_partial/bootstrap-model/header.php');
?>
<section class="section mt-2">
	<div class="need-remove">
		<div class="tabs_panel_wrap">
			<div class="tabs_panel">
				<?php
				$arr_flds = array(
					'urp_date_added' => Labels::getLabel('LBL_Valid_from', $adminLangId),
					'urp_date_expiry' => Labels::getLabel('LBL_Valid_till', $adminLangId),
					'urp_points' => Labels::getLabel('LBL_Points', $adminLangId),
					'urp_comments' => Labels::getLabel('LBL_Comments', $adminLangId),
				);
				$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
				$th = $tbl->appendElement('thead')->appendElement('tr');
				foreach ($arr_flds as $key => $val) {
					$e = $th->appendElement('th', array(), $val, true);
				}
				$sr_no = 0;
				foreach ($arr_listing as $sn => $row) {
					$sr_no++;
					$tr = $tbl->appendElement('tr');

					foreach ($arr_flds as $key => $val) {
						$td = $tr->appendElement('td');
						switch ($key) {
							case 'urp_date_added':
							case 'urp_date_expiry':
								$td->appendElement('plaintext', array(), FatDate::format($row[$key]));
								break;
							case 'urp_comments':
								$td->appendElement('plaintext', array(), nl2br($row[$key]), true);
								break;
							default:
								$td->appendElement('plaintext', array(), $row[$key], true);
								break;
						}
					}
				}

				echo $tbl->getHtml();
				if (count($arr_listing) == 0) {
					$this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
				}
				$postedData['page'] = $page;
				echo FatUtility::createHiddenFormFromData($postedData, array(
					'name' => 'frmRewardSearchPaging'
				));
				$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToRewardPage', 'adminLangId' => $adminLangId);
				$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
				?>
			</div>
		</div>
	</div>
</section>


<?php /*
<section class="card section">
<h1><?php echo Labels::getLabel('LBL_User_Reward_Points', $adminLangId); ?></h1>
<div class="need-remove">
   <ul class="nav-tabs nav-tabs-line tabs_nav">
	   <li class="nav-tabs-item"><a class="nav-tabs-link active" href="javascript:void(0)"
			   onclick="addReward(<?php echo $userId ?>);"><?php echo Labels::getLabel('LBL_Reward_Points', $adminLangId); ?></a>
	   </li>
	   <li class="nav-tabs-item"><a class="nav-tabs-link" href="javascript:void(0)"
			   onclick="addUserRewardPoints(<?php echo $userId ?>);"><?php echo Labels::getLabel('LBL_Add_New', $adminLangId); ?></a>
	   </li>
   </ul>
   <div class="tabs_panel_wrap">
	   <div class="tabs_panel">
		   <?php
		   $arr_flds = array(
			   'urp_date_added' => Labels::getLabel('LBL_Valid_from', $adminLangId),
			   'urp_date_expiry' => Labels::getLabel('LBL_Valid_till', $adminLangId),
			   'urp_points' => Labels::getLabel('LBL_Points', $adminLangId),
			   'urp_comments' => Labels::getLabel('LBL_Comments', $adminLangId),
		   );
		   $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
		   $th = $tbl->appendElement('thead')->appendElement('tr');
		   foreach ($arr_flds as $key => $val) {
			   $e = $th->appendElement('th', array(), $val, true);
		   }
		   $sr_no = 0;
		   foreach ($arr_listing as $sn => $row) {
			   $sr_no++;
			   $tr = $tbl->appendElement('tr');

			   foreach ($arr_flds as $key => $val) {
				   $td = $tr->appendElement('td');
				   switch ($key) {
					   case 'urp_date_added':
					   case 'urp_date_expiry':
						   $td->appendElement('plaintext', array(), FatDate::format($row[$key]));
						   break;
					   case 'urp_comments':
						   $td->appendElement('plaintext', array(), nl2br($row[$key]), true);
						   break;
					   default:
						   $td->appendElement('plaintext', array(), $row[$key], true);
						   break;
				   }
			   }
		   }
		   
		   echo $tbl->getHtml();
		   if (count($arr_listing) == 0) {
			   $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
		   }
		   $postedData['page'] = $page;
		   echo FatUtility::createHiddenFormFromData($postedData, array(
			   'name' => 'frmRewardSearchPaging'
		   ));
		   $pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'callBackJsFunc' => 'goToRewardPage', 'adminLangId' => $adminLangId);
		   $this->includeTemplate('_partial/pagination.php', $pagingArr, false);
		   ?>
	   </div>
   </div>
</div>
</section>
*/
?>