<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap"> 
<?php
$arr_flds = array(
    'select_all' => Labels::getLabel('LBL_Select_all', $adminLangId),
    'user_id' => Labels::getLabel('LBL_User_Id', $adminLangId),
    'user' => Labels::getLabel('LBL_User\'s_Name', $adminLangId),
    // 'shop_name' => Labels::getLabel('LBL_Shop', $adminLangId),
    'type' => Labels::getLabel('LBL_User_Type', $adminLangId),
    'user_regdate' => Labels::getLabel('LBL_Reg._Date', $adminLangId),
    'credential_active' => Labels::getLabel('LBL_Status', $adminLangId),
    'credential_verified' => Labels::getLabel('LBL_verified', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
if (!$canEdit) {
    unset($arr_flds['select_all']);
}
$tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table table-hovered table-justified'));
$th = $tbl->appendElement('thead')->appendElement('tr');

foreach ($arr_flds as $key => $val) {
    if ('select_all' == $key) {
        $th->appendElement('th')->appendElement('plaintext', array(), '<label class="checkbox"><input title="' . $val . '" type="checkbox" onclick="selectAll( $(this) )" class="selectAll-js"></label>', true);
    } else if ('user_id' == $key) {
        $th->appendElement('th', array('width' => "30"), $val);
    } else {
        $e = $th->appendElement('th', array(), $val);
    }
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr', array());

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'select_all':
                $td->appendElement('plaintext', array(), '<label class="checkbox"><input class="selectItem--js" type="checkbox" name="user_ids[]" value=' . $row['user_id'] . '></label>', true);
                break;
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user':
                $shopName = '';
                if (!empty($row['shop_name'])) {
                    $shopName = '<span>' . Labels::getLabel('LBL_Shop', $adminLangId) . ': ' . $row['shop_name'] . '</span>';
                }
                $phoneNo = '';
                if (!empty($row['user_phone'])) {
                    $phoneNo = '<span>' . Labels::getLabel('LBL_Phone', $adminLangId) . ': ' . $row['user_dial_code'] . ' ' . $row['user_phone'] . '</span>';
                }

                $userDetail = '<div class="user-profile"> 
                                <a target="_blank" href="' . UrlHelper::generateUrl('Image', 'user', array($row['user_id'], 'ORIGINAL', true), CONF_WEBROOT_FRONT_URL) . '" >
                                <figure class="user-profile-thumbnail" data-ratio="1:1">
                                    <img  width="40" height="40" title="' . $row['user_name'] . '" alt="' . $row['user_name'] . '" src="' . UrlHelper::generateUrl('Image', 'user', array($row['user_id'], 'THUMB', true), CONF_WEBROOT_FRONT_URL) . '">
                                </figure>
                            </a>
                            <div class="user-profile-data">';
                if (!empty($row['shop_id']) && $canViewShops) {
                    $userDetail .= '<a class="title" href="" onclick="redirectfunc(\'' . UrlHelper::generateUrl('Shops') . '\',\'' . $row['shop_id'] . '\'); return false;" data-toggle="tooltip" data-placement="right" data-bs-original-title="Click here to visit shop list">
                                ' . $row['user_name'] . ' (' . $row['credential_username'] . ')                
                                </a>';
                } else {
                    $userDetail .= $row['user_name'] . ' (' . $row['credential_username'] . ')';
                }

                $userDetail .= '
                            <span class="text-muted">
                                <a class="cell-link" href="javascript:void(0)" onclick="sendMailForm(' . $row['user_id'] . ')">' . $row['credential_email'] . '</a>            
                            </span>
                                    ' . $shopName . $phoneNo . '
                            </div></div></div>';
                $td->appendElement('plaintext', array(), $userDetail, true);
                break;
            case 'shop_name':
                if ($row[$key] != '') {
                    if ($canViewShops) {
                        $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Shops') . '", ' . $row['shop_id'] . ')'), $row[$key], true);
                    } else {
                        $td->appendElement('plaintext', array(), $row[$key], true);
                    }
                }
                break;
            case 'credential_active':
                // $active = "active";
                // if (!$row['credential_active']) {
                //     $active = '';
                // }
                // $statucAct = ($canEdit === true) ? 'toggleStatus(this)' : ''; 
                // $str = '<label id="' . $row['user_id'] . '" class="statustab ' . $active . '" onclick="' . $statucAct . '">
                //   <span data-off="' . Labels::getLabel('LBL_Active', $adminLangId) . '" data-on="' . Labels::getLabel('LBL_Inactive', $adminLangId) . '" class="switch-labels"></span>
                //   <span class="switch-handles"></span>
                // </label>';
                // $td->appendElement('plaintext', array(), $str, true);

                $active = "";
                if ($row['credential_active']) {
                    $active = 'checked';
                }
                $statusAct = ($canEdit === true) ? 'toggleStatus(event,this,' . applicationConstants::YES . ')' : 'toggleStatus(this,' . applicationConstants::NO . ')';
                $statusClass = ($canEdit === false) ? 'disabled' : '';
                $str = '<label class="switch switch-sm switch-icon ' . $statusClass . '">
                <input ' . $active . ' type="checkbox" id="switch' . $row['user_id'] . '" value="' . $row['user_id'] . '" onclick="' . $statusAct . '" class="switch-labels"/>
                </label>';
                $td->appendElement('plaintext', array(), $str, true);

                break;
            case 'user_regdate':
                $date = FatDate::format(
                    $row[$key],
                    true,
                    true,
                    FatApp::getConfig('CONF_TIMEZONE', FatUtility::VAR_STRING, date_default_timezone_get())
                );
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'type':
                $str = '';
                $arr = User::getUserTypesArr($adminLangId);
                if ($row['user_is_buyer']) {
                    $str .= '<li class="chip buyer">' . $arr[User::USER_TYPE_BUYER] . '</li>';
                }
                if ($row['user_is_supplier']) {
                    $str .= '<li class="chip supplier">' . $arr[User::USER_TYPE_SELLER] . '</li>';
                }
                if ($row['user_is_advertiser']) {
                    $str .= '<li class="chip advertiser">' . $arr[User::USER_TYPE_ADVERTISER] . '</li>';
                }
                /* if ($row['user_is_affiliate']) {
                    $str .= $arr[User::USER_TYPE_AFFILIATE] . '<br/>';
                } */
                if ($row['user_is_supplier'] && !$row['user_is_buyer']) {
                    $str .= '<li class="chip buyer"><a href="javascript:void(0)" onclick="markSellerAsBuyer(' . $row['user_id'] . ')">' . Labels::getLabel('LBL_MARK_AS_BUYER', $adminLangId) . '</a></li>';
                }

                if ($str == '' && $row['user_registered_initially_for'] != 0 && isset($arr[$row['user_registered_initially_for']])) {
                    $str = '<li class="chip "><span class="badge badge-danger">Signing Up For: ' . $arr[$row['user_registered_initially_for']] . '</span></li>';
                } elseif (isset($row['usuprequest_status']) && !empty($row['usuprequest_id']) && $row['usuprequest_status'] == User::SUPPLIER_REQUEST_PENDING) {
                    $str .= '<li class="chip "><span class="badge badge-danger">Signing Up For: ' . Labels::getLabel('LBL_Seller', $adminLangId) . '</span></li>';
                }

                if (0 < $row['user_parent']) {
                    $str .= '<li class="chip advertiser">' . Labels::getLabel('LBL_Sub_User', $adminLangId) . '</li>';
                }


                $td->appendElement('plaintext', array(), '<ul class="chips">' . $str . '</ul>', true);

                break;
            case 'credential_verified':
                $yesNoArr = applicationConstants::getYesNoArr($adminLangId);
                $str = isset($row[$key]) ? $yesNoArr[$row[$key]] : '';
                $td->appendElement('plaintext', array(), $str, true);
                break;
            case 'action':

                if ($canEdit) {
                    $actionArr = [
                        [
                            "title" => Labels::getLabel('LBL_Edit', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#edit'></use></svg>",
                            "onclick" => "addUserForm(" . $row['user_id'] . ")"
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Delete_User', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#delete'></use></svg>",
                            "onclick" => "deleteUser(" . $row['user_id'] . ")",
                        ],
                        [
                            "title" => Labels::getLabel('LBL_Change_Password', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#gear'></use></svg>",
                            "onclick" => "changePasswordForm(" . $row['user_id'] . ")",
                        ]
                        ,
                        [
                            "title" => Labels::getLabel('LBL_Login_to_user_profile', $adminLangId),
                            "target" => "_blank",
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#view'></use></svg>",
                            "href" => UrlHelper::generateUrl('Users', 'login', array($row['user_id'])),
                        ]
                    ];

                    if (0 == $row['user_parent']) {
                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Rewards', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                            "onclick" => "rewards(" . $row['user_id'] . ")",
                        ];

                        $actionArr[] = [
                            "title" => Labels::getLabel('LBL_Transactions', $adminLangId),
                            "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#history'></use></svg>",
                            "onclick" => "transactions(" . $row['user_id'] . ")",
                        ];
                    }

                    if (!empty($row['credential_email'])) {
                        $actionArr[] =
                            [
                                "title" => Labels::getLabel('LBL_Email_User', $adminLangId),
                                "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#send-email'></use></svg>",
                                "onclick" => "sendMailForm(" . $row['user_id'] . ")",
                            ];
                    }

                    $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['user_id']], false);
                }

                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

$frm = new Form('frmUsersListing', array('id' => 'frmUsersListing'));
$frm->setFormTagAttribute('class', 'form web_form last_td_nowrap actionButtons-js');
$frm->setFormTagAttribute('onsubmit', 'formAction(this, reloadUserList ); return(false);');
$frm->setFormTagAttribute('action', UrlHelper::generateUrl('Users', 'toggleBulkStatuses'));
$frm->addHiddenField('', 'status');

echo $frm->getFormTag();
echo $frm->getFieldHtml('status');
echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</form>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmUserSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>
<script>
    $('[data-toggle="tooltip"]').tooltip();
</script>