<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="table-responsive table-scrollable js-scrollable tablewrap">
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'usuprequest_reference' => Labels::getLabel('LBL_Reference_Number', $adminLangId),
    'user_name' => Labels::getLabel('LBL_Name', $adminLangId),
    'user_details' => Labels::getLabel('LBL_Username/Email', $adminLangId),
    'usuprequest_date' => Labels::getLabel('LBL_Requested_On', $adminLangId),
    'status' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement(
    'table',
    array('width' => '100%', 'class' => 'table table-hovered table-justified')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
foreach ($arr_listing as $sn => $row) {
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user_name':
                $td->appendElement('a', array('href' => 'javascript:void(0)', 'onClick' => 'redirectfunc("' . UrlHelper::generateUrl('Users') . '", ' . $row['user_id'] . ')'), $row['user_name'], true);
                break;
            case 'user_details':
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_U', $adminLangId) . ': </strong> ' . $row['credential_username'], true);
                $td->appendElement('br', array());
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_E', $adminLangId) . ': </strong> ' . $row['credential_email'], true);
                break;
            case 'status':
                $status = HtmlHelper::getStatusHtml($row['usuprequest_status'], $reqStatusArr[$row['usuprequest_status']]);
                $td->appendElement('plaintext', [], $status, true);
                break;
            case 'usuprequest_date':
                $date = FatDate::format($row[$key], true);
                $dateHtml = "";
                if (strpos($date, ' ') !== false) {
                    list($formattedDate, $formattedTime) = explode(' ', $date);
                    $dateHtml = "<date class='date'>" . $formattedDate . " <time>" . $formattedTime . "</time></date>";
                } else {
                    $dateHtml = "<date class='date'>" . $date . "</date>";
                }
                $td->appendElement('plaintext', array(), $dateHtml, true);
                break;
            case 'action':
                $actionArr = [];
                if ($canViewSellerApprovalRequests) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_View', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "onclick" => "viewSellerRequest(" . $row['usuprequest_id'] . ")"
                    ];
                }
                if ($canEditSellerApprovalRequests && $row['usuprequest_status'] == User::SUPPLIER_REQUEST_PENDING) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Approve_Request', $adminLangId),
                        "icon" => '<svg width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M9.9997 15.1709L19.1921 5.97852L20.6063 7.39273L9.9997 17.9993L3.63574 11.6354L5.04996 10.2212L9.9997 15.1709Z"></path></svg>',
                        "onclick" => "changeStatus(" . $row['usuprequest_id'] . "," . User::SUPPLIER_REQUEST_APPROVED . ")"
                    ];
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Cancel_Request', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#close'></use></svg>",
                        "onclick" => "changeStatus(" . $row['usuprequest_id'] . "," . User::SUPPLIER_REQUEST_CANCELLED . ")"
                    ];
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['usuprequest_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
    $sr_no--;
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
?>
</div>
<?php
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>