<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
$arr_flds = array(
    'listserial' => Labels::getLabel('LBL_#', $adminLangId),
    'scatrequest_reference' => Labels::getLabel('LBL_Reference_Number', $adminLangId),
    'user_name' => Labels::getLabel('LBL_Name', $adminLangId),
    'user_details' => Labels::getLabel('LBL_Username/Email', $adminLangId),
    'scatrequest_date' => Labels::getLabel('LBL_Requested_On', $adminLangId),
    'status' => Labels::getLabel('LBL_Status', $adminLangId),
    'action' => Labels::getLabel('LBL_Action(s)', $adminLangId),
);
$tbl = new HtmlElement(
    'table',
    array('width' => '100%', 'class' => 'table table-hovered table-justified')
);

$th = $tbl->appendElement('thead')->appendElement('tr');
foreach ($arr_flds as $val) {
    $e = $th->appendElement('th', array(), $val);
}

$sr_no = $page == 1 ? 0 : $pageSize * ($page - 1);
foreach ($arr_listing as $sn => $row) {
    $sr_no++;
    $tr = $tbl->appendElement('tr');

    foreach ($arr_flds as $key => $val) {
        $td = $tr->appendElement('td');
        switch ($key) {
            case 'listserial':
                $td->appendElement('plaintext', array(), $sr_no);
                break;
            case 'user_details':
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_U', $adminLangId) . ': </strong> ' . $row['credential_username'], true);
                $td->appendElement('br', array());
                $td->appendElement('plaintext', array(), '<strong>' . Labels::getLabel('LBL_E', $adminLangId) . ': </strong> ' . $row['credential_email'], true);
                break;
            case 'status':
                $td->appendElement('label', array('class' => 'badge badge-' . $reqStatusClassArr[$row['scatrequest_status']] . ''), $reqStatusArr[$row['scatrequest_status']], true);

                break;
            case 'action':

                $actionArr = [];

                if ($canViewSellerCatalogRequests) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_View', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#eye'></use></svg>",
                        "onclick" => "viewCatalogRequest(" . $row['scatrequest_id'] . ")"
                    ];
                }
                if ($canEditSellerCatalogRequests && $row['scatrequest_status'] == User::CATALOG_REQUEST_PENDING) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Change_Status', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#in-active'></use></svg>",
                        "onclick" => "updateCatalogRequestForm(" . $row['scatrequest_id'] . ")"
                    ];
                }
                if ($canEditSellerCatalogRequests) {
                    $actionArr[] = [
                        "title" => Labels::getLabel('LBL_Message_Seller', $adminLangId),
                        "icon" => "<svg class='svg' width='18' height='18'><use xlink:href='" . CONF_WEBROOT_FRONT_URL . "images/admin/retina/sprite-actions.svg#send-email'></use></svg>",
                        "onclick" => "sellerCatalogRequestMsgForm(" . $row['scatrequest_id'] . ")"
                    ];
                }
                $this->includeTemplate('_partial/actions.php', ['actionArr' => $actionArr, 'td' => $td, 'adminLangId' => $adminLangId, 'id' => $row['scatrequest_id']], false);
                break;
            default:
                $td->appendElement('plaintext', array(), $row[$key], true);
                break;
        }
    }
}

echo $tbl->getHtml();
if (count($arr_listing) == 0) {
    $this->includeTemplate('_partial/no-record-found.php', array('adminLangId' => $adminLangId));
}
$postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'recordCount' => $recordCount, 'adminLangId' => $adminLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);
?>