<?php

class AccountController extends LoggedUserController
{

    public function __construct($action)
    {
        parent::__construct($action);
        if (!isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'])) {
            $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = '';
            if (User::isBuyer() || User::isSigningUpBuyer()) {
                $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'B';
            } elseif (User::isSeller() || User::isSigningUpForSeller()) {
                $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'S';
            } elseif (User::isAdvertiser() || User::isSigningUpAdvertiser()) {
                $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'Ad';
            } elseif (User::isAffiliate() || User::isSigningUpAffiliate()) {
                $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] = 'AFFILIATE';
            }
        }
        $this->set('bodyClass', 'is--dashboard');
    }

    public function index()
    {
        if (UserAuthentication::isGuestUserLogged()) {
            FatApp::redirectUser(UrlHelper::generateUrl('home'));
        }

        switch ($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) {
            case 'B':
                FatApp::redirectUser(UrlHelper::generateUrl('buyer'));
                break;
            case 'S':
                FatApp::redirectUser(UrlHelper::generateUrl('seller'));
                break;
            case 'Ad':
                FatApp::redirectUser(UrlHelper::generateUrl('advertiser'));
                break;
            case 'AFFILIATE':
                FatApp::redirectUser(UrlHelper::generateUrl('affiliate'));
                break;
            default:
                FatApp::redirectUser(UrlHelper::generateUrl(''));
                break;
        }

        /* $user = new User(UserAuthentication::getLoggedUserId());
          $this->set('data', $user->getProfileData());
          $this->_template->render(true,false); */
    }

    public function viewSupplierRequest($requestId)
    {
        $userId = UserAuthentication::getLoggedUserId();
        $requestId = FatUtility::int($requestId);

        if ($userId < 1 || $requestId < 1) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatApp::redirectUser(UrlHelper::generateUrl('Account', 'SupplierApprovalForm'));
            //FatUtility::dieJsonError( Message::getHtml() );
        }

        $userObj = new User($userId);
        $srch = $userObj->getUserSupplierRequestsObj($requestId);
        $srch->addFld('tusr.*');

        $rs = $srch->getResultSet();
        /* if(!$rs){
          Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST',$this->siteLangId));
          FatUtility::dieJsonError( Message::getHtml() );
          } */

        $supplierRequest = FatApp::getDb()->fetch($rs);

        if (!$supplierRequest || $supplierRequest['usuprequest_id'] != $requestId) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatApp::redirectUser(UrlHelper::generateUrl('Account', 'SupplierApprovalForm'));
        }
        $maxAttempts = FatApp::getConfig('CONF_MAX_SUPPLIER_REQUEST_ATTEMPT', FatUtility::VAR_INT, 3);
        $maxAttemptsReached = false;
        if ($supplierRequest && $supplierRequest['usuprequest_attempts'] >= $maxAttempts) {
            $maxAttemptsReached = true;
        }
        $this->set('maxAttemptsReached', $maxAttemptsReached);
        $this->set('supplierRequest', $supplierRequest);
        $this->_template->render();
    }

    public function supplierApprovalForm($p = '')
    {
        if (!User::canViewSupplierTab()) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST_FOR_SUPPLIER_DASHBOARD', $this->siteLangId));
            if (User::isBuyer()) {
                FatApp::redirectUser(UrlHelper::generateUrl('buyer'));
            } elseif (User::isAdvertiser()) {
                FatApp::redirectUser(UrlHelper::generateUrl('advertiser'));
            } elseif (User::isAffiliate()) {
                FatApp::redirectUser(UrlHelper::generateUrl('affiliate'));
            } else {
                FatApp::redirectUser(UrlHelper::generateUrl('Account', 'ProfileInfo'));
            }
        }
        $userId = UserAuthentication::getLoggedUserId();

        $userObj = new User($userId);
        $srch = $userObj->getUserSupplierRequestsObj();
        $srch->addFld(array('usuprequest_attempts', 'usuprequest_id'));

        $rs = $srch->getResultSet();
        if (!$rs) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $supplierRequest = FatApp::getDb()->fetch($rs);
        $maxAttempts = FatApp::getConfig('CONF_MAX_SUPPLIER_REQUEST_ATTEMPT', FatUtility::VAR_INT, 3);
        if ($supplierRequest && $supplierRequest['usuprequest_attempts'] >= $maxAttempts) {
            Message::addErrorMessage(Labels::getLabel('MSG_You_have_already_consumed_max_attempts', $this->siteLangId));
            FatApp::redirectUser(UrlHelper::generateUrl('account', 'viewSupplierRequest', array($supplierRequest["usuprequest_id"])));
        }

        if ($supplierRequest && ($p != "reopen")) {
            FatApp::redirectUser(UrlHelper::generateUrl('account', 'viewSupplierRequest', array($supplierRequest["usuprequest_id"])));
        }

        $data = array('id' => isset($supplierRequest['usuprequest_id']) ? $supplierRequest['usuprequest_id'] : 0);
        $approvalFrm = $this->getSupplierForm();
        $approvalFrm->fill($data);
        $approvalFrm->addSecurityToken();

        $this->set('approvalFrm', $approvalFrm);
        $this->_template->render();
    }

    public function setupSupplierApproval()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $error_messages = array();
        $fieldIdsArr = array();
        /* check if maximum attempts reached [ */
        $userObj = new User($userId);
        $srch = $userObj->getUserSupplierRequestsObj();
        $srch->addFld(array('usuprequest_attempts', 'usuprequest_id', 'usuprequest_reference'));

        $rs = $srch->getResultSet();
        if (!$rs) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $supplierRequest = FatApp::getDb()->fetch($rs);
        $maxAttempts = FatApp::getConfig('CONF_MAX_SUPPLIER_REQUEST_ATTEMPT', FatUtility::VAR_INT, 3);
        if ($supplierRequest && $supplierRequest['usuprequest_attempts'] >= $maxAttempts) {
            Message::addErrorMessage(Labels::getLabel('MSG_You_have_already_consumed_max_attempts', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        /* ] */

        $userData = $userObj->getUserInfo('credential_verified', true, false, true);
        if ($userData['credential_verified'] == applicationConstants::INACTIVE) {
            Message::addErrorMessage(Labels::getLabel('MSG_User_not_verified', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $dialCode = FatApp::getPostedData('dial_code', FatUtility::VAR_STRING, '');
        $countryCode = FatApp::getPostedData('country_iso', FatUtility::VAR_STRING, '');

        $frm = $this->getSupplierForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData(), [], true);

        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $frm->expireSecurityToken(FatApp::getPostedData());

        $supplier_form_fields = $userObj->getSupplierFormFields($this->siteLangId);

        foreach ($supplier_form_fields as $field) {
            if ($field['sformfield_type'] == User::USER_FIELD_TYPE_PHONE) {
                $post['sformfield_' . $field['sformfield_id']] = $dialCode . '-' . $countryCode . $post['sformfield_' . $field['sformfield_id']];
            }
            $fieldIdsArr[] = $field['sformfield_id'];
            if ($field['sformfield_required'] && empty($post["sformfield_" . $field['sformfield_id']])) {
                $error_messages[] = sprintf(Labels::getLabel('MSG_Label_Required', $this->siteLangId), $field['sformfield_caption']);
            }
        }

        if (!empty($error_messages)) {
            Message::addErrorMessage($error_messages);
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (!empty($supplierRequest['usuprequest_reference'])) {
            $reference_number = $supplierRequest['usuprequest_reference'];
        } else {
            $reference_number = $userId . '-' . time();
        }
        $data = array_merge($post, array("user_id" => $userId, "reference" => $reference_number, 'fieldIdsArr' => $fieldIdsArr));

        $db = FatApp::getDb();
        $db->startTransaction();

        if (!$supplier_request_id = $userObj->addSupplierRequestData($data, $this->siteLangId)) {
            $db->rollbackTransaction();
            Message::addErrorMessage(Labels::getLabel('MSG_details_not_saved', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        if (FatApp::getConfig("CONF_ADMIN_APPROVAL_SUPPLIER_REGISTRATION", FatUtility::VAR_INT, 1)) {
            $approval_request = 1;
            $msg = Labels::getLabel('MSG_Your_seller_approval_form_request_sent', $this->siteLangId);
        } else {
            $approval_request = 0;
            $msg = Labels::getLabel('MSG_Your_application_is_approved', $this->siteLangId);
        }

        if (!$this->notifyAdminSupplierApproval($userObj, $data, $approval_request)) {
            $db->rollbackTransaction();
            Message::addErrorMessage(Labels::getLabel("MSG_SELLER_APPROVAL_EMAIL_COULD_NOT_BE_SENT", $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        //send notification to admin
        $notificationData = array(
            'notification_record_type' => Notification::TYPE_USER,
            'notification_record_id' => $userObj->getMainTableRecordId(),
            'notification_user_id' => $userId,
            'notification_label_key' => ($approval_request) ? Notification::NEW_SUPPLIER_APPROVAL_NOTIFICATION : Notification::NEW_SELLER_APPROVED_NOTIFICATION,
            'notification_added_on' => date('Y-m-d H:i:s'),
        );

        if (!Notification::saveNotifications($notificationData)) {
            $db->rollbackTransaction();
            Message::addErrorMessage(Labels::getLabel("MSG_NOTIFICATION_COULD_NOT_BE_SENT", $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $db->commitTransaction();
        $this->set('supplier_request_id', $supplier_request_id);
        $this->set('msg', $msg);
        $this->_template->render(false, false, 'json-success.php');
    }

    public function uploadSupplierFormImages()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $post = FatApp::getPostedData();

        if (empty($post)) {
            /* Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId)); */
            FatUtility::dieJsonError(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId));
        }
        $field_id = $post['field_id'];

        $fileHandlerObj = new AttachedFile();
        if (!$fileHandlerObj->isUploadedFile($_FILES['file']['tmp_name'])) {
            FatUtility::dieJsonError($fileHandlerObj->getError());
        }

        $fileHandlerObj->deleteFile($fileHandlerObj::FILETYPE_SELLER_APPROVAL_FILE, $userId, 0, $field_id);

        if (
            !$res = $fileHandlerObj->saveAttachment(
                $_FILES['file']['tmp_name'],
                    $fileHandlerObj::FILETYPE_SELLER_APPROVAL_FILE,
                $userId,
                $field_id,
                $_FILES['file']['name'],
                -1,
                $unique_record = false
            )
        ) {
            /* Message::addErrorMessage($fileHandlerObj->getError()); */
            FatUtility::dieJsonError($fileHandlerObj->getError());
        }

        $this->set('file', $_FILES['file']['name']);
        $this->set('msg', /* $_FILES['file']['name'].' '. */ Labels::getLabel('MSG_File_uploaded_successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeEmailPassword()
    {
        $this->set('siteLangId', $this->siteLangId);
        $this->set('canSendSms', SmsArchive::canSendSms(SmsTemplate::LOGIN));
        $this->_template->render();
    }

    public function changePasswordForm()
    {
        $frm = $this->getChangePasswordForm();

        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function updatePassword()
    {
        $pwdFrm = $this->getChangePasswordForm();
        $post = $pwdFrm->getFormDataFromArray(FatApp::getPostedData());

        if ($post === false) {
            $message = Labels::getLabel(current($pwdFrm->getValidationErrors()), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $userObj = new User(UserAuthentication::getLoggedUserId());
        $srch = $userObj->getUserSearchObj(array('user_id', 'credential_password'));
        $rs = $srch->getResultSet();

        $data = FatApp::getDb()->fetch($rs, 'user_id');

        if ($data === false) {
            $message = Labels::getLabel('MSG_Invalid_User', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if ($data['credential_password'] != UserAuthentication::encryptPassword($post['current_password'])) {
            $message = Labels::getLabel('MSG_YOUR_CURRENT_PASSWORD_MIS_MATCHED', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if (!$userObj->setLoginPassword($post['new_password'])) {
            $message = Labels::getLabel('MSG_Password_could_not_be_set', $this->siteLangId) . $userObj->getError();
            FatUtility::dieJsonError($message);
        }

        $this->set('msg', Labels::getLabel('MSG_Password_changed_successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function setPrefferedDashboard($dasboardType)
    {
        $dasboardType = FatUtility::int($dasboardType);

        switch ($dasboardType) {
            case User::USER_BUYER_DASHBOARD:
                if (!User::canViewBuyerTab()) {
                    Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
                    FatUtility::dieJsonError(Message::getHtml());
                }
                break;
            case User::USER_SELLER_DASHBOARD:
                if (!User::canViewSupplierTab()) {
                    Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
                    FatUtility::dieJsonError(Message::getHtml());
                }
                break;
            case User::USER_ADVERTISER_DASHBOARD:
                if (!User::canViewAdvertiserTab()) {
                    Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
                    FatUtility::dieJsonError(Message::getHtml());
                }
                break;
            case User::USER_AFFILIATE_DASHBOARD:
                if (!User::canViewAffiliateTab()) {
                    Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
                    FatUtility::dieJsonError(Message::getHtml());
                }
                break;
            default:
                Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
                FatUtility::dieJsonError(Message::getHtml());
                break;
        }

        $arr = array('user_preferred_dashboard' => $dasboardType);

        $userId = UserAuthentication::getLoggedUserId();
        $userId = FatUtility::int($userId);
        if (1 > $userId) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $userObj = new User($userId);
        $userObj->assignValues($arr);
        if (!$userObj->save()) {
            Message::addErrorMessage($userObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('MSG_Setup_successful', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function credits()
    {
        $frm = $this->getCreditsSearchForm($this->siteLangId);
        $userId = UserAuthentication::getLoggedUserId();

        $pendingLateCharges = BuyerLateChargesHistory::getUserPendingChargesTotalDetails($userId, true);
        $canAddMoneyToWallet = true;
        if (User::isAffiliate()) {
            $canAddMoneyToWallet = false;
        }
        $codMinWalletBalance = -1;
        if (User::isSeller() && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S') {
            $shop_cod_min_wallet_balance = Shop::getAttributesByUserId($userId, 'shop_cod_min_wallet_balance');
            if ($shop_cod_min_wallet_balance > -1) {
                $codMinWalletBalance = $shop_cod_min_wallet_balance;
            } elseif (FatApp::getConfig('CONF_COD_MIN_WALLET_BALANCE', FatUtility::VAR_FLOAT, -1) > -1) {
                $codMinWalletBalance = FatApp::getConfig('CONF_COD_MIN_WALLET_BALANCE', FatUtility::VAR_FLOAT, -1);
            }
        }
        $txnObj = new Transactions();

        $payoutPlugins = Plugin::getNamesWithCode(Plugin::TYPE_PAYOUTS, $this->siteLangId);
        $accountSummary = $txnObj->getTransactionSummary($userId);
        $payouts = [-1 => Labels::getLabel("LBL_BANK_PAYOUT", $this->siteLangId)] + $payoutPlugins;
        $this->set('payouts', $payouts);
        $this->set('userWalletBalance', User::getUserBalance(UserAuthentication::getLoggedUserId()));
        $this->set('userTotalWalletBalance', User::getUserBalance(UserAuthentication::getLoggedUserId(), false, false));
        $this->set('promotionWalletToBeCharged', Promotion::getPromotionWalleToBeCharged(UserAuthentication::getLoggedUserId()));
        $this->set('withdrawlRequestAmount', User::getUserWithdrawnRequestAmount(UserAuthentication::getLoggedUserId()));
        $this->set('codMinWalletBalance', $codMinWalletBalance);
        $this->set('frmSrch', $frm);
        $this->set('accountSummary', $accountSummary);
        $this->set('frmRechargeWallet', $this->getRechargeWalletForm($this->siteLangId));
        $this->set('canAddMoneyToWallet', $canAddMoneyToWallet);
        $this->set('pendingLateCharges', $pendingLateCharges);
        $this->_template->render();
    }

    public function payouts()
    {
        $payoutPlugins = Plugin::getDataByType(Plugin::TYPE_PAYOUTS, $this->siteLangId);
        $data = [
            'isBankPayoutEnabled' => applicationConstants::YES,
            'payoutPlugins' => array_values($payoutPlugins)
        ];
        $this->set('data', $data);
        $this->_template->render();
    }

    public function creditsInfo()
    {
        $this->set('userWalletBalance', User::getUserBalance(UserAuthentication::getLoggedUserId()));
        $this->set('userTotalWalletBalance', User::getUserBalance(UserAuthentication::getLoggedUserId(), false, false));
        $this->set('promotionWalletToBeCharged', Promotion::getPromotionWalleToBeCharged(UserAuthentication::getLoggedUserId()));
        $this->set('withdrawlRequestAmount', User::getUserWithdrawnRequestAmount(UserAuthentication::getLoggedUserId()));
        $payoutPlugins = Plugin::getNamesWithCode(Plugin::TYPE_PAYOUTS, $this->siteLangId);
        $payouts = [-1 => Labels::getLabel("LBL_BANK_PAYOUT", $this->siteLangId)] + $payoutPlugins;
        $this->set('payouts', $payouts);
        if (false === MOBILE_APP_API_CALL) {
            $this->_template->render(false, false);
        }
    }

    public function setUpWalletRecharge()
    {
        $minimumRechargeAmount = 1;
        $frm = $this->getRechargeWalletForm($this->siteLangId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            LibHelper::dieJsonError(current($frm->getValidationErrors()));
        }
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $order_net_amount = $post['amount'];
        if ($order_net_amount < $minimumRechargeAmount) {
            $str = Labels::getLabel("LBL_Recharge_amount_must_be_greater_than_{minimumrechargeamount}", $this->siteLangId);
            $str = str_replace("{minimumrechargeamount}", CommonHelper::displayMoneyFormat($minimumRechargeAmount, true, true), $str);
            LibHelper::dieJsonError($str);
        }
        $orderData = array();
        $order_id = isset($_SESSION['wallet_recharge_cart']["order_id"]) ? $_SESSION['wallet_recharge_cart']["order_id"] : false;
        $orderData['order_type'] = Orders::ORDER_WALLET_RECHARGE;

        $orderData['userAddresses'] = array(); //No Need of it
        $orderData['order_id'] = $order_id;
        $orderData['order_user_id'] = $loggedUserId;
        $orderData['order_payment_status'] = Orders::ORDER_PAYMENT_PENDING;
        $orderData['order_date_added'] = date('Y-m-d H:i:s');

        /* order extras[ */
        $orderData['extra'] = array(
            'oextra_order_id' => $order_id,
            'order_ip_address' => $_SERVER['REMOTE_ADDR']
        );

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_CLIENT_IP'];
        } else {
            $orderData['extra']['order_forwarded_ip'] = '';
        }

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $orderData['extra']['order_user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        } else {
            $orderData['extra']['order_user_agent'] = '';
        }

        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $orderData['extra']['order_accept_language'] = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        } else {
            $orderData['extra']['order_accept_language'] = '';
        }
        /* ] */

        $languageRow = Language::getAttributesById($this->siteLangId);
        $orderData['order_language_id'] = $languageRow['language_id'];
        $orderData['order_language_code'] = $languageRow['language_code'];

        $currencyRow = Currency::getAttributesById($this->siteCurrencyId);
        $orderData['order_currency_id'] = $currencyRow['currency_id'];
        $orderData['order_currency_code'] = $currencyRow['currency_code'];
        $orderData['order_currency_value'] = $currencyRow['currency_value'];

        $orderData['order_user_comments'] = '';
        $orderData['order_admin_comments'] = '';

        $orderData['order_shippingapi_id'] = 0;
        $orderData['order_shippingapi_code'] = '';
        $orderData['order_tax_charged'] = 0;
        $orderData['order_site_commission'] = 0;
        $orderData['order_net_amount'] = $order_net_amount;
        $orderData['order_wallet_amount_charge'] = 0;

        $orderData['orderLangData'] = array();
        $orderObj = new Orders();
        if ($orderObj->addUpdateOrder($orderData, $this->siteLangId)) {
            $order_id = $orderObj->getOrderId();
        } else {
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($orderObj->getError());
            }
            Message::addErrorMessage($orderObj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }
        if (true === MOBILE_APP_API_CALL) {
            /* Payment Methods[ */
            $pmSrch = PaymentMethods::getSearchObject($this->siteLangId);
            $pmSrch->doNotCalculateRecords();
            $pmSrch->doNotLimitRecords();
            $pmSrch->addMultipleFields(Plugin::ATTRS);
            $pmSrch->addCondition('plugin_code', '!=', 'CashOnDelivery');

            $pmRs = $pmSrch->getResultSet();
            $paymentMethods = FatApp::getDb()->fetchAll($pmRs);
            $excludePaymentGatewaysArr = applicationConstants::getExcludePaymentGatewayArr();
            /* ] */
            $this->set('paymentMethods', $paymentMethods);
            $this->set('excludePaymentGatewaysArr', $excludePaymentGatewaysArr);
            $this->set('order_id', $order_id);
            $this->set('orderType', Orders::ORDER_WALLET_RECHARGE);
            $this->_template->render();
        }
        $this->set('redirectUrl', UrlHelper::generateUrl('WalletPay', 'Recharge', array($order_id)));
        $this->set('msg', Labels::getLabel('MSG_Redirecting', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function setUpOrderPayment()
    {
        $minimumRechargeAmount = 1;

        $oppl_id  = FatApp::getPostedData('id',FatUtility::VAR_INT,0);
        $loggedUserId = UserAuthentication::getLoggedUserId();

        if(!empty($oppl_id)){
            $paymentLog = OrderProduct::getOrderPartialPaymentLog($oppl_id);
            if (!$paymentLog) {
                $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                FatUtility::dieJsonError($json);
            }
            $orderObj = new Orders();
            $data = $orderObj->getOrderProductsByOpId($paymentLog['oppl_op_id'], $this->siteLangId);
            if (!$data) {
                $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                FatUtility::dieJsonError($json);
            }
            if($data['op_payment_status'] != Orders::ORDER_PAYMENT_PARTIAL || $data['order_user_id'] != $loggedUserId){
                $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                FatUtility::dieJsonError($json);
            }
            $parent_order_id = $data['op_order_id'];
            $parent_op_id = $data['op_id'];
            $order_net_amount = $paymentLog['oppl_amount'];

        }else{
            $parent_op_id  = FatApp::getPostedData('op_id');
            $parent_order_id  = FatApp::getPostedData('order_id');
            
            $orderObj = new Orders();
            $data = $orderObj->getOrderProductsByOpId($parent_op_id, $this->siteLangId);
    
            if (!$data) {
                $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                FatUtility::dieJsonError($json);
            }
            if($data['op_payment_status'] != Orders::ORDER_PAYMENT_PARTIAL || $data['order_user_id'] != $loggedUserId){
                $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                FatUtility::dieJsonError($json);
            }
           
    
            $frm = $this->getOrderPaymentForm($this->siteLangId,$data);
            $post = $frm->getFormDataFromArray(FatApp::getPostedData());
            if (false === $post) {
                LibHelper::dieJsonError(current($frm->getValidationErrors()));
            }
            $order_net_amount = $post['amount'];
            
            $remainingAmt  =  $data['op_pending_amount']-$order_net_amount;
       
            if($remainingAmt > 0 && $remainingAmt < OrderProduct::MIN_REMAINING_AMOUNT_REQUEST_FOR_PARTIAL_PAYMENT){
                $remaningAmt = CommonHelper::displayMoneyFormat(OrderProduct::MIN_REMAINING_AMOUNT_REQUEST_FOR_PARTIAL_PAYMENT, true, true, true, false, true);
                $message = sprintf(Labels::getLabel('LBL_Remaining_amount_should_not_be_less_than_%s_or_select_the_full_amount', $this->siteLangId), $remaningAmt);
                FatUtility::dieJsonError($message);
            }
        }
        
        
        
        
        
        
        $orderData = array();
        $order_id = isset($_SESSION['wallet_recharge_cart']["order_id"]) ? $_SESSION['wallet_recharge_cart']["order_id"] : false;
        $orderData['order_type'] = Orders::ORDER_WALLET_RECHARGE;

        $orderData['userAddresses'] = array(); //No Need of it
        $orderData['order_id'] = $order_id;
        $orderData['order_user_id'] = $loggedUserId;
        $orderData['order_payment_status'] = Orders::ORDER_PAYMENT_PENDING;
        $orderData['order_date_added'] = date('Y-m-d H:i:s');
        $orderData['order_cart_data'] = json_encode(['order_id'=>$parent_order_id,'op_id'=>$parent_op_id,'oppl_id'=>$oppl_id,'is_flexi_payment'=>1]);

        /* order extras[ */
        $orderData['extra'] = array(
            'oextra_order_id' => $order_id,
            'order_ip_address' => $_SERVER['REMOTE_ADDR']
        );

        if (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_X_FORWARDED_FOR'];
        } elseif (!empty($_SERVER['HTTP_CLIENT_IP'])) {
            $orderData['extra']['order_forwarded_ip'] = $_SERVER['HTTP_CLIENT_IP'];
        } else {
            $orderData['extra']['order_forwarded_ip'] = '';
        }

        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $orderData['extra']['order_user_agent'] = $_SERVER['HTTP_USER_AGENT'];
        } else {
            $orderData['extra']['order_user_agent'] = '';
        }

        if (isset($_SERVER['HTTP_ACCEPT_LANGUAGE'])) {
            $orderData['extra']['order_accept_language'] = $_SERVER['HTTP_ACCEPT_LANGUAGE'];
        } else {
            $orderData['extra']['order_accept_language'] = '';
        }
        /* ] */

        $languageRow = Language::getAttributesById($this->siteLangId);
        $orderData['order_language_id'] = $languageRow['language_id'];
        $orderData['order_language_code'] = $languageRow['language_code'];

        $currencyRow = Currency::getAttributesById($this->siteCurrencyId);
        $orderData['order_currency_id'] = $currencyRow['currency_id'];
        $orderData['order_currency_code'] = $currencyRow['currency_code'];
        $orderData['order_currency_value'] = $currencyRow['currency_value'];

        $orderData['order_user_comments'] = '';
        $orderData['order_admin_comments'] = '';
        
        $orderData['order_is_wallet_selected'] = 0;
        $orderData['order_shippingapi_id'] = 0;
        $orderData['order_shippingapi_code'] = '';
        $orderData['order_tax_charged'] = 0;
        $orderData['order_site_commission'] = 0;
        $orderData['order_net_amount'] = $order_net_amount;
        $orderData['order_wallet_amount_charge'] = 0;

        $orderData['orderLangData'] = array();
        $orderObj = new Orders();
        if ($orderObj->addUpdateOrder($orderData, $this->siteLangId)) {
            $order_id = $orderObj->getOrderId();
        } else {
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError($orderObj->getError());
            }
            Message::addErrorMessage($orderObj->getError());
            FatUtility::dieWithError(Message::getHtml());
        }
        if (true === MOBILE_APP_API_CALL) {
            /* Payment Methods[ */
            $pmSrch = PaymentMethods::getSearchObject($this->siteLangId);
            $pmSrch->doNotCalculateRecords();
            $pmSrch->doNotLimitRecords();
            $pmSrch->addMultipleFields(Plugin::ATTRS);
            $pmSrch->addCondition('plugin_code', '!=', 'CashOnDelivery');

            $pmRs = $pmSrch->getResultSet();
            $paymentMethods = FatApp::getDb()->fetchAll($pmRs);
            $excludePaymentGatewaysArr = applicationConstants::getExcludePaymentGatewayArr();
            /* ] */
            $this->set('paymentMethods', $paymentMethods);
            $this->set('excludePaymentGatewaysArr', $excludePaymentGatewaysArr);
            $this->set('order_id', $order_id);
            $this->set('orderType', Orders::ORDER_WALLET_RECHARGE);
            $this->_template->render();
        }
        
        $this->set('redirectUrl', UrlHelper::generateUrl('OrderPay', 'Recharge', array($order_id)));
        $this->set('msg', Labels::getLabel('MSG_Redirecting', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function creditSearch()
    {
        $frm = $this->getCreditsSearchForm($this->siteLangId);

        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        //$page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        if ($page < 2) {
            $page = 1;
        }
        $pagesize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);


        $userId = UserAuthentication::getLoggedUserId();
        $debit_credit_type = FatApp::getPostedData('debit_credit_type', FatUtility::VAR_INT, -1);
        $dateOrder = FatApp::getPostedData('date_order', FatUtility::VAR_STRING, "DESC");

        $srch = Transactions::getUserTransactionsObj($userId);
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $srch->addOrder('utxn.utxn_date', $dateOrder);

        $keyword = FatApp::getPostedData('keyword', null, '');
        if (!empty($keyword)) {
            $cond = $srch->addCondition('utxn.utxn_order_id', 'like', '%' . $keyword . '%');
            $cond->attachCondition('utxn.utxn_op_id', 'like', '%' . $keyword . '%', 'OR');
            $cond->attachCondition('utxn.utxn_comments', 'like', '%' . $keyword . '%', 'OR');
            $cond->attachCondition('concat("TN-" ,lpad( utxn.`utxn_id`,7,0))', 'like', '%' . $keyword . '%', 'OR', true);
        }

        $fromDate = FatApp::getPostedData('date_from', FatUtility::VAR_DATE, '');
        if (!empty($fromDate)) {
            $cond = $srch->addCondition('utxn.utxn_date', '>=', $fromDate);
        }

        $toDate = FatApp::getPostedData('date_to', FatUtility::VAR_DATE, '');
        if (!empty($toDate)) {
            $cond = $srch->addCondition('cast( utxn.`utxn_date` as date)', '<=', $toDate, 'and', true);
        }
        if ($debit_credit_type > 0) {
            switch ($debit_credit_type) {
                case Transactions::CREDIT_TYPE:
                    $srch->addCondition('utxn.utxn_credit', '>', 'mysql_func_0', 'AND', true);
                    $srch->addCondition('utxn.utxn_debit', '=', 'mysql_func_0', 'AND', true);
                    break;

                case Transactions::DEBIT_TYPE:
                    $srch->addCondition('utxn.utxn_debit', '>', 'mysql_func_0', 'AND', true);
                    $srch->addCondition('utxn.utxn_credit', '=', 'mysql_func_0', 'AND', true);
                    break;
            }
        }
        $records = array();

        $rs = $srch->getResultSet();

        $records = FatApp::getDb()->fetchAll($rs, 'utxn_id');
        $this->set('arrListing', $records);
        $this->set('page', $page);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('postedData', $post);
        $this->set('pageSize', $pagesize);
        $this->set('siteLangId', $this->siteLangId);
        $this->set('statusArr', Transactions::getStatusArr($this->siteLangId));
        $this->set('statusClassArr', Transactions::getStatusClassArr());
        if (true === MOBILE_APP_API_CALL) {
            $this->creditsInfo();
            $this->_template->render();
        }
        $this->_template->render(false, false);
    }

    public function requestWithdrawal()
    {
        $frm = $this->getWithdrawalForm($this->siteLangId);

        if (User::isAffiliate()) {
            $fld = $frm->getField('ub_ifsc_swift_code');
            $fld->requirements()->setRegularExpressionToValidate(ValidateElement::USERNAME_REGEX);
        }

        $userId = UserAuthentication::getLoggedUserId();
        $balance = User::getUserBalance($userId);
        $lastWithdrawal = User::getUserLastWithdrawalRequest($userId);

        if ($lastWithdrawal && (strtotime($lastWithdrawal["withdrawal_request_date"] . "+" . FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS", FatUtility::VAR_INT, 0) . " days") - time()) > 0) {
            $nextWithdrawalDate = date('d M,Y', strtotime($lastWithdrawal["withdrawal_request_date"] . "+" . FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS", FatUtility::VAR_INT, 0) . " days"));
            Message::addErrorMessage(sprintf(Labels::getLabel('MSG_Withdrawal_Request_Date', $this->siteLangId), FatDate::format($lastWithdrawal["withdrawal_request_date"]), FatDate::format($nextWithdrawalDate), FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS")));
            FatUtility::dieWithError(Message::getHtml());
        }

        $minimumWithdrawLimit = FatApp::getConfig("CONF_MIN_WITHDRAW_LIMIT", FatUtility::VAR_INT, 0);
        if ($balance < $minimumWithdrawLimit) {
            Message::addErrorMessage(sprintf(Labels::getLabel('MSG_Withdrawal_Request_Minimum_Balance_Less', $this->siteLangId), CommonHelper::displayMoneyFormat($minimumWithdrawLimit)));
            FatUtility::dieWithError(Message::getHtml());
        }

        $userObj = new User($userId);
        $data = $userObj->getUserBankInfo();
        $data['uextra_payment_method'] = User::AFFILIATE_PAYMENT_METHOD_CHEQUE;

        if (User::isAffiliate()) {
            $userExtraData = User::getUserExtraData($userId, array('uextra_payment_method', 'uextra_cheque_payee_name', 'uextra_paypal_email_id'));
            $uextra_payment_method = isset($userExtraData['uextra_payment_method']) ? $userExtraData['uextra_payment_method'] : User::AFFILIATE_PAYMENT_METHOD_CHEQUE;
            $data = array_merge($data, $userExtraData);
            $data['uextra_payment_method'] = $uextra_payment_method;
            $this->set('uextra_payment_method', $uextra_payment_method);
        }

        $frm->fill($data);

        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function setupRequestWithdrawal()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $balance = User::getUserBalance($userId);
        $lastWithdrawal = User::getUserLastWithdrawalRequest($userId);

        if ($lastWithdrawal && (strtotime($lastWithdrawal["withdrawal_request_date"] . "+" . FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS", FatUtility::VAR_INT, 0) . " days") - time()) > 0) {
            $nextWithdrawalDate = date('d M,Y', strtotime($lastWithdrawal["withdrawal_request_date"] . "+" . FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS") . " days"));

            $message = sprintf(Labels::getLabel('MSG_Withdrawal_Request_Date', $this->siteLangId), FatDate::format($lastWithdrawal["withdrawal_request_date"]), FatDate::format($nextWithdrawalDate), FatApp::getConfig("CONF_MIN_INTERVAL_WITHDRAW_REQUESTS"));
            FatUtility::dieJsonError($message);
        }

        $minimumWithdrawLimit = FatApp::getConfig("CONF_MIN_WITHDRAW_LIMIT", FatUtility::VAR_INT, 0);
        if ($balance < $minimumWithdrawLimit) {
            $message = sprintf(Labels::getLabel('MSG_Withdrawal_Request_Minimum_Balance_Less', $this->siteLangId), CommonHelper::displayMoneyFormat($minimumWithdrawLimit));
            FatUtility::dieJsonError($message);
        }

        $frm = $this->getWithdrawalForm($this->siteLangId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            LibHelper::dieJsonError(current($frm->getValidationErrors()));
        }

        if (($minimumWithdrawLimit > $post["withdrawal_amount"])) {
            $message =  Labels::getLabel('MSG_Your_withdrawal_request_amount_is_less_than_the_minimum_allowed_amount_of', $this->siteLangId) . ' ' . CommonHelper::displayMoneyFormat($minimumWithdrawLimit);
            FatUtility::dieJsonError($message);
        }

        $maximumWithdrawLimit = FatApp::getConfig("CONF_MAX_WITHDRAW_LIMIT", FatUtility::VAR_INT, 0);
        if (($maximumWithdrawLimit < $post["withdrawal_amount"])) {
            $message = Labels::getLabel('MSG_Your_withdrawal_request_amount_is_greater_than_the_maximum_allowed_amount_of', $this->siteLangId) . ' ' . CommonHelper::displayMoneyFormat($maximumWithdrawLimit);
            FatUtility::dieJsonError($message);
        }

        if (($post["withdrawal_amount"] > $balance)) {
            $message = Labels::getLabel('MSG_Withdrawal_Request_Greater', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $accountNumber = FatApp::getPostedData('ub_account_number', FatUtility::VAR_STRING, 0);

        if ((string) $accountNumber != $post['ub_account_number']) {
            $message = Labels::getLabel('MSG_Invalid_Account_Number', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }


        $userObj = new User($userId);
        if (!$userObj->updateBankInfo($post)) {
            $message = Labels::getLabel($userObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $withdrawal_payment_method = FatApp::getPostedData('uextra_payment_method', FatUtility::VAR_INT, 0);

        $withdrawal_payment_method = ($withdrawal_payment_method > 0 && array_key_exists($withdrawal_payment_method, User::getAffiliatePaymentMethodArr($this->siteLangId))) ? $withdrawal_payment_method : User::AFFILIATE_PAYMENT_METHOD_BANK;
        $withdrawal_cheque_payee_name = '';
        $withdrawal_paypal_email_id = '';
        $withdrawal_bank = '';
        $withdrawal_account_holder_name = '';
        $withdrawal_account_number = '';
        $withdrawal_ifc_swift_code = '';
        $withdrawal_bank_address = '';
        $withdrawal_instructions = $post['withdrawal_instructions'];

        switch ($withdrawal_payment_method) {
            case User::AFFILIATE_PAYMENT_METHOD_CHEQUE:
                $withdrawal_cheque_payee_name = $post['uextra_cheque_payee_name'];
                break;
            case User::AFFILIATE_PAYMENT_METHOD_BANK:
                $withdrawal_bank = $post['ub_bank_name'];
                $withdrawal_account_holder_name = $post['ub_account_holder_name'];
                $withdrawal_account_number = $post['ub_account_number'];
                $withdrawal_ifc_swift_code = $post['ub_ifsc_swift_code'];
                $withdrawal_bank_address = $post['ub_bank_address'];
                break;
            case User::AFFILIATE_PAYMENT_METHOD_PAYPAL:
                $withdrawal_paypal_email_id = $post['uextra_paypal_email_id'];
                break;
        }


        $post['withdrawal_payment_method'] = $withdrawal_payment_method;
        $post['withdrawal_cheque_payee_name'] = $withdrawal_cheque_payee_name;
        $post['withdrawal_paypal_email_id'] = $withdrawal_paypal_email_id;

        $post['ub_bank_name'] = $withdrawal_bank;
        $post['ub_account_holder_name'] = $withdrawal_account_holder_name;
        $post['ub_account_number'] = $withdrawal_account_number;
        $post['ub_ifsc_swift_code'] = $withdrawal_ifc_swift_code;
        $post['ub_bank_address'] = $withdrawal_bank_address;

        $post['withdrawal_instructions'] = $withdrawal_instructions;

        if (!$withdrawRequestId = $userObj->addWithdrawalRequest(array_merge($post, array("ub_user_id" => $userId)), $this->siteLangId)) {
            $message = Labels::getLabel($userObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $emailNotificationObj = new EmailHandler();
        if (!$emailNotificationObj->sendWithdrawRequestNotification($withdrawRequestId, $this->siteLangId, "A")) {
            $message = Labels::getLabel($emailNotificationObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        //send notification to admin
        $notificationData = array(
            'notification_record_type' => Notification::TYPE_WITHDRAWAL_REQUEST,
            'notification_record_id' => $withdrawRequestId,
            'notification_user_id' => UserAuthentication::getLoggedUserId(),
            'notification_label_key' => Notification::WITHDRAWL_REQUEST_NOTIFICATION,
            'notification_added_on' => date('Y-m-d H:i:s'),
        );

        if (!Notification::saveNotifications($notificationData)) {
            $message = Labels::getLabel("MSG_NOTIFICATION_COULD_NOT_BE_SENT", $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $this->set('msg', Labels::getLabel('MSG_Withdraw_request_placed_successfully', $this->siteLangId));

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function removeProfileImage()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $userId = FatUtility::int($userId);
        if (1 > $userId) {
            $message = Labels::getLabel('MSG_INVALID_REQUEST_ID', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage();
            FatUtility::dieJsonError(Message::getHtml());
        }

        $fileHandlerObj = new AttachedFile();
        if (!$fileHandlerObj->deleteFile(AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $userId)) {
            $message = Labels::getLabel($fileHandlerObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if (!$fileHandlerObj->deleteFile(AttachedFile::FILETYPE_USER_PROFILE_CROPED_IMAGE, $userId)) {
            $message = Labels::getLabel($fileHandlerObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $where = array('smt' => 'user_id = ?', 'vals' => array($userId));
        FatApp::getDb()->updateFromArray(User::DB_TBL, array('user_updated_on' => date('Y-m-d  H:i:s')), $where);
        $this->set('msg', Labels::getLabel('MSG_Profile_Image_Removed_Successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $userImgUpdatedOn = User::getAttributesById($userId, 'user_updated_on');
            $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
            $userImage = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'user', array($userId, 'thumb', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

            $data = array('userImage' => $userImage);

            $this->set('data', $data);
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function profileInfo()
    {
        if (true === MOBILE_APP_API_CALL) {
            $userId = UserAuthentication::getLoggedUserId(true);
            $userImgUpdatedOn = User::getAttributesById($userId, 'user_updated_on');
            $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);

            $hasDigitalProducts = 0;

            $srch = Product::getSearchObject();
            $srch->addMultipleFields(['product_id']);
            $srch->addCondition('product_type', '=', 'mysql_func_' . Product::PRODUCT_TYPE_DIGITAL, 'AND', true);
            $srch->setPageSize(1);
            $rs = $srch->getResultSet();
            $row = $this->db->fetch($rs);
            if (!empty($row) && 0 < count($row)) {
                $hasDigitalProducts = 1;
            }

            $srch = new UserGdprRequestSearch();
            $srch->addCondition('ureq_user_id', '=', $this->userParentId);
            $srch->addCondition('ureq_deleted', '=', applicationConstants::NO);
            $srch->addOrder('ureq_id', 'DESC');
            $rs = $srch->getResultSet();
            $gdprRequest = $this->db->fetch($rs);          

            $splitPaymentMethods = Plugin::getDataByType(Plugin::TYPE_SPLIT_PAYMENT_METHOD, $this->siteLangId);
            $bankInfo = $this->bankInfo();
            $personalInfo = $this->personalInfo();
            $personalInfo['userImage'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'user', array($userId, 'SMALL', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
            $personalInfo['user_country_iso'] = User::getUserMeta($userId, 'user_country_iso');
            $this->set('personalInfo', empty($personalInfo) ? (object) array() : $personalInfo);
            $this->set('bankInfo', empty($bankInfo) ? (object) array() : $bankInfo);
            $this->set('privacyPolicyLink', FatApp::getConfig('CONF_PRIVACY_POLICY_PAGE', FatUtility::VAR_STRING, ''));
            $this->set('hasDigitalProducts', $hasDigitalProducts);
            $this->set('splitPaymentMethods', $splitPaymentMethods);
            $this->set('gdprRequest', $gdprRequest);
            $this->_template->render();
        }

        $this->_template->addJs('js/jquery.form.js');
        $this->_template->addJs('js/cropper.js');
        $this->_template->addJs('js/cropper-main.js');
        $this->includeDateTimeFiles();

        $userId = UserAuthentication::getLoggedUserId();

        $data = User::getAttributesById($userId, array('user_preferred_dashboard', 'user_registered_initially_for', 'user_parent'));
        if ($data === false) {
            FatUtility::dieWithError(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
        }

        $showSellerActivateButton = false;
        if (!User::canAccessSupplierDashboard() && $data['user_registered_initially_for'] == User::USER_TYPE_SELLER) {
            $showSellerActivateButton = true;
        }

        $payoutPlugins = Plugin::getNamesWithCode(Plugin::TYPE_PAYOUTS, $this->siteLangId);

        $this->set('userParentId', $data['user_parent']);
        $this->set('payouts', $payoutPlugins);
        $this->set('showSellerActivateButton', $showSellerActivateButton);
        $this->set('userPreferredDashboard', $data['user_preferred_dashboard']);
        $this->_template->render();
    }

    public function personalInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $userObj = new User($userId);
        $srch = $userObj->getUserSearchObj();
        $srch->addMultipleFields(array('u.*', 'country_name', 'state_name'));
        $srch->joinTable('tbl_countries_lang', 'LEFT JOIN', 'countrylang_country_id = user_country_id and countrylang_lang_id = ' . $this->siteLangId);
        $srch->joinTable('tbl_states_lang', 'LEFT JOIN', 'statelang_state_id = user_state_id and statelang_lang_id = ' . $this->siteLangId);
        $rs = $srch->getResultSet();
        $data = FatApp::getDb()->fetch($rs, 'user_id');
        if (true === MOBILE_APP_API_CALL) {
            return $data;
        }
        $this->set('info', $data);
        $this->_template->render(false, false);
    }

    public function bankInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $userObj = new User($userId);
        $data = $userObj->getUserBankInfo();
        if (true === MOBILE_APP_API_CALL) {
            return $data;
        }
        $this->set('info', $data);
        $this->_template->render(false, false);
    }

    public function profileInfoForm()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $frm = $this->getProfileInfoForm();
        $imgFrm = $this->getProfileImageForm();
        $stateId = 0;

        $userObj = new User($userId);
        $srch = $userObj->getUserSearchObj();
        $srch->addMultipleFields(array('u.*'));
        $rs = $srch->getResultSet();
        $data = FatApp::getDb()->fetch($rs, 'user_id');

        if (User::isAffiliate()) {
            $userExtraData = User::getUserExtraData($userId, array('uextra_company_name', 'uextra_website'));
            $userExtraData = ($userExtraData) ? $userExtraData : array();
            $data = array_merge($userExtraData, $data);
        }

        if ($data['user_dob'] == "0000-00-00") {
            $dobFld = $frm->getField('user_dob');
            $dobFld->requirements()->setRequired(true);
        }

        $frm->fill($data);
        $stateId = $data['user_state_id'];

        $mode = 'Add';
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $userId);
        if ($file_row['afile_id'] > 0) {
            $mode = 'Edit';
        }
        $this->set('countryIso', User::getUserMeta($userId, 'user_country_iso'));
        $this->set('data', $data);
        $this->set('frm', $frm);
        $this->set('imgFrm', $imgFrm);
        $this->set('mode', $mode);
        $this->set('stateId', $stateId);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }

    public function imgCropper()
    {
        $userId = UserAuthentication::getLoggedUserId(true);
        $userImgUpdatedOn = User::getAttributesById($userId, 'user_updated_on');
        $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);
        $fileRow = AttachedFile::getAttachment(AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $userId);
        $userImage = "";
        if (0 < $fileRow['afile_id']) {
            $userImage = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'user', array($userId)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
        }

        $this->set('image', $userImage);
        $this->_template->render(false, false, 'cropper/index.php');
    }

    public function profileImageForm()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $imgFrm = $this->getProfileImageForm();
        $mode = 'Add';
        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $userId);
        if ($file_row != false) {
            $mode = 'Edit';
        }
        $this->set('mode', $mode);
        $this->set('imgFrm', $imgFrm);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }

    public function uploadProfileImage()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $post = FatApp::getPostedData();

        if (empty($post)) {
            $message = Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $updatedAt = date('Y-m-d H:i:s');
        $uploadedTime = AttachedFile::setTimeParam($updatedAt);

        if (isset($_FILES['org_image']['tmp_name'])) {
            $fileHandlerObj = new AttachedFile();
            if (!$fileHandlerObj->isUploadedFile($_FILES['org_image']['tmp_name'])) {
                FatUtility::dieJsonError($fileHandlerObj->getError());
            }

            if ($_FILES['org_image']['size'] > AttachedFile::IMAGE_MAX_SIZE_IN_BYTES_FOR_CROPPER) { /* in kbs */
                Message::addErrorMessage(Labels::getLabel('MSG_Maximum_Upload_Size_is', $this->siteLangId) . ' ' . AttachedFile::IMAGE_MAX_SIZE_IN_BYTES / 1024 . 'KB');
                FatUtility::dieJsonError(Message::getHtml());
            }

            if (!$res = $fileHandlerObj->saveImage($_FILES['org_image']['tmp_name'], AttachedFile::FILETYPE_USER_PROFILE_IMAGE, $userId, 0, $_FILES['org_image']['name'], -1, true)) {
                $message = Labels::getLabel($fileHandlerObj->getError(), $this->siteLangId);
                FatUtility::dieJsonError($message);
            }
        }

        if (isset($_FILES['cropped_image']['tmp_name'])) {
            if ($_FILES['cropped_image']['size'] > AttachedFile::IMAGE_MAX_SIZE_IN_BYTES_FOR_CROPPER) { /* in kbs */
                Message::addErrorMessage(Labels::getLabel('MSG_Maximum_Upload_Size_is', $this->siteLangId) . ' ' . AttachedFile::IMAGE_MAX_SIZE_IN_BYTES / 1024 . 'KB');
                FatUtility::dieJsonError(Message::getHtml());
            }

            $fileHandlerObj = new AttachedFile();
            if (!$fileHandlerObj->isUploadedFile($_FILES['cropped_image']['tmp_name'])) {
                FatUtility::dieJsonError($fileHandlerObj->getError());
            }

            if (!$res = $fileHandlerObj->saveImage($_FILES['cropped_image']['tmp_name'], AttachedFile::FILETYPE_USER_PROFILE_CROPED_IMAGE, $userId, 0, $_FILES['cropped_image']['name'], -1, true)) {
                $message = Labels::getLabel($fileHandlerObj->getError(), $this->siteLangId);
                FatUtility::dieJsonError($message);
            }
        }

        if (false === MOBILE_APP_API_CALL) {
            $profileImg = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'userProfileImage', array($userId, 'croped', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
            $this->set('file', $profileImg);
        } else {
            $profileImg = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'user', array($userId, 'mini', true)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
            $this->set('file', $profileImg);
        }
        $this->set('file', $profileImg);

        User::setImageUpdatedOn($userId, $updatedAt);
        $this->set('msg', Labels::getLabel('MSG_File_uploaded_successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function updateProfileInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $frm = $this->getProfileInfoForm();

        $post = FatApp::getPostedData();
        Common::filterTags($post);
        if (1 > count($post) && true === MOBILE_APP_API_CALL) {
            LibHelper::dieJsonError(Labels::getLabel("MSG_INVALID_REQUEST", $this->siteLangId));
        }

        $user_state_id = FatApp::getPostedData('user_state_id', FatUtility::VAR_INT, 0);
        $post = $frm->getFormDataFromArray($post);
       
        if (false === $post) {
            $message = Labels::getLabel(current($frm->getValidationErrors()), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if (strtotime($post['user_dob']) > time()) {
            $message = Labels::getLabel("MSG_Invalid_date_of_birth", $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $post['user_state_id'] = $user_state_id;

        if (isset($post['user_id'])) {
            unset($post['user_id']);
        }
        $userPhone = User::getAttributesById($userId, 'user_phone');
        if (isset($post['user_phone']) && true == SmsArchive::canSendSms() && !empty($userPhone)) {
            unset($post['user_phone']);
        }

        if ($post['user_dob'] == "0000-00-00" || $post['user_dob'] == "" || strtotime($post['user_dob']) == 0) {
            unset($post['user_dob']);
        }

        unset($post['credential_username'], $post['credential_email']);

        /* saving user extras[ */
        if (User::isAffiliate()) {
            $dataToSave = array(
                'uextra_user_id' => $userId,
                'uextra_company_name' => $post['uextra_company_name'],
                'uextra_website' => CommonHelper::processUrlString($post['uextra_website'])
            );
            $dataToUpdateOnDuplicate = $dataToSave;
            unset($dataToUpdateOnDuplicate['uextra_user_id']);
            if (!FatApp::getDb()->insertFromArray(User::DB_TBL_USR_EXTRAS, $dataToSave, false, array(), $dataToUpdateOnDuplicate)) {
                $message = Labels::getLabel("LBL_Details_could_not_be_saved!", $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }

                Message::addErrorMessage($message);
                if (FatUtility::isAjaxCall()) {
                    FatUtility::dieWithError(Message::getHtml());
                }
                FatApp::redirectUser(UrlHelper::generateUrl('Account', 'ProfileInfo'));
            }
        }
        /* ] */

        if (false == SmsArchive::canSendSms() || empty($userPhone)) {
            $post['user_dial_code'] = FatApp::getPostedData('user_dial_code', FatUtility::VAR_STRING, '');
            $countryIso = FatApp::getPostedData('user_country_iso', FatUtility::VAR_STRING, '');
        }

        $userObj = new User($userId);
        $userObj->assignValues($post);
        if (!$userObj->save()) {
            $message = Labels::getLabel($userObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if (false == SmsArchive::canSendSms() || !empty($countryIso)) {
            $user = clone $userObj;
            if (false === $user->updateUserMeta('user_country_iso', $countryIso)) {
                LibHelper::dieJsonError($user->getError());
            }
        }

        $postUserName = isset($post['user_name']) ? $post['user_name'] : '';
        $sessionUserName = isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['user_name']) ? $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['user_name'] : '';
        if (!empty($postUserName) && !empty($sessionUserName) && $postUserName != $sessionUserName) {
            $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['user_name'] = $postUserName;
        }

        $this->set('msg', Labels::getLabel('MSG_Updated_Successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function bankInfoForm()
    {
        $userId = UserAuthentication::getLoggedUserId();

        if (User::isAffiliate()) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $userObj = new User($userId);
        $data = $userObj->getUserBankInfo();

        if (true === MOBILE_APP_API_CALL) {
            $this->set('data', ['bankInfo' => (object) $data]);
            $this->_template->render();
        }

        $frm = $this->getBankInfoForm();
        if ($data != false) {
            $frm->fill($data);
        }

        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function settingsInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $frm = $this->getSettingsForm();

        $userObj = new User($userId);
        $srch = $userObj->getUserSearchObj();
        $srch->addMultipleFields(array('u.*'));
        $rs = $srch->getResultSet();
        $data = FatApp::getDb()->fetch($rs, 'user_id');
        if ($data != false) {
            $frm->fill($data);
        }

        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function updateBankInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $post = FatApp::getPostedData();
        if (1 > count($post) && true === MOBILE_APP_API_CALL) {
            LibHelper::dieJsonError(Labels::getLabel("MSG_INVALID_REQUEST", $this->siteLangId));
        }

        $frm = $this->getBankInfoForm();
        $post = $frm->getFormDataFromArray($post);

        if (false === $post) {
            $message = Labels::getLabel(current($frm->getValidationErrors()), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $accountNumber = FatApp::getPostedData('ub_account_number', FatUtility::VAR_STRING, 0);

        if ((string) $accountNumber != $post['ub_account_number']) {
            $message = Labels::getLabel('MSG_Invalid_Account_Number', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }


        $userObj = new User($userId);
        if (!$userObj->updateBankInfo($post)) {
            $message = Labels::getLabel($userObj->getError(), $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $this->set('msg', Labels::getLabel('MSG_Updated_Successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function updateSettingsInfo()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $frm = $this->getSettingsForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $userObj = new User($userId);
        if (!$userObj->updateSettingsInfo($post)) {
            Message::addErrorMessage(Labels::getLabel($userObj->getError(), $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('MSG_Setup_successful', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function changeEmailForm()
    {
        $frm = $this->getChangeEmailForm();

        $this->set('frm', $frm);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }

    public function updateEmail()
    {
        $emailFrm = $this->getChangeEmailForm();
        $post = FatApp::getPostedData();
        $post['user_id'] = 0;
        $post = $emailFrm->getFormDataFromArray($post);

        if (false === $post) {
            $message = $emailFrm->getValidationErrors();
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError(current($message));
            }
            Message::addErrorMessage($message);
            FatUtility::dieJsonError(Message::getHtml());
        }

        if ($post['new_email'] != $post['conf_new_email']) {
            $message = Labels::getLabel('MSG_New_email_confirm_email_does_not_match', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $userObj = new User(UserAuthentication::getLoggedUserId());
        $srch = $userObj->getUserSearchObj(array('user_id', 'credential_password', 'credential_email', 'user_name', 'user_dial_code', 'user_phone'));
        $rs = $srch->getResultSet();

        if (!$rs) {
            $message = Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        $data = FatApp::getDb()->fetch($rs, 'user_id');

        if ($data === false) {
            $message = Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if ($data['credential_password'] != UserAuthentication::encryptPassword($post['current_password'])) {
            $message = Labels::getLabel('MSG_YOUR_CURRENT_PASSWORD_MIS_MATCHED', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }
        $phone = !empty($data['user_phone']) ? $data['user_dial_code'] . $data['user_phone'] : '';
        $arr = array(
            'user_name' => $data['user_name'],
            'user_phone' => $phone,
            'user_email' => $data['credential_email'],
            'user_new_email' => $post['new_email']
        );

        if (!$this->userEmailVerifications($userObj, $arr)) {
            $message = Labels::getLabel('MSG_ERROR_IN_SENDING_VERFICATION_EMAIL', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }


        $this->set('msg', Labels::getLabel('MSG_CHANGE_EMAIL_REQUEST_SENT_SUCCESSFULLY', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function moveToWishList($selProdId)
    {
        $wishList = new UserWishList();
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $defaultWishListId = $wishList->getWishListId($loggedUserId, UserWishList::TYPE_DEFAULT_WISHLIST);
        $this->addRemoveWishListProduct($selProdId, $defaultWishListId);
    }

    public function moveToSaveForLater($selProdId)
    {
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $cartObj = new Cart($loggedUserId, $this->siteLangId, $this->app_user['temp_user_id']);
        $wishList = new UserWishList();
        $wishListId = $wishList->getWishListId($loggedUserId, UserWishList::TYPE_SAVE_FOR_LATER);
        if (!$wishList->addUpdateListProducts($wishListId, $selProdId, $cartObj->getCartType())) {
            FatUtility::dieJsonError(Labels::getLabel("LBL_Invalid_Request", $this->siteLangId));
        }

        //$key = md5(base64_encode(json_encode(Cart::CART_KEY_PREFIX_PRODUCT . $selProdId)));
        $key = FatApp::getPostedData('key', FatUtility::VAR_STRING, "");
        if (!$cartObj->remove($key)) {
            LibHelper::dieJsonError($cartObj->getError());
        }

        if (true === MOBILE_APP_API_CALL) {
            $fulfilmentType = FatApp::getPostedData('fulfilmentType', FatUtility::VAR_INT, Shipping::FULFILMENT_SHIP);
            $cartObj = new Cart(UserAuthentication::getLoggedUserId(true), $this->siteLangId, $this->app_user['temp_user_id'], Cart::PAGE_TYPE_CART);
            $cartObj->setFulfilmentType($fulfilmentType);
            $cartObj->setCartCheckoutType($fulfilmentType);
            $productsArr = $cartObj->getProducts($this->siteLangId);
            $cartSummary = $cartObj->getCartFinancialSummary($this->siteLangId);
            $this->set('products', $productsArr);
            $this->set('cartSummary', $cartSummary);
            $this->_template->render();
        }

        $this->set('totalProducts', $cartObj->countProducts());
        $this->_template->render(false, false, 'json-success.php');
    }

    /* called from products listing page */

    public function viewWishList($selprod_id, $excludeWishList = 0)
    {
        $excludeWishList = FatUtility::int($excludeWishList);
        $loggedUserId = UserAuthentication::getLoggedUserId();

        $wishLists = UserWishList::getUserWishLists($loggedUserId, true, $excludeWishList);
        $frm = $this->getCreateWishListForm();
        $frm->fill(array('selprod_id' => $selprod_id));
        $this->set('frm', $frm);
        $this->set('wishLists', $wishLists);
        $this->set('selprod_id', $selprod_id);
        $this->_template->render(false, false);
    }

    public function setupWishList()
    {
        $frm = $this->getCreateWishListForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        $selprod_id = FatUtility::int($post['selprod_id']);
        if (false === $post) {
            $message = current($frm->getValidationErrors());
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $wListObj = new UserWishList();
        $data_to_save_arr = $post;
        $data_to_save_arr['uwlist_added_on'] = date('Y-m-d H:i:s');
        $data_to_save_arr['uwlist_user_id'] = UserAuthentication::getLoggedUserId();
        $wListObj->assignValues($data_to_save_arr);

        /* create new List[ */
        if (!$wListObj->save()) {
            $message = $wListObj->getError();
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }
        $uwlp_uwlist_id = $wListObj->getMainTableRecordId();
        /* ] */

        $successMsg = Labels::getLabel('LBL_WishList_Created_Successfully', $this->siteLangId);
        /* Assign current product to newly created list[ */
        if ($uwlp_uwlist_id && $selprod_id) {
            if (!$wListObj->addUpdateListProducts($uwlp_uwlist_id, $selprod_id)) {
                Message::addMessage($successMsg);
                $msg = Labels::getLabel('LBL_Error_while_assigning_product_under_selected_list.', $this->siteLangId);

                if (true === MOBILE_APP_API_CALL) {
                    LibHelper::dieJsonError($msg);
                }
                Message::addErrorMessage($msg);
                FatUtility::dieWithError(Message::getHtml());
            }
        }
        /* ] */

        //UserWishList
        $srch = UserWishList::getSearchObject($loggedUserId);
        $srch->joinTable(UserWishList::DB_TBL_LIST_PRODUCTS, 'LEFT OUTER JOIN', 'uwlist_id = uwlp_uwlist_id');
        $srch->addCondition('uwlp_selprod_id', '=', 'mysql_func_' . $selprod_id, 'AND', true);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addMultipleFields(array('uwlist_id'));
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        $productIsInAnyList = false;
        if ($row) {
            $productIsInAnyList = true;
        }

        $this->set('productIsInAnyList', $productIsInAnyList);
        $this->set('wish_list_id', $uwlp_uwlist_id);
        $this->set('msg', $successMsg);
        if (true === MOBILE_APP_API_CALL) {
            $this->set('data', ['wish_list_id' => $uwlp_uwlist_id]);
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function addRemoveWishListProductArr()
    {
        $selprod_id_arr = FatApp::getPostedData('selprod_id');
        $selprod_id_arr = !empty($selprod_id_arr) ? array_filter($selprod_id_arr) : array();

        $uwlist_id = FatApp::getPostedData('uwlist_id', FatUtility::VAR_INT, 0);

        if (empty($selprod_id_arr) || empty($uwlist_id)) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        foreach ($selprod_id_arr as $selprod_id) {
            $action = $this->updateWishList($selprod_id, $uwlist_id);
        }

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function updateRemoveWishListProduct($selprodId, $wishListId)
    {
        $selprodIdArr = FatApp::getPostedData('selprod_id');
        $oldWishlistId = FatApp::getPostedData('uwlist_id', FatUtility::VAR_INT, 0);

        if (empty($selprodIdArr) || empty($oldWishlistId)) {
            Message::addErrorMessage(Labels::getLabel("LBL_Invalid_Request", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        foreach ($selprodIdArr as $selprodId) {
            $this->updateWishList($selprodId, $oldWishlistId);
            $isExists = UserWishList::getListProductsByListId($wishListId, $selprodId);
            if (empty($isExists)) {
                $this->updateWishList($selprodId, $wishListId);
            }
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function addRemoveWishListProduct($selprod_id, $wish_list_id, $rowAction = '', $removeFromCart = 0)
    {
        $selprod_id = FatUtility::int($selprod_id);
        $wish_list_id = FatUtility::int($wish_list_id);
        $rowAction = ('' == $rowAction ? -1 : $rowAction);
        $loggedUserId = UserAuthentication::getLoggedUserId();

        if (1 > $wish_list_id) {
            $wishList = new UserWishList();
            $wish_list_id = $wishList->getWishListId($loggedUserId, UserWishList::TYPE_DEFAULT_WISHLIST);
        }

        if (1 > $selprod_id) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $action = $this->updateWishList($selprod_id, $wish_list_id, $rowAction);

        //UserWishList
        $srch = UserWishList::getSearchObject($loggedUserId);
        $srch->joinTable(UserWishList::DB_TBL_LIST_PRODUCTS, 'LEFT OUTER JOIN', 'uwlist_id = uwlp_uwlist_id');
        $srch->addCondition('uwlp_selprod_id', '=', 'mysql_func_' . $selprod_id, 'AND', true);
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addMultipleFields(array('uwlist_id'));
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        $productIsInAnyList = false;
        if ($row) {
            $productIsInAnyList = true;
        }

        if (0 < $removeFromCart) {
            $cartObj = new Cart($loggedUserId, $this->siteLangId, $this->app_user['temp_user_id']);
            $key = FatApp::getPostedData('key', FatUtility::VAR_STRING, "");
            //$key = md5(base64_encode(json_encode(Cart::CART_KEY_PREFIX_PRODUCT . $selprod_id)));
            if (!$cartObj->remove($key)) {
                LibHelper::dieJsonError($cartObj->getError());
            }

            if (true === MOBILE_APP_API_CALL) {
                $fulfilmentType = FatApp::getPostedData('fulfilmentType', FatUtility::VAR_INT, Shipping::FULFILMENT_SHIP);
                $cartObj = new Cart(UserAuthentication::getLoggedUserId(true), $this->siteLangId, $this->app_user['temp_user_id'], Cart::PAGE_TYPE_CART);
                $cartObj->setFulfilmentType($fulfilmentType);
                $cartObj->setCartCheckoutType($fulfilmentType);
                $productsArr = $cartObj->getProducts($this->siteLangId);
                $cartSummary = $cartObj->getCartFinancialSummary($this->siteLangId);
                $this->set('products', $productsArr);
                $this->set('cartSummary', $cartSummary);
            }
        }

        $this->set('productIsInAnyList', $productIsInAnyList);
        $this->set('action', $action);
        $this->set('wish_list_id', $wish_list_id);
        $this->set('totalWishListItems', Common::countWishList());

        if (true === MOBILE_APP_API_CALL) {
            $this->set('removeFromCart', $removeFromCart);
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    private function updateWishList($selprod_id, $wish_list_id, $rowAction = -1)
    {
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $row = false;
        $db = FatApp::getDb();
        $wListObj = new UserWishList();
        if (0 > $rowAction) {
            $srch = UserWishList::getSearchObject($loggedUserId);
            $wListObj->joinWishListProducts($srch);
            $srch->addMultipleFields(array('uwlist_id'));
            $srch->doNotCalculateRecords();
            $srch->doNotLimitRecords();
            $srch->addCondition('uwlp_selprod_id', '=', 'mysql_func_' . $selprod_id, 'AND', true);
            // $srch->addCondition('uwlp_uwlist_id', '=', $wish_list_id);

            $rs = $srch->getResultSet();
            $row = $db->fetchAll($rs);
            if (is_array($row)) {
                foreach ($row as $key => $wishlistRow) {
                    /* In case user wants to remove from wishlist. */
                    if ($wishlistRow['uwlist_id'] == $wish_list_id) {
                        continue;
                    }

                    /* In case user wants to add item in wishlist but remove from others as one item can be added in one wishlist only. */
                    if (!$db->deleteRecords(UserWishList::DB_TBL_LIST_PRODUCTS, array('smt' => 'uwlp_uwlist_id = ? AND uwlp_selprod_id = ?', 'vals' => array($wishlistRow['uwlist_id'], $selprod_id)))) {
                        continue;
                    }
                    unset($row[$key]);
                }
                $row = empty($row) ? false : $row;
            }
        }

        $action = 'N'; //nothing happened
        if (!$row && (0 < $rowAction || 0 > $rowAction)) {
            $cartObj = new Cart($loggedUserId, $this->siteLangId, $this->app_user['temp_user_id']);
            if (!$wListObj->addUpdateListProducts($wish_list_id, $selprod_id, $cartObj->getCartType())) {
                $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                FatUtility::dieWithError(Message::getHtml());
            }
            $action = 'A'; //Added to wishlist
            $this->set('msg', Labels::getLabel('LBL_Product_Added_in_list_successfully', $this->siteLangId));
        } else {
            $uwlistIds = array();
            if (true === MOBILE_APP_API_CALL) {
                $srch = UserWishList::getSearchObject($loggedUserId);
                $srch->addMultipleFields(array('uwlist_id'));
                $rs = $srch->getResultSet();
                $row = $db->fetchAll($rs, 'uwlist_id');
                $uwlistIds = array_keys($row);
            } else {
                $uwlistIds[] = $wish_list_id;
            }
            $err = true;
           
            foreach ($uwlistIds as $uwlistId) {
                $err = false;
                if (!$db->deleteRecords(UserWishList::DB_TBL_LIST_PRODUCTS, array('smt' => 'uwlp_uwlist_id = ? AND uwlp_selprod_id = ?', 'vals' => array($uwlistId, $selprod_id)))) {
                    $err = true;
                    break;
                }
            }

            if (true == $err) {
                $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                FatUtility::dieWithError(Message::getHtml());
            }

            $action = 'R'; //Removed from wishlist
            $this->set('msg', Labels::getLabel('LBL_Product_Removed_from_list_successfully', $this->siteLangId));
        }
        return $action;
    }

    public function wishlist()
    {
        $this->_template->addJs('js/slick.min.js');
        $this->_template->render();
    }

    public function wishListSearch()
    {
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $favVar = FatApp::getConfig('CONF_ADD_FAVORITES_TO_WISHLIST', FatUtility::VAR_INT, 1);
        $favVar = 0;
        if ($favVar == applicationConstants::NO) {
            $wishLists[] = Product::getUserFavouriteProducts($loggedUserId, $this->siteLangId);
        } else {
            $wishLists = UserWishList::getUserWishLists($loggedUserId, false);
            if ($wishLists) {
                $srchObj = new UserWishListProductSearch($this->siteLangId);
                $db = FatApp::getDb();
                foreach ($wishLists as &$wishlist) {
                    $srch = clone $srchObj;
                    $srch->joinSellerProducts();
                    $srch->joinProducts();
                    $srch->joinBrands();
                    $srch->joinSellers();
                    $srch->joinShops();
                    $srch->joinProductToCategory();
                    $srch->joinSellerSubscription($this->siteLangId, true);
                    $srch->addSubscriptionValidCondition();
                    $srch->joinSellerProductSpecialPrice();
                    $srch->joinFavouriteProducts($loggedUserId);
                    $srch->addCondition('uwlp_uwlist_id', '=', 'mysql_func_' . $wishlist['uwlist_id'], 'AND', true);
                    $srch->addCondition('selprod_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);
                    $srch->addCondition('selprod_active', '=', 'mysql_func_' . applicationConstants::YES, 'AND', true);
                    $srch->setPageNumber(1);
                    $srch->setPageSize(4);
                    $srch->addMultipleFields(array('selprod_id', 'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title', 'product_id', 'IFNULL(product_name, product_identifier) as product_name', 'IF(selprod_stock > 0, 1, 0) AS in_stock', 'IFNULL(sprodata_is_for_sell, 0) as is_sell', 'IFNULL(sprodata_is_for_rent, 0) as is_rent', 'sprodata_rental_price as rent_price', 'sprodata_rental_stock', 'selprod_stock'));
                    $srch->addOrder('uwlp_added_on');
                    $srch->addGroupBy('selprod_id');
                    $rs = $srch->getResultSet();
                    $products = $db->fetchAll($rs);
                    $wishlist['products'] = $products;
                    $wishlist['totalProducts'] = $srch->recordCount();
                }
            }
        }
        /* $wishLists = array_merge($favouriteProducts,$wishLists); */

        $this->set('wishLists', $wishLists);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $frm = $this->getCreateWishListForm();
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    public function viewFavouriteItems()
    {
        $db = FatApp::getDb();
        $loggedUserId = UserAuthentication::getLoggedUserId();

        $favouriteListRow = Product::getUserFavouriteProducts($loggedUserId, $this->siteLangId);

        if (!$favouriteListRow) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        $this->set('wishListRow', $favouriteListRow);
        $this->_template->render(false, false, 'account/favourite-list-items.php');
        // $this->_template->render(false, false, 'account/wish-list-items.php');
    }

    public function searchWishListItems()
    {
        $post = FatApp::getPostedData();
        $db = FatApp::getDb();
        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $pageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $uwlist_id = empty($post['uwlist_id']) ? 0 : FatUtility::int($post['uwlist_id']);
        $loggedUserId = 0;
        if (UserAuthentication::isUserLogged()) {
            $loggedUserId = UserAuthentication::getLoggedUserId();
        }

        if (false === MOBILE_APP_API_CALL) {
            $wishListRow = UserWishList::getAttributesById($uwlist_id, array('uwlist_id'));
            if (!$wishListRow) {
                $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                FatUtility::dieWithError(Message::getHtml());
            }
        }

        $srch = new UserWishListProductSearch($this->siteLangId);
        $srch->joinSellerProducts();
        $srch->joinProducts();
        $srch->joinBrands();
        $srch->joinSellers();
        $srch->joinShops();
        $srch->joinProductToCategory();
        $srch->joinSellerSubscription($this->siteLangId, true);
        $srch->addSubscriptionValidCondition();
        $srch->joinSellerProductSpecialPrice();
        $srch->joinFavouriteProducts($loggedUserId);
        if (true === MOBILE_APP_API_CALL && 0 >= $uwlist_id) {
            $srch->joinWishLists();
            $srch->addCondition('uwlist_user_id', '=', 'mysql_func_' . $loggedUserId, 'AND', true);
        } else {
            $srch->addCondition('uwlp_uwlist_id', '=', 'mysql_func_' . $uwlist_id, 'AND', true);
        }
        $srch->addCondition('selprod_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);
        $srch->addCondition('selprod_active', '=', 'mysql_func_' . applicationConstants::YES, 'AND', true);
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        /* groupby added, beacouse if same product is linked with multiple categories, then showing in repeat for each category[ */
        $srch->addGroupBy('selprod_id');
        /* ] */

        $srch->addMultipleFields(
            array(
                'selprod_id',
                'IFNULL(selprod_title, IFNULL(product_name, product_identifier)) as selprod_title',
                'product_id',
                'prodcat_id',
                'ufp_id',
                'IFNULL(product_name, product_identifier) as product_name',
                'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name',
                'product_updated_on',
                'IF(selprod_stock > 0, 1, 0) AS in_stock',
                'brand.brand_id',
                'product_model',
                'IFNULL(brand_name, brand_identifier) as brand_name',
                'IFNULL(splprice_price, selprod_price) AS theprice',
                'splprice_display_list_price',
                'splprice_display_dis_val',
                'splprice_display_dis_type',
                'sprodata_rental_price as rent_price',
                'sprodata_rental_stock',
                'selprod_stock',
                'sprodata_minimum_rental_duration',
                'sprodata_duration_type',
                'selprod_active',
                'sprodata_rental_active',
                'prodcat_comparison',
                'sprodata_is_for_sell as is_sell',
                'sprodata_is_for_rent as is_rent',
                '0 as special_price_found',
                'selprod_avg_rating as prod_rating',
                'selprod_review_count as totReviews'
            )
        );
        $srch->addOrder('uwlp_added_on', 'DESC');
        $rs = $srch->getResultSet();
        /* echo $srch->getQuery(); die; */
        $products = $db->fetchAll($rs);
        if (count($products)) {
            foreach ($products as &$arr) {
                $arr['options'] = SellerProduct::getSellerProductOptions($arr['selprod_id'], true, $this->siteLangId);
            }
        }

        $pageSizeArr = FilterHelper::getPageSizeArr($this->siteLangId);
        $this->set('pageSizeArr', $pageSizeArr);
        $this->set('pageSize', $pageSize);
        $this->set('products', $products);
        $this->set('showProductShortDescription', false);
        $this->set('showProductReturnPolicy', false);
        $this->set('colMdVal', 5);
        $this->set('page', $page);
        $this->set('recordCount', $srch->recordCount());
        $this->set('pageCount', $srch->pages());
        $this->set('postedData', $post);

        $startRecord = ($page - 1) * $pageSize + 1;
        $endRecord = $page * $pageSize;
        $totalRecords = $srch->recordCount();
        if ($totalRecords < $endRecord) {
            $endRecord = $totalRecords;
        }
        $this->set('totalRecords', $totalRecords);
        $this->set('startRecord', $startRecord);
        $this->set('endRecord', $endRecord);
        $this->set('showActionBtns', true);
        $this->set('isWishList', true);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $compProdCount = 0;
        $comparedProdSpecCatId = 0;
        if (!empty($_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products'])) {
            $comparedProdSpecCatId = $_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['attr_grp_cat_id'];
            $compProdCount = count($_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products']);
        }
        $this->set('compProdCount', $compProdCount);
        $this->set('comparedProdSpecCatId', $comparedProdSpecCatId);


        if ($totalRecords > 0) {
            $this->set('html', $this->_template->render(false, false, 'products/products-list.php', true, false));
        } else {
            $this->set('html', $this->_template->render(false, false, '_partial/no-record-found.php', true, false));
        }
        $this->set('loadMoreBtnHtml', $this->_template->render(false, false, 'products/products-list-load-more-btn.php', true, false));
        $this->_template->render(false, false, 'json-success.php', true, false);
        //$this->_template->render(false, false, 'products/products-list.php');
    }

    public function searchFavouriteListItems()
    {
        $post = FatApp::getPostedData();
        $db = FatApp::getDb();
        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $pageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $loggedUserId = UserAuthentication::getLoggedUserId();

        $wishListRow = Product::getUserFavouriteProducts($loggedUserId, $this->siteLangId);

        if (!$wishListRow) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $srch = new UserFavoriteProductSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->joinBrands();
        $srch->joinSellers();
        $srch->joinShops();
        $srch->joinProductToCategory();
        $srch->joinSellerProductSpecialPrice();
        $srch->joinSellerSubscription($this->siteLangId, true);
        $srch->addSubscriptionValidCondition();
        $srch->addCondition('selprod_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);
        $wislistPSrchObj = new UserWishListProductSearch();
        $wislistPSrchObj->joinWishLists();
        $wislistPSrchObj->doNotCalculateRecords();
        $wislistPSrchObj->addCondition('uwlist_user_id', '=', 'mysql_func_' . $loggedUserId, 'AND', true);
        $wishListSubQuery = $wislistPSrchObj->getQuery();
        $srch->joinTable('(' . $wishListSubQuery . ')', 'LEFT OUTER JOIN', 'uwlp.uwlp_selprod_id = selprod_id', 'uwlp');

        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);

        /* groupby added, beacouse if same product is linked with multiple categories, then showing in repeat for each category[ */
        $srch->addGroupBy('selprod_id');
        /* ] */

        $srch->addMultipleFields(
            array(
                'selprod_id',
                'IFNULL(selprod_title  ,IFNULL(product_name, product_identifier)) as selprod_title',
                'product_id',
                'prodcat_id',
                'ufp_id',
                'IFNULL(product_name, product_identifier) as product_name',
                'IFNULL(prodcat_name, prodcat_identifier) as prodcat_name',
                'product_updated_on',
                'IF(selprod_stock > 0, 1, 0) AS in_stock',
                'brand.brand_id',
                'product_model',
                'IFNULL(brand_name, brand_identifier) as brand_name',
                'IFNULL(splprice_price, sprodata_rental_price) AS theprice',
                'splprice_display_list_price',
                'splprice_display_dis_val',
                'splprice_display_dis_type',
                'sprodata_rental_price as rent_price',
                'sprodata_rental_stock',
                'selprod_stock',
                'sprodata_minimum_rental_duration',
                'sprodata_duration_type',
                'selprod_active',
                'sprodata_rental_active',
                'prodcat_comparison',
                'sprodata_is_for_sell as is_sell',
                'sprodata_is_for_rent as is_rent',
                'IFNULL(splprice_id, 0) as special_price_found',
                'selprod_avg_rating as prod_rating',
                'selprod_review_count as totReviews',
                'splprice_hour_price',
                'splprice_day_price',
                'splprice_week_price',
                'splprice_month_price',
                'sprodata_hour_rental_price',
                'sprodata_day_rental_price',
                'sprodata_week_rental_price',
                'sprodata_month_rental_price',
            )
        );

        $srch->addOrder('ufp_id', 'desc');
        $srch->addCondition('ufp_user_id', '=', 'mysql_func_' . $loggedUserId, 'AND', true);
        $rs = $srch->getResultSet();

        $products = $db->fetchAll($rs);
       
        foreach($products as $key => $val){
            applicationConstants::updateSpecialPrice($products[$key]);
        }
        
     
        /* $prodSrchObj = new ProductSearch();
          if( $products ){
          foreach($products as &$product){
          $moreSellerSrch = clone $prodSrchObj;
          $moreSellerSrch->addMoreSellerCriteria( $product['selprod_code'], $product['selprod_user_id'] );
          $moreSellerSrch->addMultipleFields(array('count(selprod_id) as totalSellersCount','MIN(theprice) as theprice'));
          $moreSellerSrch->addGroupBy('selprod_code');
          $moreSellerRs = $moreSellerSrch->getResultSet();
          $moreSellerRow = $db->fetch($moreSellerRs);
          $product['moreSellerData'] =  ($moreSellerRow) ? $moreSellerRow : array();
          }
          } */

        $compProdCount = 0;
        $comparedProdSpecCatId = 0;
        if (!empty($_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products'])) {
            $comparedProdSpecCatId = $_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['attr_grp_cat_id'];
            $compProdCount = count($_SESSION[CompareProduct::COMPARE_SESSION_ELEMENT_NAME]['products']);
        }
        $this->set('compProdCount', $compProdCount);
        $this->set('comparedProdSpecCatId', $comparedProdSpecCatId);

        $prodCatAttributes = [];
        $prodCustomFldsData = [];
        if (!empty($products) && applicationConstants::getActiveTheme() == applicationConstants::THEME_AUTOMOBILE) {
            $productCatArr = array_unique(array_column($products, 'prodcat_id'));
            $productIdsArr = array_unique(array_column($products, 'product_id'));
            $prodCatObj = new ProductCategory();
            $prodCatAttributes = $prodCatObj->getAttrDetail($this->siteLangId, 0, 'attr_attrgrp_id', $productCatArr, true);
            $prodCatAttributes = Product::formatArrByCatId($prodCatAttributes);
            $prodCustomFldsData = Product::getCustomFields($productIdsArr, $this->siteLangId);
        }

        $this->set('prodCatAttributes', $prodCatAttributes);
        $this->set('prodCustomFldsData', $prodCustomFldsData);

        $pageSizeArr = FilterHelper::getPageSizeArr($this->siteLangId);

        $this->set('pageSizeArr', $pageSizeArr);
        $this->set('pageSize', $pageSize);

        $this->set('products', $products);
        $this->set('showProductShortDescription', false);
        $this->set('showProductReturnPolicy', false);
        $this->set('colMdVal', 4);
        $this->set('page', $page);
        $this->set('pagingFunc', 'goToFavouriteListingSearchPage');
        $this->set('recordCount', $srch->recordCount());
        $this->set('pageCount', $srch->pages());
        $this->set('postedData', $post);
        $this->set('showActionBtns', true);
        $this->set('removePageSize', true);
        $startRecord = ($page - 1) * $pageSize + 1;
        $endRecord = $page * $pageSize;
        $totalRecords = $srch->recordCount();
        if ($totalRecords < $endRecord) {
            $endRecord = $totalRecords;
        }

        $this->set('totalRecords', $totalRecords);
        $this->set('startRecord', $startRecord);
        $this->set('endRecord', $endRecord);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        if ($totalRecords > 0) {
            /* $this->set('html', $this->_template->render(false, false, 'products/favorite-products-list.php', true, false)); */
            $this->_template->render(false, false, 'products/favorite-products-list.php');
        } else {
            /* $this->set('html', $this->_template->render(false, false, '_partial/no-record-found.php', true, false)); */
            $this->_template->render(false, false, '_partial/no-record-found.php');
        }
        /* $this->set('loadMoreBtnHtml', $this->_template->render(false, false, 'products/products-list-load-more-btn.php', true, false));
        $this->_template->render(false, false, 'json-success.php', true, false); */
        //$this->_template->render(false, false, 'products/products-list.php');
    }

    public function deleteWishList()
    {
        $uwlist_id = FatApp::getPostedData('uwlist_id', FatUtility::VAR_INT, 0);
        if (0 >= $uwlist_id) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $srch = UserWishList::getSearchObject(UserAuthentication::getLoggedUserId());
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('uwlist_id', '=', 'mysql_func_' . $uwlist_id, 'AND', true);
        $srch->addCondition('uwlist_type', '!=', 'mysql_func_' . UserWishList::TYPE_DEFAULT_WISHLIST, 'AND', true);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if (!$row) {
            $message = Labels::getLabel('MSG_No_record_found', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $obj = new UserWishList();
        $obj->deleteWishList($row['uwlist_id']);
        $this->set('msg', Labels::getLabel('LBL_Record_deleted_successfully', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function viewWishListItems()
    {
        $post = FatApp::getPostedData();
        $uwlist_id = FatUtility::int($post['uwlist_id']);

        $db = FatApp::getDb();
        $loggedUserId = UserAuthentication::getLoggedUserId();

        $srch = UserWishList::getSearchObject($loggedUserId);
        $srch->addMultipleFields(array('uwlist_id', 'uwlist_title', 'uwlist_type'));
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('uwlist_id', '=', 'mysql_func_' . $uwlist_id, 'AND', true);
        $rs = $srch->getResultSet();
        $wishListRow = $db->fetch($rs);
        if (!$wishListRow) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        $this->set('wishListRow', $wishListRow);
        $this->_template->render(false, false, 'account/wish-list-items.php');
    }

    public function updateSearchdate()
    {
        $post = FatApp::getPostedData();
        $pssearch_id = FatUtility::int($post['pssearch_id']);

        $srch = new SearchBase(SavedSearchProduct::DB_TBL);
        $srch->addCondition('pssearch_id', '=', 'mysql_func_' . $pssearch_id, 'AND', true);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if (!$row) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $updateArray = array('pssearch_updated_on' => date('Y-m-d H:i:s'));
        $whr = array('smt' => 'pssearch_id = ?', 'vals' => array($pssearch_id));

        if (!FatApp::getDb()->updateFromArray(SavedSearchProduct::DB_TBL, $updateArray, $whr)) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('LBL_Record_deleted_successfully', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function toggleShopFavorite()
    {
        $shop_id = FatApp::getPostedData('shop_id', FatUtility::VAR_INT, 0);
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $db = FatApp::getDb();

        $srch = new ShopSearch($this->siteLangId);
        $srch->setDefinedCriteria($this->siteLangId);
        $srch->joinSellerSubscription();
        $srch->doNotCalculateRecords();
        $srch->addMultipleFields(
            array(
                'shop_id',
                'shop_user_id',
                'shop_ltemplate_id',
                'shop_created_on',
                'IFNULL(shop_name, shop_identifier) as shop_name',
                'shop_description',
                'IFNULL(shop_country_l.country_name,country_code) AS shop_country_name',
                'IFNULL(shop_state_l.state_name,state_identifier) AS shop_state_name',
                'shop_city'
            )
        );
        $srch->addCondition('shop_id', '=', 'mysql_func_' . $shop_id, 'AND', true);
        //echo $srch->getQuery();
        $shopRs = $srch->getResultSet();
        $shop = $db->fetch($shopRs);

        if (!$shop) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $action = 'N'; //nothing happened
        $srch = new UserFavoriteShopSearch();
        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addCondition('ufs_user_id', '=', 'mysql_func_' . $loggedUserId, 'AND', true);
        $srch->addCondition('ufs_shop_id', '=', 'mysql_func_' . $shop_id, 'AND', true);
        $rs = $srch->getResultSet();
        if (!$row = $db->fetch($rs)) {
            $shopObj = new Shop($shop_id);
            if (!$shopObj->setFavorite($loggedUserId)) {
                $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                FatUtility::dieWithError(Message::getHtml());
            }
            $action = 'A'; //Added to favorite
            $this->set('msg', Labels::getLabel('LBL_Shop_is_marked_as_favoutite', $this->siteLangId));
        } else {
            if (!$db->deleteRecords(Shop::DB_TBL_SHOP_FAVORITE, array('smt' => 'ufs_user_id = ? AND ufs_shop_id = ?', 'vals' => array($loggedUserId, $shop_id)))) {
                $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                FatUtility::dieWithError(Message::getHtml());
            }
            $action = 'R'; //Removed from favorite
            $this->set('msg', Labels::getLabel('LBL_Shop_has_been_removed_from_your_favourite_list', $this->siteLangId));
        }

        $this->set('action', $action);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function favoriteShopSearch()
    {
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $post = FatApp::getPostedData();
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        if ($page < 2) {
            $page = 1;
        }
        $pageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $db = FatApp::getDb();
        $srch = new UserFavoriteShopSearch($this->siteLangId);
        $srch->setDefinedCriteria();
        $srch->joinSellerOrder();
        $srch->joinSellerOrderSubscription($this->siteLangId);
        $srch->addCondition('ufs_user_id', '=', 'mysql_func_' . $loggedUserId, 'AND', true);
        $srch->addMultipleFields(
            array(
                's.shop_id',
                'shop_user_id',
                'shop_ltemplate_id',
                'shop_created_on',
                'IFNULL(shop_name,shop_identifier) AS shop_name',
                'shop_description',
                'IFNULL(shop_country_l.country_name,shop_country.country_code) AS country_name',
                'IFNULL(shop_state_l.state_name,shop_state.state_identifier) AS state_name',
                'shop_city',
                'IFNULL(ufs.ufs_id, 0) as is_favorite'
            )
        );
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        $rs = $srch->getResultSet();
        $shops = $db->fetchAll($rs);

        $totalProductsToShow = 4;
        if ($shops) {
            foreach ($shops as &$shop) {
                $shop['shopRating'] = SelProdRating::getSellerRating($shop['shop_user_id']);
                if (true === MOBILE_APP_API_CALL) {
                    $shop['shop_logo'] = UrlHelper::getCachedUrl(UrlHelper::generateFullUrl('image', 'shopLogo', array($shop['shop_id'], $this->siteLangId, "THUMB", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                }
            }
        }
        $this->set('page', $page);
        $this->set('pageSize', $pageSize);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('postedData', $post);
        $this->set('shops', $shops);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false);
    }

    private function isValidSelProd($selprodId)
    {
        $db = FatApp::getDb();

        $srch = new ProductSearch($this->siteLangId);
        $srch->setDefinedCriteria(0, 0, array(), false);
        $srch->doNotCalculateRecords();
        $srch->addMultipleFields(['selprod_id']);
        $srch->addCondition('selprod_id', '=', 'mysql_func_' . $selprodId, 'AND', true);
        $srch->joinProductToCategory();
        $srch->joinShops();
        $srch->joinSellerSubscription();
        $srch->addSubscriptionValidCondition();
        $srch->addCondition('selprod_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);

        $productRs = $srch->getResultSet();
        $product = $db->fetch($productRs);

        if (!$product) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }
        return true;
    }

    public function toggleProductStatus(int $selprodId, int $status)
    {
        $this->isValidSelProd($selprodId);

        switch ($status) {
            case applicationConstants::ACTIVE:
                $this->markAsFavorite($selprodId, false);
                $this->set('msg', Labels::getLabel('MSG_Product_has_been_marked_as_favourite_successfully', $this->siteLangId));
                break;
            case applicationConstants::INACTIVE:
                $this->removeFromFavorite($selprodId, false);
                $this->set('msg', Labels::getLabel('MSG_Product_has_been_removed_from_favourite_list', $this->siteLangId));
                break;
            default:
                FatUtility::dieJsonError(Labels::getLabel('MSG_UNKNOWN_ACTION', $this->siteLangId));
                break;
        }

        $this->_template->render();
    }

    public function markAsFavorite($selprodId, $renderView = true)
    {
        if(!User::isBuyer()){
            $message = Labels::getLabel('LBL_Please_Login_With_Buyer_Account_To_Mark_Products_As_Favorite', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }
        
        $this->isValidSelProd($selprodId);
        $loggedUserId = UserAuthentication::getLoggedUserId();
        $prodObj = new Product();
        if (!$prodObj->addUpdateUserFavoriteProduct($loggedUserId, $selprodId)) {
            $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        if (false === $renderView) {
            return true;
        }

        $this->set('msg', Labels::getLabel('LBL_Product_has_been_marked_as_favourite_successfully', $this->siteLangId));

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function removeFromFavorite($selprodId, $renderView = true)
    {
        $this->isValidSelProd($selprodId);
        $db = FatApp::getDb();
        $loggedUserId = UserAuthentication::getLoggedUserId();
        if (!$db->deleteRecords(Product::DB_TBL_PRODUCT_FAVORITE, array('smt' => 'ufp_user_id = ? AND ufp_selprod_id = ?', 'vals' => array($loggedUserId, $selprodId)))) {
            $message = Labels::getLabel('LBL_Some_problem_occurred,_Please_contact_webmaster', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        if (false === $renderView) {
            return true;
        }

        $this->set('msg', Labels::getLabel('LBL_Product_has_been_removed_from_favourite_list', $this->siteLangId));

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function removeFromFavoriteArr()
    {
        $selprodIdsArr = (array) FatApp::getPostedData('selprod_id', FatUtility::VAR_INT);
        if (empty($selprodIdsArr)) {
            $message = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        foreach ($selprodIdsArr as $selprodId) {
            $this->removeFromFavorite($selprodId, false);
        }

        $this->set('msg', Labels::getLabel('LBL_Product_has_been_removed_from_favourite_list', $this->siteLangId));

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function messages()
    {
        $this->userPrivilege->canViewMessages(UserAuthentication::getLoggedUserId());
        $frm = $this->getMessageSearchForm($this->siteLangId);
        $this->set('frmSrch', $frm);
        $this->_template->render();
    }

    public function messageSearch()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $userImgUpdatedOn = User::getAttributesById($userId, 'user_updated_on');
        $uploadedTime = AttachedFile::setTimeParam($userImgUpdatedOn);

        $frm = $this->getMessageSearchForm($this->siteLangId);

        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        $messageType = FatApp::getPostedData('message_type', FatUtility::VAR_INT, 0);

        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $pagesize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);

        $parentAndTheirChildIds = User::getParentAndTheirChildIds($this->userParentId, false, true);

        $srch = new MessageSearch();
        $srch->joinThreadLastMessage();
        $srch->joinMessagePostedFromUser(true, $this->siteLangId);
        $srch->joinMessagePostedToUser(true, $this->siteLangId);
        $srch->joinThreadStartedByUser();
        $srch->addMultipleFields(
            array(
                'tth.*',
                'ttm.message_id',
                'ttm.message_text',
                'ttm.message_date',
                'ttm.message_is_unread',
                'ttm.message_to',
                'IFNULL(tfrs_l.shop_name, tfrs.shop_identifier) as message_from_shop_name',
                'tfrs.shop_id as message_from_shop_id',
                'tftos.shop_id as message_to_shop_id',
                'IFNULL(tftos_l.shop_name, tftos.shop_identifier) as message_to_shop_name'
            )
        );
        $srch->addCondition('ttm.message_deleted', '=', 'mysql_func_0', 'AND', true);
        $cnd = $srch->addCondition('ttm.message_from', 'IN', $parentAndTheirChildIds);
        $cnd->attachCondition('ttm.message_to', 'IN', $parentAndTheirChildIds, 'OR');
        $srch->addOrder('message_id', 'DESC');
        $srch->addGroupBy('ttm.message_thread_id');

        if ($post['keyword'] != '') {
            $cnd = $srch->addCondition('tth.thread_subject', 'like', "%" . $post['keyword'] . "%");
            $cnd->attachCondition('tfr.user_name', 'like', "%" . $post['keyword'] . "%", 'OR');
            $cnd->attachCondition('tfr_c.credential_username', 'like', "%" . $post['keyword'] . "%", 'OR');
        }

        if ($messageType > 0) {
            $srch->addCondition('tth.thread_type', '=', 'mysql_func_' . $messageType, 'AND', true);
        }

        $page = (empty($page) || $page <= 0) ? 1 : $page;
        $page = FatUtility::int($page);
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);

        if (true === MOBILE_APP_API_CALL) {
            $message_records = array();
            foreach ($records as $mkey => $mval) {
                $profile_images_arr = array(
                    "message_from_profile_url" => UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'user', array($mval['message_from_user_id'], 'thumb', 1)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'),
                    "message_to_profile_url" => UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'user', array($mval['message_to_user_id'], 'thumb', 1)) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg'),
                    "message_timestamp" => strtotime($mval['message_date'])
                );
                $message_records[] = array_merge($mval, $profile_images_arr);
            }
            $records = $message_records;
        }

        /* CommonHelper::printArray($records); die; */
        $this->set("arr_listing", $records);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('loggedUserId', $userId);
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('parentAndTheirChildIds', $parentAndTheirChildIds);
        $this->set('postedData', $post);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false);
    }

    public function viewMessages($threadId, $messageId = 0)
    {
        $this->userPrivilege->canViewMessages(UserAuthentication::getLoggedUserId());
        $threadId = FatUtility::int($threadId);
        $messageId = FatUtility::int($messageId);
        $userId = UserAuthentication::getLoggedUserId();
        if (1 > $threadId) {
            $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            CommonHelper::redirectUserReferer();
        }

        $mainThread = Thread::getThreadDataById($threadId);

        if (empty($mainThread)) {
            $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            CommonHelper::redirectUserReferer();
        }

        $threadData = $mainThread;
        if ($mainThread['thread_type'] != Thread::THREAD_TYPE_RFQ) {
            $threadData = Thread::getAttributesById($messageId, array('thread_id,thread_type'));
            if ($threadData == false) {
                $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
                if (true === MOBILE_APP_API_CALL) {
                    FatUtility::dieJsonError($message);
                }
                Message::addErrorMessage($message);
                CommonHelper::redirectUserReferer();
            }
        }


        $attr = array(
            'IFNULL(shop_name, shop_identifier) as shop_name',
            'shop_id',
            'shop_updated_on',
        );
        $shopDetails = Shop::getAttributesByUserId($userId, $attr, false, $this->siteLangId);
        $srch = new MessageSearch();
        if ($threadData['thread_type'] != Thread::THREAD_TYPE_RFQ) {
            $srch->joinThreadMessage();
            $srch->joinMessagePostedFromUser();
            $srch->joinMessagePostedToUser();
            $srch->joinThreadStartedByUser();
        }


        if ($threadData['thread_type'] == Thread::THREAD_TYPE_SHOP) {
            $srch->joinShops($this->siteLangId);
        } elseif ($threadData['thread_type'] == Thread::THREAD_TYPE_PRODUCT) {
            $srch->joinProducts($this->siteLangId);
            $srch->joinTable(SellerProduct::DB_TBL_SELLER_PROD_DATA, 'LEFT OUTER JOIN', 'tsp.selprod_id = spd.sprodata_selprod_id', 'spd');
            $srch->addFld(['sprodata_rental_price']);
        } elseif ($threadData['thread_type'] == Thread::THREAD_TYPE_RFQ) {
            $srch->joinRfqProducts($this->siteLangId);
            $srch->addFld(['rfq.rfq_id', 'rfq.rfq_user_id']);
        }

        $parentAndThierChildIds = User::getParentAndTheirChildIds($this->userParentId, false, true);
        $srch->addCondition('tth.thread_id', '=', 'mysql_func_' . $threadId, 'AND', true);
        $srch->addMultipleFields(array('tth.*'));
        if ($messageId && $threadData['thread_type'] != Thread::THREAD_TYPE_RFQ) {
            $srch->joinOrderProducts();
            if ($threadData["thread_type"] == THREAD::THREAD_TYPE_ORDER_PRODUCT) {
                $srch->joinOrderProductStatus();
            }
            $srch->addFld(array('top.op_invoice_number', 'top.op_unit_price'));
            $srch->addCondition('ttm.message_deleted', '=', 'mysql_func_0', 'AND', true);
            $srch->addCondition('ttm.message_id', '=', 'mysql_func_' . $messageId, 'AND', true);
            $cnd = $srch->addCondition('ttm.message_from', 'IN', $parentAndThierChildIds);
            $cnd->attachCondition('ttm.message_to', 'IN', $parentAndThierChildIds, 'OR');
        }


        $rs = $srch->getResultSet();
        $threadDetails = FatApp::getDb()->fetch($rs);

        if ($threadDetails == false && $mainThread['thread_type'] != Thread::THREAD_TYPE_RFQ) {
            $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            CommonHelper::redirectUserReferer();
        } elseif ($threadDetails == false) {
            $threadDetails = $mainThread;
        }

        if (false === MOBILE_APP_API_CALL) {
            $frmSrch = $this->getMsgSearchForm($this->siteLangId);
            $frmSrch->fill(array('thread_id' => $threadId));
            $frm = $this->sendMessageForm($this->siteLangId);
            $frm->fill(array('message_thread_id' => $threadId, 'message_id' => $messageId));
        }

        $threadObj = new Thread($threadId);
        if (!$threadObj->markMessageReadFromUserArr($threadId, $parentAndThierChildIds)) {
            if (true === MOBILE_APP_API_CALL) {
                Message::addErrorMessage(strip_tags(current($threadObj->getError())));
            }
            Message::addErrorMessage($threadObj->getError());
            CommonHelper::redirectUserReferer();
        }

        if (false === MOBILE_APP_API_CALL) {
            $this->set('frmSrch', $frmSrch);
            $this->set('frm', $frm);
        }
        $this->set('canEditMessages', $this->userPrivilege->canEditMessages(UserAuthentication::getLoggedUserId(), true));
        $this->set('threadDetails', $threadDetails);
        $this->set('threadTypeArr', Thread::getThreadTypeArr($this->siteLangId));
        $this->set('loggedUserId', $userId);
        $this->set('loggedUserName', ucfirst(UserAuthentication::getLoggedUserAttribute('user_name')));
        $this->set('shopDetails', $shopDetails);
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render();
    }

    public function threadMessageSearch()
    {
        $this->userPrivilege->canViewMessages(UserAuthentication::getLoggedUserId());
        $post = FatApp::getPostedData();
        $threadId = empty($post['thread_id']) ? 0 : FatUtility::int($post['thread_id']);

        if (1 > $threadId) {
            $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
            FatUtility::dieJsonError($message);
        }

        if (true === MOBILE_APP_API_CALL) {
            $threadObj = new Thread($threadId);
            if (!$threadObj->markUserMessageRead($threadId, UserAuthentication::getLoggedUserId())) {
                $msg = is_string($threadObj->getError()) ? $threadObj->getError() : current($threadObj->getError());
                LibHelper::dieJsonError(strip_tags($msg));
            }
        }

        $allowedUserIds = User::getParentAndTheirChildIds($this->userParentId, false, true);
        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $pagesize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);

        $srch = new MessageSearch();
        $srch->joinThreadMessage();
        $srch->joinMessagePostedFromUser(true, $this->siteLangId);
        $srch->joinMessagePostedToUser(true, $this->siteLangId);
        $srch->joinThreadStartedByUser();
        $srch->addMultipleFields(
            array(
                'tth.*',
                'ttm.message_id',
                'ttm.message_text',
                'ttm.message_date',
                'ttm.message_is_unread',
                'IFNULL(tfrs_l.shop_name, tfrs.shop_identifier) as message_from_shop_name',
                'tfrs.shop_id as message_from_shop_id',
                'tftos.shop_id as message_to_shop_id',
                'IFNULL(tftos_l.shop_name, tftos.shop_identifier) as message_to_shop_name'
            )
        );
        $srch->addCondition('ttm.message_deleted', '=', 'mysql_func_0', 'AND', true);
        $srch->addCondition('tth.thread_id', '=', 'mysql_func_' . $threadId, 'AND', true);
        $cnd = $srch->addCondition('ttm.message_from', 'in', $allowedUserIds);
        $cnd->attachCondition('ttm.message_to', 'in', $allowedUserIds, 'OR');
        $srch->addOrder('message_id', 'DESC');
        $srch->setPageNumber($page);
        $srch->setPageSize($pagesize);
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs, 'message_id');

        // ksort($records);

        $this->set("arrListing", $records);
        $this->set('pageCount', $srch->pages());
        $this->set('recordCount', $srch->recordCount());
        $this->set('page', $page);
        $this->set('pageSize', $pagesize);
        $this->set('postedData', $post);

        $startRecord = ($page - 1) * $pagesize + 1;
        $endRecord = $pagesize;
        $totalRecords = $srch->recordCount();
        if ($totalRecords < $endRecord) {
            $endRecord = $totalRecords;
        }

        $this->set('totalRecords', $totalRecords);
        $this->set('startRecord', $startRecord);
        $this->set('endRecord', $endRecord);
        $this->set('records', $records);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->set('loadMoreBtnHtml', $this->_template->render(false, false, '_partial/load-previous-btn.php', true));
        $this->set('html', $this->_template->render(false, false, 'account/thread-message-search.php', true, false));
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function sendMessage()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $frm = $this->sendMessageForm($this->siteLangId);
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());

        if (false === $post) {
            if (true === MOBILE_APP_API_CALL) {
                LibHelper::dieJsonError(current($frm->getValidationErrors()));
            }
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieWithError(Message::getHtml());
        }

        $threadId = FatUtility::int($post['message_thread_id']);
        $messageId = FatUtility::int($post['message_id']);

        // if (1 > $threadId || 1 > $messageId) {
        //     $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
        //     if (true === MOBILE_APP_API_CALL) {
        //         FatUtility::dieJsonError($message);
        //     }
        //     Message::addErrorMessage($message);
        //     FatUtility::dieWithError(Message::getHtml());
        // }
        if (1 > $threadId) {
            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        $mainThread = Thread::getThreadDataById($threadId);
        if (empty($mainThread) && $messageId > 0) {
            $message = Labels::getLabel('MSG_INVALID_ACCESS', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            CommonHelper::redirectUserReferer();
        }

        $allowedUserIds = User::getParentAndTheirChildIds($this->userParentId, false, true);

        $srch = new MessageSearch();
        $srch->joinThreadMessage();
        $srch->joinMessagePostedFromUser();
        $srch->joinMessagePostedToUser();
        $srch->joinThreadStartedByUser();
        $srch->addMultipleFields(array('tth.*'));
        $srch->addCondition('ttm.message_deleted', '=', 'mysql_func_0', 'AND', true);
        $srch->addCondition('tth.thread_id', '=', 'mysql_func_' . $threadId, 'AND', true);
        if ($messageId) {
            $srch->addCondition('ttm.message_id', '=', 'mysql_func_' . $messageId, 'AND', true);
        }
        $cnd = $srch->addCondition('ttm.message_from', 'in', $allowedUserIds);
        $cnd->attachCondition('ttm.message_to', 'in', $allowedUserIds, 'OR');
        $rs = $srch->getResultSet();

        $threadDetails = FatApp::getDb()->fetch($rs);
        // echo "<pre>";
        //  print_r($threadDetails);
        // die();

        if (empty($threadDetails) && $mainThread['thread_type'] != Thread::THREAD_TYPE_RFQ) {

            $message = Labels::getLabel('MSG_Invalid_Access', $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        if ($mainThread['thread_type'] == Thread::THREAD_TYPE_RFQ) {
            $reqForQuote = new RequestForQuote($mainThread['thread_record_id']);
            $rfqDetail = $reqForQuote->getRequestDetail(UserAuthentication::getLoggedUserId());
            if (empty($rfqDetail)) {
                Message::addErrorMessage(Labels::getLabel("LBL_Invalid_Request_for_Re-Quote", $this->siteLangId));
                FatUtility::dieJsonError(Message::getHtml());
            }


            if ($userId == $rfqDetail['rfq_user_id']) {
                $messageSendTo = $rfqDetail['selprod_user_id'];
            } else {
                $messageSendTo = $rfqDetail['rfq_user_id'];
            }
        } else {
            $messageSendTo = ($threadDetails['message_from_user_id'] == $userId || $threadDetails['message_from_user_id'] == $this->userParentId) ? $threadDetails['message_to_user_id'] : $threadDetails['message_from_user_id'];
        }

        $data = array(
            'message_thread_id' => $threadId,
            'message_from' => $userId,
            'message_to' => $messageSendTo,
            'message_text' => $post['message_text'],
            'message_date' => date('Y-m-d H:i:s'),
            'message_is_unread' => 1
        );

        $tObj = new Thread();
        Common::filterTags($data);
        if (!$insertId = $tObj->addThreadMessages($data)) {
            $message = Labels::getLabel($tObj->getError(), $this->siteLangId);
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError($message);
            }
            Message::addErrorMessage($message);
            FatUtility::dieWithError(Message::getHtml());
        }

        /* attach file with request [ */
        if (isset($_FILES['attached_file'])) {
            $uploadedFiles = $_FILES['attached_file']['tmp_name'];
            foreach ($uploadedFiles as $fileIndex => $uploadedFile) {
                if (is_uploaded_file($_FILES['attached_file']['tmp_name'][$fileIndex])) {
                    if (filesize($uploadedFile) > 10240000) {
                        $message = Labels::getLabel('MSG_Please_upload_file_size_less_than_10MB', $this->siteLangId);
                        if (true === MOBILE_APP_API_CALL) {
                            LibHelper::dieJsonError($message);
                        }
                        Message::addErrorMessage($message);
                        FatUtility::dieJsonError(Message::getHtml());
                    }

                    $fileHandlerObj = new AttachedFile();
                    if (!$res = $fileHandlerObj->saveAttachment($_FILES['attached_file']['tmp_name'][$fileIndex], AttachedFile::FILETYPE_MESSAGE_ATTACHMENTS, $insertId, 0, $_FILES['attached_file']['name'][$fileIndex], -1, false)) {
                        if (true === MOBILE_APP_API_CALL) {
                            LibHelper::dieJsonError($fileHandlerObj->getError());
                        }
                        Message::addErrorMessage($fileHandlerObj->getError());
                        FatUtility::dieJsonError(Message::getHtml());
                    }
                }
            }
        }
        /* ] */

        if ($insertId) {
            $emailObj = new EmailHandler();
            $emailObj->SendMessageNotification($insertId, $this->siteLangId);
        }

        $this->set('threadId', $threadId);
        $this->set('messageId', $insertId);
        $this->set('msg', Labels::getLabel('MSG_Message_Submitted_Successfully!', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->set('messageDetail', $data);
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    private function getMessageSearchForm($langId)
    {
        $frm = new Form('frmMessageSrch');
        $frm->addTextBox(Labels::getLabel('LBL_Keyword', $langId), 'keyword');
        $frm->addSelectBox(Labels::getLabel('LBL_Message_Type', $this->siteLangId), 'message_type', Thread::getThreadTypeArr($langId), '', array(), Labels::getLabel('LBL_Select_Type', $this->siteLangId));
        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $fldCancel = $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearSearch();'));
        $frm->addHiddenField('', 'page');
        return $frm;
    }

    private function getWithdrawalForm($langId)
    {
        $frm = new Form('frmWithdrawal');
        $fld = $frm->addRequiredField(Labels::getLabel('LBL_Amount_to_be_Withdrawn', $langId) . ' [' . commonHelper::getDefaultCurrencySymbol() . ']', 'withdrawal_amount');
        $fld->requirement->setFloat(true);
        $walletBalance = User::getUserBalance(UserAuthentication::getLoggedUserId());
        $fld->htmlAfterField = Labels::getLabel("LBL_Current_Wallet_Balance", $langId) . ' ' . CommonHelper::displayMoneyFormat($walletBalance, true, true);

        if (User::isAffiliate()) {
            $PayMethodFld = $frm->addRadioButtons(Labels::getLabel('LBL_Payment_Method', $langId), 'uextra_payment_method', User::getAffiliatePaymentMethodArr($langId));

            /* [ */
            $frm->addTextBox(Labels::getLabel('LBL_Cheque_Payee_Name', $langId), 'uextra_cheque_payee_name');
            $chequePayeeNameUnReqFld = new FormFieldRequirement('uextra_cheque_payee_name', Labels::getLabel('LBL_Cheque_Payee_Name', $langId));
            $chequePayeeNameUnReqFld->setRequired(false);

            $chequePayeeNameReqFld = new FormFieldRequirement('uextra_cheque_payee_name', Labels::getLabel('LBL_Cheque_Payee_Name', $langId));
            $chequePayeeNameReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'uextra_cheque_payee_name', $chequePayeeNameReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'uextra_cheque_payee_name', $chequePayeeNameUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'uextra_cheque_payee_name', $chequePayeeNameUnReqFld);
            /* ] */

            /* [ */
            $frm->addTextBox(Labels::getLabel('LBL_Bank_Name', $langId), 'ub_bank_name');
            $bankNameUnReqFld = new FormFieldRequirement('ub_bank_name', Labels::getLabel('LBL_Bank_Name', $langId));
            $bankNameUnReqFld->setRequired(false);

            $bankNameReqFld = new FormFieldRequirement('ub_bank_name', Labels::getLabel('LBL_Bank_Name', $langId));
            $bankNameReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'ub_bank_name', $bankNameUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'ub_bank_name', $bankNameReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'ub_bank_name', $bankNameUnReqFld);
            /* ] */

            /* [ */
            $frm->addTextBox(Labels::getLabel('LBL_Account_Holder_Name', $langId), 'ub_account_holder_name');
            $bankAccHolderNameUnReqFld = new FormFieldRequirement('ub_account_holder_name', Labels::getLabel('LBL_Account_Holder_Name', $langId));
            $bankAccHolderNameUnReqFld->setRequired(false);

            $bankAccHolderNameReqFld = new FormFieldRequirement('ub_account_holder_name', Labels::getLabel('LBL_Account_Holder_Name', $langId));
            $bankAccHolderNameReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'ub_account_holder_name', $bankAccHolderNameUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'ub_account_holder_name', $bankAccHolderNameReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'ub_account_holder_name', $bankAccHolderNameUnReqFld);
            /* ] */

            /* [ */
            $frm->addTextBox(Labels::getLabel('LBL_Bank_Account_Number', $langId), 'ub_account_number');
            $bankAccNumberUnReqFld = new FormFieldRequirement('ub_account_number', Labels::getLabel('LBL_Bank_Account_Number', $langId));
            $bankAccNumberUnReqFld->setRequired(false);

            $bankAccNumberReqFld = new FormFieldRequirement('ub_account_number', Labels::getLabel('LBL_Bank_Account_Number', $langId));
            $bankAccNumberReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'ub_account_number', $bankAccNumberUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'ub_account_number', $bankAccNumberReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'ub_account_number', $bankAccNumberUnReqFld);
            /* ] */

            /* [ */
            $frm->addTextBox(Labels::getLabel('LBL_Swift_Code', $langId), 'ub_ifsc_swift_code');
            $bankIfscUnReqFld = new FormFieldRequirement('ub_ifsc_swift_code', Labels::getLabel('LBL_Swift_Code', $langId));
            $bankIfscUnReqFld->setRequired(false);

            $bankIfscReqFld = new FormFieldRequirement('ub_ifsc_swift_code', Labels::getLabel('LBL_Swift_Code', $langId));
            $bankIfscReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'ub_ifsc_swift_code', $bankIfscUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'ub_ifsc_swift_code', $bankIfscReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'ub_ifsc_swift_code', $bankIfscUnReqFld);
            /* ] */

            /* [ */
            $frm->addTextArea(Labels::getLabel('LBL_Bank_Address', $langId), 'ub_bank_address');
            $bankBankAddressUnReqFld = new FormFieldRequirement('ub_bank_address', Labels::getLabel('LBL_Bank_Address', $langId));
            $bankBankAddressUnReqFld->setRequired(false);

            $bankBankAddressReqFld = new FormFieldRequirement('ub_bank_address', Labels::getLabel('LBL_Bank_Address', $langId));
            $bankBankAddressReqFld->setRequired(true);

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'ub_bank_address', $bankBankAddressUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'ub_bank_address', $bankBankAddressReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'ub_bank_address', $bankBankAddressUnReqFld);
            /* ] */

            /* [ */
            $fld = $frm->addTextBox(Labels::getLabel('LBL_PayPal_Email_Account', $langId), 'uextra_paypal_email_id');
            $PPEmailIdUnReqFld = new FormFieldRequirement('uextra_paypal_email_id', Labels::getLabel('LBL_PayPal_Email_Account', $langId));
            $PPEmailIdUnReqFld->setRequired(false);

            $PPEmailIdReqFld = new FormFieldRequirement('uextra_paypal_email_id', Labels::getLabel('LBL_PayPal_Email_Account', $langId));
            $PPEmailIdReqFld->setRequired(true);
            $PPEmailIdReqFld->setEmail();

            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_CHEQUE, 'eq', 'uextra_paypal_email_id', $PPEmailIdUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_BANK, 'eq', 'uextra_paypal_email_id', $PPEmailIdUnReqFld);
            $PayMethodFld->requirements()->addOnChangerequirementUpdate(User::AFFILIATE_PAYMENT_METHOD_PAYPAL, 'eq', 'uextra_paypal_email_id', $PPEmailIdReqFld);
            /* ] */
        } else {
            $frm->addRequiredField(Labels::getLabel('LBL_Bank_Name', $langId), 'ub_bank_name');
            $frm->addRequiredField(Labels::getLabel('LBL_Account_Holder_Name', $langId), 'ub_account_holder_name');
            $frm->addRequiredField(Labels::getLabel('LBL_Account_Number', $langId), 'ub_account_number');
            $ifsc = $frm->addRequiredField(Labels::getLabel('LBL_IFSC_Swift_Code', $langId), 'ub_ifsc_swift_code');
            $ifsc->requirements()->setRegularExpressionToValidate(ValidateElement::USERNAME_REGEX);
            $frm->addTextArea(Labels::getLabel('LBL_Bank_Address', $langId), 'ub_bank_address');
        }
        $frm->addTextArea(Labels::getLabel('LBL_Other_Info_Instructions', $langId), 'withdrawal_instructions');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Request', $langId));
        $frm->addButton("", "btn_cancel", Labels::getLabel("LBL_Cancel", $langId));
        return $frm;
    }

    private function getCreateWishListForm()
    {
        $frm = new Form('frmCreateWishList');
        $frm->setRequiredStarWith('NONE');
        $frm->addRequiredField('', 'uwlist_title');
        $frm->addHiddenField('', 'selprod_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Add', $this->siteLangId));
        $frm->setJsErrorDisplay('afterfield');
        return $frm;
    }

    private function getProfileInfoForm()
    {
        $frm = new Form('frmProfileInfo');
        $frm->addTextBox(Labels::getLabel('LBL_Username', $this->siteLangId), 'credential_username', '');
        $frm->addTextBox(Labels::getLabel('LBL_Email', $this->siteLangId), 'credential_email', '');
        $frm->addRequiredField(Labels::getLabel('LBL_Customer_Name', $this->siteLangId), 'user_name');
        $frm->addDateField(Labels::getLabel('LBL_Date_Of_Birth', $this->siteLangId), 'user_dob', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        $phoneFld = $frm->addTextBox(Labels::getLabel('LBL_Phone', $this->siteLangId), 'user_phone', '', array('class' => 'phone-js ltr-right', 'placeholder' => ValidateElement::PHONE_NO_FORMAT, 'maxlength' => ValidateElement::PHONE_NO_LENGTH));
        $phoneFld->requirements()->setRegularExpressionToValidate(ValidateElement::PHONE_REGEX);
        $phoneFld->requirements()->setCustomErrorMessage(Labels::getLabel('LBL_Please_enter_valid_phone_number_format.', $this->siteLangId));
        // $phoneFld->htmlAfterField='<small class="form-text muted-text">'.Labels::getLabel('LBL_e.g.', $this->siteLangId).': '.implode(', ', ValidateElement::PHONE_FORMATS).'</small>';

        if (User::isAffiliate()) {
            $frm->addTextBox(Labels::getLabel('LBL_Company', $this->siteLangId), 'uextra_company_name');
            $frm->addTextBox(Labels::getLabel('LBL_Website', $this->siteLangId), 'uextra_website');
            $frm->addTextBox(Labels::getLabel('LBL_Address_Line_1', $this->siteLangId), 'user_address1')->requirements()->setRequired();
            $frm->addTextBox(Labels::getLabel('LBL_Address_Line_2', $this->siteLangId), 'user_address2');
        }

        $countryObj = new Countries();
        $countriesArr = $countryObj->getCountriesArr($this->siteLangId);
        $fld = $frm->addSelectBox(Labels::getLabel('LBL_Country', $this->siteLangId), 'user_country_id', $countriesArr, FatApp::getConfig('CONF_COUNTRY', FatUtility::VAR_INT, 0), array(), Labels::getLabel('LBL_Select', $this->siteLangId));
        $fld->requirement->setRequired(true);

        $frm->addSelectBox(Labels::getLabel('LBL_State', $this->siteLangId), 'user_state_id', array(), '', array(), Labels::getLabel('LBL_Select', $this->siteLangId))->requirement->setRequired(true);
        $frm->addTextBox(Labels::getLabel('LBL_City', $this->siteLangId), 'user_city');

        if (User::isAffiliate()) {
            $zipFld = $frm->addRequiredField(Labels::getLabel('LBL_Postalcode', $this->siteLangId), 'user_zip');
            /* $zipFld->requirements()->setRegularExpressionToValidate(ValidateElement::ZIP_REGEX);
              $zipFld->requirements()->setCustomErrorMessage(Labels::getLabel('LBL_Only_alphanumeric_value_is_allowed.', $this->siteLangId)); */
        }
        $parent = User::getAttributesById(UserAuthentication::getLoggedUserId(true), 'user_parent');
        if (User::isAdvertiser() && $parent == 0) {
            $fld = $frm->addTextBox(Labels::getLabel('LBL_COMPANY', $this->siteLangId), 'user_company');
            $fld = $frm->addTextArea(Labels::getLabel('LBL_BRIEF_PROFILE', $this->siteLangId), 'user_profile_info');
            $fld->htmlAfterField = '<small>' . Labels::getLabel('LBL_PLEASE_TELL_US_SOMETHING_ABOUT_YOURSELF', $this->siteLangId) . '</small>';
            $frm->addTextArea(Labels::getLabel('LBL_WHAT_KIND_PRODUCTS_SERVICES_ADVERTISE', $this->siteLangId), 'user_products_services');
        }

        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE_CHANGES', $this->siteLangId));
        return $frm;
    }

    private function getProfileImageForm()
    {
        $frm = new Form('frmProfile', array('id' => 'frmProfile'));
        $frm->addFileUpload(Labels::getLabel('LBL_Profile_Picture', $this->siteLangId), 'user_profile_image', array('id' => 'user_profile_image', 'onClick' => 'popupImage(this)', 'accept' => 'image/*', 'data-frm' => 'frmProfile'));
        return $frm;
    }

    private function getBankInfoForm()
    {
        $frm = new Form('frmBankInfo');
        $frm->addRequiredField(Labels::getLabel('M_Bank_Name', $this->siteLangId), 'ub_bank_name', '');
        $frm->addRequiredField(Labels::getLabel('M_Account_Holder_Name', $this->siteLangId), 'ub_account_holder_name', '');
        $fld = $frm->addRequiredField(Labels::getLabel('M_Account_Number', $this->siteLangId), 'ub_account_number', '');
        $fld->requirement->setRequired(true);

        $ifsc = $frm->addRequiredField(Labels::getLabel('M_IFSC_Swift_Code', $this->siteLangId), 'ub_ifsc_swift_code', '');
        $ifsc->requirements()->setRegularExpressionToValidate(ValidateElement::USERNAME_REGEX);

        $frm->addTextArea(Labels::getLabel('M_Bank_Address', $this->siteLangId), 'ub_bank_address', '');
        $htm = '<div class="info" style="width:max-content;">
                                <svg class="svg" width="16" height="16">
                            <use xlink:href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#info" href="' . CONF_WEBROOT_URL . 'images/retina/sprite.svg#info">
                            </use>
                        </svg>' . Labels::getLabel('Lbl_Your_Bank/Card_info_is_safe_with_us', $this->siteLangId) . '
                   
                </div>';
        $frm->addHtml('bank_info_safety_text', 'bank_info_safety_text', $htm);
        
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE_CHANGES', $this->siteLangId), array('class' => 'btn btn-brand'));
        return $frm;
    }

    private function getChangePasswordForm()
    {
        $frm = new Form('changePwdFrm');
        $curPwd = $frm->addPasswordField(
            Labels::getLabel('LBL_CURRENT_PASSWORD', $this->siteLangId),
            'current_password'
        );
        $curPwd->requirements()->setRequired();

        $newPwd = $frm->addPasswordField(
            Labels::getLabel('LBL_NEW_PASSWORD', $this->siteLangId),
            'new_password'
        );
        $newPwd->htmlAfterField = '<span class="form-text muted-text">' . sprintf(Labels::getLabel('LBL_Example_password', $this->siteLangId), 'User@123') . '</span>';
        $newPwd->requirements()->setRequired();
        $newPwd->requirements()->setRegularExpressionToValidate(ValidateElement::PASSWORD_REGEX);
        $newPwd->requirements()->setCustomErrorMessage(Labels::getLabel('MSG_PASSWORD_MUST_BE_ATLEAST_EIGHT_CHARACTERS_LONG_AND_ALPHANUMERIC', $this->siteLangId));
        $conNewPwd = $frm->addPasswordField(
            Labels::getLabel('LBL_CONFIRM_NEW_PASSWORD', $this->siteLangId),
            'conf_new_password'
        );
        $conNewPwdReq = $conNewPwd->requirements();
        $conNewPwdReq->setRequired();
        $conNewPwdReq->setCompareWith('new_password', 'eq');
        /* $conNewPwdReq->setCustomErrorMessage(Labels::getLabel('LBL_CONFIRM_PASSWORD_NOT_MATCHED',
          $this->siteLangId)); */
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE', $this->siteLangId));
        return $frm;
    }

    private function notifyAdminSupplierApproval($userObj, $data, $approval_request = 1)
    {
        $attr = array('user_name', 'credential_username', 'credential_email');
        $userData = $userObj->getUserInfo($attr);

        if ($userData === false) {
            return false;
        }

        $data = array(
            'user_name' => $userData['user_name'],
            'username' => $userData['credential_username'],
            'user_email' => $userData['credential_email'],
            'reference_number' => $data['reference'],
        );

        $email = new EmailHandler();

        if (!$email->sendSupplierApprovalNotification(CommonHelper::getLangId(), $data, $approval_request)) {
            Message::addMessage(
                Labels::getLabel(
                    "MSG_ERROR_IN_SENDING_SUPPLIER_APPROVAL_EMAIL",
                    CommonHelper::getLangId()
                )
            );
            return false;
        }

        return true;
    }

    private function getSupplierForm()
    {
        $frm = new Form('frmSupplierForm');
        $frm->addHiddenField('', 'id', 0);

        $userObj = new User();
        $supplier_form_fields = $userObj->getSupplierFormFields($this->siteLangId);

        foreach ($supplier_form_fields as $field) {
            $fieldName = 'sformfield_' . $field['sformfield_id'];

            switch ($field['sformfield_type']) {
                case User::USER_FIELD_TYPE_TEXT:
                    $fld = $frm->addTextBox($field['sformfield_caption'], $fieldName);
                    break;

                case User::USER_FIELD_TYPE_TEXTAREA:
                    $fld = $frm->addTextArea($field['sformfield_caption'], $fieldName);
                    break;

                case User::USER_FIELD_TYPE_FILE:
                    $fld1 = $frm->addButton(
                        $field['sformfield_caption'],
                        'button[' . $field['sformfield_id'] . ']',
                        Labels::getLabel('LBL_Upload_File', $this->siteLangId),
                        array('class' => 'fileType-Js', 'id' => 'button-upload' . $field['sformfield_id'], 'data-field_id' => $field['sformfield_id'])
                    );
                    $fld1->htmlAfterField = '<span id="input-sformfield' . $field['sformfield_id'] . '"></span>';
                    if ($field['sformfield_required'] == 1) {
                        $fld1->captionWrapper = array('<div class="astrick">', '<span class="spn_must_field">*</span></div>');
                    }
                    $fld = $frm->addTextBox('', $fieldName, '', array('id' => $fieldName, 'hidden' => 'hidden', 'title' => $field['sformfield_caption']));
                    $fld->setRequiredStarWith(Form::FORM_REQUIRED_STAR_WITH_NONE);
                    $fld1->attachField($fld);
                    break;

                case User::USER_FIELD_TYPE_DATE:
                    $fld = $frm->addDateField($field['sformfield_caption'], $fieldName, '', array('readonly' => 'readonly', 'class' => 'field--calender'));
                    break;

                case User::USER_FIELD_TYPE_DATETIME:
                    $fld = $frm->addDateTimeField($field['sformfield_caption'], $fieldName, '', array('readonly' => 'readonly', 'class' => 'field--calender'));
                    break;

                case User::USER_FIELD_TYPE_TIME:
                    $fld = $frm->addTextBox($field['sformfield_caption'], $fieldName);
                    $fld->requirements()->setRegularExpressionToValidate(ValidateElement::TIME_REGEX);
                    $fld->htmlAfterField = Labels::getLabel('LBL_HH:MM', $this->siteLangId);
                    $fld->requirements()->setCustomErrorMessage(Labels::getLabel('LBL_Please_enter_valid_time_format.', $this->siteLangId));
                    break;

                case User::USER_FIELD_TYPE_PHONE:
                    $fld = $frm->addTextBox($field['sformfield_caption'], $fieldName, '', array('class' => 'phone-js ltr-right', 'placeholder' => ValidateElement::PHONE_NO_FORMAT));
                    $fld->requirements()->setRegularExpressionToValidate(ValidateElement::PHONE_WITH_DIAL_CODE_REGEX);
                    $fld->requirements()->setCustomErrorMessage(Labels::getLabel('LBL_Please_enter_valid_phone_number_format.', $this->siteLangId));
                    break;
            }

            if ($field['sformfield_required'] == 1) {
                $fld->requirements()->setRequired();
            }
            if ($field['sformfield_comment']) {
                $fld->htmlAfterField = '<p class="note">' . $field['sformfield_comment'] . '</p>';
            }
        }
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Save_Changes', $this->siteLangId));
        return $frm;
    }

    public function updatePhoto()
    {
        if (is_uploaded_file($_FILES['photo']['tmp_name'])) {
            if ($_FILES['photo']['size'] > AttachedFile::IMAGE_MAX_SIZE_IN_BYTES_FOR_CROPPER) { /* in kbs */
                Message::addErrorMessage(Labels::getLabel('MSG_Maximum_Upload_Size_is', $this->siteLangId) . ' ' . AttachedFile::IMAGE_MAX_SIZE_IN_BYTES / 1024 . 'KB');
            }

            $attachment = new AttachedFile();
            if ($attachment->saveImage($_FILES['photo']['tmp_name'], AttachedFile::FILETYPE_USER_IMAGE, UserAuthentication::getLoggedUserId(), 0, $_FILES['photo']['name'], 0, false)) {
                Message::addMessage(Labels::getLabel('MSG_Profile_Picture_Updated', $this->siteLangId));
            } else {
                Message::addErrorMessage($attachment->getError());
            }
        } else {
            Message::addErrorMessage(Labels::getLabel('MSG_No_File_Uploaded', $this->siteLangId));
        }
        FatApp::redirectUser(UrlHelper::generateUrl('member', 'account'));
    }

    public function escalateOrderReturnRequest($orrequest_id)
    {
        $orrequest_id = FatUtility::int($orrequest_id);
        if (!$orrequest_id) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            CommonHelper::redirectUserReferer();
        }
        $user_id = UserAuthentication::getLoggedUserId();
        $srch = new OrderReturnRequestSearch();
        $srch->joinOrderProducts();
        $srch->addCondition('orrequest_id', '=', 'mysql_func_' . $orrequest_id, 'AND', true);
        $srch->addCondition('orrequest_status', '=', 'mysql_func_' . OrderReturnRequest::RETURN_REQUEST_STATUS_PENDING, 'AND', true);

        /* $cnd = $srch->addCondition( 'orrequest_user_id', '=', $user_id );
          $cnd->attachCondition('op_selprod_user_id', '=', $user_id ); */
        $srch->addCondition('op_selprod_user_id', '=', 'mysql_func_' . $user_id, 'AND', true);

        $srch->doNotCalculateRecords();
        $srch->doNotLimitRecords();
        $srch->addMultipleFields(array('orrequest_id', 'orrequest_user_id'));
        $rs = $srch->getResultSet();
        $request = FatApp::getDb()->fetch($rs);

        if (!$request || $request['orrequest_id'] != $orrequest_id) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            CommonHelper::redirectUserReferer();
        }

        /* buyer cannot escalate request[ */
        // if( $user_id == $request['orrequest_user_id'] ){
        if (!User::isSeller()) {
            Message::addErrorMessage(Labels::getLabel('MSG_Invalid_Access', $this->siteLangId));
            CommonHelper::redirectUserReferer();
        }
        /* ] */


        $orrObj = new OrderReturnRequest();
        if (!$orrObj->escalateRequest($request['orrequest_id'], $user_id, $this->siteLangId)) {
            Message::addErrorMessage(Labels::getLabel($orrObj->getError(), $this->siteLangId));
            CommonHelper::redirectUserReferer();
        }

        /* email notification handling[ */
        $emailNotificationObj = new EmailHandler();
        if (!$emailNotificationObj->sendOrderReturnRequestStatusChangeNotification($orrequest_id, $this->siteLangId)) {
            Message::addErrorMessage(Labels::getLabel($emailNotificationObj->getError(), $this->siteLangId));
            CommonHelper::redirectUserReferer();
        }
        /* ] */
        Message::addMessage(Labels::getLabel('MSG_Your_request_sent', $this->siteLangId));
        CommonHelper::redirectUserReferer();
    }

    public function orderReturnRequestMessageSearch()
    {
        $frm = $this->getOrderReturnRequestMessageSearchForm($this->siteLangId);
        $postedData = FatApp::getPostedData();
        $post = $frm->getFormDataFromArray($postedData);
        $page = (empty($post['page']) || $post['page'] <= 0) ? 1 : FatUtility::int($post['page']);
        $pageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $user_id = UserAuthentication::getLoggedUserId();

        $orrequest_id = isset($post['orrequest_id']) ? FatUtility::int($post['orrequest_id']) : 0;
        $isSeller = isset($postedData['isSeller']) ? FatUtility::int($postedData['isSeller']) : 0;

        $parentAndTheirChildIds = User::getParentAndTheirChildIds($this->userParentId, false, true);
        $srch = new OrderReturnRequestMessageSearch($this->siteLangId);
        $srch->joinOrderReturnRequests();
        $srch->joinMessageUser($this->siteLangId);
        $srch->joinMessageAdmin();
        $srch->joinOrderProducts();
        $srch->addCondition('orrmsg_orrequest_id', '=', 'mysql_func_' . $orrequest_id, 'AND', true);
        if (0 < $isSeller) {
            $srch->addCondition('op_selprod_user_id', 'in', $parentAndTheirChildIds);
        } else {
            $srch->addCondition('orrequest_user_id', 'in', $parentAndTheirChildIds);
        }
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        $srch->addOrder('orrmsg_id', 'DESC');
        $srch->addMultipleFields(
            array(
                'orrmsg_id',
                'orrmsg_from_user_id',
                'orrmsg_msg',
                'orrmsg_date',
                'msg_user.user_name as msg_user_name',
                'orrequest_status',
                'orrmsg_from_admin_id',
                'admin_name',
                'ifnull(s_l.shop_name, s.shop_identifier) as shop_name',
                's.shop_id',
                'op_selprod_user_id',
                'op_rounding_off'
            )
        );

        $rs = $srch->getResultSet();
        $messagesList = FatApp::getDb()->fetchAll($rs, 'orrmsg_id');
        ksort($messagesList);

        $this->set('messagesList', (!empty($messagesList) ? $messagesList : array()));
        $this->set('page', $page);
        $this->set('pageCount', $srch->pages());
        $this->set('postedData', $post);

        $startRecord = ($page - 1) * $pageSize + 1;
        $endRecord = $page * $pageSize;
        $totalRecords = $srch->recordCount();
        if ($totalRecords < $endRecord) {
            $endRecord = $totalRecords;
        }
        $this->set('totalRecords', $totalRecords);
        $this->set('startRecord', $startRecord);
        $this->set('endRecord', $endRecord);
        $this->set('parentAndTheirChildIds', $parentAndTheirChildIds);

        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $this->set('loadMoreBtnHtml', $this->_template->render(false, false, '_partial/load-previous-btn.php', true));
        $this->set('html', $this->_template->render(false, false, 'account/order-return-request-messages-list.php', true, false));
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function shareWithTag()
    {
        $userId = UserAuthentication::getLoggedUserId();

        if (!FatApp::getConfig("CONF_ENABLE_REFERRER_MODULE", FatUtility::VAR_INT, 1)) {
            Message::addErrorMessage(Labels::getLabel("LBL_Refferal_module_no_longer_active", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $post = FatApp::getPostedData();
        //print_r($post); exit;
        $selprod_id = FatApp::getPostedData('selprod_id', FatUtility::VAR_INT, 0);
        $friendlist = FatApp::getPostedData('friendlist');
        $friendlist = rtrim($friendlist, ',');

        if (1 > $selprod_id && $friendlist == '') {
            Message::addErrorMessage(Labels::getLabel("LBL_INVALID_REQUEST", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $returnDataArr = array();
        $prodSrchObj = new ProductSearch($this->siteLangId);
        $prodSrchObj->setDefinedCriteria();
        $prodSrchObj->joinSellerSubscription();
        $prodSrchObj->addSubscriptionValidCondition();
        $prodSrchObj->doNotCalculateRecords();
        $prodSrchObj->doNotLimitRecords();
        $prodSrchObj->addCondition('selprod_id', '=', 'mysql_func_' . $selprod_id, 'AND', true);
        $prodSrchObj->addMultipleFields(array('selprod_id'));
        $rs = $prodSrchObj->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if (!$row) {
            Message::addErrorMessage(Labels::getLabel("LBL_Product_not_found_or_no_longer_available.", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $user_referral_code = User::getAttributesById($userId, "user_referral_code");
        if ($user_referral_code == '') {
            Message::addErrorMessage(Labels::getLabel("LBL_Your_referral_code_is_not_generated,_Please_contact_admin.", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        $productUrl = UrlHelper::generateUrl('products', 'view', array($selprod_id));
        $productUrl = base64_encode(ltrim($productUrl, '/'));

        $productSharingUrl = UrlHelper::generateFullUrl("custom", "referral", array($user_referral_code, $productUrl));

        $userInfo = User::getAttributesById($userId, array('user_fb_access_token'));
        if ($userInfo['user_fb_access_token'] == '') {
            Message::addErrorMessage(Labels::getLabel('MSG_Authenticate_Your_Account', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        include_once CONF_INSTALLATION_PATH . 'library/Fbapi.php';
        $config = array(
            'app_id' => FatApp::getConfig('CONF_FACEBOOK_APP_ID', FatUtility::VAR_STRING, ''),
            'app_secret' => FatApp::getConfig('CONF_FACEBOOK_APP_SECRET', FatUtility::VAR_STRING, ''),
        );
        $fb = new Fbapi($config);
        $fbObj = $fb->getInstance();

        $linkData = array(
            'link' => $productSharingUrl,
            'message' => Labels::getLabel('MSG_Share_and_Earn_Mesage', $this->siteLangId),
        );

        if ($friendlist != '') {
            $linkData['tags'] = $friendlist;
        }

        $fbAccessToken = $userInfo['user_fb_access_token'];

        try {
            // Returns a `Facebook\FacebookResponse` object
            $response = $fbObj->post('/me/feed', $linkData, $fbAccessToken);
        } catch (FacebookResponseException $e) {
            Message::addErrorMessage($e->getMessage());
            FatUtility::dieJsonError(Message::getHtml());
        } catch (FacebookSDKException $e) {
            Message::addErrorMessage($e->getMessage());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $graphNode = $response->getGraphNode();

        $this->set('msg', Labels::getLabel('MSG_Shared_Successfully!', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    public function shareSocialReferEarn()
    {
        $userId = UserAuthentication::getLoggedUserId();

        if (!FatApp::getConfig("CONF_ENABLE_REFERRER_MODULE", FatUtility::VAR_INT, 1)) {
            Message::addErrorMessage(Labels::getLabel("LBL_Refferal_module_no_longer_active", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }
        $post = FatApp::getPostedData();
        $selprod_id = FatApp::getPostedData('selprod_id', FatUtility::VAR_INT, 0);
        $socialMediaName = FatApp::getPostedData('socialMediaName', FatUtility::VAR_STRING, 0);

        if ($selprod_id <= 0 || $socialMediaName == '') {
            Message::addErrorMessage(Labels::getLabel("LBL_INVALID_REQUEST", $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['redirect_user'] = UrlHelper::generateUrl('products', 'view', array($selprod_id));

        /* FB API to share [ */
        include_once CONF_INSTALLATION_PATH . 'library/Fbapi.php';
        $config = array(
            'app_id' => FatApp::getConfig('CONF_FACEBOOK_APP_ID', FatUtility::VAR_STRING, ''),
            'app_secret' => FatApp::getConfig('CONF_FACEBOOK_APP_SECRET', FatUtility::VAR_STRING, ''),
        );
        $fb = new Fbapi($config);

        $userInfo = User::getAttributesById($userId, array('user_fb_access_token'));

        $fbLoginUrl = '';
        $friendList = array();
        if ($userInfo['user_fb_access_token'] == '') {
            $redirectUrl = UrlHelper::generateFullUrl('Buyer', 'getFbToken', array(), '', false);
            $fbLoginUrl = $fb->getLoginUrl($redirectUrl);
        } else {
            $fbAccessToken = $userInfo['user_fb_access_token'];
            $fbObj = $fb->getInstance();

            try {
                $response = $fbObj->get('/me/friends?fields=id,name', $fbAccessToken);
                $graphEdge = $response->getGraphEdge();
                foreach ($graphEdge as $graphNode) {
                    $friendList[] = $graphNode->asArray();
                }
            } catch (FacebookResponseException $e) {
                Message::addErrorMessage($e->getMessage());
                FatUtility::dieWithError(Message::getHtml());
            } catch (FacebookSDKException $e) {
                Message::addErrorMessage($e->getMessage());
                FatUtility::dieWithError(Message::getHtml());
            }
        }

        $this->set('fbLoginUrl', $fbLoginUrl);
        $this->set('friendList', $friendList);
        $this->set('selprod_id', $selprod_id);
        $this->_template->render(false, false);
    }

    private function getCreditsSearchForm($langId)
    {
        $frm = new Form('frmCreditSrch');
        $frm->addTextBox(Labels::getLabel('LBL_Keyword', $langId), 'keyword', '');
        $frm->addSelectBox(Labels::getLabel('LBL_Transaction_Type', $langId), 'debit_credit_type', array(-1 => Labels::getLabel('LBL_Both-Debit/Credit', $langId)) + Transactions::getCreditDebitTypeArr($langId), -1, array(), '');
        $frm->addDateField(Labels::getLabel('LBL_From_Date', $langId), 'date_from', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        $frm->addDateField(Labels::getLabel('LBL_To_Date', $langId), 'date_to', '', array('readonly' => 'readonly', 'class' => 'field--calender'));
        /* $frm->addSelectBox( '', 'date_order', array( 'ASC' => Labels::getLabel('LBL_Date_Order_Ascending', $langId), 'DESC' => Labels::getLabel('LBL_Date_Order_Descending', $langId) ), 'DESC', array(), '' ); */
        $fldSubmit = $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Search', $langId));
        $fldCancel = $frm->addButton("", "btn_clear", Labels::getLabel("LBL_Clear", $langId), array('onclick' => 'clearSearch();'));
        $frm->addHiddenField('', 'page');
        return $frm;
    }

    private function sendMessageForm($langId)
    {
        $frm = new Form('frmSendMessage', array('enctype' => "multipart/form-data"));
        $frm->addTextarea(Labels::getLabel('LBL_Comments', $langId), 'message_text', '', array('id' => 'messagetext'))->requirements()->setRequired(true);
        $frm->addHiddenField('', 'message_thread_id');
        $frm->addHiddenField('', 'message_id');
        $frm->addFileUpload(Labels::getLabel('LBL_Attach_file', $this->siteLangId), 'attached_file[]', array('accept' => '/*', 'id' => 'attachedFile[]', 'multiple' => 'multiple'));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Send', $langId));
        return $frm;
    }

    private function getMsgSearchForm($langId)
    {
        $frm = new Form('frmMessageSrch');
        $frm->addHiddenField('', 'page');
        $frm->addHiddenField('', 'thread_id');
        return $frm;
    }

    private function getSettingsForm()
    {
        $frm = new Form('frmBankInfo');
        $activeInactiveArr = applicationConstants::getActiveInactiveArr($this->siteLangId);
        $frm->addSelectBox(Labels::getLabel('LBL_Auto_Renew_Subscription', $this->siteLangId), 'user_autorenew_subscription', $activeInactiveArr, '', array(), Labels::getLabel('LBL_Select', $this->siteLangId));
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_SAVE_CHANGES', $this->siteLangId));
        return $frm;
    }

    private function getRechargeWalletForm($langId)
    {
        $frm = new Form('frmRechargeWallet');
        $fld = $frm->addFloatField('', 'amount');
        //$fld->requirements()->setRequired();
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Add_Credits', $langId));
        return $frm;
    }

    public function payOrderProductReqForm()
    {
        $post = FatApp::getPostedData();
        $userId = UserAuthentication::getLoggedUserId();

        $orderObj = new Orders();
        $data = $orderObj->getOrderProductsByOpId($post['op_id'], $this->siteLangId);
        
        if (!$data) {
            $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            FatUtility::dieJsonError($json);
        }
        if($data['op_pending_amount'] <= 0){
            $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            FatUtility::dieJsonError($json);
        }
        if($data['op_payment_status'] != Orders::ORDER_PAYMENT_PARTIAL || $data['order_user_id'] != $userId){
            $json['msg'] = Labels::getLabel('LBL_Invalid_Request', $this->siteLangId);
            FatUtility::dieJsonError($json);
        }
        

        $frm = $this->getOrderPaymentForm($this->siteLangId,$data);
        $frm->fill(array('op_id' => $post['op_id'],'order_id' => $post['order_id']));
        $this->set('frmPaymentOrder', $frm);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }

    private function getOrderPaymentForm($langId,$data)
    {
        $frm = new Form('frmPaymentOrder');
        $fld = $frm->addFloatField('', 'amount');
        $fld->htmlAfterField = '<span class="form-text muted-text">' . Labels::getLabel('LBL_Pending_Amount', $this->siteLangId) .': '.CommonHelper::displayMoneyFormat($data['op_pending_amount'], true, false, true, false, true). '</span>';
        $fld->requirements()->setPositive();
        $fld->requirements()->setRange(1, $data['op_pending_amount']);
        
        $frm->addHiddenField('', 'op_id');
        $frm->addHiddenField('', 'order_id');
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Pay', $langId));
        return $frm;
    }

    public function myAddresses()
    {
        $this->_template->render();
    }

    public function searchAddresses()
    {
        $address = new Address(0, $this->siteLangId);
        $addresses = $address->getData(Address::TYPE_USER, UserAuthentication::getLoggedUserId());

        if ($addresses) {
            $this->set('addresses', $addresses);
        } else {
            if (true === MOBILE_APP_API_CALL) {
                $this->set('addresses', array());
            }
            $this->set('noRecordsHtml', $this->_template->render(false, false, '_partial/no-record-found.php', true));
        }
        if (true === MOBILE_APP_API_CALL) {
            $cartObj = new Cart(UserAuthentication::getLoggedUserId());
            $shipping_address_id = $cartObj->getCartShippingAddress();
            $this->set('shippingAddressId', $shipping_address_id);
            $this->_template->render();
        }
        $this->_template->render(false, false);
    }

    public function addAddressForm($addr_id)
    {
        $addr_id = FatUtility::int($addr_id);
        $addressFrm = $this->getUserAddressForm($this->siteLangId);

        $stateId = 0;

        if ($addr_id > 0) {
            $address = new Address($addr_id, $this->siteLangId);
            $data = $address->getData(Address::TYPE_USER, UserAuthentication::getLoggedUserId());
            if (empty($data)) {
                Message::addErrorMessage(Labels::getLabel('MSG_Invalid_request', $this->siteLangId));
                FatUtility::dieJsonError(Message::getHtml());
            }
            $stateId = $data['addr_state_id'];
            $addressFrm->fill($data);

            $this->set('countryIso', $data['addr_country_iso']);
        }
        $isAlreadyExistsAddress = true;
        if (empty($addr_id)) {
            $addressObj = new Address(0, $this->siteLangId);
            $userAddress = $addressObj->getData(Address::TYPE_USER, UserAuthentication::getLoggedUserId());
            if (empty($userAddress)) {
                $isAlreadyExistsAddress = false;
            }
        }

        $this->set('isAlreadyExistsAddress', $isAlreadyExistsAddress);
        $this->set('addr_id', $addr_id);
        $this->set('stateId', $stateId);
        $this->set('addressFrm', $addressFrm);
        $this->_template->render(false, false);
    }

    public function truncateDataRequestPopup()
    {
        $this->_template->render(false, false);
    }

    public function sendTruncateRequest()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $db = FatApp::getDb();

        $srch = new UserGdprRequestSearch();
        $srch->addCondition('ureq_user_id', '=', 'mysql_func_' . $userId, 'AND', true);
        $srch->addCondition('ureq_type', '=', 'mysql_func_' . UserGdprRequest::TYPE_TRUNCATE, 'AND', true);
        $srch->addCondition('ureq_status', '=', 'mysql_func_' . UserGdprRequest::STATUS_PENDING, 'AND', true);
        $srch->addCondition('ureq_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if ($row) {
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError(Labels::getLabel('LBL_You_have_alrady_submitted_the_request', $this->siteLangId));
            }
            Message::addErrorMessage(Labels::getLabel('LBL_You_have_alrady_submitted_the_request', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $assignValues = array(
            'ureq_user_id' => $userId,
            'ureq_type' => UserGdprRequest::TYPE_TRUNCATE,
            'ureq_date' => date('Y-m-d H:i:s'),
        );

        $userReqObj = new UserGdprRequest();
        $userReqObj->assignValues($assignValues);
        if (!$userReqObj->save()) {
            Message::addErrorMessage($userReqObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }
        
        if (true === MOBILE_APP_API_CALL) {
            FatUtility::dieJsonSuccess(Labels::getLabel('MSG_Request_sent_successfully', $this->siteLangId));
        }
        Message::addMessage(Labels::getLabel('MSG_Request_sent_successfully', $this->siteLangId));
        FatUtility::dieJsonSuccess(Message::getHtml());
    }

    private function getRequestDataForm()
    {
        $frm = new Form('frmRequestdata');
        $frm->addTextBox(Labels::getLabel('LBL_Email', $this->siteLangId), 'credential_email', '', array('readonly' => 'readonly'));
        $frm->addTextBox(Labels::getLabel('LBL_Name', $this->siteLangId), 'user_name', '', array('readonly' => 'readonly'));
        $purposeFld = $frm->addTextArea(Labels::getLabel('LBL_PURPOSE_OF_REQUEST_DATA', $this->siteLangId), 'ureq_purpose');
        $purposeFld->requirements()->setRequired();
        $frm->addSubmitButton('', 'btn_submit', Labels::getLabel('LBL_Send_Request', $this->siteLangId));
        return $frm;
    }

    public function requestDataForm()
    {
        $userObj = new User(UserAuthentication::getLoggedUserId());
        $srch = $userObj->getUserSearchObj(array('credential_username', 'credential_email', 'user_name'));
        $rs = $srch->getResultSet();

        if (!$rs) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $data = FatApp::getDb()->fetch($rs, 'user_id');

        if ($data === false) {
            Message::addErrorMessage(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $cPageSrch = ContentPage::getSearchObject($this->siteLangId);
        $cPageSrch->addCondition('cpage_id', '=', 'mysql_func_' . FatApp::getConfig('CONF_GDPR_POLICY_PAGE', FatUtility::VAR_INT, 0), 'AND', true);
        $cpage = FatApp::getDb()->fetch($cPageSrch->getResultSet());
        $gdprPolicyLinkHref = '';
        if (!empty($cpage) && is_array($cpage)) {
            $gdprPolicyLinkHref = UrlHelper::generateUrl('Cms', 'view', array($cpage['cpage_id']));
        }

        $frm = $this->getRequestDataForm();
        $frm->fill($data);
        $this->set('frm', $frm);
        $this->set('gdprPolicyLinkHref', $gdprPolicyLinkHref);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }

    public function setupRequestData()
    {
        $frm = $this->getRequestDataForm();
        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            Message::addErrorMessage(current($frm->getValidationErrors()));
            FatUtility::dieJsonError(Message::getHtml());
        }
        $userId = UserAuthentication::getLoggedUserId();

        $srch = new UserGdprRequestSearch();
        $srch->addCondition('ureq_user_id', '=', 'mysql_func_' . $userId, 'AND', true);
        $srch->addCondition('ureq_type', '=', 'mysql_func_' . UserGdprRequest::TYPE_DATA_REQUEST, 'AND', true);
        $srch->addCondition('ureq_status', '=', 'mysql_func_' . UserGdprRequest::STATUS_PENDING, 'AND', true);
        $srch->addCondition('ureq_deleted', '=', 'mysql_func_' . applicationConstants::NO, 'AND', true);
        $rs = $srch->getResultSet();
        $row = FatApp::getDb()->fetch($rs);
        if ($row) {
            if (true === MOBILE_APP_API_CALL) {
                FatUtility::dieJsonError(Labels::getLabel('LBL_You_have_alrady_submitted_the_data_request', $this->siteLangId));
            }
            Message::addErrorMessage(Labels::getLabel('LBL_You_have_alrady_submitted_the_data_request', $this->siteLangId));
            FatUtility::dieWithError(Message::getHtml());
        }

        $assignValues = array(
            'ureq_user_id' => $userId,
            'ureq_type' => UserGdprRequest::TYPE_DATA_REQUEST,
            'ureq_date' => date('Y-m-d H:i:s'),
            'ureq_purpose' => $post['ureq_purpose'],
        );

        $userReqObj = new UserGdprRequest();
        $userReqObj->assignValues($assignValues);
        if (!$userReqObj->save()) {
            Message::addErrorMessage($userReqObj->getError());
            FatUtility::dieJsonError(Message::getHtml());
        }

        $post['user_id'] = $userId;
        $emailNotificationObj = new EmailHandler();
        if (!$emailNotificationObj->sendDataRequestNotification($post, $this->siteLangId)) {
            Message::addErrorMessage(Labels::getLabel($emailNotificationObj->getError(), $this->siteLangId));
            FatUtility::dieJsonError(Message::getHtml());
        }

        $this->set('msg', Labels::getLabel('MSG_REQUEST_SENT_SUCCESSFULLY', $this->siteLangId));
        $this->_template->render(false, false, 'json-success.php');
    }

    //Valid for 10 Minutes only
    public function getTempToken()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $uObj = new User($userId);
        $tempToken = substr(md5(rand(1, 99999) . microtime()), 0, UserAuthentication::TOKEN_LENGTH);

        if (!$uObj->createUserTempToken($tempToken)) {
            FatUtility::dieJsonError($uObj->getError());
        }
        $this->set('data', array('tempToken' => $tempToken));
        $this->_template->render();
    }

    public function notifications()
    {
        $userId = UserAuthentication::getLoggedUserId();

        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $defaultPageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $pageSize = FatApp::getPostedData('pagesize', FatUtility::VAR_INT, $defaultPageSize);
        $srch = Notifications::getSearchObject();
        $srch->addCondition('unt.unotification_user_id', '=', 'mysql_func_' . $userId, 'AND', true);
        $srch->addOrder('unt.unotification_id', 'DESC');
        $srch->addMultipleFields(array('unt.*'));
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);

        $this->set('notifications', $records);
        $this->set('total_pages', $srch->pages());
        $this->set('total_records', $srch->recordCount());
        $this->_template->render();
    }

    public function readAllNotifications()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $smt = array(
            'smt' => Notifications::DB_TBL_PREFIX . 'is_read = ? AND ' . Notifications::DB_TBL_PREFIX . 'user_id = ?',
            'vals' => array(applicationConstants::NO, (int) $userId)
        );
        $db = FatApp::getDb();
        if (!$db->updateFromArray(Notifications::DB_TBL, array(Notifications::DB_TBL_PREFIX . 'is_read' => 1), $smt)) {
            FatUtility::dieJsonError($db->getError());
        }
        $this->set('msg', Labels::getLabel('Msg_Successfully_Updated', $this->siteLangId));
        $this->_template->render();
    }

    public function markNotificationRead($notificationId)
    {
        $notificationId = FatUtility::int($notificationId);
        if (1 > $notificationId) {
            FatUtility::dieJSONError(Labels::getLabel('Msg_Invalid_Request', $this->siteLangId));
        }
        $userId = UserAuthentication::getLoggedUserId();

        $srch = Notifications::getSearchObject();
        $srch->addCondition('unt.unotification_user_id', '=', 'mysql_func_' . $userId, 'AND', true);
        $srch->addCondition('unt.unotification_id', '=', 'mysql_func_' . $notificationId, 'AND', true);
        $srch->setPageSize(1);
        $rs = $srch->getResultSet();
        $notification = FatApp::getDb()->fetch($rs);
        if (!($notification)) {
            FatUtility::dieJSONError(Labels::getLabel('Msg_Invalid_Request', $this->siteLangId));
        }
        $nObj = new Notifications();
        if (!$nObj->readUserNotification($notificationId, $userId)) {
            FatUtility::dieJsonError($nObj->getError());
        }

        $notificationData = Notifications::getAttributesById($notificationId, ['unotification_data', 'unotification_type']);
        $rfqNotificationTypes = Notifications::getRfqModuleNotificationTypes();
        $resData = json_decode($notificationData['unotification_data'], true);
        if (!empty($notificationData) && (in_array($notificationData['unotification_type'], $rfqNotificationTypes))) {
            switch ($notificationData['unotification_type']) {
                case Notifications::NEW_RFQ_SUBMISSION:
                case Notifications::NEW_RFQ_OFFER_SUBMISSION_BY_BUYER:
                case Notifications::NEW_RFQ_OFFER_UPDATE_BY_BUYER:
                    $action = CommonHelper::generateUrl('requestForQuotes', 'view', [$resData['rfq_id']]);
                    break;
                case Notifications::NEW_RFQ_OFFER_SUBMISSION_BY_SELLER:
                case Notifications::NEW_RFQ_OFFER_UPDATE_BY_SELLER:
                    $action = CommonHelper::generateUrl('requestForQuotes', 'requestView', [$resData['rfq_id']]);
                    break;
                case Notifications::INVOICE_SHARED_BY_SELLER:
                    $action = CommonHelper::generateUrl('RfqCheckout', 'index', [$resData['order_id']]);
                    break;
                case Notifications::INVOICE_REGENERATE_REQUEST_BY_BUYER:
                    $action = CommonHelper::generateUrl('invoices', 'create', [$resData['order_id']]);
                    break;
                case Notifications::RFQ_CLOSED_BY_ADMIN:
                    $action = CommonHelper::generateUrl('requestForQuotes', $resData['action'], [$resData['rfq_id']]);
                    break;

                default:
                    $action = '';
            }
            $this->set('action', $action);
        }


        $this->set('msg', Labels::getLabel('Msg_Successfully_Updated', $this->siteLangId));
        /* $this->_template->render(); */
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php', true, false);
    }

    public function changePhoneForm($updatePhnFrm = 0)
    {
        $userId = UserAuthentication::getLoggedUserId();
        $phData = User::getAttributesById($userId, ['user_dial_code', 'user_phone']);
        $updatePhnFrm = empty($updatePhnFrm) ? empty($phData['user_phone']) ? 1 : 0 : $updatePhnFrm;

        $frm = $this->getPhoneNumberForm();
        if (1 > $updatePhnFrm && !empty($phData['user_phone'])) {
            $frm->fill(['user_phone' => $phData['user_phone']]);
            $phnFld = $frm->getField('user_phone');
            $phnFld->setFieldTagAttribute('readonly', 'readonly');
        }
        $dialCode = isset($phData['user_dial_code']) && !empty($phData['user_dial_code']) ? $phData['user_dial_code'] : '';
        $this->set('dialCode', $dialCode);
        $this->set('countryIso', User::getUserMeta($userId, 'user_country_iso'));
        $this->set('frm', $frm);
        $this->set('updatePhnFrm', $updatePhnFrm);
        $this->set('siteLangId', $this->siteLangId);
        $json['html'] = $this->_template->render(false, false, 'account/change-phone-form.php', true, false);
        FatUtility::dieJsonSuccess($json);
    }

    private function sendOtp(int $userId, string $countryIso, string $dialCode, int $phone)
    {
        $userObj = new User($userId);
        $dialCode = !empty($dialCode) & '+' != $dialCode[0] ? '+' . $dialCode : $dialCode;
        $otp = $userObj->prepareUserPhoneOtp($countryIso, $dialCode, $phone);
        if (false == $otp) {
            LibHelper::dieJsonError($userObj->getError());
        }

        $userData = $userObj->getUserInfo('user_name', false, false);
        $phone = $dialCode . $phone;
        $obj = clone $userObj;
        if (false === $obj->sendOtp($phone, $userData['user_name'], $otp, $this->siteLangId)) {
            LibHelper::dieJsonError($obj->getError());
        }
        return true;
    }

    public function getOtp($updatePhnFrm = 0)
    {
        $frm = $this->getPhoneNumberForm();

        $post = $frm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $post) {
            LibHelper::dieJsonError(current($frm->getValidationErrors()));
        }

        $dialCode = FatApp::getPostedData('user_dial_code', FatUtility::VAR_STRING, '');
        $countryIso = FatApp::getPostedData('user_country_iso', FatUtility::VAR_STRING, '');
        $phoneNumber = FatUtility::int($post['user_phone']);
        if (empty($phoneNumber) || (!empty($phoneNumber) && empty($dialCode))) {
            $message = Labels::getLabel("MSG_INVALID_PHONE_NUMBER_FORMAT", $this->siteLangId);
            LibHelper::dieJsonError($message);
        }

        $userId = UserAuthentication::getLoggedUserId();
        if (1 > $updatePhnFrm && false === UserAuthentication::validateUserPhone($userId, $phoneNumber)) {
            LibHelper::dieJsonError(Labels::getLabel('MSG_INVALID_PHONE_NUMBER', $this->siteLangId));
        }

        if (0 < $updatePhnFrm) {
            $db = FatApp::getDb();
            $srch = User::getSearchObject(false, 0, false);
            $srch->addCondition('user_phone', '=', $phoneNumber);
            $srch->addCondition('user_id', '!=', 'mysql_func_' . $userId, 'AND', true);
            $rs = $srch->getResultSet();
            $row = $db->fetch($rs);
            if (!empty($row)) {
                LibHelper::dieJsonError(Labels::getLabel('MSG_THIS_PHONE_NUMBER_IS_ALREADY_EXISTS.', $this->siteLangId));
            }
        }

        $this->sendOtp($userId, trim($countryIso), trim($dialCode), $phoneNumber);

        $this->set('msg', Labels::getLabel('MSG_OTP_SENT!_PLEASE_CHECK_YOUR_PHONE.', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }

        $otpFrm = $this->getOtpForm();
        $otpFrm->fill(['user_id' => $userId]);
        $this->set('frm', $otpFrm);
        $json['html'] = $this->_template->render(false, false, 'guest-user/otp-form.php', true, false);
        FatUtility::dieJsonSuccess($json);
    }

    public function validateOtp($updatePhnFrm = 0)
    {
        $updateToDb = (1 > $updatePhnFrm ? 1 : 0);
        $this->validateOtpApi($updateToDb);

        if (0 < $updatePhnFrm) {
            $this->changePhoneForm($updatePhnFrm);
            exit;
        }

        $this->_template->render(false, false, 'json-success.php');
    }

    public function resendOtp()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $dialCode = FatApp::getPostedData('user_dial_code', FatUtility::VAR_STRING, '');
        $countryIso = FatApp::getPostedData('user_country_iso', FatUtility::VAR_STRING, '');
        $phone = FatApp::getPostedData('user_phone', FatUtility::VAR_INT, 0);

        if (!empty($phone)) {
            $this->sendOtp($userId, $countryIso, $dialCode, $phone);
        } else {
            $userObj = new User($userId);
            if (false == $userObj->resendOtp()) {
                FatUtility::dieJsonError($userObj->getError());
            }
        }

        $this->set('msg', Labels::getLabel('MSG_OTP_SENT!_PLEASE_CHECK_YOUR_PHONE.', $this->siteLangId));
        if (true === MOBILE_APP_API_CALL) {
            $this->_template->render();
        }
        $this->_template->render(false, false, 'json-success.php');
    }

    public function pushNotifications()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $page = FatApp::getPostedData('page', FatUtility::VAR_INT, 1);
        $defaultPageSize = FatApp::getConfig('conf_page_size', FatUtility::VAR_INT, 10);
        $pageSize = FatApp::getPostedData('pagesize', FatUtility::VAR_INT, $defaultPageSize);

        $srch = User::getSearchObject();
        $srch->joinTable(UserAuthentication::DB_TBL_USER_AUTH, 'INNER JOIN', 'ua.uauth_user_id = u.user_id', 'ua');
        $srch->addMultipleFields(['uauth_device_os', 'user_regdate']);
        $srch->addCondition('uauth_user_id', '=', 'mysql_func_' . $userId, 'AND', true);
        $srch->setPageSize(1);
        $rs = $srch->getResultSet();
        $uData = FatApp::getDb()->fetch($rs);

        $srch = PushNotification::getSearchObject(true);
        $srch->addMultipleFields([
            'pnotification_id',
            'pnotification_title',
            'pnotification_description',
            'pnotification_url',
            'pntu_user_id'
        ]);
        $cond = $srch->addCondition('pnotification_status', '=', 'mysql_func_' . PushNotification::STATUS_COMPLETED, 'AND', true);
        $cond->attachCondition('pnotification_status', '=', 'mysql_func_' . PushNotification::STATUS_PROCESSING, 'OR', true);
        $srch->addCondition('pnotification_user_auth_type', '=', 'mysql_func_' . User::AUTH_TYPE_REGISTERED, 'AND', true);
        $srch->addCondition('pnotification_added_on', '>=', $uData['user_regdate']);
        $cond = $srch->addCondition('pntu_user_id', 'IS', 'mysql_func_NULL', 'AND', true);
        $cond->attachCondition('pntu_user_id', '=', 'mysql_func_' . $userId, 'OR', true);
        $cond = $srch->addCondition('pnotification_device_os', '=', 'mysql_func_' . User::DEVICE_OS_BOTH, 'AND', true);
        $cond->attachCondition('pnotification_device_os', '=', $uData['uauth_device_os'], 'OR');
        $srch->setPageNumber($page);
        $srch->setPageSize($pageSize);
        $srch->addOrder('pnotification_added_on', 'DESC');
        $srch->addOrder('pnotification_id', 'DESC');
        $rs = $srch->getResultSet();
        $pnotificationsArr = FatApp::getDb()->fetchAll($rs);

        $this->set('pnotifications', $pnotificationsArr);
        $this->set('total_pages', $srch->pages());
        $this->set('total_records', $srch->recordCount());
        $this->_template->render();
    }

    /* Cards Management */

    private function setErrorAndRedirect(string $msg, bool $json = false, $redirect = true)
    {
        $json = FatUtility::isAjaxCall() ? true : $json;
        LibHelper::exitWithError($msg, $json, $redirect);
        CommonHelper::redirectUserReferer();
    }

    public function cards()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $paymentCard = new PaymentCard($this->siteLangId, $userId);
        if (false === $paymentCard->fetchAll()) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }
        $this->set('savedCards', $paymentCard->getResponse());

        if (false === $paymentCard->getDefault()) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }
        $this->set('defaultSource', $paymentCard->getResponse());
        $this->_template->render();
    }

    /**
     * removeCard
     *
     * @param  string $cardId
     * @return void
     */
    public function removeCard(string $cardId)
    {
        if (empty($cardId)) {
            $this->setErrorAndRedirect(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }
        $userId = UserAuthentication::getLoggedUserId();
        $paymentCard = new PaymentCard($this->siteLangId, $userId);
        if (false === $paymentCard->delete($cardId)) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }

        $msg = Labels::getLabel("MSG_REMOVED_SUCCESSFULLY", $this->siteLangId);
        FatUtility::dieJsonSuccess($msg);
    }

    /**
     * addCardForm
     *
     * @return void
     */
    public function addCardForm()
    {
        $frm = PaymentCard::getCardForm($this->siteLangId);
        $this->set('frm', $frm);
        $this->_template->render(false, false);
    }

    /**
     * bindCustomer
     *
     * @return void
     */
    public function bindCustomer()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $paymentCard = new PaymentCard($this->siteLangId, $userId);
        if (false === $paymentCard->bindCustomer()) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }

        $customer = $paymentCard->getResponse();
        $json['customerId'] = $customer->id;
        $json['msg'] = Labels::getLabel('MSG_SUCCESS', $this->siteLangId);
        FatUtility::dieJsonSuccess($json);
    }

    /**
     * setupNewCard
     *
     * @return void
     */
    public function setupNewCard()
    {
        $cardFrm = PaymentCard::getCardForm($this->siteLangId);
        $cardData = $cardFrm->getFormDataFromArray(FatApp::getPostedData());
        if (false === $cardData) {
            $this->setErrorAndRedirect(current($cardFrm->getValidationErrors()));
        }
        unset($cardData['btn_submit']);

        $userId = UserAuthentication::getLoggedUserId();
        $paymentCard = new PaymentCard($this->siteLangId, $userId);
        if (false === $paymentCard->create($cardData)) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }

        $cardTokenResponse = $paymentCard->getResponse();
        $json['cardId'] = $cardTokenResponse->id;
        $json['msg'] = Labels::getLabel('MSG_SUCCESS', $this->siteLangId);
        FatUtility::dieJsonSuccess($json);
    }

    /**
     * markAsDefault
     *
     * @param  string $cardId
     * @return void
     */
    public function markAsDefault(string $cardId)
    {
        if (empty($cardId)) {
            $this->setErrorAndRedirect(Labels::getLabel('MSG_INVALID_REQUEST', $this->siteLangId));
        }

        $userId = UserAuthentication::getLoggedUserId();
        $paymentCard = new PaymentCard($this->siteLangId, $userId);
        if (false === $paymentCard->markAsDefault($cardId)) {
            $this->setErrorAndRedirect($paymentCard->getError());
        }

        $json['msg'] = Labels::getLabel('MSG_SUCESS', $this->siteLangId);
        FatUtility::dieJsonSuccess($json);
    }

    /* Cards Management */

    public function loadNotifications()
    {
        $srch = new SearchBase(Notifications::DB_TBL, 'unt');
        //$srch->doNotCalculateRecords();
        //$srch->doNotLimitRecords();
        $srch->addCondition('unt.unotification_user_id', '=', 'mysql_func_' . $this->userParentId, 'AND', true);
        //$srch->addCondition('unt.unotification_is_read', '=', 0);
        $srch->addCondition('unt.unotification_type', 'IN', Notifications::getRfqModuleNotificationTypes());
        $srch->addOrder('unotification_is_read', 'ASC');
        $srch->addOrder('unt.unotification_id', 'DESC');
        $srch->setPageNumber(1);
        $srch->setPageSize(50);
        $rs = $srch->getResultSet();
        $records = FatApp::getDb()->fetchAll($rs);
        $this->set('records', $records);
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false, 'account/load-notifications.php', false, false);
    }

    public function downloadAttachedFileMsg($fileId = 0)
    {
        $fileId = FatUtility::int(CommonHelper::decryptId($fileId));
        if ($fileId > 0) {
            $file_row = AttachedFile::getAttributesById($fileId);
        }

        if (false == $file_row) {
            Message::addErrorMessage($this->str_invalid_request);
            FatUtility::dieWithError(Message::getHtml());
        }

        $fileName = isset($file_row['afile_physical_path']) ? $file_row['afile_physical_path'] : '';
        AttachedFile::downloadAttachment($fileName, $file_row['afile_name']);
    }

    public function addCreditReqForm()
    {
        $userId = UserAuthentication::getLoggedUserId();
        $pendingLateCharges = BuyerLateChargesHistory::getUserPendingChargesTotalDetails($userId, true);
        $this->set('pendingLateCharges', $pendingLateCharges);
        $this->set('frmRechargeWallet', $this->getRechargeWalletForm($this->siteLangId));
        $this->set('siteLangId', $this->siteLangId);
        $this->_template->render(false, false);
    }
}