<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
foreach ($paymentMethods as $key => $val) {
    if ($cartHasDigitalProduct && in_array(strtolower($val['plugin_code']), ['cashondelivery', 'payatstore'])) {
        unset($paymentMethods[$key]);
        continue;
    }

    if (in_array($val['plugin_code'], $excludePaymentGatewaysArr[applicationConstants::CHECKOUT_PRODUCT])) {
        unset($paymentMethods[$key]);
        continue;
    }
    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PLUGIN_LOGO, $val['plugin_id']);
    $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
    $paymentMethods[$key]['image'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'plugin', array($val['plugin_id'], 'ICON'), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
}

$rewardPoints = UserRewardBreakup::rewardPointBalance(UserAuthentication::getLoggedUserId());

$cartTotal = isset($cartSummary['cartTotal']) ? $cartSummary['cartTotal'] : 0;
$cartDiscounts = isset($cartSummary['cartDiscounts']["coupon_discount_total"]) ? $cartSummary['cartDiscounts']["coupon_discount_total"] : 0;
$canBeUsed = min(min($rewardPoints, CommonHelper::convertCurrencyToRewardPoint($cartTotal - $cartDiscounts)), FatApp::getConfig('CONF_MAX_REWARD_POINT', FatUtility::VAR_INT, 0));
$minRewardPoints = FatApp::getConfig('CONF_MIN_REWARD_POINT', FatUtility::VAR_INT, 0);
if ($minRewardPoints == $canBeUsed) {
    $str = Labels::getLabel('LBL_You_can_redeem_{MIN}_reward_points.', $siteLangId);
} else if ($minRewardPoints > $canBeUsed) {
    $str = Labels::getLabel('LBL_You_need_minimum_{MIN}_reward_points_to_redeem.', $siteLangId);
} else {
    $str = Labels::getLabel('LBL_Redeem_reward_points_within_the_range_of_{MIN}_to_{MAX}.', $siteLangId);
}
$minRewardPointsMsg = CommonHelper::replaceStringData($str, ['{MIN}' => $minRewardPoints, '{MAX}' => $canBeUsed]);

$data = array(
    'orderId' => $orderId,
    'orderType' => $orderType,
    'cartType'=>$cartType,
    'minRewardPointsMsg' => $minRewardPointsMsg,
    'canUseWalletForPayment' => (true == $canUseWalletForPayment ? 1 : 0),
    'paymentMethods' => array_values($paymentMethods),
);

require_once(CONF_THEME_PATH . 'default/cart/price-detail.php');

if (empty($products)) {
    $status = applicationConstants::OFF;
}
