<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

foreach ($paymentMethods as $key => $val) {
    if ($cartHasDigitalProduct && in_array(strtolower($val['plugin_code']), ['cashondelivery', 'payatstore'])) {
        unset($paymentMethods[$key]);
        continue;
    }

    if (in_array($val['plugin_code'], $excludePaymentGatewaysArr[applicationConstants::CHECKOUT_PRODUCT])) {
        unset($paymentMethods[$key]);
        continue;
    }
    $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_PLUGIN_LOGO, $val['plugin_id']);
    $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
    $paymentMethods[$key]['image'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'plugin', array($val['plugin_id'], 'ICON'), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
}

if (!empty($verificationFldsData)) {
    foreach ($verificationFldsData as $key => $vfldData) {
        if ($vfldData['ovd_vflds_type'] == VerificationFields::FLD_TYPE_FILE) {
            $downloadUrl = UrlHelper::generateFullUrl('RfqCheckout', 'downloadAttachedFile', array($orderOrderId, $vfldData['ovd_vfld_id']));
            $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_VERIFICATION_ATTACHMENT, $orderOrderId, $vfldData['ovd_vfld_id']);
            $verificationFldsData[$key]['file_download_url'] = $downloadUrl;
            $verificationFldsData[$key]['file_name'] = $file_row['afile_name'];
        }
    }
}
if (empty($shippingAddressArr)) {
    $shippingAddressArr = new stdClass();
}

if (empty($billingAddressArr)) {
    $billingAddressArr = new stdClass();
}

$data = array(
    'orderId' => $orderId,
    'orderType' => $orderType,
    'fulfillmentType' => $fulfillmentType,
    'shippingAddressArr' => $shippingAddressArr,
    'cartHasPhysicalProduct' => $cartHasPhysicalProduct,
    'billingAddressArr' => $billingAddressArr,
    'verificationFldsData' => $verificationFldsData,
    'orderPickUpData' => $orderPickUpData,
    'canUseWalletForPayment' => (true == $canUseWalletForPayment ? 1 : 0),
    'paymentMethods' => array_values($paymentMethods),
    
);

require_once(CONF_THEME_PATH . 'default/cart/price-detail-rfq.php');
