<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$sortByArr = array(
    ['key'=>'price_asc','value'=>Labels::getLabel('LBL_Price_(Low_to_High)', $siteLangId)],
    ['key'=>'price_desc','value'=>Labels::getLabel('LBL_Price_(High_to_Low)', $siteLangId)],
    ['key'=>'popularity_desc','value'=>Labels::getLabel('LBL_Sort_by_Popularity', $siteLangId)],
    ['key'=>'discounted','value'=>Labels::getLabel('LBL_Most_discounted', $siteLangId)],
);
if (0 < FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0)) {
    $sortByArr[] = ['key'=>'rating_desc','value'=>Labels::getLabel('LBL_Sort_by_Rating', $siteLangId)];
}
$data['sortBy'] = $sortByArr;

if (array_key_exists('products', $data)) {
    foreach ($data['products'] as $index => $product) {
        $uploadedTime = AttachedFile::setTimeParam($product['product_updated_on']);
        $data['products'][$index]['product_image_url'] = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('image', 'product', array($product['product_id'], "CLAYOUT3", $product['selprod_id'], 0, $siteLangId)).$uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');
        $data['products'][$index]['selprod_price'] = CommonHelper::displayMoneyFormat($product['selprod_price'], false, false, false);
        $data['products'][$index]['theprice'] = CommonHelper::displayMoneyFormat($product['theprice'], false, false, false);
        $data['products'][$index]['rent_price'] = CommonHelper::displayMoneyFormat($product['rent_price']??0, false, false, false);
    }
}
if (!empty($data['shop'])) {
    if (isset($data['shop']['shop_payment_policy']) && !empty(array_filter((array)$data['shop']['shop_payment_policy']))) {
        $data['shop']['policies'][] = $data['shop']['shop_payment_policy'];
    }
    if (isset($data['shop']['shop_delivery_policy']) && !empty(array_filter((array)$data['shop']['shop_delivery_policy']))) {
        $data['shop']['policies'][] = $data['shop']['shop_delivery_policy'];
    }
    if (isset($data['shop']['shop_refund_policy']) && !empty(array_filter((array)$data['shop']['shop_refund_policy']))) {
        $data['shop']['policies'][] = $data['shop']['shop_refund_policy'];
    }
    if (isset($data['shop']['shop_additional_info']) && !empty(array_filter((array)$data['shop']['shop_additional_info']))) {
        $data['shop']['policies'][] = $data['shop']['shop_additional_info'];
    }
    if (isset($data['shop']['shop_seller_info']) && !empty(array_filter((array)$data['shop']['shop_seller_info']))) {
        $data['shop']['policies'][] = $data['shop']['shop_seller_info'];
    }

    $data['shop']['policies'] = !empty($data['shop']['policies']) ? $data['shop']['policies'] : [];
    $data['shop']['shop_logo'] = UrlHelper::generateFullUrl('image', 'shopLogo', array($data['shop']['shop_id'], $siteLangId, 'SMALL'));;

    $data['shop']['socialPlatforms'] = !empty($socialPlatforms) ? $socialPlatforms : [];
    unset($data['shop']['shop_payment_policy'], $data['shop']['shop_delivery_policy'], $data['shop']['shop_refund_policy'], $data['shop']['shop_additional_info'], $data['shop']['shop_seller_info']);
}

$data['shop'] = !empty($data['shop']) ? $data['shop'] : (object)array();

$data['socialShareContent'] = !empty($socialShareContent) ? $socialShareContent : (object)array();

$reportSpamVisibility = false;
$showMoreButtons = true;
if (isset($userParentId) && $userParentId == $shop['shop_user_id']) {
    $showMoreButtons = false;
}
if ($showMoreButtons) {
    $shopRepData = ShopReport::getReportDetail($shop['shop_id'], UserAuthentication::getLoggedUserId(true), 'sreport_id');
    if (false === UserAuthentication::isUserLogged() || empty($shopRepData)) { 
        $reportSpamVisibility = true;
    }
}
$data['reportSpamVisibility'] = $reportSpamVisibility; 

if (empty($data['products'])) {
    $status = applicationConstants::OFF;
}
