<?php

class OrderCancelRequest extends MyAppModel
{
    public const DB_TBL = 'tbl_order_cancel_requests';
    public const DB_TBL_PREFIX = 'ocrequest_';

    public const CANCELLATION_REQUEST_STATUS_PENDING = 0;
    public const CANCELLATION_REQUEST_STATUS_APPROVED = 1;
    public const CANCELLATION_REQUEST_STATUS_DECLINED = 2;
    public const CANCELLATION_REQUEST_STATUS_APPROVED_BY_SELLER = 3;

    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
    }

    public static function getSearchObject($langId = 0)
    {
        $srch = new SearchBase(static::DB_TBL, 'ocr');
        return $srch;
    }

    public static function getStatusClassArr()
    {
        return array(
        static::CANCELLATION_REQUEST_STATUS_PENDING => applicationConstants::CLASS_INFO,
        static::CANCELLATION_REQUEST_STATUS_APPROVED => applicationConstants::CLASS_SUCCESS,
        static::CANCELLATION_REQUEST_STATUS_DECLINED => applicationConstants::CLASS_DANGER,
        static::CANCELLATION_REQUEST_STATUS_APPROVED_BY_SELLER => applicationConstants::CLASS_SUCCESS,
        );
    }

    public static function getRequestStatusArr($langId)
    {
        $langId = FatUtility::int($langId);
        if ($langId < 1) {
            $langId = FatApp::getConfig('CONF_ADMIN_DEFAULT_LANG');
        }
        return array(
            static::CANCELLATION_REQUEST_STATUS_PENDING => Labels::getLabel('LBL_PENDING', $langId),
            static::CANCELLATION_REQUEST_STATUS_APPROVED => Labels::getLabel('LBL_APPROVED', $langId),
            static::CANCELLATION_REQUEST_STATUS_DECLINED => Labels::getLabel('LBL_DECLINED', $langId),
            static::CANCELLATION_REQUEST_STATUS_APPROVED_BY_SELLER => Labels::getLabel('LBL_ORDER_CANCELLED_BY_SELLER', $langId),
        );
    }

    public static function getCancelRequestById($recordId, $attr = null)
    {
        $recordId = FatUtility::convertToType($recordId, FatUtility::VAR_INT);
        if (1 > $recordId) {
            return false;
        }

        $db = FatApp::getDb();

        $srch = new SearchBase(static::DB_TBL);
        $srch->addCondition('ocrequest_op_id', '=', $recordId);

        if (null != $attr) {
            if (is_array($attr)) {
                $srch->addMultipleFields($attr);
            } elseif (is_string($attr)) {
                $srch->addFld($attr);
            }
        }

        $rs = $srch->getResultSet();
        $row = $db->fetch($rs);

        if (!is_array($row)) {
            return false;
        }

        if (is_string($attr)) {
            return $row[$attr];
        }
        return $row;
    }

    public static function getStatusHtml(int $langId, int $status): string
    {
        $arr = self::getRequestStatusArr($langId);
        $msg = $arr[$status] ?? Labels::getLabel('LBL_N/A', $langId);
        switch ($status) {
            case static::CANCELLATION_REQUEST_STATUS_PENDING:
                $status = HtmlHelper::INFO;
                break;
            case static::CANCELLATION_REQUEST_STATUS_APPROVED:
                $status = HtmlHelper::SUCCESS;
                break;
            case static::CANCELLATION_REQUEST_STATUS_DECLINED:
            case static::CANCELLATION_REQUEST_STATUS_APPROVED_BY_SELLER:
                $status = HtmlHelper::DANGER;
                break;
            default:
                $status = HtmlHelper::PRIMARY;
                break;
        }
        return HtmlHelper::getStatusHtml($status, rtrim($msg));
    }
	
	public function getAddonsDetail($requests, $langId)
	{
		foreach($requests as $key => $requestRow) {
			$addonTotalAmt = $addonTotalAfterPenality = 0;
			if ($requestRow['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
				$addonProducts = Orders::getAddonsIdsByProduct($requestRow['op_id'], false);
				
				if (!empty($addonProducts)) {
					$retReqObj = new OrderCancelRequest();
					$cancelRequestDetail = $retReqObj->getCancelRequestById($requestRow['op_id']);
					$orderObj = new Orders();
					foreach ($addonProducts as $addonProduct) {
						$childOrderInfo = $orderObj->getOrderProductsByOpId($addonProduct['op_id'], $langId);
						
						if (!$childOrderInfo['opd_is_eligible_cancel']) {
							continue;
						}
						
						$txnAmount = CommonHelper::orderProductAmount($childOrderInfo, 'netamount');
						
						$addonTotalAmt += $txnAmount;
						
						if($cancelRequestDetail['ocrequest_is_penalty_applicable'] > 0) {
							$shippingCharges = CommonHelper::orderProductAmount($childOrderInfo, 'SHIPPING');
							$taxCharges = CommonHelper::orderProductAmount($childOrderInfo, 'TAX');
							$updatesTxnAmont = $txnAmount - $shippingCharges - $taxCharges;
							$txnAmount = (($updatesTxnAmont) * $cancelRequestDetail['ocrequest_refund_amount'] / 100) + $shippingCharges + ($taxCharges * $cancelRequestDetail['ocrequest_refund_amount'] / 100);
						}
						$addonTotalAfterPenality += $txnAmount;
					}
				}
			}
			$requests[$key]['addon_total_amount'] = $addonTotalAmt;
			$requests[$key]['addon_total_amount_after_penality'] = $addonTotalAfterPenality;
		}
		return $requests;
	}
}
