<?php

class OrderProductChecklistPoint extends MyAppModel
{

    public const DB_TBL = 'tbl_order_product_checklist_points';
    public const DB_TBL_PREFIX = 'opcp_';

    private $db;

    public function __construct($id = 0)
    {
        parent::__construct(static::DB_TBL, static::DB_TBL_PREFIX . 'id', $id);
        $this->db = FatApp::getDb();
    }

    public static function getSearchObject(): object
    {
        $srch = new SearchBase(static::DB_TBL, 'opcp');
        return $srch;
    }

    public static function getOrderProductData($opId)
    {
        if($opId <= 0){
            return [];
        }
        $srch = new SearchBase(OrderProductChecklistPoint::DB_TBL, 'opcp');
        $srch->joinTable(ChecklistPoint::DB_TBL, 'LEFT JOIN', 'opcp.opcp_cp_id = cp.cp_id', 'cp');
        $srch->doNotCalculateRecords();
        $srch->addMultipleFields(array('opcp.*', 'cp.cp_type'));
        $srch->addCondition('opcp_op_id', '=', $opId);
        $checklistPointRecords = FatApp::getDb()->fetchALL($srch->getResultSet());

        return $checklistPointRecords;
    }

}
