<?php

trait SingleCatalogFormHelper
{
    public function setupSizeChart()
    {
        //$this->objPrivilege->canEditProducts(); //@todo
        $post = FatApp::getPostedData();
        if (empty($post)) {
            Message::addErrorMessage(Labels::getLabel('LBL_Invalid_Request_Or_File_not_supported', $langId));
            FatUtility::dieJsonError(Message::getHtml());
        }
		
		$productId = $recordId = FatUtility::int($post['product_id']);
        $tempProductId = FatUtility::int($post['temp_record_id']);
		$langId = FatUtility::int($post['lang_id']);
		
		if ($_FILES['file']['size'] > 10240000) {
			Message::addErrorMessage(Labels::getLabel('MSG_Please_upload_file_size_less_than_10MB', $langId));
			FatUtility::dieJsonError(Message::getHtml());
		}
		
		if (1 > $productId) {
            $recordId = $tempProductId;
        }
		
		if (1 > $productId) {
			$fileHandlerObj = new AttachedFileTemp();
			$tempRecord = applicationConstants::YES;
		} else {
			$fileHandlerObj = new AttachedFile();
			$tempRecord = applicationConstants::NO;
		}
		
		/* [  DELETE OLD SIZE CHART */
        $productSizeChart = $fileHandlerObj::getMultipleAttachments(AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, 0, $langId, false, 0, 0, true);
		
        if (!empty($productSizeChart)) {
			
            foreach ($productSizeChart as $fileData) {
				if (1 > $productId) {
					if (!$fileHandlerObj->deleteTempFile(AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, 0, $langId)) {
						Message::addErrorMessage($fileHandlerObj->getError());
						FatUtility::dieJsonError(Message::getHtml());
					}
				} else {
					if (!$fileHandlerObj->deleteFile(AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, $fileData['afile_id'])) {
						Message::addErrorMessage($fileHandlerObj->getError());
						FatUtility::dieJsonError(Message::getHtml());
					}
				}
            }
        }
        /* ] */
		if(!empty($post['auto_update_other_langs_data_prod_size_chart']) && $post['auto_update_other_langs_data_prod_size_chart'] == 'true' ){
			if (!$res = $fileHandlerObj->saveAttachment($_FILES['file']['tmp_name'], AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, 0, $_FILES['file']['name'], -1,true, 0,0,0,false,false)) {
				Message::addErrorMessage($fileHandlerObj->getError());
				FatUtility::dieJsonError(Message::getHtml());
			}
			
			foreach(Language::getAllNames() as $lang_id => $lang_name){
				$afileObj = new AttachedFile();
				$moved = $afileObj->moveAttachment($res, AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, 0,  $lang_id.$_FILES['file']['name'], -1, true, $lang_id,0);
			}
		}else{
			if (!$res = $fileHandlerObj->saveAttachment($_FILES['file']['tmp_name'], AttachedFile::FILETYPE_PRODUCT_SIZE_CHART, $recordId, 0, $_FILES['file']['name'], -1, false, $langId)) {
				Message::addErrorMessage($fileHandlerObj->getError());
				FatUtility::dieJsonError(Message::getHtml());
			}
		}
		
		if (1 > $productId) {
			$sizeCharImgUrl = UrlHelper::generateUrl('Image', 'attachment', [$fileHandlerObj->getMainTableRecordId(), $tempRecord], CONF_WEBROOT_FRONTEND);
		} else {
			$sizeCharImgUrl = CommonHelper::generateUrl('image', 'productSizeChart', array($recordId, "THUMB", $fileHandlerObj->getMainTableRecordId()), CONF_WEBROOT_FRONTEND);
		}
		
		$tpl = new FatTemplate('', '');
		$tpl->set('afileRecordId', $recordId);
		$tpl->set('afileId', $fileHandlerObj->getMainTableRecordId());
		$tpl->set('langId', $langId);
		$tpl->set('imgUrl', $sizeCharImgUrl);
		$sizeChartLayout = $tpl->render(false, false, 'seller/single-catalog-form/size-chart.php', true, true);
		
		$retFileTag = '<img class="img-thumbnail image-small" src="' . UrlHelper::generateUrl('Image', 'attachment', [$fileHandlerObj->getMainTableRecordId(), $tempRecord], '/') . '" style="height:100px">';
		
		$sizeChartTempId = 0;
		if($tempRecord) {
			$sizeChartTempId = $fileHandlerObj->getMainTableRecordId();
		}
		
        $this->set("size_chart_temp_id", $sizeChartTempId);
        $this->set("retFileTag", $sizeChartLayout);
        $this->set("msg", Labels::getLabel('MSG_FILE_UPLOADED_SUCCESSFULLY', $langId));
        $this->_template->render(false, false, 'json-success.php', true, false);
		
    }
	
	public function moveTempFiles($productId, $criteria = [], $newFileType = '', $subRecordId = '', $updateForGlobalLang = false) 
	{
        if(empty($criteria)) {
			return true;
		}
		
        $tempFiles = AttachedFileTemp::getTempImagesWithCriteria($criteria);
	
        if (!empty($tempFiles)) {
            foreach ($tempFiles as $tempFile) {
				
				/*$whr = ['smt' => 'afile_record_id = ? AND afile_type = ?', 'vals' => array($productId, $tempFile['afile_type'])];
				FatApp::getDb()->deleteRecords(AttachedFile::DB_TBL, $whr);*/
				
				$afileId = $tempFile['afile_id'];	
                unset($tempFile['afile_id']);
                $tempFile['afile_record_id'] = $productId;
                $tempFile['afile_updated_at'] = date('Y-m-d H:i:s');
				if($newFileType != '') {
					$tempFile['afile_type'] = $newFileType;
				}
				
				if($subRecordId != '') {
					$tempFile['afile_record_subid'] = $subRecordId;
				}
				
                $fileHandler = new AttachedFile();
                $fileHandler->assignValues($tempFile);
                if (!$fileHandler->save()) {
                    Message::addErrorMessage($fileHandler->getError());
                    return false;
                }
				
				if($updateForGlobalLang == true) {
					$tempFile['afile_lang_id'] = 0;
					$fileHandler->assignValues($tempFile);
					if (!$fileHandler->save()) {
						Message::addErrorMessage($fileHandler->getError());
						return false;
					}
				}

                $whr = ['smt' => 'afile_id = ?', 'vals' => array($afileId)];
                FatApp::getDb()->deleteRecords(AttachedFileTemp::DB_TBL, $whr);
            }
        }
    }

}
