<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="footer-drop dropdown dropdown--arrow" id="HDR-SETTING">
    <button class="footer-drop-trigger dropdown-toggle" data-bs-toggle="dropdown" data-bs-auto-close="outside"
        aria-expanded="false">
        <span>
            <?php if ($languages[$siteLangId]['language_country_code']) {
                echo $languages[$siteLangId]['language_country_code']
                    ?>
            <?php } else { ?>
            <svg class="svg" width="16" height="16">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#lang"></use>
            </svg>
            <?php } ?> |
            <?php echo $currencies[$siteCurrencyId]; ?>
        </span>
    </button>
    <div class="footer-drop-target dropdown-menu dropdown-menu-fit dropdown-menu-anim dropdown-menu-right">
        <?php ?>
        <div class="setting-group">
            <h6>
                <?php echo Labels::getLabel('LBL_Language', $siteLangId); ?>
            </h6>
            <ul class="list-vertical">
                <?php foreach ($languages as $langId => $language) { ?>
                <li class="<?php echo ($siteLangId == $langId) ? ' is-active' : ''; ?>">
                    <button type="button" class="" onClick="setSiteDefaultLang(<?php echo $langId; ?>)">
                        <?php if ($language['language_country_code']) { ?>

                        <img class="icon-img" width="16" height="16"
                            alt="<?php echo Labels::getLabel('LBL_Language_Flag', $siteLangId); ?>"
                            src="<?php echo CONF_WEBROOT_URL; ?>images/flags/<?php echo FatApp::getConfig('CONF_COUNTRY_FLAG_TYPE', FatUtility::VAR_STRING, 'round'); ?>/<?php echo $language['language_country_code']; ?>.svg">

                        <?php } ?>
                        <?php echo ' ' . $language['language_name']; ?>
                    </button>
                </li>
                <?php } ?>
            </ul>
        </div>
        <div class="setting-group">
            <h6>
                <?php echo Labels::getLabel('LBL_Currency', $siteLangId); ?>
            </h6>
            <ul class="list-vertical">
                <?php foreach ($currencies as $currencyId => $currency) { ?>
                <li class="list-vertical-item <?php echo ($siteCurrencyId == $currencyId) ? ' is-active' : ''; ?>">
                    <button type="button" onClick="setSiteDefaultCurrency(<?php echo $currencyId; ?>)">
                        <?php echo $currency; ?>
                    </button>
                </li>
                <?php } ?>
            </ul>
        </div>
    </div>
</div>