<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<section class="collection-hero">
    <div class="hero-slider js--hero-slider" dir="<?php echo CommonHelper::getLayoutDirection(); ?>">
        <?php
        $uploadPath = UrlHelper::generateFullFileUrl() . CONF_UPLOADS_FOLDER_NAME . '/' . AttachedFile::FILETYPE_HOME_PAGE_BANNER_PATH;
        $attachmentArr = isset($slides['slidesImages']) ? $slides['slidesImages'] : [];
        unset($slides['slidesImages']);
        foreach ($slides as $slide) {
            $desktop_url = '';
            $tablet_url = '';
            $mobile_url = '';
            $haveUrl = ($slide['slide_url'] != '') ? true : false;
            $altImg = ($slide['slide_title'] != '') ? $slide['slide_title'] : '';
            $defaultUrl = '';
            $slideArr = (isset($attachmentArr[$slide['slide_id']])) ? $attachmentArr[$slide['slide_id']] : [];
            if (!$slideArr) {
                continue;
            } else {
                foreach ($slideArr as $slideScreen) {
                    /* $uploadedTime = AttachedFile::setTimeParam($slideScreen['afile_updated_at']); */
                    switch ($slideScreen['afile_screen']) {
                        case applicationConstants::SCREEN_MOBILE:
                            $mobile_url = $uploadPath . $slideScreen['afile_physical_path'];
                            break;
                        case applicationConstants::SCREEN_IPAD:
                            $tablet_url = $uploadPath . $slideScreen['afile_physical_path'];
                            break;
                        case applicationConstants::SCREEN_DESKTOP:
                            $defaultUrl = $uploadPath . $slideScreen['afile_physical_path'];

                            $desktop_url = $defaultUrl . ",";
                            break;
                    }
                }
            }

            if ($defaultUrl == '') {
                $defaultUrl = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'slide', array($slide['slide_id'], applicationConstants::SCREEN_DESKTOP, $siteLangId, 'DESKTOP')), CONF_IMG_CACHE_TIME, '.jpg');
            }


            if ($haveUrl) {
                if ($slide['promotion_id'] > 0) {
                    $slideUrl = UrlHelper::generateUrl('slides', 'track', array($slide['slide_id']));
                } else {
                    $slideUrl = CommonHelper::processUrlString($slide['slide_url']);
                }
            }

            $out = "";
            if ($haveUrl) {
                $out = '<a  aria-label="" target="' . $slide['slide_target'] . '" href="' . $slideUrl . '">';
            }

            $out .= '<div class="hero-slider-item" aria-label="">';
            $out .= '<picture class="hero-slider-media">';
			if(rtrim($mobile_url, ',') != '') {
				$out .= '<source  srcset="' . rtrim($mobile_url, ',') . '" media="(max-width: 767px)">';
			}
			
			if(rtrim($tablet_url, ',') != '') {
				$out .= '<source  srcset="' . rtrim($tablet_url, ',') . '" media="(max-width: 1024px)">';
			}
			$out .= '<source data-aspect-ratio="2:1" srcset="' . rtrim($desktop_url, ',') . '">
					<img data-aspect-ratio="2:1" src="' . rtrim($desktop_url, ',') . '" alt="' . trim($altImg) . '">
				</picture>
			 ';

            $out .= '</div>';

            if ($haveUrl) {
                $out .= '</a>';
            }

            echo $out;
            if (isset($slide['promotion_id']) && $slide['promotion_id'] > 0) {
                Promotion::updateImpressionData($slide['promotion_id']);
            }
        }
        ?>
    </div>
    <div class="site-search">
        <?php
        $searchForm->setFormTagAttribute('onSubmit', 'submitSiteSearch(this, 12); return(false);');
		$searchForm->setFormTagAttribute('id', 'frm_fat_id_frmSiteSearch_slider');
        $keywordFld = $searchForm->getField('keyword');
        $keywordFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Keyword_Search', $siteLangId));
        $keywordFld->addFieldTagAttribute('autofocus', 'autofocus');

        $geoAddress = '';
        if ((!isset($_COOKIE['_ykGeoLat']) || !isset($_COOKIE['_ykGeoLng']) || !isset($_COOKIE['_ykGeoCountryCode'])) && FatApp::getConfig('CONF_DEFAULT_GEO_LOCATION', FatUtility::VAR_INT, 0)) {
            $geoAddress = FatApp::getConfig('CONF_GEO_DEFAULT_ADDR', FatUtility::VAR_STRING, '');
            if (empty($address)) {
                $address = FatApp::getConfig('CONF_GEO_DEFAULT_ZIPCODE', FatUtility::VAR_INT, 0) . '-' . FatApp::getConfig('CONF_GEO_DEFAULT_STATE', FatUtility::VAR_STRING, '');
            }
        }

        $locFld = $searchForm->getField('location');
        $locFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Location_Search', $siteLangId));
        $locFld->addFieldTagAttribute('id', 'ga-autoComplete-header-2');
        $locFld->setFieldTagAttribute('class', 'location-selected');
        $locFld->setFieldTagAttribute('onKeyup', "googleAddressAutocomplete('ga-autoComplete-header-2', 'formatted_address', true, 'googleSelectedAddress', 0)");
        $locFld->value = isset($_COOKIE["_ykGeoAddress"]) ? $_COOKIE["_ykGeoAddress"] : $geoAddress;

        $locFld = $searchForm->getField('rentaldates');
        $locFld->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Add_Dates', $siteLangId));
        $locFld->addFieldTagAttribute('data-section', 'slider-search-section');
        ?>
        <?php echo $searchForm->getFormTag(); ?>
        <div class="site-search-form site-search-form-home">
            <ul>
                <li class="site-search-form-item keyword">
                    <svg class="svg" width="16" height="16">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#magnifier">
                        </use>
                    </svg>
                    <div class="form-group">
                        <label class="form-label">
                            <?php echo $searchForm->getField('keyword')->getCaption(); ?>
                        </label>
                        <?php echo $searchForm->getFieldHtml('keyword'); ?>
                    </div>

                </li>
                <?php if (!CommonHelper::isDistanceShippingEnabled()) { ?>
                <li class="site-search-form-item location">
                    <svg class="svg" width="16" height="16">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#location">
                        </use>
                    </svg>

                    <div class="form-group">
                        <label class="form-label">
                            <?php echo $searchForm->getField('location')->getCaption(); ?>
                        </label>
                        <?php echo $searchForm->getFieldHtml('location'); ?>
                    </div>
                </li>
                <?php } ?>
                <li class="site-search-form-item date-selector">
                    <svg class="svg" width="16" height="16">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#date">
                        </use>
                    </svg>

                    <div class="form-group date-selector slider-search-section">
                        <label class="form-label">
                            <?php echo $searchForm->getField('rentaldates')->getCaption(); ?>
                        </label>
                        <?php echo $searchForm->getFieldHtml('rentaldates'); ?>
                        <?php echo $searchForm->getFieldHtml('rentalstart'); ?>
                        <?php echo $searchForm->getFieldHtml('rentalend'); ?>

                    </div>
                </li>
                <li class="site-search-form-item submit">
                    <div class="form-group">
                        <?php echo $searchForm->getFieldHtml('searchButton'); ?>
                    </div>
                </li>
            </ul>
        </div>
        </form>
    </div>
</section>

<script>
$('.js--hero-slider').slick({
    rtl: ('rtl' == langLbl.layoutDirection),
    autoplay: true,
    autoplaySpeed: 8000,
    draggable: true,
    arrows: true,
    dots: true,
    fade: true,
    speed: 900,
    infinite: true,
    cssEase: 'cubic-bezier(0.7, 0, 0.3, 1)',
    touchThreshold: 100,
    prevArrow: '<button class="slick-prev slick-arrow"><svg viewBox="0 0 13.476 25.939" id="icon-chevron"><path d="M.525,0,0,.526,12.462,12.988,0,25.45l.525.49L13.476,12.988Z" transform="translate(0 -.001)"></path></svg></button>',
    nextArrow: '<button class="slick-next slick-arrow"><svg viewBox="0 0 13.476 25.939" id="icon-chevron"> <path d = "M.525,0,0,.526,12.462,12.988,0,25.45l.525.49L13.476,12.988Z"       transform = "translate(0 -.001)" > < /path> </svg> </button >',
    responsive: [{
            breakpoint: 1024,
            settings: {
                arrows: true,
                slidesToScroll: 3,
                infinite: true,
                dots: true
            }
        },
        {
            breakpoint: 600,
            settings: {
                arrows: false,
                slidesToScroll: 2
            }
        },
        {
            breakpoint: 480,
            settings: {
                arrows: false,
                slidesToScroll: 1
            }
        }

    ]
});
</script>