<?php
$controller = strtolower($controller);
$action = strtolower($action);
?>
<ul class="dashboard-menu">
    <?php if (User::canViewAdvertiserTab() && $userPrivilege->canViewPromotions(0, true)) { ?>

        <li class="dashboard-menu-item">
            <?php
            $isControllerActive = in_array($controller, [
                'advertiser',
                'account',
            ]);
            $isActionActive = in_array($action, [
                'promotions',
                'viewpromotions',
                'promotioncharges',
                'credits'
            ]);
            ?>
            <button
                class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
                type="button" data-bs-toggle="collapse" data-bs-target="#Promotions"
                aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
                aria-controls="collapseOne" title="">
                <span class="dashboard-menu-icon">
                    <svg class="svg" width="18" height="18">
                        <use
                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#promotion">
                        </use>
                    </svg>
                </span>
                <span class="dashboard-menu-head">
                    <?php echo Labels::getLabel("LBL_Promotions", $siteLangId); ?>
                </span>
                <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
            </button>

            <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
                id="Promotions" aria-labelledby="" data-parent="#dashboard-menu">
                <li
                    class="menu-sub-item  <?php echo ($controller == 'advertiser' && ($action == 'promotions' || $action == 'viewpromotions')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_My_Promotions", $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('advertiser', 'promotions'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-promotions">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel("LBL_My_Promotions", $siteLangId); ?></span></a>
                </li>
                <li
                    class="menu-sub-item  <?php echo ($controller == 'advertiser' && ($action == 'promotioncharges' || $action == 'viewpromotions')) ? 'is-active' : ''; ?>">
                    <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_Promotion_Charges", $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('advertiser', 'promotionCharges'); ?>">
                        <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#promotion-charges">
                                </use>
                            </svg>
                        </span><span
                            class="menu-sub-head"><?php echo Labels::getLabel("LBL_Promotion_Charges", $siteLangId); ?></span></a>
                </li>
                <?php if ($userParentId == UserAuthentication::getLoggedUserId()) { ?>
                    <li
                        class="menu-sub-item <?php echo ($controller == 'account' && $action == 'credits') ? 'is-active' : ''; ?>">
                        <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_My_Credits", $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>"><span class="menu-sub-icon"><svg
                                    class="svg" width="16" height="16">
                                    <use
                                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-credits">
                                    </use>
                                </svg>
                            </span><span
                                class="menu-sub-head"><?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?></span></a>
                    </li>
                <?php } ?>
            </ul>
        </li>
    <?php } ?>


    <li class="dashboard-menu-item">
        <?php
        $isControllerActive = in_array($controller, [
            'account',
        ]);
        $isActionActive = in_array($action, [
            'profileinfo',
            'changeemailpassword'
        ]);
        ?>
        <button
            class="dashboard-menu-btn dropdown-toggle-custom <?php echo ($isControllerActive && $isActionActive ? '' : 'collapsed'); ?>"
            type="button" data-bs-toggle="collapse" data-bs-target="#Profile"
            aria-expanded="<?php echo ($isControllerActive && $isActionActive ? 'true' : 'false'); ?>"
            aria-controls="collapseOne" title="">
            <span class="dashboard-menu-icon">
                <svg class="svg" width="18" height="18">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite-sidebar.svg#profile">
                    </use>
                </svg>
            </span>
            <span class="dashboard-menu-head">
                <?php echo Labels::getLabel("LBL_Profile", $siteLangId); ?>
            </span>
            <i class="dashboard-menu-arrow dropdown-toggle-custom-arrow"></i>
        </button>
        <ul class="menu-sub menu-sub-accordion collapse <?php echo ($isControllerActive && $isActionActive ? 'show' : ''); ?>"
            id="Profile" aria-labelledby="" data-parent="#dashboard-menu">
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'profileinfo') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'ProfileInfo'); ?>">
                    <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-account">
                            </use>
                        </svg>
                    </span><span
                        class="menu-sub-head"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></span></a>
            </li>
            <li
                class="menu-sub-item <?php echo ($controller == 'account' && $action == 'changeemailpassword') ? 'is-active' : ''; ?>">
                <a class="menu-sub-link" title="<?php echo Labels::getLabel("LBL_UPDATE_CREDENTIALS", $siteLangId); ?>"
                    href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                    <span class="menu-sub-icon"><svg class="svg" width="16" height="16">
                            <use
                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#update-credentials">
                            </use>
                        </svg>
                    </span><span
                        class="menu-sub-head"><?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?></span></a>
            </li>
        </ul>
    </li>
    <?php $this->includeTemplate('_partial/dashboardLanguageArea.php'); ?>
</ul>