<?php
$controller = strtolower($controller);
$action = strtolower($action);
?>
<sidebar class="sidebar no-print" id="sidebar">

    <div class="sidebar-body">
        <ul class="dashboard-menu">
            <?php if (User::canViewAffiliateTab()) { ?>
                <li class="dashboard-menu-item <?php echo ($controller == 'affiliate' && $action == 'referredbyme') ? 'is-active' : ''; ?>">
                    <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_Sharing", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Affiliate', 'ReferredByMe'); ?>">
                            <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#dash-reffered"></use>
                                </svg>
                            </span><span class="dashboard-menu-head"><?php echo Labels::getLabel("LBL_My_Referral", $siteLangId); ?></span></a></div>
                </li> <?php
                    } ?>
            <li class="dashboard-menu-item <?php echo ($controller == 'account' && $action == 'profileinfo') ? 'is-active' : ''; ?>">
                <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'ProfileInfo'); ?>">
                        <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-account"></use>
                            </svg>
                        </span><span class="dashboard-menu-head"><?php echo Labels::getLabel("LBL_My_Account", $siteLangId); ?></span></a></div>
            </li> <?php if (!User::canViewAffiliateTab()) {
                    ?> <li class="dashboard-menu-item <?php echo ($controller == 'account' && $action == 'messages') ? 'is-active' : ''; ?>">
                    <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'Messages'); ?>">
                            <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#messages"></use>
                                </svg>
                            </span><span class="dashboard-menu-head"><?php echo Labels::getLabel("LBL_Messages", $siteLangId); ?></span></a></div>
                </li> <?php
                    } ?> <li class="dashboard-menu-item <?php echo ($controller == 'account' && $action == 'credits') ? 'is-active' : ''; ?>">
                <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_My_Credits", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'credits'); ?>">
                        <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#my-credits"></use>
                            </svg>
                        </span><span class="dashboard-menu-head"><?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?></span></a></div>
            </li> <?php if (!User::canViewAffiliateTab()) {
                    ?> <li class="dashboard-menu-item <?php echo ($controller == 'account' && $action == 'wishlist') ? 'is-active' : ''; ?>">
                    <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel("LBL_Wishlist/Favorites", $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'wishlist'); ?>">
                            <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#favorite"></use>
                                </svg>
                            </span><span class="dashboard-menu-head"><?php echo Labels::getLabel('LBL_Wishlist/Favorites', $siteLangId); ?></span></a></div>
                </li> <?php
                    } ?>
            <li class="dashboard-menu-item <?php echo ($controller == 'account' && $action == 'changeemailpassword') ? 'is-active' : ''; ?>">
                <div class="dashboard-menu-item__inner"><a class="dashboard-menu-btn" title="<?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                        <span class="dashboard-menu-icon shop"><svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sidebar.svg#update-credentials"></use>
                            </svg>
                        </span><span class="dashboard-menu-head"><?php echo Labels::getLabel('LBL_UPDATE_CREDENTIALS', $siteLangId); ?></span></a></div>
            </li>
            <?php $this->includeTemplate('_partial/dashboardLanguageArea.php'); ?>
        </ul>

    </div>

</sidebar>