<?php if (isset($collection['shops']) && count($collection['shops']) > 0) { ?>
    <section class="section collection-shop" data-collection="collection-sponsored-shop"
        id="shop_layout2_<?php echo $collection['collection_id']; ?>">
        <div class="container container-narrow">
            <div class="section-head section-head-center">
                <div class="section-heading">
                    <h5>
                        <?php echo $collection['collection_description'] ?>
                    </h5>
                    <h2>
                        <?php echo $collection['collection_name'] ?>
                    </h2>
                </div>
            </div>

            <div class="js-carousel <?php echo (count($collection['shops'])) > 3 ? " js-carousel" : ""; ?> "
                data-slides="4,3,3,2,2" dir="<?php echo CommonHelper::getLayoutDirection(); ?>" data-infinite="false"
                data-arrows="false" data-slickdots="true">
                <?php foreach ($collection['shops'] as $shop) { ?>
                    <div class="js-carousel-item">
                        <div class="shop">
                            <div class="shop-card">
                                <div class="shop-card-body">
                                    <a class="shop-card-media"
                                        href="<?php echo (!isset($shop['shopData']['promotion_id']) ? UrlHelper::generateUrl('shops', 'view', array($shop['shopData']['shop_id'])) : UrlHelper::generateUrl('shops', 'track', array($shop['shopData']['promotion_record_id'], Promotion::REDIRECT_SHOP, $shop['shopData']['promotion_record_id']))); ?>">
                                        <picture >
                                            <source type="image/webp"
                                                srcset="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'shopLogo', array($shop['shopData']['shop_id'], $siteLangId, "SHOP_LAYOUT_2", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                                            <img alt="<?php echo $shop['shopData']['shop_name']; ?>" data-aspect-ratio="1:1"
                                                src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'shopLogo', array($shop['shopData']['shop_id'], $siteLangId, "SHOP_LAYOUT_2", 0, false), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg'); ?>">
                                        </picture>
                                    </a>

                                </div>
                                <div class="shop-card-foot">
                                    <div class="shop-description">
                                        <a class="shop-name"
                                            href="<?php echo (!isset($shop['shopData']['promotion_id']) ? UrlHelper::generateUrl('shops', 'view', array($shop['shopData']['shop_id'])) : UrlHelper::generateUrl('shops', 'track', array($shop['shopData']['promotion_record_id'], Promotion::REDIRECT_SHOP, $shop['shopData']['promotion_record_id']))); ?>">
                                            <?php echo $shop['shopData']['shop_name']; ?>
                                        </a>
                                        <p class="shop-location">
                                            <svg class="svg" width="16" height="16">
                                                <use
                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite.svg#collection-location">
                                                </use>
                                            </svg>
                                            <span>
                                                <?php echo $shop['shopData']['state_name']; ?>
                                                <?php echo ($shop['shopData']['country_name'] && $shop['shopData']['state_name']) ? ', ' : ''; ?>
                                                <?php echo $shop['shopData']['country_name']; ?>
                                            </span>
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php } ?>
            </div>

        </div>
    </section>
    <?php
}
/* ] */