<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
if (!$isUserLogged) {
    if (UserAuthentication::isGuestUserLogged()) {
        ?>
        <button class="quick-nav-links dropdown-toggle no-after  btn-link  btn-sm btn header-actions-link"
            title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
            data-bs-auto-close="outside" aria-expanded="false">
            <svg class="svg" width="20" height="20">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/fashion/retina/sprite-header.svg#account">
                </use>
            </svg>
        </button>
        <ul class="dropdown-menu dropdown-menu-anim dropdown-menu-end dropdown-menu-account">
            <?php $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?>

            <li class="dropdown-menu-item">
                <div class="profile profile-account">
                    <div class="profile-image">
                        <img class="profile-avatar" width="40" height="40" src="<?php echo $profilePicUrl ?>" alt="">
                    </div>
                    <div class="profile-data">
                        <h6 class="profile-name"><?php echo $userName ?></h6>
                        <p class="profile-email"><?php echo $userEmail ?></p>
                    </div>
                </div>
            </li>
            <li class="dropdown-menu-item">
                <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('account', 'profileInfo'); ?>">
                    <?php echo Labels::getLabel('LBL_Hi,', $siteLangId) . ' ' . $userName; ?>
                </a>
            </li>

            <li class="dropdown-menu-item logout">
                <a class="dropdown-menu-link"
                    data-org-url="<?php echo UrlHelper::generateUrl('GuestUser', 'logout', array(), '', null, false, $getOrgUrl); ?>"
                    href="<?php echo UrlHelper::generateUrl('GuestUser', 'logout'); ?>">
                    <?php echo Labels::getLabel('LBL_Logout', $siteLangId); ?>
                </a>
            </li>
        </ul>


    <?php } else { ?>
        <button class="quick-nav-links sign-in sign-in-popup-js"
            title="<?php echo Labels::getLabel('LBL_Login', $siteLangId); ?>">
            <svg class="svg" width="16" height="16">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#account">
                </use>
            </svg>
            <span class="d-none"><?php echo Labels::getLabel('LBL_Login_/_Sign_Up', $siteLangId); ?></span>
        </button>
    <?php }
} else {
    $userActiveTab = false;
    $activeTab = '';
    if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
        $userActiveTab = true;
        $activeTab = 'S';
        $dashboardUrl = UrlHelper::generateUrl('Seller');
        $dashboardOrgUrl = UrlHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
        $userActiveTab = true;
        $activeTab = 'B';
        $dashboardUrl = UrlHelper::generateUrl('Buyer');
        $dashboardOrgUrl = UrlHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
        $userActiveTab = true;
        $activeTab = 'Ad';
        $dashboardUrl = UrlHelper::generateUrl('Advertiser');
        $dashboardOrgUrl = UrlHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAffiliateTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'AFFILIATE')) {
        $userActiveTab = true;
        $activeTab = 'AFFILIATE';
        $dashboardUrl = UrlHelper::generateUrl('Affiliate');
        $dashboardOrgUrl = UrlHelper::generateUrl('Affiliate', '', array(), '', null, false, $getOrgUrl);
    }
    if (!$userActiveTab) {
        $dashboardUrl = UrlHelper::generateUrl('Account');
        $dashboardOrgUrl = UrlHelper::generateUrl('Account', '', array(), '', null, false, $getOrgUrl);
    }
    ?>


    <?php if (isset($isUserDashboard) && ($isUserDashboard)) { ?>
        <button class="header-actions-link dropdown-toggle no-after"
            title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
            data-bs-auto-close="outside">
            <svg class="svg" width="20" height="20">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/fashion/retina/sprite-header.svg#account">
                </use>
            </svg>
        </button>
    <?php } else { ?>
        <button class="quick-nav-links dropdown-toggle no-after"
            title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
            data-bs-auto-close="outside" aria-expanded="false">
            <svg class="svg" width="20" height="20">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/fashion/retina/sprite-header.svg#account">
                </use>
            </svg>
            <span
                class="quick-nav-txt d-none hide-sm"><?php echo Labels::getLabel('LBL_Hi,', $siteLangId) . ' ' . User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?></span>
        </button>
    <?php } ?>
    <ul class="dropdown-menu dropdown-menu-anim dropdown-menu-end dropdown-menu-account">
        <?php
        $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name");
        ?>
        <li class="dropdown-menu-item">
            <div class="profile profile-account">
                <div class="profile-image">
                    <img class="profile-avatar" width="40" height="40" src="<?php echo $profilePicUrl ?>" alt="">
                </div>
                <div class="profile-data">
                    <h6 class="profile-name"><?php echo $userName ?></h6>
                    <p class="profile-email"><?php echo $userEmail ?></p>
                </div>
            </div>
        </li>

        <li class="dropdown-menu-item">
            <a class="dropdown-menu-link" data-org-url="<?php echo $dashboardOrgUrl; ?>"
                href="<?php echo $dashboardUrl; ?>">
                <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor">
                    <path
                        d="M14 21C13.4477 21 13 20.5523 13 20V12C13 11.4477 13.4477 11 14 11H20C20.5523 11 21 11.4477 21 12V20C21 20.5523 20.5523 21 20 21H14ZM4 13C3.44772 13 3 12.5523 3 12V4C3 3.44772 3.44772 3 4 3H10C10.5523 3 11 3.44772 11 4V12C11 12.5523 10.5523 13 10 13H4ZM9 11V5H5V11H9ZM4 21C3.44772 21 3 20.5523 3 20V16C3 15.4477 3.44772 15 4 15H10C10.5523 15 11 15.4477 11 16V20C11 20.5523 10.5523 21 10 21H4ZM5 19H9V17H5V19ZM15 19H19V13H15V19ZM13 4C13 3.44772 13.4477 3 14 3H20C20.5523 3 21 3.44772 21 4V8C21 8.55228 20.5523 9 20 9H14C13.4477 9 13 8.55228 13 8V4ZM15 5V7H19V5H15Z">
                    </path>
                </svg>
                <?php echo Labels::getLabel("LBL_Dashboard", $siteLangId); ?></a>
        </li>

        <li class="dropdown-menu-item">
            <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('', '', [], CONF_WEBROOT_FRONT_URL); ?>">
                <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor">
                    <path
                        d="M19 21H5C4.44772 21 4 20.5523 4 20V11L1 11L11.3273 1.6115C11.7087 1.26475 12.2913 1.26475 12.6727 1.6115L23 11L20 11V20C20 20.5523 19.5523 21 19 21ZM13 19H18V9.15745L12 3.7029L6 9.15745V19H11V13H13V19Z">
                    </path>
                </svg> <?php echo Labels::getLabel("LBL_HOME", $siteLangId); ?>
            </a>
        </li>
        <?php if ($isShopActive && $shop_id > 0 && $activeTab == 'S') { ?>
            <li class="dropdown-menu-item">
                <a class="dropdown-menu-link"
                    href="<?php echo UrlHelper::generateUrl('Shops', 'view', array($shop_id), CONF_WEBROOT_FRONT_URL); ?>">
                    <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                        fill="currentColor">
                        <path
                            d="M21 13.2422V20H22V22H2V20H3V13.2422C1.79401 12.435 1 11.0602 1 9.5C1 8.67286 1.22443 7.87621 1.63322 7.19746L4.3453 2.5C4.52393 2.1906 4.85406 2 5.21132 2H18.7887C19.1459 2 19.4761 2.1906 19.6547 2.5L22.3575 7.18172C22.7756 7.87621 23 8.67286 23 9.5C23 11.0602 22.206 12.435 21 13.2422ZM19 13.9725C18.8358 13.9907 18.669 14 18.5 14C17.2409 14 16.0789 13.478 15.25 12.6132C14.4211 13.478 13.2591 14 12 14C10.7409 14 9.5789 13.478 8.75 12.6132C7.9211 13.478 6.75911 14 5.5 14C5.331 14 5.16417 13.9907 5 13.9725V20H19V13.9725ZM5.78865 4L3.35598 8.21321C3.12409 8.59843 3 9.0389 3 9.5C3 10.8807 4.11929 12 5.5 12C6.53096 12 7.44467 11.3703 7.82179 10.4295C8.1574 9.59223 9.3426 9.59223 9.67821 10.4295C10.0553 11.3703 10.969 12 12 12C13.031 12 13.9447 11.3703 14.3218 10.4295C14.6574 9.59223 15.8426 9.59223 16.1782 10.4295C16.5553 11.3703 17.469 12 18.5 12C19.8807 12 21 10.8807 21 9.5C21 9.0389 20.8759 8.59843 20.6347 8.19746L18.2113 4H5.78865Z">
                        </path>
                    </svg> <?php echo Labels::getLabel("LBL_SHOP", $siteLangId); ?>
                </a>
            </li>
        <?php } ?>
        <li class="dropdown-menu-item">
            <a class="dropdown-menu-link"
                href="<?php echo UrlHelper::generateUrl('account', 'profileInfo', [], CONF_WEBROOT_FRONT_URL); ?>">
                <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor">
                    <path
                        d="M20 22H18V20C18 18.3431 16.6569 17 15 17H9C7.34315 17 6 18.3431 6 20V22H4V20C4 17.2386 6.23858 15 9 15H15C17.7614 15 20 17.2386 20 20V22ZM12 13C8.68629 13 6 10.3137 6 7C6 3.68629 8.68629 1 12 1C15.3137 1 18 3.68629 18 7C18 10.3137 15.3137 13 12 13ZM12 11C14.2091 11 16 9.20914 16 7C16 4.79086 14.2091 3 12 3C9.79086 3 8 4.79086 8 7C8 9.20914 9.79086 11 12 11Z">
                    </path>
                </svg>
                <?php echo Labels::getLabel("LBL_PROFILE", $siteLangId); ?>
            </a>
        </li>
        <li class="dropdown-menu-item">
            <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor">
                    <path
                        d="M7 10H20C20.5523 10 21 10.4477 21 11V21C21 21.5523 20.5523 22 20 22H4C3.44772 22 3 21.5523 3 21V11C3 10.4477 3.44772 10 4 10H5V9C5 5.13401 8.13401 2 12 2C14.7405 2 17.1131 3.5748 18.2624 5.86882L16.4731 6.76344C15.6522 5.12486 13.9575 4 12 4C9.23858 4 7 6.23858 7 9V10ZM5 12V20H19V12H5ZM10 15H14V17H10V15Z">
                    </path>
                </svg> <?php echo Labels::getLabel("LBL_UPDATE_CREDENTIALS", $siteLangId); ?>
            </a>
        </li>
        <li class="dropdown-menu-item logout">
            <a class="dropdown-menu-link"
                data-org-url="<?php echo UrlHelper::generateUrl('GuestUser', 'logout', array(), '', null, false, $getOrgUrl); ?>"
                href="<?php echo UrlHelper::generateUrl('GuestUser', 'logout'); ?>">
                <svg class="svg" width="14" height="14" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"
                    fill="currentColor">
                    <path
                        d="M5 11H13V13H5V16L0 12L5 8V11ZM3.99927 18H6.70835C8.11862 19.2447 9.97111 20 12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C9.97111 4 8.11862 4.75527 6.70835 6H3.99927C5.82368 3.57111 8.72836 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22C8.72836 22 5.82368 20.4289 3.99927 18Z">
                    </path>
                </svg>
                <?php echo Labels::getLabel('LBL_Logout', $siteLangId); ?>
            </a>
        </li>
    </ul>


<?php } ?>