<?php
defined('SYSTEM_INIT') or die('Invalid Usage');
$getOrgUrl = (CONF_DEVELOPMENT_MODE) ? true : false;
if (!$isUserLogged) {
    if (UserAuthentication::isGuestUserLogged()) {
        ?>
        <div class="dropdown">
            <button class="quick-nav-links dropdown-toggle no-after"
                title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
                data-bs-auto-close="outside" aria-expanded="false">
                <span class="icn-txt">
                    <?php echo Labels::getLabel('LBL_Hi,', $siteLangId) . ' ' . User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?>
                </span>
            </button>
            <ul class="dropdown-menu dropdown-menu-anim dropdown-menu-end dropdown-menu-account">
                <?php $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?>

                <li class="dropdown-menu-item">
                    <div class="profile profile-account">
                        <div class="profile-image">
                            <img class="profile-avatar" width="40" height="40" src="<?php echo $profilePicUrl ?>" alt="">
                        </div>
                        <div class="profile-data">
                            <h6 class="profile-name"><?php echo $userName ?></h6>
                            <p class="profile-email"><?php echo $userEmail ?></p>
                        </div>
                    </div>
                </li>
                <li class="dropdown-menu-item">
                    <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('account', 'profileInfo'); ?>">
                        <?php echo Labels::getLabel('LBL_Hi,', $siteLangId) . ' ' . $userName; ?>
                    </a>
                </li>

                <li class="dropdown-menu-item logout">
                    <a class="dropdown-menu-link"
                        data-org-url="<?php echo UrlHelper::generateUrl('GuestUser', 'logout', array(), '', null, false, $getOrgUrl); ?>"
                        href="<?php echo UrlHelper::generateUrl('GuestUser', 'logout'); ?>">
                        <?php echo Labels::getLabel('LBL_Logout', $siteLangId); ?>
                    </a>
                </li>
            </ul>

        </div>
    <?php } else { ?>
        <button class="quick-nav-links sign-in sign-in-popup-js"
            title="<?php echo Labels::getLabel('LBL_Login', $siteLangId); ?>">
            <svg class="svg" width="16" height="16">
                <use
                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#account">
                </use>
            </svg>
            <span class="d-none"><?php echo Labels::getLabel('LBL_Login_/_Sign_Up', $siteLangId); ?></span>
        </button>
    <?php }
} else {
    $userActiveTab = false;
    $activeTab = '';
    if (User::canViewSupplierTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'S')) {
        $userActiveTab = true;
        $activeTab = 'S';
        $dashboardUrl = UrlHelper::generateUrl('Seller');
        $dashboardOrgUrl = UrlHelper::generateUrl('Seller', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewBuyerTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'B')) {
        $userActiveTab = true;
        $activeTab = 'B';
        $dashboardUrl = UrlHelper::generateUrl('Buyer');
        $dashboardOrgUrl = UrlHelper::generateUrl('Buyer', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAdvertiserTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'Ad')) {
        $userActiveTab = true;
        $activeTab = 'Ad';
        $dashboardUrl = UrlHelper::generateUrl('Advertiser');
        $dashboardOrgUrl = UrlHelper::generateUrl('Advertiser', '', array(), '', null, false, $getOrgUrl);
    } elseif (User::canViewAffiliateTab() && (isset($_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab']) && $_SESSION[UserAuthentication::SESSION_ELEMENT_NAME]['activeTab'] == 'AFFILIATE')) {
        $userActiveTab = true;
        $activeTab = 'AFFILIATE';
        $dashboardUrl = UrlHelper::generateUrl('Affiliate');
        $dashboardOrgUrl = UrlHelper::generateUrl('Affiliate', '', array(), '', null, false, $getOrgUrl);
    }
    if (!$userActiveTab) {
        $dashboardUrl = UrlHelper::generateUrl('Account');
        $dashboardOrgUrl = UrlHelper::generateUrl('Account', '', array(), '', null, false, $getOrgUrl);
    }
    ?>

    <div class="dropdown">
        <?php if (isset($isUserDashboard) && ($isUserDashboard)) { ?>
            <button class="header-actions-link dropdown-toggle no-after"
                title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
                data-bs-auto-close="outside">
                <svg class="svg" width="16" height="16">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/fashion/retina/sprite-header.svg#account">
                    </use>
                </svg>
            </button>
        <?php } else { ?>
            <button class="quick-nav-links dropdown-toggle no-after"
                title="<?php echo Labels::getLabel('LBL_Account', $siteLangId); ?>" data-bs-toggle="dropdown"
                data-bs-auto-close="outside" aria-expanded="false">
                <svg class="svg" width="16" height="16">
                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/fashion/retina/sprite-header.svg#account">
                    </use>
                </svg>
                <span
                    class="quick-nav-txt d-none hide-sm"><?php echo Labels::getLabel('LBL_Hi,', $siteLangId) . ' ' . User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name"); ?></span>
            </button>
        <?php } ?>
        <ul class="dropdown-menu dropdown-menu-anim dropdown-menu-end dropdown-menu-account">
            <?php
            $userName = User::getAttributesById(UserAuthentication::getLoggedUserId(), "user_name");
            ?>
            <li class="dropdown-menu-item">
                <div class="profile profile-account">
                    <div class="profile-image">
                        <img class="profile-avatar" width="40" height="40" src="<?php echo $profilePicUrl ?>" alt="">
                    </div>
                    <div class="profile-data">
                        <h6 class="profile-name"><?php echo $userName ?></h6>
                        <p class="profile-email"><?php echo $userEmail ?></p>
                    </div>
                </div>
            </li>

            <li
                class="dropdown-menu-item <?php if (isset($isUserDashboard) && ($isUserDashboard)) { ?> d-block d-md-none <?php } ?>">
                <a class="dropdown-menu-link" data-org-url="<?php echo $dashboardOrgUrl; ?>"
                    href="<?php echo $dashboardUrl; ?>"><?php echo Labels::getLabel("LBL_Dashboard", $siteLangId); ?></a>
            </li>

            <li class="dropdown-menu-item">
                <a class="dropdown-menu-link"
                    href="<?php echo UrlHelper::generateUrl('', '', [], CONF_WEBROOT_FRONT_URL); ?>">
                    <?php echo Labels::getLabel("LBL_HOME", $siteLangId); ?>
                </a>
            </li>
            <?php if ($isShopActive && $shop_id > 0 && $activeTab == 'S') { ?>
                <li class="dropdown-menu-item">
                    <a class="dropdown-menu-link"
                        href="<?php echo UrlHelper::generateUrl('Shops', 'view', array($shop_id), CONF_WEBROOT_FRONT_URL); ?>">
                        <?php echo Labels::getLabel("LBL_SHOP", $siteLangId); ?>
                    </a>
                </li>
            <?php } ?>
            <li class="dropdown-menu-item">
                <a class="dropdown-menu-link"
                    href="<?php echo UrlHelper::generateUrl('account', 'profileInfo', [], CONF_WEBROOT_FRONT_URL); ?>">
                    <?php echo Labels::getLabel("LBL_PROFILE", $siteLangId); ?>
                </a>
            </li>
            <li class="dropdown-menu-item">
                <a class="dropdown-menu-link"
                    href="<?php echo UrlHelper::generateUrl('Account', 'changeEmailPassword'); ?>">
                    <?php echo Labels::getLabel("LBL_UPDATE_CREDENTIALS", $siteLangId); ?>
                </a>
            </li>
            <li class="dropdown-menu-item logout">
                <a class="dropdown-menu-link"
                    data-org-url="<?php echo UrlHelper::generateUrl('GuestUser', 'logout', array(), '', null, false, $getOrgUrl); ?>"
                    href="<?php echo UrlHelper::generateUrl('GuestUser', 'logout'); ?>"><?php echo Labels::getLabel('LBL_Logout', $siteLangId); ?>
                </a>
            </li>
        </ul>

    </div>
<?php } ?>