<?php /* [ NEW NAVIGATION IMPLEMENTATION */ ?>
<?php if (FatApp::getConfig('CONF_ENABLE_ALL_CATEGORIES_NAVIGATION', FatUtility::VAR_INT, 1) && count($headerCategories)) { ?>
    <!-- [ ALL CATEGORIES NAVIGATION -->
    <li class="navigation-item navchild">
        <button class="navigation-link hamburger-categories"
                aria-label="<?php echo Labels::getLabel('LBL_All_Categories', $siteLangId); ?>">
            <svg class="svg" width="16" height="16">
                <use
                        xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/<?php echo ACTIVE_THEME; ?>/retina/sprite-header.svg#hamburger-menu">
                </use>
            </svg>
            <?php echo Labels::getLabel('LBL_All_Categories', $siteLangId); ?></button>
        <span class="link__mobilenav"></span>
        <div class="subnav">
            <div class="subnav-inner">
                <div class="container categories-container">
                    <div class="navigation-tabs">
                        <ul class="nav navigation-tabs-controls " id="navigation-tabs" role="tablist">
                            <?php
                            $i = 0;
                            foreach ($headerCategories as $pcatid => $pcatval) {
                                if ($i < 8) {
                                    $pCatNavUrl = UrlHelper::generateUrl('category', 'view', array($pcatval['prodcat_id']));
                                    ?>
                                    <li class="navigation-tabs-controls-item" role="presentation">
                                        <a href="<?php echo $pCatNavUrl; ?>" data-bs-toggle="tab-menu"
                                           class="navigation-tabs-controls-link <?php echo ($i == 0) ? "active" : ""; ?>"
                                           data-bs-target="#menu-<?php echo $pcatval['prodcat_id'] ?>" role="tab"
                                           aria-controls="menu-<?php echo $pcatval['prodcat_id'] ?>">
                                            <?php echo $pcatval['prodcat_name']; ?>
                                        </a>
                                    </li>
                                    <?php $i++;
                                }
                            }
                            if ($i >= 8) {
                            ?>
                                    <li class="navigation-tabs-controls-item" role="presentation">
                                        <a href="<?php echo UrlHelper::generateUrl('category'); ?>" data-bs-toggle="tab-menu"
                                            class="navigation-tabs-controls-link"
                                            data-bs-target="#menu-8989L" role="tab"
                                            aria-controls="menu-8989L">
                                            <?php echo Labels::getLabel('LBL_All_Categories', $siteLangId); ?>
                                        </a>
                                    </li>
                            <?php
                            }
                            ?>
                        </ul>
                        <div class="tab-content navigation-tabs-content" id="navigation-tabs-content">
                            <?php
                            $j = 0;
                            foreach ($headerCategories as $pcatid => $pcatval) {
                                if ($j < 8) {
                                    $pCatNavUrl = UrlHelper::generateUrl('category', 'view', array($pcatval['prodcat_id']));
                                    $pCatHasChild = (count($pcatval['children']) > 0) ? true : false;
                                    if ($pCatHasChild) {
                                        $childLevel1Arr = array_chunk($pcatval['children'], 200);

                                        ?>
                                        <div class="tab-pane fade <?php echo ($j == 0) ? " active show" : ""; ?>"
                                             id="menu-<?php echo $pcatval['prodcat_id'] ?>" role="tabpanel"
                                             aria-labelledby="#menu-<?php echo $pcatval['prodcat_id'] ?>">
                                            <?php
                                            foreach ($childLevel1Arr as $childLevel1) {
                                                ?>
                                                <div class="categories-block">
                                                    <?php
                                                    foreach ($childLevel1 as $catkey => $catval) {
                                                        $catNavUrl = UrlHelper::generateUrl('category', 'view', array($catval['prodcat_id']));
                                                        $catHasChild = (count($catval['children']) > 0) ? true : false;
                                                        ?>
                                                        <div class="categories-cols">
                                                            <ul class="categories-list">
                                                                <li class="categories-list-item">
                                                                    <a class="categories-list-link categories-list-head"
                                                                       data-org-url="<?php echo $catNavUrl; ?>"
                                                                       href="<?php echo $catNavUrl; ?>"><?php echo $catval['prodcat_name']; ?></a>
                                                                </li>
                                                                <?php
                                                                if ($catHasChild) {
                                                                    foreach ($catval['children'] as $ccatkey => $ccatval) {
                                                                        $ccatNavUrl = UrlHelper::generateUrl('category', 'view', array($ccatval['prodcat_id']));
                                                                        ?>
                                                                        <li class="categories-list-item">
                                                                            <a class="categories-list-link" data-org-url="<?php echo $ccatNavUrl; ?>"
                                                                               href="<?php echo $ccatNavUrl; ?>">
                                                                                <?php echo $ccatval['prodcat_name']; ?></a>
                                                                        </li>
                                                                    <?php }
                                                                } ?>
                                                            </ul>
                                                        </div>
                                                    <?php } ?>
                            </div>
                            <?php } ?>
                        </div>
                        <?php
                                    }else{
                                        ?>
                        <div class="tab-pane fade" id="menu-<?php echo $pcatval['prodcat_id'] ?>" role="tabpanel"></div>
                                            <?php
                                    }
                                    $j++;
                                } ?>
                            <?php } ?>

                            <?php if ($j >= 8) { ?>
                                <div class="tab-pane fade" id="menu-8989L" role="tabpanel"></div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </li>
<?php  } ?>
<script>
    $(function() {

        jQuery(document).ready(function($) {
            $('a[data-bs-toggle="tab-menu"]').hover(function() {
                $(this).tab('show');
            });
            $('a[data-bs-toggle="tab-menu"]').on('shown.bs.tab', function(e) {
                var target = $(e.relatedTarget).attr('data-bs-target');
                $(target).removeClass('active');
                $(target).removeClass('show');
            })
        });

        /* $('#navigation-tabs > li > a').on('mouseenter', function() {
             $(this).tab('show');
         });
        $("#navigation-tabs > li > a").hover(function (e) {
            $('.tab-pane').removeClass('show active');
            $(this).tab('show');
        });*/

    });
</script>