<script>
    var disableDates = <?php echo json_encode($unavailableDatesSlots); ?>;
    var disableSlots = <?php echo json_encode($disableSlots); ?>;
    var setIntervalTime = <?php echo Product::PRODUCT_RENTAL_SLOTS_DURATION; ?>;

    $(document).ready(function () {
        'use strict';
        var $datePickers = $('.rental_datescalendar--js--start, .rental_datescalendar--js--end');
        $datePickers.each(function () {
            var $this = $(this);
            var isEndDatePicker = $this.hasClass('rental_datescalendar--js--end');
            var defaultTime = isEndDatePicker ? '23:59' : '00:00';
            var defaultDate = isEndDatePicker ? false : '<?php echo $minDate; ?>';

            if ('<?php echo date('Y-m-d') ?>' == '<?php echo $rentalAvailableDate ?>' && isEndDatePicker == false) {
                defaultTime = getTimeRound(30);
            }
            $this.datetimepicker({
                disabledDates: <?php echo json_encode($fullDisabledDates); ?>,
                formatDate: 'Y-m-d',
                formatTime: 'H:i',
                validateOnBlur: false,
                minDate: '<?php echo $minDate; ?>',
                format: 'Y-m-d H:i',
                defaultTime: defaultTime,  // Set default time during initialization
                onShow: function (ct, el) {
                    let $el = $(el);
                    let isEndDatePicker = $el.hasClass('rental_datescalendar--js--end');
                    let selectedStartDateTime = null;
                    if (isEndDatePicker) {
                        selectedStartDateTime = $('.rental_datescalendar--js--start').val();
                        $('.rental_datescalendar--js--start').datetimepicker('hide');
                        if($('.rental_datescalendar--js--start').val() == ''){
                            return false;
                        }
                    } else {
                        $('.rental_datescalendar--js--end').datetimepicker('hide');
                        $('.rental_datescalendar-without-hour--js--end').datetimepicker('hide');
                    }

                    let date = new Date(ct.toDateString());
                    let year = date.getFullYear();
                    let month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based, so add 1
                    let day = String(date.getDate()).padStart(2, '0');
                    let selectedDate = `${year}-${month}-${day}`;
                    let setIntervalSlots = setIntervalTime;
                    if (isEndDatePicker) {
                        setIntervalSlots = 60;
                    }
                    let selectedTime = ct.toTimeString().substring(0, 5);
                    let allowedTimeSlots = generateAllowedTimeSlots(setIntervalSlots, [], (selectedDate + ' ' + selectedTime), isEndDatePicker, selectedStartDateTime);
                    if (disableDates.indexOf(selectedDate) != -1) {
                        if (disableSlots[selectedDate] != -1) {
                            allowedTimeSlots = generateAllowedTimeSlots(setIntervalSlots, disableSlots[selectedDate] ?? [], (selectedDate + ' ' + selectedTime), isEndDatePicker, selectedStartDateTime);
                        }
                    }
                    if (allowedTimeSlots.length == 0) {
                        date.setDate(date.getDate() + 1);
                        do {
                            year = date.getFullYear();
                            month = String(date.getMonth() + 1).padStart(2, '0');
                            day = String(date.getDate()).padStart(2, '0');
                            selectedDate = `${year}-${month}-${day}`;

                            // Move to the next day if the current date is disabled
                            if (disableDates.includes(selectedDate)) {
                                date.setDate(date.getDate() + 1);
                            }
                            allowedTimeSlots = generateAllowedTimeSlots(setIntervalSlots, [], (selectedDate + ' ' + selectedTime), isEndDatePicker, selectedStartDateTime);
                            if (disableDates.indexOf(selectedDate) != -1) {
                                if (disableSlots[selectedDate] != -1) {
                                    allowedTimeSlots = generateAllowedTimeSlots(setIntervalSlots, disableSlots[selectedDate] ?? [], (selectedDate + ' ' + selectedTime), isEndDatePicker, selectedStartDateTime);
                                }
                            }

                        } while (disableDates.includes(selectedDate));
                        // this.setOptions({ defaultDate: selectedDate });
                    }

                    if (isEndDatePicker) {
                        let dateTimeString = $('.rental_datescalendar--js--start').val();
                        let dateOnly = dateTimeString.split(" ")[0];
                        let timeOnly = dateTimeString.split(" ")[1];

                        let endDateTimeString = $('.rental_datescalendar--js--end').val();
                        let endDateOnly = endDateTimeString.split(" ")[0];
                        if (dateOnly == endDateOnly) {
                            this.setOptions({
                                defaultTime: allowedTimeSlots[allowedTimeSlots.length - 1],
                                allowTimes: allowedTimeSlots,
                                minDate: dateOnly,
                                defaultDate: selectedDate,
                                minTime: timeOnly,
                            });
                        } else {

                            this.setOptions({
                                defaultTime: allowedTimeSlots[allowedTimeSlots.length - 1],
                                allowTimes: allowedTimeSlots,
                                defaultDate: selectedDate,
                                minDate: dateOnly,
                            });
                        }
                        throttleDatePickerActions('.rental_datescalendar--js--end');
                    } else {
                        this.setOptions({
                            minTime: isEndDatePicker ? allowedTimeSlots[allowedTimeSlots.length - 1] : allowedTimeSlots[0],
                            defaultTime: isEndDatePicker ? allowedTimeSlots[allowedTimeSlots.length - 1] : allowedTimeSlots[0],
                            allowTimes: allowedTimeSlots
                        });
                        throttleDatePickerActions('.rental_datescalendar--js--start');
                    }

                },
                closeOnWithoutClick: false,
                onSelectDate: async function (currentDateTime, $input, event) {
                    if (event) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    await logic(currentDateTime, $input);
                   // $($input).datetimepicker('reset');
                    $($input).datetimepicker('toggle').datetimepicker('toggle')
                    $($input).val('');
                },
                onSelectTime: function (currentDateTime, $input, event) {
                    event.preventDefault();
                    event.stopPropagation();
                    let isEndDatePicker = $($input).hasClass('rental_datescalendar--js--end');
                    if (isEndDatePicker) {
                        getRentalDetails();
                    }
                },

            });
        });
    });
    <?php if (!empty($extendedOrderData)) { ?>
        $('.rental_datescalendar--js').data('dateRangePicker').setStart('<?php echo $rentalAvailableDate; ?>');
    <?php } ?>

    $(document).ready(function () {
        $('.rental_datescalendar--js--start').on('change', function () {
            if ($(this).val()) {
                $('.rental_datescalendar--js--end').prop('disabled', false);
            } else {
                $('.rental_datescalendar--js--end').prop('disabled', true);
            }
        });
    });
    var logic = async function (currentDateTime, el) {
        if (currentDateTime) {
            var date = new Date(currentDateTime.toDateString());
            var year = date.getFullYear();
            var month = String(date.getMonth() + 1).padStart(2, '0');
            var day = String(date.getDate()).padStart(2, '0');
            var selectedDate = `${year}-${month}-${day}`;
            let selectedTime = currentDateTime.toTimeString().substring(0, 5);
            var allowedTimeSlots = generateAllowedTimeSlots(setIntervalTime, [], selectedDate + ' ' + selectedTime);

            if (disableDates.indexOf(selectedDate) != -1) {
                if (disableSlots[selectedDate]) {
                    allowedTimeSlots = generateAllowedTimeSlots(setIntervalTime, disableSlots[selectedDate] ?? [], (selectedDate + ' ' + selectedTime));
                }
            }
            let newOptions = {
                allowTimes: allowedTimeSlots,
                defaultTime: allowedTimeSlots[0],
                defaultDate: selectedDate,
                minTime: false
            };
            let isEndDatePicker = $(el).hasClass('rental_datescalendar--js--end');
            if (isEndDatePicker) {
                newOptions['defaultTime'] = allowedTimeSlots[allowedTimeSlots.length - 1];
            }
            let dateObject = $(el).datetimepicker('getValue');
            let isSameDay = selectedDate == getcurentDate();

            if (isEndDatePicker && isSameDay == false) {
                $(el).datetimepicker('setOptions', newOptions);
            } else {
                $(el).datetimepicker('setOptions', newOptions);
            }
            if (dateObject) {
                let year = dateObject.getFullYear();
                let month = String(dateObject.getMonth() + 1).padStart(2, '0'); // Months are zero-indexed
                let day = String(dateObject.getDate()).padStart(2, '0');
                let hours = String(dateObject.getHours()).padStart(2, '0');
                let minutes = String(dateObject.getMinutes()).padStart(2, '0');
                let formattedDateTime = `${year}-${month}-${day} ${hours}:${minutes}`;
                $(el).val(formattedDateTime);
            }
        }
    };
</script>

<script>
    
     $('input[name="radio_for_rent_duration_section"]').on('change',function(){
            let selectedDurationType = $('input[name="radio_for_rent_duration_section"]:checked').val();
            
            $('.get-dates-with-time').addClass('d-none');
            $('.get-dates').addClass('d-none');
            $('input[name="rental_start_date"]').attr('disabled',true);
            $('input[name="rental_end_date"]').attr('disabled',true);
            if(selectedDurationType == 1) {
                $('.get-dates-with-time').find('input[name="rental_start_date"]').attr('disabled',false);
                $('.get-dates-with-time').find('input[name="rental_end_date"]').attr('disabled',false);
                $('.get-dates-with-time').removeClass('d-none');
				$('.price-breakup-link-js').addClass('d-none');
            } else {
                $('.get-dates').find('input[name="rental_start_date"]').attr('disabled',false);
                $('.get-dates').find('input[name="rental_end_date"]').attr('disabled',false);
                $('.get-dates').removeClass('d-none');
				if($('#price-breakup-js').length > 0) {
					$('.price-breakup-link-js').removeClass('d-none');
				} else {
					$('.price-breakup-link-js').addClass('d-none');
				}
            }
            
     });
     $(function(){
        setTimeout(function(){
            $('input[name="radio_for_rent_duration_section"]').trigger('change');
        },500);
     });
     
     $('input[name="radio_for_rent_duration_section"]').trigger('change');    
     var $datePickersWithoutHour = $('.rental_datescalendar-without-hour--js--start, .rental_datescalendar-without-hour--js--end');
        $datePickersWithoutHour.each(function () {
            var $this = $(this);
            $this.datetimepicker({
                disabledDates: <?php echo json_encode($disabledDays); ?>,
                formatDate: 'Y-m-d',
                validateOnBlur: false,
                minDate: '<?php echo $minDate; ?>',
                format: 'Y-m-d',
                scrollMonth: false,
                scrollTime: false,
                scrollInput: false,
                timepicker:false,
				onSelectDate: async function (currentDateTime, $input, event) {
                    if (event) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    getRentalDetails();
                },
                onShow: function (ct, el) {
                    let $el = $(el);
                    let isEndDatePicker = $el.hasClass('rental_datescalendar-without-hour--js--end');
                    let selectedStartDateTime = null;
                    if (isEndDatePicker) {
                        selectedStartDateTime = $('.rental_datescalendar-without-hour--js--start').val();
                        $('.rental_datescalendar-without-hour--js--start').datetimepicker('hide');
                        if($('.rental_datescalendar-without-hour--js--start').val() == ''){
                            return false;
                        }
                    } 
                }
            });
        });
</script>