<?php if (!empty($rentalPriceDetail)) { ?>
	<div class="price-breakup">
		<ul class="price-breakdown">
			<?php
			if (!empty($rentalPriceDetail['number_of_months']) && $rentalPriceDetail['number_of_months'] > 0) { ?>
				<li class="price-breakdown-item">
					<div class="price-breakdown-label">
						<span class="duration"><?php echo Labels::getLabel('LBL_Month', $siteLangId); ?></span>
						<span class="duration-desc">
							<span><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['month_price']); ?>
								X
								<?php echo $rentalPriceDetail['number_of_months']; ?>
							</span>

						</span>
					</div>
					<div class="price-breakdown-value">
						<span class="last-price">
							<?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_months_price']); ?></span>
				</li>
			<?php } ?>
			<?php
			if (!empty($rentalPriceDetail['number_of_weeks']) && $rentalPriceDetail['number_of_weeks'] > 0) { ?>
				<li class="price-breakdown-item">
					<div class="price-breakdown-label">
						<span class="duration"><?php echo Labels::getLabel('LBL_Week', $siteLangId); ?></span>
						<span
							class="duration-desc"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['week_price']); ?>
							X
							<?php echo $rentalPriceDetail['number_of_weeks']; ?> </span>

					</div>
					<div class="price-breakdown-value">
						<span
							class="last-price"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_weeks_price']); ?></span>
					</div>
				</li>
			<?php } ?>
			<?php
			if (!empty($rentalPriceDetail['number_of_days']) && $rentalPriceDetail['number_of_days'] > 0) { ?>
				<li class="price-breakdown-item">
					<div class="price-breakdown-label">
						<span class="duration"><?php echo Labels::getLabel('LBL_Day', $siteLangId); ?></span>
						<span
							class="duration-desc"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['day_price']); ?>
							X
							<?php echo $rentalPriceDetail['number_of_days']; ?> </span>
					</div>
					<div class="price-breakdown-value">
						<span
							class="last-price"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_days_price']); ?></span>
					</div>
				</li>
			<?php } ?>
			<?php
			if (!empty($rentalPriceDetail['total_rental_price'])) { ?>
				<li class="price-breakdown-item price-breakdown-total">
					<div class="price-breakdown-label">
						<span class="duration"></span>
						<span
							class="duration-desc"><?php echo Labels::getLabel('LBL_Sub_total', $siteLangId); ?>
						</span>

					</div>
					<div class="price-breakdown-value">
						<span
							class="last-price"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_rental_price']); ?></span>
					</div>
				</li>
				<li class="price-breakdown-item price-breakdown-total">
					<div class="price-breakdown-label">
						<span
							class="duration"><?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?>
							<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" height="18" width="18" data-bs-toggle="tooltip" data-placement="right" title="" data-bs-original-title="<?php echo Labels::getLabel('LBL_Sub_total_X_quantity', $siteLangId); ?>" aria-label="<?php echo Labels::getLabel('LBL_Sub_total_X_quantity', $siteLangId); ?>"><path d="M12 22C6.47715 22 2 17.5228 2 12C2 6.47715 6.47715 2 12 2C17.5228 2 22 6.47715 22 12C22 17.5228 17.5228 22 12 22ZM12 20C16.4183 20 20 16.4183 20 12C20 7.58172 16.4183 4 12 4C7.58172 4 4 7.58172 4 12C4 16.4183 7.58172 20 12 20ZM11 7H13V9H11V7ZM11 11H13V17H11V11Z"></path></svg>
						</span>
						<span
							class="duration-desc"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_rental_price']); ?>
							X
							<?php echo $quantity; ?>
							</span>

					</div>
					<div class="price-breakdown-value">
						<span
							class="last-price"><?php echo CommonHelper::displayMoneyFormat($rentalPriceDetail['total_rental_price'] * $quantity); ?></span>
					</div>
				</li>
			<?php } ?>
		</ul>
	</div>	
	<?php
}