<?php if ($canEdit) { ?>
        <?php
        $countActions = 0;

        if (User::canAddCustomProduct() && ($action == 'products' || $action == 'sales')) {
            $countActions++;
            $countActions++;
        }

        if (isset($adminCatalogs) && $adminCatalogs > 0) {
            $countActions++;
        }

        if (User::canAddCustomProduct() && $action == 'catalog' && $type == 1) {
            $countActions++;
        }

        if ((isset($canAddCustomProduct) && $canAddCustomProduct == false) && (isset($canRequestProduct) && $canRequestProduct === true)) {
            $countActions++;
        }
        ?>

        <div class="content-header-toolbar">
            <?php if ($countActions <= 2) { ?>
                        <div class="links-inline">
                            <?php if (User::canAddCustomProduct() && ($action == 'products' || $action == 'sales')) { ?>
                                    <a class="btn btn btn-outline-gray btn-icon btn-add" href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>">
                                        <svg class="svg" width="18" height="18">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                            </use>
                                        </svg>
                                        <?php echo Labels::getLabel('LBL_Add_New_Product', $siteLangId); ?>
                                    </a>
                                    <a class="btn btn btn-outline-gray btn-icon" href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>">
                                        <svg class="svg" width="18" height="18">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#my-products">
                                            </use>
                                        </svg>
                                        <?php echo Labels::getLabel('LBL_MY_PRODUCTS', $siteLangId); ?>
                                    </a>
                            <?php } ?>
                            <?php if (isset($adminCatalogs) && $adminCatalogs > 0) { ?>
                                    <a class="btn btn btn-outline-gray btn-icon" href="<?php echo UrlHelper::generateUrl('seller', 'catalog', [0]); ?>">
                                        <svg class="svg" width="18" height="18">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#marketplace-products">
                                            </use>
                                        </svg> <?php echo Labels::getLabel('LBL_Marketplace_Products', $siteLangId); ?>
                                    </a>
                            <?php } ?>
                            <?php if (User::canAddCustomProduct() && $action == 'catalog' && $type == 1) { ?>
                                    <a class="btn btn btn-outline-gray btn-icon  btn-add" href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>">
                                        <svg class="svg" width="18" height="18">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                            </use>
                                        </svg> <?php echo Labels::getLabel('LBL_Add_New_Product', $siteLangId); ?>
                                    </a>
                            <?php } ?>

                            <?php if ((isset($canAddCustomProduct) && $canAddCustomProduct == false) && (isset($canRequestProduct) && $canRequestProduct === true)) { ?>
                                    <a class="btn btn btn-outline-gray btn-icon" href="<?php echo UrlHelper::generateUrl('Seller', 'requestedCatalog'); ?>">
                                        <svg class="svg" width="18" height="18">
                                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#request-product">
                                            </use>
                                        </svg>
                                        <?php echo Labels::getLabel('LBL_Request_A_Product', $siteLangId); ?></a>

                            <?php } ?>
                        </div>
            <?php } else { ?>
                        <div class="dropdown">
                            <button class="btn btn-outline-gray  dropdown-toggle" type="button" id="dashboardDropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside"     aria-haspopup="true" aria-expanded="false">
                                <?php echo Labels::getLabel('LBL_More_Actions', $siteLangId); ?>
                            </button>
                            <ul class="dropdown-menu dropdown-menu-anim">
                                <?php if (User::canAddCustomProduct() && ($action == 'products' || $action == 'sales')) { ?>
                                            <li class="dropdown-menu-item">
                                                <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>"><?php echo Labels::getLabel('LBL_Add_New_Product', $siteLangId); ?></a>
                                            </li>
                                            <li class="dropdown-menu-item">
                                                <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('seller', 'catalog'); ?>"><?php echo Labels::getLabel('LBL_MY_PRODUCTS', $siteLangId); ?></a>
                                            </li>
                                <?php } ?>
                                <?php if (isset($adminCatalogs) && $adminCatalogs > 0) { ?>
                                            <li class="dropdown-menu-item">
                                                <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('seller', 'catalog', [0]); ?>"><?php echo Labels::getLabel('LBL_Marketplace_Products', $siteLangId); ?></a>
                                            </li>
                                <?php } ?>
                                <?php if (User::canAddCustomProduct() && $action == 'catalog' && $type == 1) { ?>
                                            <li class="dropdown-menu-item">
                                                <a class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('seller', 'customProductForm'); ?>"><?php echo Labels::getLabel('LBL_Add_New_Product', $siteLangId); ?></a>
                                            </li>
                                <?php } ?>
                                <?php if ((isset($canAddCustomProduct) && $canAddCustomProduct == false) && (isset($canRequestProduct) && $canRequestProduct === true)) { ?>
                                            <li class="dropdown-menu-item">
                                                <button class="dropdown-menu-link" href="<?php echo UrlHelper::generateUrl('Seller', 'requestedCatalog'); ?>"><?php echo Labels::getLabel('LBL_Request_A_Product', $siteLangId); ?></button>
                                            </li>
                                <?php } ?>    
                            </ul>
                        </div>
            <?php } ?>    
        </div>
<?php } ?>