<div class="atom-radio-drawer">
    <label class="atom-radio-drawer_head atom-section-js for-rent--js" for="rent-section-js" data-bs-toggle="tooltip"
        title="<?php echo Labels::getLabel('LBL_Rental_Detail_Box_Tooltip', $siteLangId); ?>">
        <div
            class="atom-radio-drawer_head_left <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "disabled" : ""; ?>">
            <div class="data">
                <span class="title"> <?php echo Labels::getLabel('LBL_Rent_Now', $siteLangId); ?>
                </span>
                <?php
                if ($displayHourPrice && $displayDayPrice) {
                    ?>

                    <span class="price">
                        <?php
                        if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0) {
                            echo CommonHelper::displayMoneyFormat($product['splprice_hour_price']);
                        } else {
                            echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']);
                        }
                        ?>
                    </span>
                    <?php if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0 && $product['sprodata_hour_rental_price'] > $product['splprice_hour_price']) { ?>
                        <del class="off-price">
                            <?php echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']); ?>

                        </del>
                    <?php } ?>
                    <span class="duration-type">
                        <?php echo Labels::getLabel('LBL_Per', $siteLangId) . ' ' . $rentalTypeArr[$product['sprodata_duration_type']]; ?>
                    </span>

                <?php } else if ($displayHourPrice) {
                    ?>

                        <span class="price">
                            <?php
                            if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0) {
                                echo CommonHelper::displayMoneyFormat($product['splprice_hour_price']);
                            } else {
                                echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']);
                            }
                            ?>
                        </span>
                    <?php if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0 && $product['sprodata_hour_rental_price'] > $product['splprice_hour_price']) { ?>
                            <del class="off-price">
                            <?php echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']); ?>

                            </del>
                    <?php } ?>
                        <span class="duration-type">
                        <?php echo Labels::getLabel('LBL_Per', $siteLangId) . ' ' . $rentalTypeArr[ProductRental::DURATION_TYPE_HOUR]; ?>
                        </span>

                        <input class="radio-switch d-none" name="radio_for_rent_duration_section" type="radio" value="1"
                            checked>
                    <?php
                } else if ($displayDayPrice) {
                    ?>
                            <span class="price">
                            <?php
                            if ($product_special_price > 0) {
                                echo CommonHelper::displayMoneyFormat($product_special_price);
                            } else {
                                echo CommonHelper::displayMoneyFormat($product_rental_price);
                            }
                            ?>
                            </span>

                    <?php if ($product_special_price > 0 && $product_rental_price > $product_special_price) { ?>
                                <del class="off-price">
                            <?php echo CommonHelper::displayMoneyFormat($product_rental_price); ?>

                                </del>
                    <?php } ?>

                            <span class="duration-type">
                        <?php echo Labels::getLabel('LBL_Per', $siteLangId) . ' ' . $product_rental_duration; ?>
                            </span>

                            <input class="radio-switch d-none" name="radio_for_rent_duration_section" type="radio" value="2"
                                checked>
                <?php } ?>
                <br />
                <?php if (!empty($addonProducts)) { ?>
                    <button type="button" class="link-brand link-underline service-link--js" onClick="showAddonModal()"
                        data-displaybox="1">
                        <?php echo Labels::getLabel('LBL_Addons', $siteLangId); ?>
                    </button>
                <?php } ?>
            </div>

            <?php if (FatApp::getConfig('CONF_PRODUCT_INCLUSIVE_TAX', FatUtility::VAR_INT, 0)) {
                echo '<p class=" txt-normal">' . Labels::getLabel('LBL_Inclusive_All_Taxes', $siteLangId) . '</p>';
            } ?>
        </div>
        <div class="radio <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "disabled" : ""; ?>">
            <input id="rent-section-js" class="radio-switch" name="radio_for_rent_sale_section" type="radio" value="2">
        </div>

        <div class="sale-rent-only" data-bs-toggle="tooltip" data-placement="top"
            style="display: <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "block" : "none"; ?>;"
            title="<?php echo Labels::getLabel('LBL_You_have_sale_item(s)_in_your_cart_you_cannot_add_items_for_Rent', $siteLangId); ?>">

            <svg class="svg" width="30" height="30">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#info">
                </use>
            </svg>

        </div>
    </label>
    <div class="atom-radio-drawer_body">
        <?php
        if ((in_array(applicationConstants::RENT_TYPE_MONTH, $activeRentalDurations) && $product['sprodata_month_rental_price'] > 0) || (in_array(applicationConstants::RENT_TYPE_WEEK, $activeRentalDurations) && $product['sprodata_week_rental_price'] > 0) || (in_array(applicationConstants::RENT_TYPE_DAY, $activeRentalDurations) && $product['sprodata_day_rental_price'] > 0) || (in_array(applicationConstants::RENT_TYPE_HOUR, $activeRentalDurations) && $product['sprodata_hour_rental_price'] > 0)) { ?>

            <ul class="pricing-models">
                <?php
                if (in_array(applicationConstants::RENT_TYPE_HOUR, $activeRentalDurations) && $product['sprodata_hour_rental_price'] > 0) { ?>
                    <li class="pricing-models-item">
                        <div class="pricing-models-icon">
                            <svg class="svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                width="30" height="30" viewBox="0 0 30 30">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_8" data-name="Rectangle 8" width="30" height="30" fill="none" />
                                    </clipPath>
                                </defs>
                                <g id="Group_33" data-name="Group 33" clip-path="url(#clip-path)">
                                    <path id="Path_46" data-name="Path 46"
                                        d="M26.262,6.644a2.515,2.515,0,0,0-1.338-.766,4.485,4.485,0,0,0-.807-.081c-.387-.008-.774-.008-1.169,0h-.6V3.87a.842.842,0,0,0-.226-.6.832.832,0,0,0-1.436.581V5.539l-.008.113v.137H9.318V3.862a.816.816,0,0,0-.4-.734A.806.806,0,0,0,8.084,3.1a.844.844,0,0,0-.428.742c-.008.371,0,.733,0,1.1v.589l-.008.1L7.64,5.8H6.93c-.387,0-.766-.008-1.153,0a4.072,4.072,0,0,0-.605.057A2.633,2.633,0,0,0,3.463,6.991,2.721,2.721,0,0,0,3,8.572V24.226c0,.1,0,.194.008.274a2.675,2.675,0,0,0,1.4,2.17A2.756,2.756,0,0,0,5.785,27q4.125-.012,8.259-.008h6.533c1.217,0,2.435,0,3.653.008A2.7,2.7,0,0,0,27,24.21q-.012-7.8,0-15.614a2.745,2.745,0,0,0-.734-1.952m-.927,17.582a1.065,1.065,0,0,1-.419.911.99.99,0,0,1-.557.194l-.153.008H5.785a1.071,1.071,0,0,1-.919-.419,1.024,1.024,0,0,1-.2-.565V8.58a1.078,1.078,0,0,1,.395-.9A1.026,1.026,0,0,1,5.7,7.459c.443-.008.887-.008,1.33-.008h.444l.056.008.121.016V9.4a.835.835,0,0,0,.662.831.816.816,0,0,0,.927-.492A1.059,1.059,0,0,0,9.31,9.37c.008-.395.008-.8.008-1.194V7.459H20.681V9.4a.809.809,0,0,0,.5.775.792.792,0,0,0,.888-.146.828.828,0,0,0,.274-.645V7.515l.056-.024.089-.032h.557c.443-.008.9-.008,1.338.016a.987.987,0,0,1,.952,1.008Z" />
                                    <path id="Path_47" data-name="Path 47"
                                        d="M19.521,12.322a6.36,6.36,0,0,0-4.509-1.871h-.024A6.412,6.412,0,0,0,15,23.274H15a6.41,6.41,0,0,0,4.517-10.952M15,21.613a4.75,4.75,0,0,1-4.742-4.742A4.739,4.739,0,0,1,15,12.111H15a4.751,4.751,0,0,1-.008,9.5" />
                                    <path id="Path_48" data-name="Path 48"
                                        d="M17.666,17.991a.819.819,0,0,1-.961.613c-.621-.145-1.257-.3-1.95-.484a.845.845,0,0,1-.589-.855v-2.21a.837.837,0,0,1,.742-.879h.1a.817.817,0,0,1,.5.17.779.779,0,0,1,.3.516,4.434,4.434,0,0,1,.024.564v1.057a.212.212,0,0,0,.186.242c.322.08.645.161.958.242l.057.016a.829.829,0,0,1,.63,1.008" />
                                </g>
                            </svg>

                        </div>
                        <div class="pricing-models-detail">
                            <span class="pricing-models-label">
                                <?php echo Labels::getLabel('LBL_Hourly_price', $siteLangId); ?>
                            </span>
                            <span class="pricing-models-price">
                                <span class="price">
                                    <?php
                                    if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0) {
                                        echo CommonHelper::displayMoneyFormat($product['splprice_hour_price']);
                                    } else {
                                        echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']);
                                    }
                                    ?>
                                </span>
                                <?php if (!empty($product['splprice_hour_price']) && $product['splprice_hour_price'] > 0 && $product['sprodata_hour_rental_price'] > $product['splprice_hour_price']) { ?>

                                    <del class="off-price">
                                        <?php echo CommonHelper::displayMoneyFormat($product['sprodata_hour_rental_price']); ?>

                                    </del>
                                <?php } ?>
                            </span>
                        </div>
                    </li>
                <?php } ?>

                <?php
                if (in_array(applicationConstants::RENT_TYPE_DAY, $activeRentalDurations) && $product['sprodata_day_rental_price'] > 0) { ?>
                    <li class="pricing-models-item">
                        <div class="pricing-models-icon">
                            <svg class="svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                width="30" height="30" viewBox="0 0 30 30">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_3" data-name="Rectangle 3" width="30" height="30" fill="none" />
                                    </clipPath>
                                </defs>
                                <g id="Group_23" data-name="Group 23" clip-path="url(#clip-path)">
                                    <path id="Path_31" data-name="Path 31"
                                        d="M26.415,6.816a2.7,2.7,0,0,0-2.186-1.025h-1.88V3.871a.836.836,0,0,0-.21-.589A.856.856,0,0,0,21.518,3a.731.731,0,0,0-.29.057.815.815,0,0,0-.541.8V5.541l-.016.242H9.321V3.871a.855.855,0,0,0-.355-.718A.834.834,0,0,0,8.49,3a.834.834,0,0,0-.831.855c0,.226-.008.444-.008.67,0,.339.008.669.008,1.008v.258H7.392c-.33,0-.661.008-.992.008-.193,0-.387-.008-.589-.008H5.779a2.688,2.688,0,0,0-1.654.517A2.636,2.636,0,0,0,3.012,8.3,2.22,2.22,0,0,0,3,8.534V24.217A2.713,2.713,0,0,0,5.771,27Q15,27,24.229,26.992a2.743,2.743,0,0,0,.451-.024,2.61,2.61,0,0,0,1.751-1.009,2.566,2.566,0,0,0,.557-1.492c.008-.081.008-.161.008-.242V8.566a2.668,2.668,0,0,0-.581-1.75M25.342,24.233a1.028,1.028,0,0,1-1.1,1.1H5.763a1.026,1.026,0,0,1-1.1-1.1V8.55a1.029,1.029,0,0,1,1.048-1.1c.226,0,.46-.008.686-.008.363,0,.726.008,1.089.008h.016l.154.024V9.4a.827.827,0,0,0,.823.847H8.49a.836.836,0,0,0,.831-.855V7.461h11.35l.008.1.008.153v1.67a.826.826,0,0,0,.823.863h.008a.839.839,0,0,0,.831-.871v-1.9l.089-.008.121-.008h1.686a1.039,1.039,0,0,1,1.1,1.1Z" />
                                    <path id="Path_32" data-name="Path 32"
                                        d="M18.3,12.955a3.551,3.551,0,0,0-3-1.573c-.452-.008-.9-.008-1.364-.008-.669,0-1.339.008-2.009.008a.865.865,0,0,0-.379.089.794.794,0,0,0-.476.814c-.008.71-.008,1.428-.008,2.146,0,.815.008,1.622.008,2.437V17.4c0,.686-.008,1.371-.008,2.065,0,.654,0,1.307.008,1.961a.841.841,0,0,0,.92.919c.113.008.234.008.347.008.1,0,.193,0,.29-.008.952,0,1.9.008,2.84-.008a3.236,3.236,0,0,0,1.888-.629,3.566,3.566,0,0,0,1.581-3.033V15.052a3.579,3.579,0,0,0-.637-2.1m-1.025,5.768a1.955,1.955,0,0,1-1.307,1.847,1.863,1.863,0,0,1-.629.1c-.387.008-.775.008-1.162.008H12.9l-.162-.016V13.036h2.493a1.994,1.994,0,0,1,1.6.726,1.731,1.731,0,0,1,.428,1.1c.008.532.008,1.073.008,1.605V18.2c0,.161,0,.314.008.468Z" />
                                </g>
                            </svg>

                        </div>
                        <div class="pricing-models-detail">
                            <span class="pricing-models-label">
                                <?php echo Labels::getLabel('LBL_Daily_price', $siteLangId); ?></span>
                            <span class="pricing-models-price">
                                <span class="price">
                                    <?php
                                    if (!empty($product['splprice_day_price']) && $product['splprice_day_price'] > 0) {
                                        echo CommonHelper::displayMoneyFormat($product['splprice_day_price']);
                                    } else {
                                        echo CommonHelper::displayMoneyFormat($product['sprodata_day_rental_price']);
                                    }
                                    ?>
                                </span>
                                <?php if (!empty($product['splprice_day_price']) && $product['splprice_day_price'] > 0 && $product['sprodata_day_rental_price'] > $product['splprice_day_price']) { ?>
                                    <del class="off-price">
                                        <?php echo CommonHelper::displayMoneyFormat($product['sprodata_day_rental_price']); ?>

                                    </del>
                                <?php } ?>
                            </span>
                        </div>
                    </li>
                <?php } ?>

                <?php
                if (in_array(applicationConstants::RENT_TYPE_WEEK, $activeRentalDurations) && $product['sprodata_week_rental_price'] > 0) { ?>
                    <li class="pricing-models-item">
                        <div class="pricing-models-icon">
                            <svg class="svg" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"
                                width="30" height="30" viewBox="0 0 30 30">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_2" data-name="Rectangle 2" width="30" height="30" fill="none" />
                                    </clipPath>
                                </defs>
                                <g id="Group_21" data-name="Group 21" clip-path="url(#clip-path)">
                                    <path id="Path_29" data-name="Path 29"
                                        d="M26.907,7.784A2.666,2.666,0,0,0,24.366,5.8c-.234-.008-.476-.008-.726-.008H22.349V3.855a.816.816,0,0,0-.242-.605.851.851,0,0,0-.6-.25.783.783,0,0,0-.3.056.838.838,0,0,0-.525.783V5.783H9.312V3.863a.811.811,0,0,0-.234-.613.85.85,0,0,0-.6-.25.832.832,0,0,0-.307.056.849.849,0,0,0-.524.783V5.791H5.739a2.653,2.653,0,0,0-1.4.371A2.624,2.624,0,0,0,3,8.526V24.265a2.469,2.469,0,0,0,.21,1.089,2.6,2.6,0,0,0,2.517,1.638Q10.486,27,15.242,27h9.027a2.584,2.584,0,0,0,1.4-.371A2.63,2.63,0,0,0,27,24.257V8.542a2.9,2.9,0,0,0-.089-.758M25.342,24.241a1.029,1.029,0,0,1-.758,1.057,1.285,1.285,0,0,1-.347.04H5.755a1.094,1.094,0,0,1-.791-.3,1.067,1.067,0,0,1-.306-.791V8.542a1.1,1.1,0,0,1,.306-.79,1.11,1.11,0,0,1,.8-.3H7.651V9.4a.837.837,0,0,0,.7.831l.121.008a.813.813,0,0,0,.807-.621.97.97,0,0,0,.032-.266v-1.9H20.687V9.4a.845.845,0,0,0,.67.839l.153.008a.811.811,0,0,0,.775-.524,1.018,1.018,0,0,0,.056-.347c.008-.266.008-.524.008-.791V7.469l.089-.008.113-.008h1.718A1.048,1.048,0,0,1,25.3,8.2a1.71,1.71,0,0,1,.04.347Z" />
                                    <path id="Path_30" data-name="Path 30"
                                        d="M20.47,12.374l-.839,5.042c-.21,1.226-.411,2.461-.613,3.687a1.388,1.388,0,0,1-.8,1.129,1.3,1.3,0,0,1-1.016.024,1.221,1.221,0,0,1-.7-.653c-.145-.331-.258-.678-.371-1.017l-.113-.322c-.194-.565-.4-1.138-.589-1.7l-.29-.856-.025-.064-.121-.3-.718,2.082c-.234.661-.459,1.323-.685,1.992a1.357,1.357,0,0,1-.791.839,1.337,1.337,0,0,1-1.1-.064,1.31,1.31,0,0,1-.694-.984c-.121-.726-.25-1.461-.371-2.187l-.895-5.389c-.073-.427-.146-.855-.21-1.282a.817.817,0,0,1,.427-.871.838.838,0,0,1,.968.137,1.068,1.068,0,0,1,.267.613c.347,2.065.685,4.122,1.024,6.187.032.17.057.339.089.517l.105.621.161-.331.032-.073c.444-1.282.888-2.565,1.323-3.856a1.221,1.221,0,0,1,.662-.734,1.053,1.053,0,0,1,.855.016,1.2,1.2,0,0,1,.629.71l1.315,3.84.033.089.161.379,1.024-6.139q.109-.666.218-1.331a.9.9,0,0,1,.46-.662.868.868,0,0,1,.783.033.856.856,0,0,1,.4.879" />
                                </g>
                            </svg>

                        </div>
                        <div class="pricing-models-detail">
                            <span class="pricing-models-label">
                                <?php echo Labels::getLabel('LBL_Weekly_price', $siteLangId); ?></span>
                            <span class="pricing-models-price">
                                <span class="price">
                                    <?php
                                    if (!empty($product['splprice_week_price']) && $product['splprice_week_price'] > 0) {
                                        echo CommonHelper::displayMoneyFormat($product['splprice_week_price']);
                                    } else {
                                        echo CommonHelper::displayMoneyFormat($product['sprodata_week_rental_price']);
                                    }
                                    ?>
                                </span>
                                <?php if (!empty($product['splprice_week_price']) && $product['splprice_week_price'] > 0 && $product['sprodata_week_rental_price'] > $product['splprice_week_price']) { ?>
                                    <del class="off-price">
                                        <?php echo CommonHelper::displayMoneyFormat($product['sprodata_week_rental_price']); ?>

                                    </del>
                                <?php } ?>
                            </span>
                        </div>
                    </li>
                <?php } ?>

                <?php
                if (in_array(applicationConstants::RENT_TYPE_MONTH, $activeRentalDurations) && $product['sprodata_month_rental_price'] > 0) { ?>
                    <li class="pricing-models-item">
                        <div class="pricing-models-icon">
                            <svg class="svg" id="Group_38" data-name="Group 38" xmlns="http://www.w3.org/2000/svg"
                                xmlns:xlink="http://www.w3.org/1999/xlink" width="30" height="30" viewBox="0 0 30 30">
                                <defs>
                                    <clipPath id="clip-path">
                                        <rect id="Rectangle_10" data-name="Rectangle 10" width="30" height="30" fill="none" />
                                    </clipPath>
                                </defs>
                                <g id="Group_37" data-name="Group 37" clip-path="url(#clip-path)">
                                    <path id="Path_53" data-name="Path 53"
                                        d="M26.792,7.449a2.65,2.65,0,0,0-2.4-1.645c-.468-.024-.951-.016-1.419-.008l-.387.008L22.4,5.747l-.056-.193V3.86a.815.815,0,0,0-.339-.694.788.788,0,0,0-.855-.072.779.779,0,0,0-.468.742c-.008.581,0,1.177,0,1.733l-.056.178-.17.057Q15,5.792,9.539,5.8L9.37,5.747l-.048-.178V3.86a.836.836,0,0,0-.339-.694.835.835,0,0,0-1.323.678c-.008.573-.008,1.169,0,1.742L7.6,5.747,7.442,5.8H5.781a2.578,2.578,0,0,0-.589.056A2.674,2.674,0,0,0,3.466,6.99a2.732,2.732,0,0,0-.46,1.579q.012,2.991,0,5.994v9.671A2.7,2.7,0,0,0,5.781,27q3.351-.012,6.694-.008h7.55c1.4,0,2.8,0,4.2.008h.008a2.7,2.7,0,0,0,2.758-2.749V8.538a2.631,2.631,0,0,0-.2-1.089M25.34,24.241a1.015,1.015,0,0,1-.742,1.05,1.183,1.183,0,0,1-.4.048H5.781a1.058,1.058,0,0,1-.912-.42,1.03,1.03,0,0,1-.2-.629V8.578a1.085,1.085,0,0,1,.395-.9,1.065,1.065,0,0,1,.677-.218h.775c.314,0,.621,0,.935-.008l.162.057.048.153c0,.581-.008,1.17,0,1.75a.834.834,0,0,0,.67.831.845.845,0,0,0,.927-.516.961.961,0,0,0,.065-.347V7.667l.048-.161.161-.057q5.469.012,10.945,0l.162.057.048.161c0,.589-.008,1.17,0,1.75a.81.81,0,0,0,.549.783.833.833,0,0,0,1.113-.808V7.675l.048-.169.169-.057c.355.008.71.008,1.065.008h.605a1.032,1.032,0,0,1,1.1,1.1Z" />
                                    <path id="Path_54" data-name="Path 54"
                                        d="M13.739,20.875A2.881,2.881,0,0,1,11.682,22.3a3.538,3.538,0,0,1-.661.041H10.3a5.6,5.6,0,0,1-1.049-.058,2.934,2.934,0,0,1-2.177-1.87.826.826,0,0,1,1.516-.654l.032.064a1.458,1.458,0,0,0,.3.485,1.292,1.292,0,0,0,.9.371c.476,0,.936,0,1.395-.008a1.231,1.231,0,0,0,1.251-1.25l.008-.1a2.194,2.194,0,0,0-.033-.517,1.284,1.284,0,0,0-1.266-1h-.25c-.161,0-.323,0-.484-.007a.792.792,0,0,1-.742-.679.815.815,0,0,1,.508-.9,1.135,1.135,0,0,1,.395-.073l.2.008a1.62,1.62,0,0,0,.581-.064,1.086,1.086,0,0,0-.347-2.113c-.1,0-.21-.008-.323-.008a5.2,5.2,0,0,0-.871.024,1.044,1.044,0,0,0-.855.637l-.048.12a.976.976,0,0,1-.226.387.828.828,0,0,1-1.355-.87,2.773,2.773,0,0,1,1.549-1.734,2.327,2.327,0,0,1,.79-.2,9.914,9.914,0,0,1,1.605.007,2.664,2.664,0,0,1,1.815.937,2.783,2.783,0,0,1,.3,3.169,2.823,2.823,0,0,1-.2.283.168.168,0,0,0,.016.25,2.777,2.777,0,0,1,.831,1.5,3.342,3.342,0,0,1-.323,2.4" />
                                    <path id="Path_55" data-name="Path 55"
                                        d="M22.918,14.633a2.9,2.9,0,0,0-1.169-1.773,2.679,2.679,0,0,0-1.538-.544c-.4-.02-.8-.02-1.2-.02h-.369c-.1,0-.2.01-.307.02a2.946,2.946,0,0,0-1.661.749,2.783,2.783,0,0,0-.974,2.091c-.021,1.466-.01,2.943,0,4.378a2.71,2.71,0,0,0,.379,1.323,2.957,2.957,0,0,0,1.938,1.415,2.878,2.878,0,0,0,.287.051l.133.02h1.815c.041-.01.1-.02.164-.03a2.452,2.452,0,0,0,.39-.082,2.9,2.9,0,0,0,1.527-1,3.013,3.013,0,0,0,.656-1.917v-4a3.454,3.454,0,0,0-.071-.687M21.185,17.9V19.35a1.16,1.16,0,0,1-.892,1.158,1.269,1.269,0,0,1-.287.031H18.683a1.153,1.153,0,0,1-1.158-.872,1.412,1.412,0,0,1-.031-.317V15.289a1.145,1.145,0,0,1,1.138-1.179c.461-.01.954-.01,1.456,0a1.14,1.14,0,0,1,1.087,1.1c.01.492.01.984.01,1.486l-.01.513Z" />
                                </g>
                            </svg>


                        </div>
                        <div class="pricing-models-detail">
                            <span
                                class="pricing-models-label"><?php echo Labels::getLabel('LBL_Monthly_price', $siteLangId); ?></span>
                            <span class="pricing-models-price">
                                <span class="price">

                                    <?php
                                    if (!empty($product['splprice_month_price']) && $product['splprice_month_price'] > 0) {
                                        echo CommonHelper::displayMoneyFormat($product['splprice_month_price']);
                                    } else {
                                        echo CommonHelper::displayMoneyFormat($product['sprodata_month_rental_price']);
                                    }
                                    ?>
                                </span>
                                <?php if (!empty($product['splprice_month_price']) && $product['splprice_month_price'] > 0 && $product['sprodata_month_rental_price'] > $product['splprice_month_price']) { ?>
                                    <del class="off-price">
                                        <?php echo CommonHelper::displayMoneyFormat($product['sprodata_month_rental_price']); ?>

                                    </del>
                                <?php } ?>
                            </span>
                        </div>
                    </li>
                <?php } ?>
            </ul>
            <div class="divider"></div>
        <?php } ?>

        <ul class="list-features">
            <li class="list-features-item">
                <span class="lable">
                    <?php echo Labels::getLabel('LBL_Original_Price', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($product['selprod_cost']); ?>
                </span>
            </li>
            <li class="list-features-item">
                <span class="lable">
                    <?php echo Labels::getLabel('LBL_Security_(refundable)', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo CommonHelper::displayMoneyFormat($product['sprodata_rental_security']); ?>
                    <?php /**  <span class="slash"><?php echo Labels::getLabel('LBL_(Refundable)', $siteLangId); ?></span>
                      */ ?>
                    <i class="fas fa-info-circle" data-bs-toggle="tooltip" data-placement="top"
                        title="<?php echo Labels::getLabel('LBL_Security_Amount_is_refundable_after_product_return', $siteLangId); ?>"></i>
                </span>
            </li>
            <li class="list-features-item">
                <span class="lable">
                    <?php echo Labels::getLabel('LBL_Minimum_Rental_Quantity', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo $product['sprodata_minimum_rental_quantity']; ?>
                </span>
            </li>

            <li class="list-features-item">
                <span class="lable">
                    <?php echo Labels::getLabel('LBL_Minimum_Rental_Duration', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php
                    $minimum_duration = $product['sprodata_minimum_rental_duration'] . ' ' . $rentalTypeArr[$product['sprodata_min_duration_type']];
                    echo $minimum_duration; ?>
                </span>
            </li>

            <?php
            if (0) {
                if ($selectedFullfillmentType == Shipping::FULFILMENT_SHIP && $fulfillmentType != $selectedFullfillmentType && $fulfillmentType != Shipping::FULFILMENT_ALL) {
                    $selectedFullfillmentType = $fulfillmentType;

                    ?>
                    <li class="list-features-item">
                        <span class="lable">
                            <?php echo sprintf(Labels::getLabel('LBL_This_Product_Is_Not_Available_for_Shipping.', $siteLangId), $minShipDuration); ?>
                        </span>
                        <span class="value"></span>
                    </li>

                <?php } elseif ($selectedFullfillmentType == Shipping::FULFILMENT_PICKUP && $fulfillmentType != $selectedFullfillmentType && $fulfillmentType != Shipping::FULFILMENT_ALL) {
                    $selectedFullfillmentType = $fulfillmentType;
                    ?>
                    <li class="list-features-item">
                        <span class="lable">
                            <?php echo sprintf(Labels::getLabel('LBL_This_Product_Is_Not_Available_for_Pickup.', $siteLangId), $minShipDuration); ?>
                        </span>
                        <span class="value"></span>
                    </li>
                <?php } ?>

                <?php if ($selectedFullfillmentType == Shipping::FULFILMENT_SHIP) { ?>
                    <li class="list-features-item">
                        <span class="lable">
                            <?php echo Labels::getLabel('LBL_Ships_to_your_location_in', $siteLangId); ?>
                        </span>
                        <span class="value">
                            <?php echo $minShipDuration . ' ' . Labels::getLabel('LBL_day(s)', $siteLangId); ?>
                        </span>
                    </li>
                <?php } else { ?>
                    <li class="list-features-item">
                        <span class="lable">
                            <?php echo Labels::getLabel('LBL_Available_for_pickup_on', $siteLangId); ?>
                        </span>
                        <span class="value">
                            <?php echo date('d M, Y', strtotime($rentalAvailableDate)); ?>
                        </span>
                    </li>
                <?php } ?>
            <?php } ?>


            <li class="list-features-item">
                <span class="lable">
                    <?php echo Labels::getLabel('LBL_Product_condition', $siteLangId); ?>
                </span>
                <span class="value">
                    <?php echo $conditionArr[$product['sprodata_rental_condition']]; ?>
                </span>
            </li>

        </ul>
        <?php
        $upfrontInPec = 100;
        if (FatApp::getConfig('CONF_ENABLED_PARTIAL_PAYMENT_MODULE', FatUtility::VAR_INT, 0) == 1) {
            
            if ($product['shop_partial_payment_type'] == Shop::SHOP_PARTIAL_PAYMENT_INVENTORY_LEVEL && $product['sprodata_upfront_payment'] != 100) {
                $upfrontInPec = $product['sprodata_upfront_payment'];
            } else if ($product['shop_partial_payment_type'] == Shop::SHOP_PARTIAL_PAYMENT_SHOP_LEVEL && $product['shop_partial_payment_percentage'] != 100) {
                $upfrontInPec = $product['shop_partial_payment_percentage'];
            }
        }
        if ($upfrontInPec != 100) {
            ?>


            <?php echo ' <div class="easy"> <img class="easy-icon" width="40" src="'.CONF_WEBROOT_FRONT_URL.'images/emi.png" />' . sprintf(Labels::getLabel('LBL_For_Long_Durations,_pay_only_%s_upfront,_with_the_remaining_amount_available_through_an_easy_installment_plan.', $siteLangId),$upfrontInPec.'%') . '</div>'; ?>



            <?php
        }
        ?>


        <div class="rental-dates">
            <?php
            if ($displayHourPrice && $displayDayPrice) {
                ?>
                <h5 class="h5"><?php echo Labels::getLabel('LBL_Booking_Options', $siteLangId); ?></h5>
                <div class="durations">
                    <?php
                    if ($displayHourPrice) {
                        ?>
                        <div class="durations-item">
                            <input class="btn-check" id="btn-check-1" name="radio_for_rent_duration_section" type="radio"
                                value="1" checked>
                            <label class="durations-label" for="btn-check-1">
                                <div
                                    class="data <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "disabled" : ""; ?>">
                                    <span class="durations-type">
                                        <?php echo Labels::getLabel('LBL_Hourly_Booking', $siteLangId); ?>
                                    </span>
                                </div>
                                <div
                                    class="atom-radio-drawer_head_right radio <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "disabled" : ""; ?>">
                                </div>
                            </label>
                        </div>
                        <?php
                    }
                    ?>

                    <?php
                    if ($displayDayPrice) {
                        ?>
                        <div class="durations-item">
                            <input class="btn-check" id="btn-check-2" name="radio_for_rent_duration_section" type="radio"
                                value="2">
                            <label class="durations-label" for="btn-check-2">
                                <div
                                    class="data <?php echo ($cartType == applicationConstants::PRODUCT_FOR_SALE) ? "disabled" : ""; ?>">
                                    <span class="durations-type">
                                        <?php echo $product_rental_duration . ' ' . Labels::getLabel('LBL_or_more', $siteLangId); ?>
                                    </span>
                                </div>
                            </label>
                        </div>

                    <?php } ?>

                </div>
                <?php
            }
            ?>
            <div class="get-dates-with-time date-with-time-js d-none">
                <div class="row g-2">
                    <div class="col-md-6">
                        <div class="field-wraper">
                            <div class="field_cover rent-calender date-selector">
                                <div class="form-group">
                                    <label class="form-label" for="rental-start-date-time-js">
                                        <?php echo Labels::getLabel('LBL_Start_Date_&_Time', $siteLangId); ?>
                                    </label>
                                    <?php
                                    $rentalStartDateFld = $frmBuyProduct->getField('rental_start_date');
                                    $rentalStartDateFld->setFieldTagAttribute('id', 'rental-start-date-time-js');
                                    echo $frmBuyProduct->getFieldHtml('rental_start_date'); ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="field-wraper">
                            <div class="field_cover rent-calender date-selector">
                                <div class="form-group">
                                    <label class="form-label"
                                        for="rental-end-date-time-js"><?php echo Labels::getLabel('LBL_End_Date_&_Time', $siteLangId); ?></label>
                                    <?php
                                    $rentalEndDateFld = $frmBuyProduct->getField('rental_end_date');
                                    $rentalEndDateFld->setFieldTagAttribute('id', 'rental-end-date-time-js');
                                    echo $frmBuyProduct->getFieldHtml('rental_end_date'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="get-dates date-without-time-js d-none">
                <div class="row g-2">
                    <div class="col-md-6">
                        <div class="field-wraper">
                            <div class="field_cover rent-calender date-selector">
                                <div class="form-group">
                                    <label class="form-label"
                                        for="rental-start-date-js"><?php echo Labels::getLabel('LBL_Start_Date', $siteLangId); ?></label>
                                    <?php
                                    $rentalStartDateFld = $frmBuyProduct->getField('rental_start_date');
                                    $rentalStartDateFld->setFieldTagAttribute('class', 'rental_datescalendar-without-hour--js--start field--calender');
                                    $rentalStartDateFld->setFieldTagAttribute('id', 'rental-start-date-js');
                                    //$rentalStartDateFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Rental_Start_Date', $siteLangId));
                                    echo $frmBuyProduct->getFieldHtml('rental_start_date'); ?>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-md-6">
                        <div class="field-wraper">
                            <div class="field_cover rent-calender date-selector">
                                <div class="form-group">
                                    <label class="form-label"
                                        for="rental-end-date-js"><?php echo Labels::getLabel('LBL_End_Date', $siteLangId); ?></label>
                                    <?php
                                    $rentalEndDateFld = $frmBuyProduct->getField('rental_end_date');
                                    $rentalEndDateFld->setFieldTagAttribute('class', 'rental_datescalendar-without-hour--js--end field--calender');
                                    $rentalEndDateFld->setFieldTagAttribute('id', 'rental-end-date-js');
                                    //$rentalEndDateFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Rental_End_Date', $siteLangId));
                                    echo $frmBuyProduct->getFieldHtml('rental_end_date'); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php if ($product['sprodata_rental_stock'] > 0 && 0) { ?>
            <div class="bg-gray p-4 rounded my-4">
                <div class="row align-items-center justify-content-between">
                    <div class="col-xl-12">
                        <h6 class="m-0">
                            <?php echo Labels::getLabel('LBL_Enter_Start_Date_And_End_Date_to_Calculate_Rental_Price', $siteLangId); ?>
                        </h6>
                        <p class="mt-2">
                            <small>
                                <?php echo Labels::getLabel('LBL_Rental_Price', $siteLangId); ?>:
                            </small>
                            <small class="rental-price--js">
                                <?php echo CommonHelper::displayMoneyFormat($product['rent_price']); ?>
                            </small> +
                            <small>
                                <?php echo Labels::getLabel('LBL_Rental_Security', $siteLangId); ?>:
                            </small>
                            <small class="text-uppercase rental-security--js">
                                <?php echo ($extendOrderId < 1) ? CommonHelper::displayMoneyFormat($product['sprodata_rental_security']) : Labels::getLabel('LBL_NA', $siteLangId); ?>
                            </small>
                        </p>
                        <h6 class="mt-2">
                            <?php echo Labels::getLabel('LBL_Total_Payment', $siteLangId); ?> :
                            <span class="total-amount--js">
                                <?php echo Labels::getLabel('LBL_Select_Dates_To_Calculate_Amount', $siteLangId); ?>
                            </span>
                        </h6>
                    </div>
                </div>
            </div>
        <?php } ?>
        <?php include(CONF_THEME_PATH_WITH_THEME_NAME . 'products/duration-discount.php'); ?>
        <?php if (!empty($addonProducts)) { ?>
            <div class="modal fade" id="aditional-services-js" role="dialog" aria-labelledby="exampleModalLabel"
                aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="exampleModalLabel">
                                <?php echo Labels::getLabel('LBL_Addon\'s_to_go_with_your_rental_order', $siteLangId) ?>
                            </h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="detail--js">
                                <div class="detial-content scroll scroll-y detial-content--js"></div>
                            </div>
                            <?php if (FatApp::getConfig('CONF_PRODUCT_INCLUSIVE_TAX', FatUtility::VAR_INT, 0)) {
                                echo '<p class="text-small text-muted">' . Labels::getLabel('LBL_Price_Inclusive_All_Taxes', $siteLangId) . '</p>';
                            } ?>

                            <ul class="rental-addons rental-cart-tbl-js">
                                <?php foreach ($addonProducts as $rentalAddon) { ?>
                                    <li class="rental-addons-item">
                                        <label class="rental-addons-label" for="">
                                            <div class="product-profile product-profile-sm">
                                                <div class="product-profile-thumbnail">
                                                    <img src="<?php echo FatCache::getCachedUrl(CommonHelper::generateUrl('Image', 'addonProduct', array($rentalAddon['selprod_id'], 'THUMB', 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
                                                        alt="<?php echo $rentalAddon['selprod_title']; ?>">
                                                </div>
                                                <div class="product-profile-data">
                                                    <div class="title">
                                                        <?php echo html_entity_decode($rentalAddon['selprod_title']); ?>
                                                    </div>
                                                    <button type="button"
                                                        onClick="viewServiceDetails(<?php echo $rentalAddon['selprod_id']; ?>)"
                                                        class="link-underline">
                                                        <?php echo Labels::getLabel('LBL_Details', $siteLangId); ?>
                                                    </button>
                                                    <div class="service-details--js"
                                                        id="service_detail_<?php echo $rentalAddon['selprod_id']; ?>"
                                                        style="display:none;">
                                                        <?php echo html_entity_decode(nl2br($rentalAddon['selprod_rental_terms']??'')); ?>
                                                    </div>

                                                </div>

                                            </div>

                                            <div class="price">
                                                <strong>
                                                    <?php echo CommonHelper::displayMoneyFormat($rentalAddon['selprod_price']); ?>
                                                </strong>
                                            </div> <?php if (1 > $extendOrderId) { ?>
                                                <span class="switch switch-sm">
                                                    <input type="checkbox" name="check_addons" id="check_addons"
                                                        data-attrname="rental_addons[<?php echo $rentalAddon['selprod_id'] ?>]"
                                                        data-rentalqty="1">
                                                </span>
                                            <?php } ?>

                                        </label>

                                    </li>
                                <?php } ?>
                            </ul>

                        </div>
                        <div class="modal-footer addon-actions--js">
                            <button type="button" class="btn btn-outline-gray close-detail--js" style="display: none;">
                                <?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>
                            </button>
                            <button type="button" class="btn btn-outline-brand continue-rental-cart--js skipServicesJs">
                                <?php echo Labels::getLabel('LBL_Skip', $siteLangId); ?>
                            </button>
                            <button type="button" class="btn btn-brand continue-rental-cart--js">
                                <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        <?php } ?>
        <div class="price-breakup-link price-breakup-link-js d-none" onclick="$('#price-breakup-js').modal('show')">
            <button type="button"
                class="link-brand link-underline"><?php echo Labels::getLabel('LBL_View_price_breakup', $siteLangId); ?></button>
        </div>
    </div>
    <?php if (FatApp::getConfig('CONF_ALLOW_PENALTY_ON_RENTAL_ORDER_CANCEL_FROM_BUYER', FatUtility::VAR_INT, 0)) { ?>
        <div class="modal fade" id="penaltyModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel"
            aria-hidden="true" style="display:none;">
            <div class="modal-dialog modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="exampleModalLabel">
                            <?php echo Labels::getLabel('LBL_Penalty_Rules', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body">
                        <?php
                        if (!empty($orderCancelPenaltyRules)) {
                            echo '<table class="table "><thead>
                                        <tr>
                                        <th>' . Labels::getLabel('LBL_Cancellation_Duration(Hours)', $siteLangId) . '</th>
                                        <th>' . Labels::getLabel('LBL_Refundable_Amount', $siteLangId) . '</th>
                                        </tr></thead><tbody>';
                            foreach ($orderCancelPenaltyRules as $rule) { ?>
                                <tr>
                                    <td>
                                        <?php $maxDurationLabel = ($rule['ocrule_duration_max'] == -1) ? Labels::getLabel('LBL_Infinity', $siteLangId) : $rule['ocrule_duration_max']; ?>

                                        <?php echo $rule['ocrule_duration_min'] . ' - ' . $maxDurationLabel . ' ' . Labels::getLabel('LBL_Hours', $siteLangId); ?>
                                    </td>
                                    <td>
                                        <?php echo $rule['ocrule_refund_amount'] . ' %'; ?>
                                    </td>
                                </tr>
                                <?php
                            }
                            echo '</tbody></table>';
                        }
                        ?>

                    </div>
                </div>
            </div>
        </div>
    <?php } ?>
    <div class="atom-radio-drawer_foot">
        <div class="conditions-links">
            <?php $labelTxt = ($checkType == Shipping::FULFILMENT_PICKUP) ? Labels::getLabel('LBL_Check_Pickup_Locations', $siteLangId) : Labels::getLabel('LBL_Calculate_Shipping_Charges', $siteLangId); ?>
            <?php if (($checkType == Shipping::FULFILMENT_PICKUP && $product['sprodata_fullfillment_type'] != Shipping::FULFILMENT_SHIP) || ($checkType == Shipping::FULFILMENT_SHIP && $product['sprodata_fullfillment_type'] != Shipping::FULFILMENT_PICKUP)) { ?>
                <button type="button" class="link-brand link-underline"
                    onClick="getFullfillmentData(<?php echo $checkType; ?>, <?php echo applicationConstants::PRODUCT_FOR_RENT; ?>, <?php echo $product['selprod_id']; ?>)">
                    <?php echo $labelTxt; ?>
                </button>
            <?php } ?>


            <?php if (FatApp::getConfig('CONF_ALLOW_PENALTY_ON_RENTAL_ORDER_CANCEL_FROM_BUYER', FatUtility::VAR_INT, 0)) { ?>
                <button type="button" class="link-brand link-underline" type="button" data-bs-toggle="modal"
                    data-bs-target="#penaltyModal">
                    <?php echo Labels::getLabel('LBL_Cancellation_policy', $siteLangId); ?>
                </button>
            <?php } ?>
        </div>
        <div class="action"> <?php
        $btnAddToCartFld = $frmBuyProduct->getField('btnAddToCart');
        $btnAddToCartFld->addFieldTagAttribute('class', 'btn btn-brand');
        echo $frmBuyProduct->getFieldHtml('selprod_id');
        echo $frmBuyProduct->getFieldHtml('fulfillmentType');
        echo $frmBuyProduct->getFieldHtml('product_for');
        echo $frmBuyProduct->getFieldHtml('extend_order');
        echo $frmBuyProduct->getFieldHtml('btnAddToCart');
        ?>
        </div>
    </div>
</div>