<div class="modal-dialog modal-dialog-centered" role="document" id="brand-req-form">
    <div class="modal-content">
        <div class="modal-header">
            <h5 class="modal-title"><?php echo Labels::getLabel('LBL_Add_Wallet_Credits', $siteLangId) ?></h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">
            </button>
        </div>
        <div class="modal-body">
            <div class="box__body">
                <?php
                $frmRechargeWallet->setFormTagAttribute('onSubmit', 'setUpWalletRecharge(this); return false;');
                $frmRechargeWallet->setFormTagAttribute('class', 'form');
                $frmRechargeWallet->developerTags['colClassPrefix'] = 'col-md-';
                $frmRechargeWallet->developerTags['fld_default_col'] = 12;
                $frmRechargeWallet->setRequiredStarPosition(Form::FORM_REQUIRED_STAR_WITH_NONE);

                $amountFld = $frmRechargeWallet->getField('amount');
                $amountFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Enter_Amount', $siteLangId));
                $amountFld->developerTags['noCaptionTag'] = true;
                $amountFld->developerTags['col'] = 7;
                if ($pendingLateCharges > 0) {
                    $amountFld->htmlAfterField = '<span class="form-text text-muted">' . CommonHelper::displayMoneyFormat($pendingLateCharges, true, true) . ' ' . Labels::getLabel('LBL_pending_charges_will_be_deducted_from_your_wallet', $siteLangId) . '</span>';
                }

                $buttonFld = $frmRechargeWallet->getField('btn_submit');
                $buttonFld->setFieldTagAttribute('class', 'btn-block block-on-mobile');
                $buttonFld->developerTags['noCaptionTag'] = true;
                $buttonFld->developerTags['col'] = 5;
                $buttonFld->setFieldTagAttribute('class', "btn btn-gray btn-block");
                echo $frmRechargeWallet->getFormHtml();
                ?>
            </div>

        </div>
    </div>
</div>