<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');
$frmSrch->setFormTagAttribute('onSubmit', 'searchCredits(this); return false;');
$frmSrch->setFormTagAttribute('class', 'form form-search');
$frmSrch->developerTags['colClassPrefix'] = 'col-md-';
$frmSrch->developerTags['fld_default_col'] = 12;

$keyFld = $frmSrch->getField('keyword');
$keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Keyword', $siteLangId));
$keyFld->setWrapperAttribute('class', 'col-lg-6');
$keyFld->developerTags['col'] = 6;

$keyFld = $frmSrch->getField('debit_credit_type');
$keyFld->setWrapperAttribute('class', 'col-lg-6');
$keyFld->developerTags['col'] = 6;

$keyFld = $frmSrch->getField('date_from');
$keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_From_Date', $siteLangId));
$keyFld->setWrapperAttribute('class', 'col-lg-4');
$keyFld->developerTags['col'] = 4;

$keyFld = $frmSrch->getField('date_to');
$keyFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_To_Date', $siteLangId));
$keyFld->setWrapperAttribute('class', 'col-lg-4');
$keyFld->developerTags['col'] = 4;

$submitBtnFld = $frmSrch->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn-block');
$submitBtnFld->setWrapperAttribute('class', 'col-lg-2');
$submitBtnFld->developerTags['col'] = 2;
$cancelBtnFld = $frmSrch->getField('btn_clear');
$cancelBtnFld->setFieldTagAttribute('class', 'btn-block');
$cancelBtnFld->setWrapperAttribute('class', 'col-lg-2');
$cancelBtnFld->developerTags['col'] = 2;

$displayTab = 1;
if($promotionWalletToBeCharged){
    $displayTab++;
}
if($withdrawlRequestAmount){
    $displayTab++;
}
if($userTotalWalletBalance != $userWalletBalance){
    $displayTab++;
}

if($displayTab == 1 || $displayTab == 2){
    $colbalance = 6;
}else if($displayTab == 3){
    $colbalance = 4;
}else if($displayTab == 4){
    $colbalance = 3;
}

?> <?php $this->includeTemplate('_partial/dashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_My_Credits', $siteLangId); ?></h2>
            </div>
            <div class="content-header-toolbar">
                <?php if ($canAddMoneyToWallet) { ?>
                <div class="links-inline">
                    <button type="button" class="btn btn-outline-gray qwer  btn-add" title="<?php echo Labels::getLabel('LBL_Add_Credits', $siteLangId); ?>" onClick="addCreditReqForm();">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_Add_Credits', $siteLangId); ?></button>
                </div>
                <?php } ?>
            </div>
        </div>
        <div class="content-body">
            <div class="card d-none withdrawForm">
                <div id="withdrawalReqForm"></div>
            </div>
            <div id="credits-info"></div>
           
            <div class="gap"></div>
            <div class="card">
                <div class="card-head">
                    <h5 class="card-title"><?php echo Labels::getLabel('LBL_Search_Transactions', $siteLangId); ?></h5>
                </div>
                <div class="card-head">
                    <?php
                    $submitFld = $frmSrch->getField('btn_submit');
                    $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');

                    $fldClear = $frmSrch->getField('btn_clear');
                    $fldClear->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
                    echo $frmSrch->getFormHtml();
                    ?>
                </div>
            </div>
            <div class="card">
                <?php if ($codMinWalletBalance > -1) { ?>
                <div class="cards-header pb-0">
                    <p class="note"><?php echo Labels::getLabel('MSG_Minimum_balance_Required_For_COD', $siteLangId) . ' : <starong>' . CommonHelper::displaymoneyformat($codMinWalletBalance); ?></strong< /p>
                </div>
                <?php } ?>
                <div class="card-table">
                    <div id="creditListing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?></div>
                </div>
            </div>
        </div>
    </div>
</main>