<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php if (!empty($records)) { ?>

    <ul class="list-notifications">
        <li class="list-notifications-item list-notifications-head">
            <?php echo Labels::getLabel('LBL_RFQ_Notifications', $siteLangId); ?>
        </li>
        <?php
        $statusArr = RequestForQuote::statusArray($siteLangId);
        foreach ($records as $notification) { ?>
            <li class="list-notifications-item <?php echo ($notification['unotification_is_read'] == 1) ? "note" : ""; ?>">
                <button type="button" class="list-notifications-link" onclick="markNotificationRead(<?php echo $notification['unotification_id']; ?>)">

                    <span class="desc">
                        <?php
                        $message = '';
                        $notiData = json_decode($notification['unotification_data'], true);
                        switch ($notification['unotification_type']) {
                            case Notifications::NEW_RFQ_SUBMISSION:
                                $selprodName = SellerProduct::getProductDisplayTitle($notiData['product_id'], $siteLangId);
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_NEW_QUOTATION_REQUEST_IS_SUBMITTED_FOR_YOUR_PRODUCT', $siteLangId) . ' ' . $selprodName;
                                if ($notiData['rfq_parent_id'] > 0) {
                                    $message = '(# '.$notiData['rfq_parent_id'].')' . Labels::getLabel('LBL_RE-QUOTATION_REQUEST_IS_SUBMITTED_FOR_YOUR_PRODUCT', $siteLangId) . ' ' . $selprodName;
                                }
                                break;
                            case Notifications::NEW_RFQ_OFFER_SUBMISSION_BY_SELLER:
                            case Notifications::NEW_RFQ_OFFER_SUBMISSION_BY_BUYER:
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_Offer_is_submitted_on_your_request_by', $siteLangId) . ' ' . $notiData['user_name'];
                                break;
                            case Notifications::NEW_RFQ_OFFER_UPDATE_BY_SELLER:
                            case Notifications::NEW_RFQ_OFFER_UPDATE_BY_BUYER:
                                $newStatus = $statusArr[$notiData['new_status_id']];
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_OFFER_STATUS_UPDATED_BY', $siteLangId) . ' ' . $notiData['user_name'] . ' ' . Labels::getLabel('LBL_AS_', $siteLangId) . ' ' . $newStatus;  
                                break;
                            case Notifications::INVOICE_SHARED_BY_SELLER:
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_NEW_INVOICE_IS_GENERATED_FOR_YOUR_REQUEST', $siteLangId);
                                break;
                            case Notifications::RFQ_CLOSED_BY_ADMIN:
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_RFQ_CLOSED_BY_ADMIN', $siteLangId);
                                break;

                            case Notifications::INVOICE_REGENERATE_REQUEST_BY_BUYER:
                                $message = '(# '.$notiData['rfq_id'].')' . Labels::getLabel('LBL_NEW_INVOICE_REGENRATION_REQUEST_IS_SUBMITTED_BY', $siteLangId) . ' ' . $notiData['user_name'] . '(' . $notiData['order_id']. ')' ;;
                                break;
                        }

                        echo $message;
                        ?>
                    </span>
                    <span class="date">
                        <?php echo FatDate::format($notification['unotification_date'], true); ?></span>

                </button>
            </li>
        <?php } ?>
    </ul>
<?php } ?>