$(document).ready(function(){
	searchAddresses();
});

(function() {
	var runningAjaxReq = false;
	var dv = '#listing';

	checkRunningAjax = function(){
		if( runningAjaxReq == true ){
			console.log(runningAjaxMsg);
			return;
		}
		runningAjaxReq = true;
	};

	searchAddresses = function(){
		$(dv).html(fcom.getLoader());
		fcom.ajax(fcom.makeUrl('Account','searchAddresses'),'',function(res){
			$(dv).html(res);
		});
	};

	addAddressForm = function(id){
		$(dv).html(fcom.getLoader());
		fcom.ajax(fcom.makeUrl('Account', 'addAddressForm', [id]), '', function(t) {
			$(dv).html(t);
		});
	};

	setupAddress = function(frm){
		if (!$(frm).validate()) return;
		var data = fcom.frmData(frm);
		fcom.updateWithAjax(fcom.makeUrl('Addresses', 'setUpAddress'), data, function(t) {
			if($(frm.addr_id).val() == 0 && isAlreadyExistsAddress == 1){
				setDefaultAddress(t.addr_id);
			}
			searchAddresses();
		});
	};

	setDefaultAddress = function(id, e){
		if( !confirm(langLbl.confirmDefault) ){
			if(e){
				e.preventDefault();
			}
			return false;
		}
		data='id='+id;
		fcom.updateWithAjax(fcom.makeUrl('Addresses','setDefault'),data,function(res){
			searchAddresses();
		});
	};

	removeAddress = function(id){
		var agree = confirm(langLbl.confirmDelete);
		if( !agree ){
			return false;
		}
		data='id='+id;
		fcom.updateWithAjax(fcom.makeUrl('Addresses','deleteRecord'),data,function(res){
			searchAddresses();
		});
	};

})();
function initMap(lat = 40.72, lng = -73.96, elementId = "map") {
    var lat = parseFloat(lat);
    var lng = parseFloat(lng);
    var latlng = { lat: lat, lng: lng };
    var address = "";
    if (1 > $("#" + elementId).length) {
      return;
    }
    map = new google.maps.Map(document.getElementById(elementId), {
      zoom: 12,
      center: latlng,
    });
    geocoder = new google.maps.Geocoder();
    infowindow = new google.maps.InfoWindow();
  
    geocodeAddress(geocoder, map, infowindow, { location: latlng });

    document.getElementById("addr_zip").addEventListener("blur", function () {
        var sel = document.getElementById("addr_country_id");
        var country = sel.options[sel.selectedIndex].text;
    
        var sel = document.getElementById("addr_state_id");
        var state = sel.options[sel.selectedIndex].text;
    
        zipcode = document.getElementById("addr_zip").value;
        city = document.getElementById("addr_city").value;
        address1 = document.getElementById("addr_address1").value;
        address = country + " " + state + " " + city + " " + zipcode + " " + address1;
        geocodeAddress(geocoder, map, infowindow, { address: address }, false);
    });
  
    document.getElementById("addr_state_id").addEventListener("change", function () {
      var sel = document.getElementById("addr_country_id");
      var country = sel.options[sel.selectedIndex].text;
  
      var sel = document.getElementById("addr_state_id");
      var state = sel.options[sel.selectedIndex].text;	
  
      address = country + " " + state;
  
      geocodeAddress(geocoder, map, infowindow, { address: address });
    });
  
    document.getElementById("addr_country_id").addEventListener("change", function () {
        var sel = document.getElementById("addr_country_id");
        var country = sel.options[sel.selectedIndex].text;
        geocodeAddress(geocoder, map, infowindow, { address: country });
      });

      
      document.getElementById('ga-autoComplete').addEventListener("keydown", function(event) {
        if (event.key === "Enter") {
          event.preventDefault();
        }
      });

  }
  
  function geocodeAddress(
    geocoder,
    resultsMap,
    infowindow,
    address,
    isPostcodeChange = false
  ) {
    geocoder.geocode(address, function (results, status) {
      if (status === google.maps.GeocoderStatus.OK) {
        resultsMap.setCenter(results[0].geometry.location);
        if (marker && marker.setMap) {
          marker.setMap(null);
        }
        marker = new google.maps.Marker({
          map: resultsMap,
          position: results[0].geometry.location,
          draggable: true,
        });
        geocodeSetData(results, isPostcodeChange);
        google.maps.event.addListener(marker, "dragend", function () {
          geocoder.geocode(
            { latLng: marker.getPosition() },
            function (results, status) {
              if (status == google.maps.GeocoderStatus.OK) {
                geocodeSetData(results, isPostcodeChange);
              }
            }
          );
        });
      } else {
        console.log(
          "Geocode was not successful for the following reason: " + status
        );
      }
    });
  }

  function geocodeSetData(results, isPostcodeChange = false) {
    document.getElementById("lat").value = marker.getPosition().lat();
    document.getElementById("lng").value = marker.getPosition().lng();
    if (results[0]) {
      infowindow.setContent(results[0].formatted_address);
      infowindow.open(map, marker);
      var address_components = results[0].address_components;
      var data = {};
      data["formatted_address"] = results[0].formatted_address;
      if ($('#ga-autoComplete').length > 0) {
        $('#ga-autoComplete').val(data["formatted_address"]);
      }
      if (0 < address_components.length) {
        var addressComponents = address_components;
        for (var i = 0; i < addressComponents.length; i++) {
          var key = address_components[i].types[0];
          var value = address_components[i].long_name;
          data[key] = value;
          if ("country" == key) {
            data["country_code"] = address_components[i].short_name;
            data["country"] = value;
          } else if ("administrative_area_level_1" == key) {
            data["state_code"] = address_components[i].short_name;
            data["state"] = value;
          } else if ("administrative_area_level_2" == key) {
            data["city"] = value;
          }
        }
      }
      if (isPostcodeChange) {
        $("#postal_code").val(data.postal_code);
      }
  
      $("#addr_country_id option").each(function () {
        if (this.text == data.country) {
          var state = 0;
          $("#addr_state_id option").each(function () {
            if (
              this.value == data.state_code ||
              this.text == data.state ||
              this.text == data.locality
            ) {
              return (state = this.value);
            }
          });
          return false;
        }
      });
    }
  }