<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
$promotionLangFrm->setFormTagAttribute('onsubmit', 'setupPromotionLang(this); return(false);');
$promotionLangFrm->setFormTagAttribute('class', 'form form--horizontal layout--' . $formLayout);
$promotionLangFrm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
$promotionLangFrm->developerTags['fld_default_col'] = 12;

$langFld = $promotionLangFrm->getField('lang_id');
$langFld->setfieldTagAttribute('onChange', "promotionLangForm(" . $promotion_id . ", this.value);");
?>


<div class="row">
    <div class="col-md-12">
        <div class="tabs tabs-sm clearfix">
            <ul>
                <li><button type="button" onClick="promotionGeneralForm(<?php echo $promotion_id ?>)"><?php echo Labels::getLabel('LBL_General', $siteLangId); ?></button></li>
                <?php $inactive = ($promotion_id == 0) ? 'fat-inactive' : ''; ?>
                <li class="<?php echo (0 < $formLangId) ? 'is-active' : '';
                            echo $inactive; ?>">
                    <button>
                        <?php echo Labels::getLabel('LBL_Language_Data', $siteLangId); ?>
                    </button>
                </li>
                <li class="<?php echo $inactive; ?>"><button type="button"  onClick="promotionMediaForm(<?php echo $promotion_id; ?>)"><?php echo Labels::getLabel('LBL_Media', $siteLangId); ?></button></li>
            </ul>
        </div>

        <div class="form__subcontent">
            <?php
            $translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
            $siteDefaultLangId = FatApp::getConfig('conf_default_site_lang', FatUtility::VAR_INT, 1);
            if (!empty($translatorSubscriptionKey) && $formLangId != $siteDefaultLangId) { ?>
                <div class="row justify-content-end">
                    <div class="col-auto mb-4">
                        <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="promotionLangForm(<?php echo $promotion_id; ?>, <?php echo $formLangId; ?>, 1)">
                            <svg class="svg" width="24" height="24">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
                            </svg>
                            <!-- <?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?> -->
                        </button>
                    </div>
                </div>
            <?php } ?>
            <?php echo $promotionLangFrm->getFormTag();
            echo $promotionLangFrm->getFormHtml(false);
            echo '</form>'; ?>
        </div>
    </div>
</div>