<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Rental_Addons', $siteLangId); ?><i class="fa fa-info-circle" data-bs-toggle="tooltip" data-placement="right" title="<?php echo Labels::getLabel('LBL_Rental_addon_can_be_linked_with_a_product_for_rent,_which_will_be_rented_together.', $siteLangId); ?>"></i></h2>
                <span class="form-text text-muted">(<?php echo Labels::getLabel('LBL_Valid_Only_With_Rental_Products', $siteLangId); ?>)</span>
            </div>
            <?php if ($canEdit) { ?>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <a class="btn btn-outline-gray qwer  btn-add" title="<?php echo Labels::getLabel('LBL_Add_Rental_Addons', $siteLangId); ?>" href="<?php echo UrlHelper::generateUrl('AddonProducts', 'form'); ?>">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_Add_Rental_Addons', $siteLangId); ?></a>
                </div>
            </div>
            <?php } ?>
        </div>
        <div class="content-form">
            <?php
            $searchForm->setFormTagAttribute('id', 'frmSearchAddonProduct');
            $searchForm->setFormTagAttribute('class', 'form form-search');
            $searchForm->setFormTagAttribute('onsubmit', 'searchAddonProducts(this); return(false);');
            $searchForm->getField('keyword')->addFieldTagAttribute('placeholder', Labels::getLabel('LBL_Search_By_Addon_Name', $siteLangId));
            $searchForm->developerTags['colClassPrefix'] = 'col-md-';
            $searchForm->developerTags['fld_default_col'] = 12;
            $keywordFld = $searchForm->getField('keyword');
            $keywordFld->setWrapperAttribute('class', 'col-lg-6');
            $keywordFld->developerTags['col'] = 6;
            $typeFld = $searchForm->getField('addonprod_active');
            $typeFld->setWrapperAttribute('class', 'col-lg-2');
            $typeFld->developerTags['col'] = 2;
            $submitFld = $searchForm->getField('btn_submit');
            $submitFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
            $submitFld->setWrapperAttribute('class', 'col-lg-2');
            $submitFld->developerTags['col'] = 2;

            $fldClear = $searchForm->getField('btn_clear');
            $fldClear->setFieldTagAttribute('onclick', 'clearSearch()');
            $fldClear->setFieldTagAttribute('class', ' btn btn-gray btn-clear');
            $fldClear->setWrapperAttribute('class', 'col-lg-2');
            $fldClear->developerTags['col'] = 2;

            echo $searchForm->getFormHtml();
            ?>

        </div>

        <div class="content-body">
            <div class="card">
                <div class="card-table">
                    <div id="addon-products-listing-js"></div>
                </div>
            </div>
        </div>
    </div>
</main>

<script type="text/javascript">
(function() {
    var runningAjaxMsg = 'some requests already running or this stucked into runningAjaxReq variable value, so try to relaod the page and update the same to WebMaster. ';
    var runningAjaxReq = false;
    var dv = '#addon-products-listing-js';

    checkRunningAjax = function() {
        if (runningAjaxReq == true) {
            console.log(runningAjaxMsg);
            return;
        }
        runningAjaxReq = true;
    };

    searchAddonProducts = function(frm) {
        checkRunningAjax();
        /*[ this block should be written before overriding html of 'form's parent div/element, otherwise it will through exception in ie due to form being removed from div */
        var data = fcom.frmData(frm);
        /*]*/
        $(dv).html(fcom.getLoader());

        fcom.ajax(fcom.makeUrl('AddonProducts', 'search'), data, function(res) {
            runningAjaxReq = false;
            $(dv).html(res);
        });
    };

    clearSearch = function() {
        document.frmSearchAddonProduct.reset();
        searchAddonProducts(document.frmSearchAddonProduct);
    };

    goToAddonProductSearchPage = function(page) {
        if (typeof page == undefined || page == null) {
            page = 1;
        }
        var frm = document.frmSearchAddonProduct;
        $(frm.page).val(page);
        searchAddonProducts(frm);
    }

})();

function changeStatus(addonProdId, status) {
    var data = 'addonProdId=' + addonProdId + '&status=' + status;
    fcom.updateWithAjax(fcom.makeUrl('AddonProducts', 'changeStatus'), data, function(t) {
        window.location.reload();
    });
}

function attachAddonForm(addonId) {
    var url = fcom.makeUrl('AttachAddonPoducts', 'index');
    var input = '<input type="hidden" name="addonId" value="' + addonId + '">';
    $('<form action="' + url + '" method="POST">' + input + '</form>').appendTo($(document.body)).submit();
}


searchAddonProducts();
</script>