<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/advertiser/advertiserDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Promotion_Analytics', $siteLangId); ?></h2>
            </div>
        </div>
        <div class="content-body">
            <div class="card">
                <div class="card-head">
                    <h5 class="card-title "><?php echo ucfirst($promotionDetails['promotion_name']); ?></h5>
                    <div class="card-head-toolbar">
                        <div class="links-inline">
                            <a class="btn btn-outline-gray qwer" href="<?php echo UrlHelper::generateUrl('advertiser', 'promotions'); ?>">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#promotions">
                                    </use>
                                </svg>
                                <?php echo Labels::getLabel('LBL_My_promotions', $siteLangId); ?></a>
                        </div>
                    </div>
                </div>
                <div class="card-head">
                    <?php
                    $searchForm->setFormTagAttribute('class', 'form form-search');
                    $searchForm->setFormTagAttribute('onsubmit', 'searchAnalytics(this); return false;');
                    $searchForm->developerTags['colClassPrefix'] = 'col-md-';
                    $searchForm->developerTags['fld_default_col'] = 4;
                    $fldSubmit = $searchForm->getField('btn_submit');

                    $dateFromFld = $searchForm->getField('date_from');
                    $dateFromFld->setFieldTagAttribute('class', 'field--calender');
                    $dateFromFld->setWrapperAttribute('class', 'col-lg-4');
                    $dateFromFld->developerTags['col'] = 4;
                    $dateFromFld->developerTags['noCaptionTag'] = true;

                    $dateToFld = $searchForm->getField('date_to');
                    $dateToFld->setFieldTagAttribute('class', 'field--calender');
                    $dateToFld->setWrapperAttribute('class', 'col-lg-4');
                    $dateToFld->developerTags['col'] = 4;
                    $dateToFld->developerTags['noCaptionTag'] = true;

                    $submitBtnFld = $searchForm->getField('btn_submit');
                    $submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
                    $submitBtnFld->setWrapperAttribute('class', 'col-sm-6 ');
                    $submitBtnFld->developerTags['col'] = 2;
                    $submitBtnFld->developerTags['noCaptionTag'] = true;

                    $cancelBtnFld = $searchForm->getField('btn_clear');
                    $cancelBtnFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
                    $cancelBtnFld->setWrapperAttribute('class', 'col-sm-6 ');
                    $cancelBtnFld->developerTags['col'] = 2;
                    $cancelBtnFld->developerTags['noCaptionTag'] = true;

                    echo $searchForm->getFormHTML(); ?>
                </div>
                <div class="card-table">
                    <div id="ppcListing"></div>
                </div>
            </div>

        </div>
    </div>
</main>