<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/advertiser/advertiserDashboardNavigation.php'); ?>
<main id="main-area" class="main">
    <div class="content content-wrapper content-space">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading"><?php echo Labels::getLabel('LBL_Promotions', $siteLangId); ?></h2>
                <p class="form-text text-muted"><?php echo Labels::getLabel('MSG_Minimum_balance_Required_For_Promotions', $siteLangId) . ' : '; ?>
                    <span class="d-inline-block"><?php echo CommonHelper::displayMoneyFormat(FatApp::getConfig('CONF_PPC_MIN_WALLET_BALANCE')); ?></span>
                </p>
            </div>
            <div class="content-header-toolbar">
                <div class="links-inline">
                    <?php if ($canEdit) { ?>
                    <button class="btn btn-outline-gray qwer  btn-add" onClick="promotionForm()" type="button">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                            </use>
                        </svg><?php echo Labels::getLabel('LBL_Add_Promotion', $siteLangId); ?></button>

                    <?php } ?>
                    <button class="btn btn-outline-gray qwer" onClick="reloadList()" type="button">
                        <svg class="svg" width="16" height="16">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#promotions">
                            </use>
                        </svg>
                        <?php echo Labels::getLabel('LBL_My_promotions', $siteLangId); ?></button>
                </div>
            </div>
        </div>
        <div class="content-form formshowhide-js">
            <div id="promotionForm">
                    <?php
                    $frmSearchPromotions->setFormTagAttribute('id', 'frmSearchPromotions');
                    $frmSearchPromotions->setFormTagAttribute('class', 'form form-search');
                    $frmSearchPromotions->setFormTagAttribute('onsubmit', 'searchPromotions(this); return(false);');

                    $frmSearchPromotions->developerTags['colClassPrefix'] = 'col-md-';
                    $frmSearchPromotions->developerTags['fld_default_col'] = 4;
                    $frmSearchPromotions->developerTags['noCaptionTag'] = true;

                    $keywordFld = $frmSearchPromotions->getField('keyword');
                    $keywordFld->setWrapperAttribute('class', 'col-lg-4');
                    $keywordFld->developerTags['col'] = 4;

                    $statusFld = $frmSearchPromotions->getField('active_promotion');
                    $statusFld->setWrapperAttribute('class', 'col-lg-2');
                    $statusFld->developerTags['col'] = 2;

                    $typeFld = $frmSearchPromotions->getField('type');
                    $typeFld->setWrapperAttribute('class', 'col-lg-2');
                    $typeFld->developerTags['col'] = 2;

                    $dateFromFld = $frmSearchPromotions->getField('date_from');
                    $dateFromFld->setFieldTagAttribute('class', 'field--calender');
                    $dateFromFld->setWrapperAttribute('class', 'col-lg-2');
                    $dateFromFld->developerTags['col'] = 2;

                    $dateToFld = $frmSearchPromotions->getField('date_to');
                    $dateToFld->setFieldTagAttribute('class', 'field--calender');
                    $dateToFld->setWrapperAttribute('class', 'col-lg-2');
                    $dateToFld->developerTags['col'] = 2;

                    $submitBtnFld = $frmSearchPromotions->getField('btn_submit');
                    $submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block ');
                    $submitBtnFld->setWrapperAttribute('class', 'col-lg-2');
                    $submitBtnFld->developerTags['col'] = 2;
                    $submitBtnFld->developerTags['noCaptionTag'] = true;

                    $cancelBtnFld = $frmSearchPromotions->getField('btn_clear');
                    $cancelBtnFld->setFieldTagAttribute('class', 'btn btn-block btn-outline-brand');
                    $cancelBtnFld->setWrapperAttribute('class', 'col-lg-2');
                    $cancelBtnFld->developerTags['col'] = 2;
                    $cancelBtnFld->developerTags['noCaptionTag'] = true;
                    echo $frmSearchPromotions->getFormHtml();
                    ?>
            </div>
        </div>
        <div class="content-body">
            <div class="card card-tabs">
                <div class="card-table">
                    <div id="listing">
                        <?php echo Labels::getLabel('LBL_Loading..', $siteLangId); ?>
                    </div>
                </div>
            </div>
        </div>

    </div>
</main>