<?php
$navData = (isset($activeAction)) ? ['action' => $activeAction, 'controller' => 'buyer'] : ['action' => 'orders', 'controller' => 'buyer'];
if ($orderDetail['order_is_rfq'] == applicationConstants::YES) {
    $navData = array(
        'controller' => 'requestforquotes',
        'action' => 'orders'
    );
}
$this->includeTemplate('_partial/dashboardNavigation.php', ['navData' => $navData]);
$canExtendOrder = true;
$canCancelOrder = false;
$canReturnRefund = false;
$canReviewOrders = false;
$canSubmitFeedback = false;
$orderStatusArr = Orders::getOrderPaymentStatusArr($siteLangId);

$isrentalOrder = false;
if (true == $primaryOrder) {
    $canCancelOrder = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderCancellationStatuses()));
    $canReturnRefund = (in_array($childOrderDetail["op_status_id"], (array) Orders::getBuyerAllowedOrderReturnStatuses()));
    if (in_array($childOrderDetail["op_status_id"], SelProdReview::getBuyerAllowedOrderReviewStatuses())) {
        $canReviewOrders = true;
    }
    $canSubmitFeedback = Orders::canSubmitFeedback($childOrderDetail['order_user_id'], $childOrderDetail['order_id'], $childOrderDetail['op_selprod_id']);
    if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_SALE) {
        $cancelAge = $childOrderDetail['selprod_cancellation_age'];
        $returnAge = $childOrderDetail['selprod_return_age'];
        if ($childOrderDetail['selprod_cancellation_age'] == '') {
            $cancelAge = $childOrderDetail['shop_cancellation_age'];
        }
        if ($childOrderDetail['selprod_return_age'] == '') {
            $returnAge = $childOrderDetail['shop_return_age'];
        }
        $daysSpent = round((time() - strtotime($childOrderDetail['order_date_added'])) / (60 * 60 * 24));
        $canCancelOrder = (empty($cancelAge) || $cancelAge < $daysSpent) ? false : $canCancelOrder;
        $canReturnRefund = ($returnAge < $daysSpent) ? false : $canReturnRefund;
    }
    if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
        $isrentalOrder = true;
    }

    if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT && strtotime($childOrderDetail['opd_rental_start_date']) <= strtotime(date('Y-m-d'))) {
        $canReturnRefund = false;
    }

    if ($childOrderDetail['opd_extend_from_op_id'] > 0) {
        $canReturnRefund = false;
    }

    if (isset($returnAge) && $returnAge <= 0) {
        $canReturnRefund = false;
    }

    if (!FatApp::getConfig('CONF_ALLOW_RENTAL_ORDER_CANCEL_FROM_BUYER_END', FatUtility::VAR_INT, 0)) {
        $canCancelOrder = false;
    }
}

?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <h2 class="content-header-heading no-print">
                    <?php if ($orderDetail['order_is_rfq'] == applicationConstants::YES) { ?>
                        <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_to_messages', $siteLangId); ?>"
                            href="<?php echo UrlHelper::generateUrl('requestForQuotes', 'orders'); ?>">
                            <svg class="svg" width="24" height="24">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                                </use>
                            </svg>
                        </a>
                        <?php
                        echo Labels::getLabel('LBL_RFQ_Order', $siteLangId);
                    } else {
                        echo Labels::getLabel('LBL_Order_Details', $siteLangId);
                    } ?>
                </h2>
            </div>

            <?php if (true == $primaryOrder) { ?>
                <div class="content-header-toolbar">
                    <div class="links-inline no-print">
       

                        <?php if ($canCancelOrder && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                            <a class="btn btn-outline-gray qwer no-print"
                                href="<?php echo UrlHelper::generateUrl('Buyer', 'orderCancellationRequest', array($childOrderDetail['op_id'])); ?>">
                                <?php echo Labels::getLabel('LBL_Cancel_Order', $siteLangId); ?>
                            </a>
                        <?php } ?>
                        <?php if (FatApp::getConfig("CONF_ALLOW_REVIEWS", FatUtility::VAR_INT, 0) && $canReviewOrders && $canSubmitFeedback && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) { ?>
                            <a class="btn btn-outline-gray qwer no-print"
                                href="<?php echo UrlHelper::generateUrl('Buyer', 'orderFeedback', array($childOrderDetail['op_id'])); ?>">
                                <?php echo Labels::getLabel('LBL_Feedback', $siteLangId); ?>
                            </a>
                        <?php } ?>
                        <?php if ($canReturnRefund && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON && !$childOrderDetail['deliveredMarkedBy']) { ?>
                            <a class="btn btn-outline-gray qwer no-print"
                                href="<?php echo UrlHelper::generateUrl('Buyer', 'orderReturnRequest', array($childOrderDetail['op_id'])); ?>">
                                <?php echo Labels::getLabel('LBL_Refund', $siteLangId); ?>
                            </a>
                        <?php } ?>
                        <?php if ($thread_id > 0) { ?>
                            <a class="btn btn-outline-gray qwer no-print"
                                href="<?php echo UrlHelper::generateUrl('Account', 'viewMessages', array($thread_id, $message_id)); ?>">
                                <?php echo Labels::getLabel('LBL_View_Order_Message', $siteLangId); ?>
                            </a>
                        <?php } else { ?>
                            <button class="btn btn-outline-gray qwer no-print" type="button"
                                onclick="sendOrderMessage(<?php echo $childOrderDetail['op_id']; ?>, 'buyer')">
                                <?php echo Labels::getLabel('LBL_Send_message_to_seller', $siteLangId); ?>
                            </button>
                        <?php } ?>
                        <?php if (0 < $opId && !$orderDetail['order_deleted'] && !$orderDetail["order_payment_status"] && 'TransferBank' == $orderDetail['plugin_code']) { ?>
                            <a href="<?php echo UrlHelper::generateUrl('Buyer', 'viewOrder', [$orderDetail['order_id']]); ?>"
                                class="btn btn-outline-gray qwer no-print"
                                title="<?php echo Labels::getLabel('LBL_ADD_PAYMENT_DETAIL', $siteLangId); ?>">
                                <?php echo Labels::getLabel('LBL_ADD_PAYMENT_DETAIL', $siteLangId); ?>
                            </a>
                        <?php } ?>
                        <?php if ($orderDetail['order_is_rfq'] == applicationConstants::YES) { ?>
                            <a class="btn btn-outline-gray qwer no-print"
                                href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'requestView', array($childOrderDetail['order_rfq_id'])); ?>"
                                target="_blank">
                                <?php echo Labels::getLabel('LBL_View_RFQ', $siteLangId); ?>
                            </a>
                        <?php } ?>
                            

                    </div>
                </div>
            <?php } ?>
        </div>
        <div class="content-body">
            <?php
            if (true == $primaryOrder) {
                if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {

                    if (!($canCancelOrder && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) && $childOrderDetail['opd_rental_type'] != ProductRental::DURATION_TYPE_HOUR && strtotime($childOrderDetail['opd_rental_start_date']) <= strtotime(date('Y-m-d 00:00:00')) && strtotime($childOrderDetail['opd_rental_end_date']) >= strtotime(date('Y-m-d 00:00:00')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForRentalExpireNote())) {
                        if (date('Y-m-d 00:00:00') == $childOrderDetail['opd_rental_end_date']) {
                            $dateToRentalEnd = 0;
                        } else {
                            $dateToRentalEnd = CommonHelper::getDifferenceBetweenDates(date('Y-m-d 00:00:00'), $childOrderDetail['opd_rental_end_date'], 0, ProductRental::DURATION_TYPE_DAY);
                        }

                        if ($dateToRentalEnd >= 3) {
                            $rentalEndMsgClass = 'alert-success';
                        } elseif ($dateToRentalEnd >= 2) {
                            $rentalEndMsgClass = 'alert-warning';
                        } else {
                            $rentalEndMsgClass = 'alert-danger';
                        }
                        ?>
                        <div class="alert alert-custom <?php echo $rentalEndMsgClass; ?>" role="alert">
                            <svg class="svg  me-2" width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                role="img" aria-label="Warning:">
                                <path
                                    d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                            </svg>
                            <div>
                                <?php echo $dateToRentalEnd . ' ' . Labels::getLabel('LBL_Day(s)_Remaining_to_end_Rental', $siteLangId); ?>
                            </div>
                        </div>

                    <?php } else if (!($canCancelOrder && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON) && $childOrderDetail['opd_rental_type'] == ProductRental::DURATION_TYPE_HOUR && !(strtotime($childOrderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d H:i')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForLateChargeNote()))) {

                        $dateToRentalEnd = CommonHelper::getDifferenceBetweenDates(date('Y-m-d H:i'), $childOrderDetail['opd_rental_end_date'], 0, ProductRental::DURATION_TYPE_HOUR);

                        if ($dateToRentalEnd >= 3) {
                            $rentalEndMsgClass = 'alert-success';
                        } elseif ($dateToRentalEnd >= 2) {
                            $rentalEndMsgClass = 'alert-warning';
                        } else {
                            $rentalEndMsgClass = 'alert-danger';
                        }
                        if ($dateToRentalEnd <= 24) {
                            ?>
                                <div class="alert alert-custom <?php echo $rentalEndMsgClass; ?>" role="alert">
                                    <svg class="svg" width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                        role="img" aria-label="Warning:">
                                        <path
                                            d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                    </svg>
                                    <div>
                                    <?php echo $dateToRentalEnd . ' ' . Labels::getLabel('LBL_Hour(s)_Remaining_to_end_Rental', $siteLangId); ?>
                                    </div>
                                </div>
                            <?php
                        }
                    } elseif (strtotime($childOrderDetail['opd_rental_end_date']) < strtotime(date('Y-m-d H:i')) && in_array($childOrderDetail['op_status_id'], OrderStatus::statusArrForLateChargeNote())) {
                        $canExtendOrder = false;
                        ?>
                            <div class="alert alert-warning alert-custom " role="alert">
                                <svg class="svg" width="18" height="18" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 16 16"
                                    role="img" aria-label="Warning:">
                                    <path
                                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                                </svg>
                                <div>
                                <?php echo Labels::getLabel('LBL_Rental_Duration_Ended._Late_Charges_may_be_Apply', $siteLangId); ?>
                                </div>
                            </div>
                    <?php }
                }
            }
            ?>
            <!-- static <div class="alert alert-warning alert-custom" role="alert">
                <svg class="svg me-5" width="18" height="18" xmlns="http://www.w3.org/2000/svg"
                     viewBox="0 0 16 16" role="img"
                    aria-label="Warning:">
                    <path
                        d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z" />
                </svg>
                <div>
                    Rental Duration Ended. Late Charges May Be Apply
                </div>
            </div>  /static -->

            <div class="card">
                <div class="card-head">
                    <h5 class="card-title">
                        <div class="order-number">
                            <small class="sm-txt">
                                <?php echo Labels::getLabel('LBL_Order', $siteLangId); ?> #
                            </small>
                            <span class="numbers">
                                <?php echo (true == $primaryOrder) ? $childOrderDetail['op_invoice_number'] : $orderDetail['order_id']; ?>
                                <?php
                                if (true == $primaryOrder) {
                                    if ($childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                        if ($parentOrderId != '') {
                                            echo '<span class="notice ">' . Labels::getLabel('LBL_This_order_is_extended_from_', $siteLangId) . ' <a href="' . CommonHelper::generateUrl('Buyer', 'viewOrder', array($parentOrderId, $extendFromOpId)) . '">#' . $parentOrderId . '</a> </span>';
                                        }
                                        if (!empty($extendChildOrder)) {
                                            echo '<span class="notice ">' . Labels::getLabel('LBL_This_order_is_extended_By', $siteLangId) . ' <a href="' . CommonHelper::generateUrl('Buyer', 'viewOrder', array($extendChildOrder['opd_order_id'], $extendChildOrder['opd_op_id'])) . '">#' . $extendChildOrder['opd_order_id'] . '</a> </span>';
                                        }
                                    }
                                }
                                ?>
                            </span>
                        </div>
                    </h5>
                    <div class="btn-group orders-actions">
                        <?php if (true == $primaryOrder && $childOrderDetail['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) { ?>
                            <?php if (FatApp::getConfig("CONF_DEFAULT_DEIVERED_ORDER_STATUS") == $childOrderDetail["op_status_id"] && true == $primaryOrder && $childOrderDetail['opd_extend_from_op_id'] <= 0 && empty($extendChildOrder) && $childOrderDetail['opd_product_type'] != SellerProduct::PRODUCT_TYPE_ADDON && $canExtendOrder == true) { ?>
                                <button class="btn btn-outline-gray" type="button"
                                    onClick="extendRentalOrderForm(<?php echo $childOrderDetail['op_id'] ?>, 0);">
                                    <?php echo Labels::getLabel('LBL_Extend_Order', $siteLangId); ?>
                                </button>
                                <?php
                            }
                        }
                        ?>
                        <a class="btn btn-outline-gray"
                            href="<?php echo (0 < $opId) ? UrlHelper::generateUrl('Buyer', 'viewInvoice', [$orderDetail['order_id'], $opId]) : UrlHelper::generateUrl('Buyer', 'viewInvoice', [$orderDetail['order_id']]); ?>">
                            <svg class="svg" width="16" height="16">
                                <use
                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#print">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Print_order_detail', $siteLangId); ?>
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="table-wrap">
                                <table class="table table-orders table-justified">
                                    <thead>
                                        <tr class="">
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Items_Summary', $siteLangId); ?>
                                            </th>
                                            <!--th>
                                                <?php /* echo Labels::getLabel('LBL_Unit_Price', $siteLangId); ?>
                                                <?php if ($isrentalOrder) { ?>
                                                    <button class="btn btn-tooltip" data-bs-toggle="tooltip"
                                                        title="<?php echo Labels::getLabel('LBL_Per_Duration_Price', $siteLangId); ?>"
                                                        data-original-title="<?php echo Labels::getLabel('LBL_Per_Duration_Price', $siteLangId); ?>"><i
                                                            class="fa fa-info-circle"></i></button>
                                                <?php } */?>
                                            </th-->
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Total_Price', $siteLangId); ?>
                                                <?php /*if ($isrentalOrder) { ?>
                                                    <button class="btn btn-tooltip" data-bs-toggle="tooltip"
                                                        title="<?php echo Labels::getLabel('LBL_Total_Amount_tooltip', $siteLangId); ?>"
                                                        data-original-title="<?php echo Labels::getLabel('LBL_Total_Amount_tooltip', $siteLangId); ?>"><i
                                                            class="fa fa-info-circle"></i></button>
                                                <?php } */?>
                                            </th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        if ($primaryOrder) {
                                            $arr[] = $childOrderDetail;
                                        } else {
                                            $arr = $childOrderDetail;
                                        }
                                        $couponDiscount = $volumnDiscountAmount = $durationDiscountAmount = $shippingCharges = $totalTaxes = $rewardPointTotal = $cartTotalAmount = $totalSecurityAmount = $orderNetTotal = $roundingOffTotal = $addonTotal = $totalLateCharges = 0;
                                        $isShipping = false;
                                        $securityHtml = $taxOptionsHtml = $pickupAddressHtml = $durationDiscountHtml = $volumnDiscountHtml = $shippingHtml = $couponDiscountHtml = $addonAmountHtml = '';
                                        foreach ($arr as $childOrder) {
                                            $services = (isset($attachedServicesArr[$childOrder['op_id']])) ? $attachedServicesArr[$childOrder['op_id']] : [];


                                            $prodOrBatchUrl = 'javascript:void(0)';
                                            if ($childOrder['op_is_batch']) {
                                                $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'batch', array($childOrder['op_selprod_id']));
                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'BatchProduct', array($childOrder['op_selprod_id'], $siteLangId, "SMALL"), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                            } else {
                                                if (Product::verifyProductIsValid($childOrder['op_selprod_id']) == true) {
                                                    $prodOrBatchUrl = UrlHelper::generateUrl('Products', 'view', array($childOrder['op_selprod_id']));
                                                }
                                                $prodOrBatchImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($childOrder['selprod_product_id'], "SMALL", $childOrder['op_selprod_id'], 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                            }

                                            $optionsHtml = ($childOrder['op_selprod_options'] != '') ? ' | ' . $childOrder['op_selprod_options'] : "";

											$productTitle = $childOrder['op_product_identifier'];
											if($childOrder['op_selprod_title'] != '') {
												if(trim($childOrder['op_selprod_title']) != '') {
													$productTitle = trim($childOrder['op_selprod_title']);
												}
											}
											
                                            /*$productTitle = (trim($childOrder['op_selprod_title']) == '') ? $childOrder['op_product_identifier'] : $childOrder['op_selprod_title'];*/


                                            $productImgHtml = '<td><div class="product-profile"><a class="product-profile-thumbnail" '.HtmlHelper::profileImgAttr().' href="' . $prodOrBatchUrl . '">
                                                    <img src="' . $prodOrBatchImgUrl . '" title="' . $childOrder['op_product_name'] . '" alt="' . $childOrder['op_product_name'] . '" />
                                                </a>
                                                 
                                                <div class="product-profile-data">
                                                    <div class="product-profile-title">
                                                        <a title="' . $productTitle . '" href="' . $prodOrBatchUrl . '">
                                                            ' . $productTitle . '
                                                        </a>
                                                    </div>
                                                    <div class="product-profile-options"> ' . Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $childOrder['op_qty'] . ' ' . $optionsHtml . '
                                                </div>
                                                    
                                                </div>
                                                </div></td>';



                                            if (Shipping::FULFILMENT_PICKUP == $childOrder['opshipping_fulfillment_type']) {
                                                $pickupAddressHtml .= '<div class="address-info">';
                                                if (!$primaryOrder) {
                                                    $pickupAddressHtml .= '<h5>' . $childOrder['op_selprod_title'] . '</h5>';
                                                }

                                                $pickupAddressHtml .= '<p>' . $childOrder['addr_name'] . ', ';
                                                $address1 = !empty($childOrder['addr_address1']) ? ' ' . $childOrder['addr_address1'] . ' ' : '';
                                                $address2 = !empty($childOrder['addr_address2']) ? ', ' . $childOrder['addr_address2'] . ' ' : '';
                                                $city = !empty($childOrder['addr_city']) ? ', ' . $childOrder['addr_city'] : '';
                                                $state = !empty($childOrder['state_name']) ? ', ' . $childOrder['state_name'] : ', ' . $childOrder['state_identifier'];
                                                $zip = !empty($childOrder['addr_zip']) ? '(' . $childOrder['addr_zip'] . ')' : '';
                                                $stateStr = $city . $state . $zip;
                                                $country = !empty($childOrder['country_name']) ? ' , ' . $childOrder['country_name'] . ' ' : ', ' . $childOrder['country_code'] . ' ';
                                                $pickupAddressHtml .= $address1 . $address2 . $stateStr . $country . '</p>';

                                                $pickupAddressHtml .= '<p class="c-info"><strong><i class="fas fa-mobile-alt mr-2"></i> ' . $childOrder['addr_dial_code'] . ' ' . $childOrder['addr_phone'] . '</strong></p>';

                                                if ($childOrder['order_is_rfq'] == applicationConstants::NO && $childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_SALE) {
                                                    $fromTime = isset($childOrder["opshipping_time_slot_from"]) ? date('H:i', strtotime($childOrder["opshipping_time_slot_from"])) : '';
                                                    $toTime = isset($childOrder["opshipping_time_slot_to"]) ? date('H:i', strtotime($childOrder["opshipping_time_slot_to"])) : '';
                                                    $date = isset($childOrder["opshipping_date"]) ? FatDate::format($childOrder["opshipping_date"]) : '';
                                                    $pickupAddressHtml .= '<p class="c-info"><strong><i class="fas fa-calendar mr-2"></i>' . $date . ' ' . $fromTime . ' - ' . $toTime . '</strong></p>';
                                                }

                                                if (!$primaryOrder) {
                                                    $pickupAddressHtml .= '<hr class="dotted" />';
                                                }
                                                $pickupAddressHtml .= '</div>';
                                            } else {
                                                $isShipping = true;
                                                $shippingHtml .= '<tr>' . $productImgHtml . '<td>' . $childOrder['opshipping_label'] . '</td><td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'SHIPPING'), true, false, true, false, true) . '</td></tr>';
                                            }

                                            $cartTotalAmount += CommonHelper::orderProductAmount($childOrder, 'cart_total');
                                            $couponDiscount += CommonHelper::orderProductAmount($childOrder, 'DISCOUNT');
                                            $shippingCharges += CommonHelper::orderProductAmount($childOrder, 'SHIPPING');
                                            $totalTaxes += CommonHelper::orderProductAmount($childOrder, 'TAX');
                                            $volumnDiscountAmount += CommonHelper::orderProductAmount($childOrder, 'VOLUME_DISCOUNT');
                                            $durationDiscountAmount += CommonHelper::orderProductAmount($childOrder, 'DURATION_DISCOUNT');
                                            $rewardPointTotal += CommonHelper::orderProductAmount($childOrder, 'REWARDPOINT');
                                            $totalSecurityAmount += $childOrder['opd_rental_security'] * $childOrder['op_qty'];
                                            $orderNetTotal += CommonHelper::orderProductAmount($childOrder, 'NETAMOUNT');
                                            $roundingOffTotal += $childOrder['op_rounding_off'];
                                            $totalLateCharges += $childOrder['charge_total_amount'];
                                            $couponDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'DISCOUNT'), true, false, true, false, true) . '</td></tr>';
                                            if ($childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                                $securityHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(($childOrder['opd_rental_security'] * $childOrder['op_qty']), true, false, true, false, true) . '</td></tr>';

                                                $durationDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'DURATION_DISCOUNT'), true, false, true, false, true) . '</td></tr>';
                                            } else {
                                                $volumnDiscountHtml .= '<tr>' . $productImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'VOLUME_DISCOUNT'), true, false, true, false, true) . '</td></tr>';
                                            }
                                            if (empty($childOrder['taxOptions'])) {
                                                $taxOptionsHtml .= '<tr>
                                                ' . $productImgHtml . '
                                                <td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'TAX'), true, false, true, false, true) . '</td>
                                                </tr>';
                                            } else {
                                                $taxOptionsHtml .= '<tr>' . $productImgHtml . '<td>';
                                                foreach ($childOrder['taxOptions'] as $key => $val) {
                                                    $taxOptionsHtml .= '<strong>' . CommonHelper::displayTaxPercantage($val, true) . '</strong> : ' . CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true) . '<br />';
                                                }
                                                $taxOptionsHtml .= '</td></tr>';
                                            }
                                            ?>
                                            <tr>
                                                <td>
                                                    <div class="product-profile">
                                                        <a class="product-profile-thumbnail xxl <?php echo ($prodOrBatchUrl == 'javascript:void(0)') ? "blank-anchor" : ""; ?>" <?php echo HtmlHelper::profileImgAttr(); ?>
                                                            href="<?php echo $prodOrBatchUrl; ?>">
                                                            <img class="product-profile-thumb" width="120"
                                                                src="<?php echo $prodOrBatchImgUrl; ?>"
                                                                title="<?php echo $childOrder['op_product_name']; ?>"
                                                                alt="<?php echo $childOrder['op_product_name']; ?>" />
                                                        </a>
                                                        <div class="product-profile-data">
                                                            <div class="product-profile-title">
                                                                <a class="<?php echo ($prodOrBatchUrl == 'javascript:void(0)') ? "blank-anchor" : ""; ?>"
                                                                    title="<?php echo $productTitle; ?>"
                                                                    href="<?php echo $prodOrBatchUrl; ?>">
                                                                    <?php echo $productTitle; ?>
                                                                </a><br>
                                                                <?php /* echo $childOrder['op_product_name']; */ ?>
                                                            </div>
                                                            <div class="product-profile-options">
                                                                <?php
                                                                echo Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $childOrder['op_qty'];
                                                                if ($childOrder['op_selprod_options'] != '') {
                                                                    echo ' <br> ' . $childOrder['op_selprod_options'];
                                                                }
                                                                ?>
                                                            </div>
                                                            <div class="product-profile-sold">
                                                                <?php echo Labels::getLabel('LBL_Sold_By', $siteLangId) . ': ' . $childOrder['op_shop_name']; ?>
                                                            </div>
                                                            <?php
                                                            if ($childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                                                $duration = CommonHelper::getDifferenceBetweenDates($childOrder['opd_rental_start_date'], $childOrder['opd_rental_end_date'], $childOrder['op_selprod_user_id'], $childOrder['opd_rental_type']);
                                                                ?>
                                                                <div class="product-profile-range">
                                                                    <small>
                                                                        <?php echo Labels::getLabel('LBL_From', $siteLangId) . ': ' . date('M d, Y H:i ', strtotime($childOrder['opd_rental_start_date'])); ?>
																		</br>
                                                                        <?php echo Labels::getLabel('LBL_To', $siteLangId) . ': ' . date('M d, Y H:i ', strtotime($childOrder['opd_rental_end_date'])); ?>
                                                                    </small>
                                                                </div>
																<?php if(0) { ?>
                                                                <div class="product-profile-range">
                                                                    <small>
                                                                        <i class="icn">
                                                                            <svg width="13px" height="13px" class="svg">
                                                                                <use
                                                                                    xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#time">
                                                                                </use>
                                                                            </svg>
                                                                        </i>
                                                                        <?php
                                                                        echo Labels::getLabel('LBL_Duration', $siteLangId) . ': ';
                                                                        echo CommonHelper::displayProductRentalDuration($duration, $childOrder['opd_rental_type'], $siteLangId);
                                                                        ?>
                                                                    </small>
                                                                </div>
																<?php } ?>
                                                            <?php } ?>
                                                        </div>
                                                    </div>
                                                </td>
                                                <!--td>
                                                    <?php
													/*
                                                    if ($childOrder['opd_sold_or_rented'] == applicationConstants::ORDER_TYPE_RENT) {
                                                        if ($childOrder['opd_rental_price'] != $childOrder['op_unit_price']) {
                                                            echo CommonHelper::displayMoneyFormat(($childOrder['op_unit_price'] / $childOrder['opd_rental_price_multiplier_days']), true, false, true, false, true);
                                                        } else {
                                                            echo CommonHelper::displayMoneyFormat(($childOrder['opd_duration_price']), true, false, true, false, true);
                                                        }
                                                    } else {
                                                        echo CommonHelper::displayMoneyFormat($childOrder['op_unit_price'], true, false, true, false, true);
                                                    }*/
                                                    ?>
                                                </td -->
                                                <td>
												<?php if(!empty($childOrder['opd_price_bifurcation'])) { ?>
														<button class="dotted" data-bs-toggle="modal" data-bs-target="#price-bifurcation-<?php echo $childOrder['op_id']; ?>">
														<?php echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'cart_total'), true, false, true, false, true); ?>
														</button>
												<?php	} else {
														echo CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($childOrder, 'cart_total'), true, false, true, false, true); 
													}
													?>
                                                </td>
                                            </tr>
                                            <?php if (!empty($services)) { ?>
                                                <tr class="row-addons">
                                                    <td colspan="3">
                                                        <div class="addons">
                                                            <button class="addons_trigger collapsed" type="button"
                                                                data-bs-toggle="collapse"
                                                                data-bs-target="#service_<?php echo $childOrder['op_id']; ?>"
                                                                aria-expanded="false"
                                                                aria-controls="service_<?php echo $childOrder['op_id']; ?>">
                                                                <span class="txt">
                                                                    <?php echo Labels::getLabel('LBL_Addons_And_Details', $siteLangId); ?>
                                                                    <span class="count">
                                                                        <?php echo count($services); ?>
                                                                    </span>
                                                                </span>
                                                                <i class="icn"></i>
                                                            </button>
                                                            <div class="collapse"
                                                                id="service_<?php echo $childOrder['op_id']; ?>">
                                                                <ul class="addons-list">
                                                                    <?php
                                                                    foreach ($services as $service) {
                                                                        $addonImgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($service['op_selprod_id'], "THUMB", 0, $siteLangId), CONF_WEBROOT_URL), CONF_IMG_CACHE_TIME, '.jpg');
                                                                        $addonTotal += CommonHelper::orderProductAmount($service, 'cart_total');
                                                                        $couponDiscount += CommonHelper::orderProductAmount($service, 'DISCOUNT');
                                                                        $shippingCharges += CommonHelper::orderProductAmount($service, 'SHIPPING');
                                                                        $totalTaxes += CommonHelper::orderProductAmount($service, 'TAX');
                                                                        $volumnDiscountAmount += CommonHelper::orderProductAmount($service, 'VOLUME_DISCOUNT');
                                                                        $durationDiscountAmount += CommonHelper::orderProductAmount($service, 'DURATION_DISCOUNT');

                                                                        $addonTitle = (trim($service['op_selprod_title']) == '') ? $service['op_product_identifier'] : $service['op_selprod_title'];

                                                                        $addonImgHtml = '<td><div class="product-profile"> 
                                                                         
                                                                        <button class="product-profile-thumbnail">
                                                                            <img src="' . $addonImgUrl . '" title="' . $service['op_product_name'] . '" alt="' . $service['op_product_name'] . '" />
                                                                        </button>
                                                                        
                                                                        <div class="product-profile-data">
                                                                            <div class="product-profile-title">
                                                                                ' . $addonTitle . '
                                                                            </div> <div class="product-profile-options"> ' . Labels::getLabel('LBL_QTY', $siteLangId) . ' : ' . $service['op_qty'] . ' </div>
                                                                        </div></div></td>';

                                                                        $couponDiscountHtml .= '<tr>' . $addonImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'DISCOUNT'), true, false, true, false, true) . '</td></tr>';


                                                                        $rewardPointTotal += CommonHelper::orderProductAmount($service, 'REWARDPOINT');
                                                                        $totalSecurityAmount += $service['opd_rental_security'] * $service['op_qty'];
                                                                        $orderNetTotal += CommonHelper::orderProductAmount($service, 'NETAMOUNT');
                                                                        $roundingOffTotal += $service['op_rounding_off'];
                                                                        $totalLateCharges += $service['charge_total_amount'];
                                                                        $addonAmountHtml .= '<tr>' . $addonImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'cart_total'), true, false, true, false, true) . '</td></tr>';
                                                                        if (empty($service['taxOptions'])) {
                                                                            $taxOptionsHtml .= '<tr>' . $addonImgHtml . '<td>' . CommonHelper::displayMoneyFormat(CommonHelper::orderProductAmount($service, 'TAX'), true, false, true, false, true) . '</td></tr>';
                                                                        } else {
                                                                            $taxOptionsHtml .= '<tr>' . $addonImgHtml . '<td>';
                                                                            foreach ($service['taxOptions'] as $key => $val) {
                                                                                $taxOptionsHtml .= '<strong>' . CommonHelper::displayTaxPercantage($val, true) . '</strong> : ' . CommonHelper::displayMoneyFormat($val['value'], true, false, true, false, true) . '<br />';
                                                                            }
                                                                            $taxOptionsHtml .= '</td></tr>';
                                                                        }
                                                                        ?>
                                                                        <li>
                                                                            <div class="addons-img">
                                                                                <img src="<?php echo $addonImgUrl; ?>"
                                                                                    title="<?php echo $addonTitle; ?>"
                                                                                    alt="<?php echo $addonTitle; ?>">
                                                                            </div>
                                                                            <div class="addons-name">
                                                                                <?php echo $addonTitle; ?>
                                                                            </div>
                                                                        </li>
                                                                    <?php } ?>
                                                                </ul>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            <?php } ?>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php
                            /* if (!empty($orderDetail['comments'])) { */
                            if (!empty($orderStatusList)) {
                                $classArr = OrderStatus::orderStatusClassess();
                                ?>
                                <div class="timelines-wrap">
                                    <h5 class="card-title">
                                        <?php echo Labels::getLabel('LBL_Order_Status_Log', $siteLangId); ?>
                                    </h5>
                                    <ul class="timeline">
                                        <?php if (isset($childOrderDetail['op_status_id']) && $childOrderDetail['op_status_id'] == OrderStatus::ORDER_CANCELLED) { ?>
                                            <li class="enable shipped">
                                                <div class="timeline_data">
                                                    <div class="timeline_data_head">
                                                        <span class="order-status">
                                                            <span class="dot"></span>
                                                            <?php echo Labels::getLabel('LBL_Cancelled', $siteLangId); ?>
                                                        </span>
                                                    </div>
                                                </div>
                                            </li>
                                            <?php
                                        } else {
                                            $orderStatusList = array_values($orderStatusList);
                                            foreach ($orderStatusList as $key => $opStatus) {
                                                $postedComments = [array('oshistory_id' => 0)];
                                                $opStatusId = $opStatus['orderstatus_id'];
                                                if (!isset($orderDetail['comments'][$opStatusId])) {
                                                    foreach ($orderStatusList as $keyChild => $opStatusChild) {
                                                        $opStatusIdChild = $opStatusChild['orderstatus_id'];
                                                        if ($keyChild > $key && isset($orderDetail['comments'][$opStatusIdChild])) {
                                                            $postedComments = [array('oshistory_id' => 0, 'oshistory_date_added' => $orderDetail['comments'][$opStatusIdChild][0]['oshistory_date_added'])];
                                                            break;
                                                        }
                                                    }
                                                } else {
                                                    $postedComments = $orderDetail['comments'][$opStatusId];
                                                }

                                                $enableDisableClass = "disabled";
                                                if (isset($currentOrderStatusPriority) && $currentOrderStatusPriority >= $opStatus['priority']) {
                                                    $enableDisableClass = "enable";
                                                }
                                                if ($primaryOrder && $opStatusId == $childOrderDetail['op_status_id']) {
                                                    $enableDisableClass .= ' currently';
                                                }
                                                
                                                if (!$primaryOrder && $orderDetail['order_payment_status'] == Orders::ORDER_PAYMENT_PAID ) {
                                                    $enableDisableClass = "enable";
                                                }

                                                if (Shipping::FULFILMENT_PICKUP == $childOrder['opshipping_fulfillment_type'] && $opStatusId == OrderStatus::ORDER_DELIVERED) {
                                                    $opStatus['orderstatus_name'] = Labels::getLabel('LBL_Picked', $siteLangId);
                                                }
                                               
                                                if ($orderDetail['order_payment_status'] != Orders::ORDER_PAYMENT_PAID && $opStatusId == OrderStatus::ORDER_PAYMENT_CONFIRM) {
                                                    $enableDisableClass .= " on-hold";
                                                }
                                                if(isset($childOrderDetail['op_payment_status']) && $childOrderDetail['op_payment_status'] != Orders::ORDER_PAYMENT_PAID && $opStatusId == OrderStatus::ORDER_PAYMENT_CONFIRM){
                                                    $enableDisableClass .= " on-hold";
                                                }
                                                
                                                ?>
                                                <li
                                                    class="<?php echo $enableDisableClass; ?> <?php echo (isset($classArr[$opStatusId])) ? $classArr[$opStatusId] : "in-process" ?>">
                                                    <?php
                                                    foreach ($postedComments as $row) {
                                                        $attachedFiles = (isset($statusAttachedFiles[$row['oshistory_id']])) ? $statusAttachedFiles[$row['oshistory_id']] : [];
                                                        ?>
                                                        <div class="timeline_data">
                                                            <div class="timeline_data_head">
                                                                <?php if (isset($row['oshistory_date_added'])) { ?>
                                                                    <time class="timeline_date">
                                                                        <?php echo FatDate::format($row['oshistory_date_added']); ?>
                                                                    </time>
                                                                <?php } ?>
                                                                <span class="order-status"> <span class="dot"></span>
                                                                    <?php echo $opStatus['orderstatus_name']; ?>
                                                                </span>
                                                            </div>
                                                            <?php if ($row['oshistory_id'] > 0) { ?>
                                                                <div class="timeline_data_body">
                                                                    <?php if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_SHIPPED || ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_READY_FOR_RENTAL_RETURN && $row['oshistory_fullfillment_type'] == OrderProduct::RENTAL_ORDER_RETURN_TYPE_SHIP)) { ?>
                                                                        <?php if (empty($row['oshistory_courier'])) { ?>
                                                                            <h6><strong>
                                                                                    <?php echo Labels::getLabel('LBL_Tracking_Number', $siteLangId); ?>
                                                                                </strong>
                                                                            </h6>
                                                                            <div class="clipboard-wrap">
                                                                                <div class="clipboard">
                                                                                    <p class="clipboard_url">
                                                                                        <?php echo $row['oshistory_tracking_number']; ?>
                                                                                    </p>
                                                                                    <button class="clipboard_btn" data-bs-toggle="tooltip"
                                                                                        onclick="copyContent(this)"
                                                                                        title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                        data-original-title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"><i
                                                                                            class="far fa-copy"></i></button>
                                                                                </div>

                                                                            </div>
                                                                            <?php $str = '';
                                                                            if (empty($childOrderDetail['opship_tracking_url']) && !empty($row['oshistory_tracking_number'])) {
                                                                                $str .= "<p class='text-muted'><span class='via'> VIA <span>" . CommonHelper::displayNotApplicable($siteLangId, $childOrderDetail["opshipping_label"]) . "</span></span></p>";
                                                                            } elseif (!empty($childOrderDetail['opship_tracking_url'])) {
                                                                                $str .= " <p class='text-muted'><a class='link-brand link-underline' href='" . $childOrderDetail['opship_tracking_url'] . "' target='_blank'>" . Labels::getLabel("MSG_TRACK", $siteLangId) . "</a></p>";
                                                                            }
                                                                            echo $str ?>

                                                                            <?php
                                                                        } else {
                                                                            $trackingNumber = $row['oshistory_tracking_number'];
                                                                            $carrier = $row['oshistory_courier'];
                                                                            echo ($row['oshistory_tracking_number']) ? '<h6><strong>' . Labels::getLabel('LBL_Tracking_Number', $siteLangId) . '</strong> </h6>' : '';
                                                                            if (trim($trackingNumber) != '') {
                                                                                ?>
                                                                                <div class="clipboard-wrap">
                                                                                    <div class="clipboard">
                                                                                        <p class="clipboard_url">
                                                                                            <?php echo $row['oshistory_tracking_number']; ?>
                                                                                        </p>
                                                                                        <button class="clipboard_btn" data-bs-toggle="tooltip"
                                                                                            title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                            data-original-title="<?php echo Labels::getLabel('LBL_Copy_to_clipboard', $siteLangId); ?>"
                                                                                            onclick="copyContent(this)"><i class="far fa-copy"></i>
                                                                                        </button>
                                                                                    </div>
                                                                                    <?php

                                                                                    ?>
                                                                                </div>
                                                                                <p class='text-muted'>
                                                                                    <?php
                                                                                    if ($row['oshistory_orderstatus_id'] != OrderStatus::ORDER_READY_FOR_RENTAL_RETURN) {
                                                                                        echo " <span class='via'>";
                                                                                        echo Labels::getLabel('LBL_VIA', $siteLangId);
                                                                                        ?>
                                                                                        <span>
                                                                                            <?php echo CommonHelper::displayNotApplicable($siteLangId, $childOrderDetail["opshipping_label"]); ?>
                                                                                        </span>
                                                                                        <?php
                                                                                        echo "</span>";
                                                                                    } else { ?>

                                                                                        <?php
                                                                                        if (trim($row['oshistory_tracking_url']) != '') {
                                                                                            echo " <a class='link-brand link-underline' href='" . $row['oshistory_tracking_url'] . "'  target='_blank'>" . Labels::getLabel("MSG_TRACK", $siteLangId) . "</a>";
                                                                                        }

                                                                                        echo " <span class='via'>" . Labels::getLabel('LBL_VIA', $siteLangId) . " <span>" . $carrier . " </span></span>";
                                                                                        ?>

                                                                                        <?php
                                                                                    } ?>

                                                                                </p>

                                                                                <?php
                                                                            }
                                                                        }
                                                                    }
                                                                    if (isset($statusAddressData[$row['oshistory_id']])) {
                                                                        $dropOffAddress = $statusAddressData[$row['oshistory_id']];
                                                                        ?>

                                                                        <div class="my-addresses-body mb-2 p-0">
                                                                            <address class="delivery-address">
                                                                                <h5>
                                                                                    <span>
                                                                                        <?php echo $dropOffAddress['addr_name']; ?>
                                                                                    </span>
                                                                                    <span class="tag">
                                                                                        <?php echo $dropOffAddress['addr_title']; ?>
                                                                                    </span>
                                                                                </h5>
                                                                                <p>
                                                                                    <?php echo $dropOffAddress['addr_address1'] . ','; ?>

                                                                                    <?php echo $dropOffAddress['addr_city'] . ','; ?>
                                                                                    <?php echo $dropOffAddress['state_name'] . ','; ?>
                                                                                    <?php echo $dropOffAddress['country_name']; ?>

                                                                                    <?php echo Labels::getLabel("LBL_Zip", $siteLangId) . ': ' . $dropOffAddress['addr_zip'] ?>

                                                                                </p>
                                                                                <p class="phone-txt">
                                                                                    <svg class="svg" width="16" height="16">
                                                                                        <use
                                                                                            xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                                                                        </use>
                                                                                    </svg>
                                                                                    <?php echo Labels::getLabel("LBL_Phone", $siteLangId) . ': ' . $dropOffAddress['addr_dial_code'] . ' ' . $dropOffAddress['addr_phone']; ?>
                                                                                </p>
                                                                            </address>
                                                                        </div>
                                                                        <?php
                                                                    }
                                                                    if (!empty($attachedFiles)) {
                                                                        ?>
                                                <div class="attached-files">
                                                    <h6>
                                                        <strong>
                                                            <?php echo Labels::getLabel('LBL_Attached_Files', $siteLangId); ?>
                                                        </strong>
                                                    </h6>
                                                    <ul>
                                                        <?php foreach ($attachedFiles as $attachedFile) { ?>
                                                        <li>
                                                            <a href="<?php echo UrlHelper::generateUrl('buyer', 'downloadBuyerAtatchedFile', array(CommonHelper::encryptId($attachedFile['afile_record_id']), 0, CommonHelper::encryptId($attachedFile['afile_id']))); ?>"
                                                                title="<?php echo $attachedFile['afile_name']; ?>">
                                                                <i class="fa fa-download"></i>
                                                                <?php echo $attachedFile['afile_name']; ?>
                                                            </a>
                                                        </li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                                <?php } ?>
                                                <?php if (trim(($row['oshistory_comments']) != '' && strpos(trim($row['oshistory_comments']), 'Transaction Id') === false)) { ?>
                                                <p class="extra-p">
                                                    <?php echo !empty(trim(($row['oshistory_comments']))) ? html_entity_decode(nl2br($row['oshistory_comments'])) : ""; ?>
                                                </p>
                                                <?php }else if(trim(($row['oshistory_comments']) != '' && strpos(trim($row['oshistory_comments']), 'Transaction Id') !== false)){
                                                    preg_match('/Transaction Id: (\w+)/', $row['oshistory_comments'], $matches);
                                                    if (isset($matches[1])) {
                                                         $transactionId = $matches[1];
                                                    ?>
                                                    <p class="extra-p">
                                                        <?php echo Labels::getLabel('LBL_Transaction_number', $siteLangId) .': '. $transactionId ; ?>
                                                    </p>
                                                    <?php
                                                    }
                                                } ?>
                                                <?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>
                                                    <?php if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_RENTAL_RETURNED && !empty($orderDetail['checklistPoints'])) { ?>
                                                        <button class="dotted" data-bs-toggle="modal" data-bs-target="#returned_checklist_points_modal">
                                                        <?php echo Labels::getLabel('LBL_Checklist_points', $siteLangId) ; ?> 
                                                        </button>
                                                    <?php } ?>
                                                    <?php if ($row['oshistory_orderstatus_id'] == OrderStatus::ORDER_SHIPPED && !empty($orderDetail['checklistPoints'])) { ?>
                                                        <button class="dotted" data-bs-toggle="modal" data-bs-target="#shipped_checklist_points_modal">
                                                        <?php echo Labels::getLabel('LBL_Checklist_points', $siteLangId) ; ?> 
                                                        </button>
                                                        <?php } else if ((Shipping::FULFILMENT_PICKUP == $childOrder['opshipping_fulfillment_type'] && $opStatusId == 7) && (!empty($orderDetail['checklistPoints']) && array_key_exists(7, $orderDetail['checklistPoints']))) { ?>
                                                        <button class="dotted" data-bs-toggle="modal" data-bs-target="#shipped_checklist_points_modal">
                                                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                                                        </button>
                                                    <?php } ?>
                                                <?php } ?>

                                                                </div>
                                                            <?php } ?>
                                                        </div>
                                                    <?php } ?>
                                                </li>
                                                <?php
                                            }
                                        }
                                        ?>
                                    </ul>
                                </div>
                            <?php } ?>

                            <?php if (!$orderDetail['order_deleted'] && !$primaryOrder && !$orderDetail["order_payment_status"] && 'TransferBank' == $orderDetail['plugin_code']) { ?>
                                <div class="section--repeated mb-3">
                                    <h6>
                                        <?php echo Labels::getLabel('LBL_ORDER_PAYMENTS', $siteLangId); ?>
                                    </h6>
                                    <div class="info--order">
                                        <?php
                                        $frm->setFormTagAttribute('onsubmit', 'updatePayment(this); return(false);');
                                        $frm->setFormTagAttribute('class', 'form');
                                        $frm->developerTags['colClassPrefix'] = 'col-md-';
                                        $frm->developerTags['fld_default_col'] = 12;


                                        $paymentFld = $frm->getField('opayment_method');
                                        $paymentFld->developerTags['col'] = 4;

                                        $gatewayFld = $frm->getField('opayment_gateway_txn_id');
                                        $gatewayFld->developerTags['col'] = 4;

                                        $amountFld = $frm->getField('opayment_amount');
                                        $amountFld->developerTags['col'] = 4;

                                        $submitFld = $frm->getField('btn_submit');
                                        $submitFld->developerTags['col'] = 4;
                                        $submitFld->addFieldTagAttribute('class', 'btn btn-brand');
                                        $submitFld->value = Labels::getLabel("LBL_SUBMIT_REQUEST", $siteLangId);
                                        echo $frm->getFormHtml();
                                        ?>
                                    </div>
                                </div>
                            <?php } ?>

                            <!-- [ RENTAL STATUS FORM -->
                            <?php if (isset($orderStatusFrm)) { ?>
                                <div class="section--repeated mb-3">
                                    <h6>
                                        <?php echo Labels::getLabel('LBL_ORDER_STATUS', $siteLangId); ?>
                                    </h6>
                                    <div class="orders-info">
                                        <?php
                                        $orderStatusFrm->setFormTagAttribute('onsubmit', 'updateOrderStatus(this); return(false);');
                                        $orderStatusFrm->setFormTagAttribute('class', 'form');
                                        $orderStatusFrm->developerTags['colClassPrefix'] = 'col-md-';
                                        $orderStatusFrm->developerTags['fld_default_col'] = 6;
                                        if (1 >= $childOrderDetail['op_qty'] || $childOrderDetail['opd_extend_from_op_id'] > 0) {
                                            $qtyFld = $orderStatusFrm->getField('return_qty');
                                            if (!empty($qtyFld)) {
                                                $qtyFld->value = $childOrderDetail['op_qty'];
                                                $qtyFld->setFieldTagAttribute('readonly', 'readonly');
                                                $qtyFld->setFieldTagAttribute('class', 'disabled-input');
                                            }
                                        }

                                        if ($childOrderDetail['op_status_id'] == FatApp::getConfig('CONF_DEFAULT_DEIVERED_ORDER_STATUS')) {
                                            $orderStatusFrm->developerTags['fld_default_col'] = 6;
                                        }

                                        $fileFld = $orderStatusFrm->getField('file_field');
                                        $fileFld->developerTags['col'] = 12;
                                        $cmtFld = $orderStatusFrm->getField('comments');
                                        $cmtFld->developerTags['col'] = 12;

                                        $fld = $orderStatusFrm->getField('tracking_number');
                                        if (!empty($fld)) {
                                            $fld->developerTags['col'] = 6;
                                            $fld->setWrapperAttribute('class', 'shipfield');
                                        }
                                        $couFld = $orderStatusFrm->getField('tracking_courier');
                                        if (!empty($couFld)) {
                                            $couFld->developerTags['col'] = 6;
                                            $couFld->setWrapperAttribute('class', 'shipfield');
                                        }

                                        $trackingUrlFld = $orderStatusFrm->getField('tracking_url');
                                        if (!empty($trackingUrlFld)) {
                                            $couFld->developerTags['col'] = 6;
                                            $trackingUrlFld->setWrapperAttribute('class', 'shipfield');
                                            $trackingUrlFld->setFieldTagAttribute('pattern', '^(https?|ftp):\/\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*(\/[^\s\/$.?#]+\.[^\s\/$.?#]+[^\s]*)?$');

                                            $trackingUrlFld->setFieldTagAttribute('placeholder', 'https://example.com');
                                            $trackingUrlFld->htmlAfterField = '<small>' . Labels::getLabel("LBL_Example", $siteLangId) . ' : https://example.com' . '</small>';
                                        }

                                        $opReturnResFld = $orderStatusFrm->getField('op_return_reason');
                                        if (!empty($opReturnResFld)) {
                                            $opReturnResFld->setWrapperAttribute('class', 'orderReturnReson--js');
                                        }

                                        $addressFld = $orderStatusFrm->getField('shop_address');
                                        $addressFld->developerTags['col'] = 12;
                                        if (!empty($shopAddresses) && !empty($addressFld)) {
                                            $addressFld->setWrapperAttribute('class', 'dropfld mt-4 ship-fld--js');
                                            $addressHtml = '<ul class="my-addresses">';
                                            foreach ($shopAddresses as $shopAddress) {
                                                $addressHtml .= '<li class="my-addresses-item"><div class="my-addresses-body">
												<span class="radio">
												<input type="radio" name="address_id" value="' . $shopAddress['addr_id'] . '"> </span>
												<address class="delivery-address"><h5>' . $shopAddress['addr_name'] . '<span class="tag">' . $shopAddress['addr_title'] . '</span></h5><p>' . $shopAddress['addr_address1'] . '' . $shopAddress['addr_city'] . ',' . $shopAddress['state_name'] . '' . $shopAddress['country_name'] . '' . Labels::getLabel("LBL_Zip", $siteLangId) . ': ' . $shopAddress['addr_zip'] . '</p><p class="phone-txt"><i class="fas fa-mobile-alt"></i> ' . Labels::getLabel("LBL_Phone", $siteLangId) . ': ' . $shopAddress['addr_dial_code'] . ' ' . $shopAddress['addr_phone'] . '</p></address></div></li>';
                                            }
                                            $addressHtml .= '</ul>';
                                            $addressFld->value = $addressHtml;
                                        }
                                        $submitFld = $orderStatusFrm->getField('btn_submit');
                                        $submitFld->developerTags['col'] = 4;
                                        $submitFld->addFieldTagAttribute('class', 'btn btn-brand');
                                        $submitFld->value = Labels::getLabel("LBL_SUBMIT_REQUEST", $siteLangId);
                                        echo $orderStatusFrm->getFormHtml();
                                        ?>
                                    </div>
                                </div>
                            <?php } ?>
                            <!-- RENTAL STATUS FORM END] -->
                        </div>
                        <div class="col-md-4">
                            <div class="ml-xl-2">
                                <div class="order-block">
                                    <h4>
                                        <?php echo Labels::getLabel('LBL_Order_Summary', $siteLangId); ?>
                                    </h4>

                                    <ul class="cart-summary">
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo FatDate::format($orderDetail['order_date_added']); ?>
                                            </span>
                                        </li>
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Cart_Total', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($cartTotalAmount, true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <?php if ($addonTotal > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#addon_modal">
                                                        <?php echo Labels::getLabel('LBL_Addon_Total', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($addonTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($durationDiscountAmount != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#duration_discount_modal">
                                                        <?php echo Labels::getLabel('LBL_Duration_Discount', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($durationDiscountAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($volumnDiscountAmount != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#volume_modal">
                                                        <?php echo Labels::getLabel('LBL_Volume_Discount', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($volumnDiscountAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($totalSecurityAmount > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label"><button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#security_modal">
                                                        <?php echo Labels::getLabel('LBL_Security_Amount', $siteLangId); ?>
                                                    </button></span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalSecurityAmount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($isShipping > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#shipping_modal">
                                                        <?php echo Labels::getLabel('LBL_Shipping_Price', $siteLangId); ?>
                                                    </button>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <button class="dotted" data-bs-toggle="modal"
                                                    data-bs-target="#tax_modal">
                                                    <?php echo Labels::getLabel('LBL_Taxes', $siteLangId); ?>
                                                    <?php /* <span class="count">5</span> */ ?>
                                                </button>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($totalTaxes, true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <?php if ($roundingOffTotal > 0) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Rounding_Up', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } elseif (0 > $roundingOffTotal) { ?>
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($couponDiscount != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label"><button class="dotted" data-bs-toggle="modal"
                                                        data-bs-target="#discount_modal">
                                                        <?php echo Labels::getLabel('LBL_Discount', $siteLangId); ?>
                                                    </button></span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($couponDiscount, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php if ($rewardPointTotal != 0) { ?>
                                            <li class="cart-summary-item discounted">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Reward_Point_Discount', $siteLangId); ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($rewardPointTotal, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        <?php } ?>
                                        <?php /* <li>
<span class="label"><?php echo Labels::getLabel('LBL_Sub_Total', $siteLangId); ?></span>
                                   <span
                                       class="value"><?php echo CommonHelper::displayMoneyFormat($cartTotalAmount, true, false, true, false, true); ?></span>
                                   </li> */ ?>
                                        <li class="cart-summary-item highlighted">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Order_Total_Amount', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($orderNetTotal, true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <?php 
                                        if(!empty($childOrderDetail['op_pending_amount']) && $childOrderDetail['op_pending_amount'] > 0){
                                           
                                        ?>
                                        <li class="cart-summary-item">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Upfront_Amount', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($childOrderDetail['op_upfront_amount'], true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <li class="cart-summary-item pt-0">
                                            <span class="label">
                                                <?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>
                                            </span>
                                            <span class="value">
                                                <?php echo CommonHelper::displayMoneyFormat($childOrderDetail['op_pending_amount'], true, false, true, false, true); ?>
                                            </span>
                                        </li>
                                        <?php
                                        }
                                        
                                        ?>
                                    </ul>

                                </div>
                                <?php if (isset($orderDetail['order_late_charges']) && $orderDetail['order_late_charges'] > 0) { ?>
                                    <div class="order-block">

                                        <ul class="cart-summary pt-0">
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('LBL_Pending_Charges_From_Previous_Orders', $siteLangId) ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($orderDetail['order_late_charges'], true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        </ul>

                                    </div>
                                <?php } ?>
                                <?php
                                if ($totalLateCharges > 0) {
                                    $chargeLbl = ($primaryOrder && $childOrderDetail['charge_status'] != BuyerLateChargesHistory::STATUS_PENDING) ? Labels::getLabel('Lbl_Late_Charges_Apply', $siteLangId) : Labels::getLabel('Lbl_Late_Charges_May_be_Apply', $siteLangId);
                                    ?>
                                    <div class="order-block">

                                        <ul class="cart-summary pt-0">
                                            <li class="cart-summary-item">
                                                <span class="label">
                                                    <?php echo Labels::getLabel('Lbl_Late_Charges', $siteLangId) ?>
                                                </span>
                                                <span class="value">
                                                    <?php echo CommonHelper::displayMoneyFormat($totalLateCharges, true, false, true, false, true); ?>
                                                </span>
                                            </li>
                                        </ul>

                                    </div>
                                <?php } ?>


                                <?php $totalSaving = $couponDiscount + $volumnDiscountAmount + $durationDiscountAmount + $rewardPointTotal; ?>
                                <?php if ($totalSaving != 0) { ?>
                                    <div class="total-savings">
                                        <img class="total-savings-img"
                                            src="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/savings.svg" alt="">
                                        <p>
                                            <?php echo Labels::getLabel('LBL_Your_total_savings_amount_on_this_order', $siteLangId); ?>
                                        </p>
                                        <span class="amount">
                                            <?php echo CommonHelper::displayMoneyFormat((-$totalSaving), true, false, true, false, true); ?>
                                        </span>
                                    </div>
                                <?php } ?>
                                <?php if (!empty($orderDetail['payments']) || !empty($orderDetail['shippingAddress'])) { ?>
                                    <div class="order-block">
                                        <h4>
                                            <?php echo Labels::getLabel('LBL_Order_Details', $siteLangId); ?>
                                        </h4>
                                        <?php if (!empty($orderDetail['shippingAddress'])) { ?>
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Shipping_Details', $siteLangId); ?>
                                            </h5>
                                            <div class="address-info">
                                                <?php
                                                $shippingAddress = '<p>' . $orderDetail['shippingAddress']['oua_name'] . '</p>';
                                                if ($orderDetail['shippingAddress']['oua_address1'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_address1'] . '</p>';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_address2'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_address2'] . '</p>';
                                                }

                                                $shippingAddress .= '<p>';
                                                if ($orderDetail['shippingAddress']['oua_city'] != '') {
                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_city'] . ',';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_state'] != '') {
                                                    $shippingAddress .= $orderDetail['shippingAddress']['oua_state'] . ', ';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_zip'] != '') {
                                                    $shippingAddress .= '-' . $orderDetail['shippingAddress']['oua_zip'];
                                                }
                                                $shippingAddress .= '</p>';

                                                if ($orderDetail['shippingAddress']['oua_country'] != '') {
                                                    $shippingAddress .= '<p>' . $orderDetail['shippingAddress']['oua_country'] . '</p>';
                                                }

                                                if ($orderDetail['shippingAddress']['oua_phone'] != '') {
                                                    $shippingAddress .= '<p class="c-info"><strong><i class="fas fa-mobile-alt mr-2"></i>' . $orderDetail['shippingAddress']['oua_dial_code'] . ' ' . $orderDetail['shippingAddress']['oua_phone'] . '</strong></p>';
                                                }
                                                echo $shippingAddress
                                                    ?>
                                            </div>
                                        <?php } ?>

                                        <?php if (!empty($orderDetail['payments'])) { ?>
                                            <hr class="dotted">
                                            <h5>
                                                <?php echo Labels::getLabel('LBL_Payment_History', $siteLangId); ?>
                                            </h5>
                                            <div class="list-specification">
                                                <ul>
                                                    <?php
                                                    $mCount = 1;
                                                    $totalRows = count($orderDetail['payments']);
                                                    foreach ($orderDetail['payments'] as $row) { ?>
                                                        <li>
                                                            <span class="label text-nowrap">
                                                                <?php echo Labels::getLabel('LBL_Transaction_number', $siteLangId); ?>
                                                                :
                                                                </br><strong class="value"
                                                                    style="margin-left: 0;"><?php echo trim($row['opayment_gateway_txn_id']); ?></strong>
                                                            </span>
                                                        </li>
                                                        <li>
                                                            <span class="label">
                                                                <?php echo Labels::getLabel('LBL_Payment_Method', $siteLangId); ?>
                                                            </span>
                                                            <span class="value">
                                                                <?php echo $row['opayment_method']; ?>
                                                            </span>
                                                        </li>
                                                        <li>
                                                            <span class="label">
                                                                <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                                            </span>
                                                            <span class="value">
                                                                <?php echo CommonHelper::displayMoneyFormat($row['opayment_amount'], true, false, true, false, true); ?>
                                                            </span>
                                                        </li>
                                                        <li>
                                                            <span class="label">
                                                                <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                                            </span>
                                                            <span class="value">
                                                                <?php echo FatDate::format($row['opayment_date']); ?>
                                                            </span>
                                                        </li>

                                                        <li>
                                                            <?php
                                                            /* $class = '';
                                                if (Orders::ORDER_PAYMENT_CANCELLED == $row['opayment_txn_status']) {
                                                    $class = "label-danger";
                                                } elseif (Orders::ORDER_PAYMENT_PENDING == $row['opayment_txn_status']) {
                                                    $class = "label-info";
                                                } elseif (Orders::ORDER_PAYMENT_PAID == $row['opayment_txn_status']) {
                                                    $class = "label-success";
                                                }  */ ?>
                                                            <span class="label">
                                                                <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                            </span>
                                                            <span class="value">
                                                                <?php echo $orderStatusArr[$row['opayment_txn_status']]; ?>
                                                            </span>
                                                        </li>
                                                        <li>
                                                            <span class="label">
                                                                <?php echo Labels::getLabel('LBL_Comments', $siteLangId); ?>
                                                            </span>
                                                            <span class="value">
                                                                <?php echo nl2br($row['opayment_comments']); ?>
                                                            </span>
                                                        </li>
                                                        <?php if ($mCount < $totalRows) { ?>
                                                            <hr class="dotted" />
                                                        <?php }
                                                        $mCount++;
                                                    } ?>
                                                </ul>
                                            </div>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <div class="order-block">
                                    <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                        data-bs-target="#billing-address" aria-expanded="false"
                                        aria-controls="billing-address">
                                        <?php echo Labels::getLabel('LBL_Billing_Details', $siteLangId); ?> : <i
                                            class="dropdown-toggle-custom-arrow"></i>
                                    </h4>
                                    <div class="collapse" id="billing-address">
                                        <div class="order-block-data">
                                            <div class="address-info">
                                                <?php
                                                $billingAddress = '<p>' . $orderDetail['billingAddress']['oua_name'] . '</p>';
                                                if ($orderDetail['billingAddress']['oua_address1'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_address1'] . '</p>';
                                                }

                                                if ($orderDetail['billingAddress']['oua_address2'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_address2'] . '</p>';
                                                }

                                                $billingAddress .= '<p>';

                                                if ($orderDetail['billingAddress']['oua_city'] != '') {
                                                    $billingAddress .= $orderDetail['billingAddress']['oua_city'] . ', ';
                                                }

                                                if ($orderDetail['billingAddress']['oua_state'] != '') {
                                                    $billingAddress .= $orderDetail['billingAddress']['oua_state'];
                                                }

                                                if ($orderDetail['billingAddress']['oua_zip'] != '') {
                                                    $billingAddress .= ', ' . $orderDetail['billingAddress']['oua_zip'];
                                                }
                                                $billingAddress .= '</p>';

                                                if ($orderDetail['billingAddress']['oua_country'] != '') {
                                                    $billingAddress .= '<p>' . $orderDetail['billingAddress']['oua_country'] . '</p>';
                                                }

                                                if ($orderDetail['billingAddress']['oua_phone'] != '') {
                                                    $billingAddress .= '<p class="c-info"><strong><i class="fas fa-mobile-alt mr-2"></i>' . $orderDetail['billingAddress']['oua_dial_code'] . ' ' . $orderDetail['billingAddress']['oua_phone'] . '</strong></p>';
                                                }
                                                echo $billingAddress;
                                                ?>
                                            </div>
                                        </div>
                                    </div>

                                </div>
                                <?php if (trim($pickupAddressHtml) != '') { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#pickup-address" aria-expanded="false"
                                            aria-controls="pickup-address">
                                            <?php echo Labels::getLabel('LBL_Pickup_Address:', $siteLangId); ?>
                                            <i class="dropdown-toggle-custom-arrow"></i>
                                        </h4>

                                        <div class="collapse" id="pickup-address">
                                            <?php /* <hr class="dotted"> */ ?>
                                            <div class="order-block-data">
                                                <?php echo $pickupAddressHtml; ?>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if (!empty($verificationFldsData)) { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#verification-data" aria-expanded="false"
                                            aria-controls="verification-data">
                                            <?php echo Labels::getLabel('LBL_Verification_Data', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <?php
                                        $verificationData = [];
                                        foreach ($verificationFldsData as $val) {
                                            $verificationData[$val['ovd_vfld_id']][] = $val;
                                        }
                                        ?>
                                        <div class="collapse" id="verification-data">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <ul class="">
                                                        <?php foreach ($verificationData as $key => $val) { ?>
                                                            <li>
                                                                <span class="label">
                                                                    <?php echo $val[0]['ovd_vflds_name']; ?>
                                                                </span>
                                                                <span class="value text-break">
                                                                    <?php
                                                                    if ($val[0]['ovd_vflds_type'] == VerificationFields::FLD_TYPE_TEXTBOX) {
                                                                        echo (trim($val[0]['ovd_value']) != '') ? $val[0]['ovd_value'] : Labels::getLabel('LBL_N/A', $siteLangId);
                                                                    } else {
                                                                        $downloadUrl = UrlHelper::generateUrl('Buyer', 'downloadAttachedFile', array(CommonHelper::encryptId($orderDetail['order_order_id']), CommonHelper::encryptId($val[0]['ovd_vfld_id'])));
                                                                        $file_row = AttachedFile::getAttachment(AttachedFile::FILETYPE_VERIFICATION_ATTACHMENT, $orderDetail['order_order_id'], $val[0]['ovd_vfld_id'], 0, true, 0, false);
                                                                        if (empty($file_row)) {
                                                                            echo Labels::getLabel('LBL_N/A', $siteLangId);
                                                                        } else {
                                                                            echo '<a download href="' . $downloadUrl . '"> ' . $file_row['afile_name'] . '</a>';
                                                                        }
                                                                    }
                                                                    ?>
                                                                </span>
                                                                <?php if (false == $primaryOrder) { ?>
                                                                    <span>
                                                                        <?php
                                                                        $count = count($val);
                                                                        $i = 1;
                                                                        foreach ($val as $vdata) {
                                                                            if (!isset($childOrderDetail[$vdata['optvf_op_id']]['op_selprod_title'])) {
                                                                                continue;
                                                                            }
                                                                            echo $childOrderDetail[$vdata['optvf_op_id']]['op_selprod_title'];
                                                                            if ($count > $i) {
                                                                                echo "</br>";
                                                                            }
                                                                            $i++;
                                                                        }
                                                                        ?>
                                                                    </span>
                                                                <?php } ?>

                                                            </li>
                                                        <?php } ?>
                                                    </ul>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                                <?php if (!empty($shopAgreementArr)) { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#rental-agreement" aria-expanded="false"
                                            aria-controls="rental-agreement">
                                            <?php echo Labels::getLabel('LBL_Rental_Agreement', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <div class="collapse" id="rental-agreement">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <ul class="">
                                                        <?php
                                                        foreach ($shopAgreementArr as $key => $val) {
                                                            $afileName = AttachedFile::getAttributesById($val['agreementFileId'], 'afile_name');
                                                            ?>
                                                    <li>
                                                        <span class="label">
                                                            <?php echo Labels::getLabel('LBL_Shop_Name', $siteLangId); ?>
                                                        </span>
                                                        <span class="value">
                                                            <?php echo $val['shopName']; ?>
                                                        </span>
                                                    </li>
                                                    <li>
                                                        <span class="label">
                                                            <?php echo Labels::getLabel('LBL_Shop_Agreement', $siteLangId); ?>
                                                        </span>
                                                        <span class="value">
                                                            <a download
                                                                href="<?php echo UrlHelper::generateUrl('Buyer', 'downloadDigitalFile', [CommonHelper::encryptId($key), CommonHelper::encryptId($val['agreementFileId']), AttachedFile::FILETYPE_SHOP_AGREEMENT]); ?>"
                                                                title="<?php echo Labels::getLabel('LBL_Download_file', $siteLangId); ?>">
                                                                <?php echo $afileName; ?>
                                                            </a>
                                                        </span>
                                                    </li>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                                <?php if (empty($childOrderDetail['order_is_rfq']) && (!empty($childOrderDetail['invoice_delivery_date']) || !empty($childOrderDetail['invoice_description']))) { ?>
                                    <div class="order-block">
                                        <h4 class="dropdown-toggle-custom collapsed" data-bs-toggle="collapse"
                                            data-bs-target="#invoice-data" aria-expanded="false"
                                            aria-controls="invoice-data">
                                            <?php echo Labels::getLabel('LBL_Invoice_Details', $siteLangId); ?> <i
                                                class="dropdown-toggle-custom-arrow"></i>
                                        </h4>
                                        <div class="collapse" id="invoice-data">
                                            <div class="order-block-data">
                                                <div class="list-specification">
                                                    <?php if (!empty($childOrderDetail['invoice_delivery_date'])) { ?>
                                                        <p>
                                                            <strong>
                                                                <?php echo Labels::getLabel('LBL_Delivery_date', $siteLangId); ?>:
                                                            </strong>
                                                            <?php echo FatDate::format($childOrderDetail['invoice_delivery_date']); ?>
                                                        </p>
                                                    <?php } ?>
                                                    <?php if (!empty($childOrderDetail['invoice_description'])) { ?>
                                                        <p>
                                                            <strong>
                                                                <?php echo Labels::getLabel('LBL_Description', $siteLangId); ?>:
                                                            </strong>
                                                            <?php echo nl2br($childOrderDetail['invoice_description']); ?>
                                                        </p>
                                                    <?php } ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>

                            </div>
                        </div>
                    </div>
                    
                    
                    <?php
                    if(!empty($childOrderDetail['partialPaymentLog'])){
                    ?>
                    <div class="row mt-5">
                        <div class="col-md-12">

                        <div class="card" >
                            <div class="card-head">
                            <h5 class="card-title"><?php echo Labels::getLabel('LBL_Payment_Log', $siteLangId); ?>   
                          
                                      </h5>
                                      <?php 
                    
                    if(!empty($childOrderDetail['op_pending_amount']) && $childOrderDetail['op_pending_amount'] > 0 && $childOrderDetail['op_payment_status'] == Orders::ORDER_PAYMENT_PARTIAL){
                    ?>
                    <div class="links-inline">
                        <button type="button" class="btn btn-outline-gray qwer  btn-add" title="<?php echo Labels::getLabel('LBL_Pay_Order', $siteLangId); ?>" onClick="payOrderProductReqForm('<?php echo $childOrderDetail['op_order_id']; ?>','<?php echo $childOrderDetail['op_id']; ?>')">
                            <svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#add">
                                </use>
                            </svg>
                            <?php echo Labels::getLabel('LBL_Pay_Order', $siteLangId); ?></button>
                    </div>
                    <?php    
                    }
                     ?>
                            </div>
                            <div class="card-table">
                            <div class="table-responsive table-scrollable js-scrollable tablewrap">
                            <table class="table table-justified">
                                        <thead>
                                            <tr>
                                                <th width="100px">
                                                    <?php echo Labels::getLabel('LBL_Date', $siteLangId); ?>
                                                </th>
                                                <th >
                                                    <?php echo Labels::getLabel('LBL_Type', $siteLangId); ?>
                                                </th>
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Comment', $siteLangId); ?>
                                                </th>
                                                <th >
                                                    <?php echo Labels::getLabel('LBL_Txn_Id', $siteLangId); ?>
                                                </th>
                                                <!-- <th width="50px">
                                                    <?php echo Labels::getLabel('LBL_Status', $siteLangId); ?>
                                                </th> -->
                                                <th>
                                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                                </th>
                                             
                                                
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php 
                                            foreach($childOrderDetail['partialPaymentLog'] as $key => $val){
                                                ?>
                                                <tr>
                                                    <td>
                                                        <?php echo $val['oppl_created_at']; ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['status_title']; ?>
                                                        &nbsp;
                                                        <?php 
                                                        if($val['oppl_type'] == OrderProduct::DB_TBL_REQUEST_TYPE && $val['oppl_status'] == Orders::ORDER_PAYMENT_PENDING && !empty($val['oppl_amount']) && $childOrderDetail['op_pending_amount'] > 0 && $childOrderDetail['op_payment_status'] == Orders::ORDER_PAYMENT_PARTIAL && $childOrderDetail['op_pending_amount'] >= $val['oppl_amount'] ){
                                                            ?>
                                                        <ul class="actions actions-tbl">
                                                            <li class="actions-item"><button type="button" data-bs-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo Labels::getLabel('LBL_Pay', $siteLangId); ?>"  data-bs-original-title="<?php echo Labels::getLabel('LBL_Pay', $siteLangId); ?>"  class="actions-link zxc" onclick="setUpOrderPaymentRequest(<?php echo $val['oppl_id'] ?>); return false;"><svg width="16px" height="16px" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor"><path d="M3.00488 2.99979H21.0049C21.5572 2.99979 22.0049 3.4475 22.0049 3.99979V19.9998C22.0049 20.5521 21.5572 20.9998 21.0049 20.9998H3.00488C2.4526 20.9998 2.00488 20.5521 2.00488 19.9998V3.99979C2.00488 3.4475 2.4526 2.99979 3.00488 2.99979ZM20.0049 10.9998H4.00488V18.9998H20.0049V10.9998ZM20.0049 8.99979V4.99979H4.00488V8.99979H20.0049ZM14.0049 14.9998H18.0049V16.9998H14.0049V14.9998Z"></path></svg></button></li>
                                                        </ul>
                                                            <?php
                                                        }
                                                        ?>
                                                        
                                                    </td>
                                                    <td>
                                                        <?php echo $val['oppl_comment']; ?>
                                                       
                                                        <?php
                                                    $attachedFile = AttachedFile::getMultipleAttachments(AttachedFile::FILETYPE_FLEXI_PAYMENT_ATTACHMENT, $val['oppl_id']);
                                                    if (!empty($attachedFile)) {
                                                        ?>
                                                         <?php
                                                        foreach ($attachedFile as $attach) {
                                                            ?>
                                                            <a class="actions-link" href="<?php echo UrlHelper::generateUrl('Account', 'downloadAttachedFileMsg', array(CommonHelper::encryptId($attach['afile_id']))); ?>" data-bs-toggle='tooltip' data-placement='top' data-original-title='<?php echo $attach['afile_name']; ?>' title='<?php echo $attach['afile_name']; ?>' download>
                       

                                                                <span data-bs-toggle="tooltip" data-placement="top" title="" data-original-title="<?php echo $attach['afile_name']; ?>"><svg class='svg' width='28' height='28'>
                                                                <use xlink:href=' <?php echo CONF_WEBROOT_URL ?>images/retina/sprite.svg#dash-downloads'></use></svg></span>
                                                            </a>
                                                        <?php }
                                                    } ?>
                                                    </td>
                                                    <td>
                                                        <?php echo $val['opayment_gateway_txn_id']; ?>
                                                    </td>
                                                    
                                                    

                                                    <!-- <td>
                                                    <?php
                                                    $class = '';
                                                    if (Orders::ORDER_PAYMENT_CANCELLED == $val['oppl_status']) {
                                                        $class = "label-danger badge-danger";
                                                    } elseif (Orders::ORDER_PAYMENT_PENDING == $val['oppl_status']) {
                                                        $class = "label-info badge-info";
                                                    } elseif (Orders::ORDER_PAYMENT_PAID == $val['oppl_status']) {
                                                        $class = "label-success badge-success";
                                                    }
                                                    ?>
                                                    <span class="badge badge-inline <?php echo $class; ?>">
                                                        <?php
                                                        $orderStatusArr = Orders::getOrderPaymentStatusArr($siteLangId);
                                                        echo $orderStatusArr[$val['oppl_status']];
                                                        ?>
                                                    </span>
                                                </td> -->
                                                    <td>
                                                        <?php echo  CommonHelper::displayMoneyFormat($val['oppl_amount'], true, false, true, false, true) ; ?>
                                                    </td>
                                                </tr>
                                                <?php
                                            }
                                            ?>
                                        </tbody>
                                        <thead>
                                            <tr>
                                                <td colspan="6">
                                                    <strong>
                                                    <?php echo Labels::getLabel('LBL_Pending_Amount', $siteLangId); ?>&nbsp;&nbsp;: &nbsp;&nbsp;&nbsp;
                                                    <?php echo CommonHelper::displayMoneyFormat($childOrderDetail['op_pending_amount'], true, false, true, false, true) ?>
                                                    </strong>
                                                </td>
                                            </tr>
                                        </thead>
                                </table>
                                </div>
                            </div>
                        </div>

                                
                            </div>
                        </div>
                        <?php } ?>

                    </div>
                </div>
            </div>
        </div>
    </div>
</main>
<?php if ($totalSecurityAmount > 0) { ?>
    <!-- Modal -->
    <div class="modal fade" id="security_modal" tabindex="-1" role="dialog" aria-labelledby="securityModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="securityModalLabel">
                        <?php echo Labels::getLabel('LBL_Security_List', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $securityHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($totalSecurityAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($taxOptionsHtml != '') { ?>
    <div class="modal fade" id="tax_modal" tabindex="-1" role="dialog" aria-labelledby="taxModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="taxModalLabel">
                        <?php echo Labels::getLabel('LBL_Tax_List', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $taxOptionsHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <?php if ($roundingOffTotal != 0) { ?>
                        <div class="row w-100">
                            <div class="col">
                                <span>
                                    <?php echo ($roundingOffTotal > 0) ? Labels::getLabel('LBL_Rounding_Up', $siteLangId) : Labels::getLabel('LBL_Rounding_Down', $siteLangId); ?>
                                    :
                                </span>
                            </div>
                            <div class="col-auto">
                                <span>
                                    <?php echo CommonHelper::displayMoneyFormat($roundingOffTotal, true, false, true, false, true); ?>
                                </span>
                            </div>
                        </div>
                    <?php } ?>
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($totalTaxes, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($isShipping) { ?>
    <div class="modal fade" id="shipping_modal" tabindex="-1" role="dialog" aria-labelledby="shippingModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="shippingModalLabel">
                        <?php echo Labels::getLabel('LBL_Shipping_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Shipping_Method', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $shippingHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($shippingCharges, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($volumnDiscountAmount != 0) { ?>
    <div class="modal fade" id="volume_modal" tabindex="-1" role="dialog" aria-labelledby="volumeModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="volumeModalLabel">
                        <?php echo Labels::getLabel('LBL_Volume_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $volumnDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($volumnDiscountAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
<?php } ?>
<?php if ($durationDiscountAmount != 0) { ?>
    <div class="modal fade" id="duration_discount_modal" role="dialog" aria-labelledby="durationDiscountModalLabel"
        aria-hidden="true" tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="durationDiscountModalLabel">
                        <?php echo Labels::getLabel('LBL_Duration_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $durationDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($durationDiscountAmount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if ($couponDiscount != 0) { ?>
    <div class="modal fade" id="discount_modal" role="dialog" aria-labelledby="discountModalLabel" aria-hidden="true"
        tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="discountModalLabel">
                        <?php echo Labels::getLabel('LBL_Discount_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Product_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $couponDiscountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($couponDiscount, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>
<?php if (!empty($attachedServicesArr)) { ?>
    <div class="modal fade" id="addon_modal" role="dialog" aria-labelledby="addonModalLabel" aria-hidden="true"
        tabindex="-1">
        <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addonModalLabel">
                        <?php echo Labels::getLabel('LBL_Addons_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body p-0">
                    <table class="table table-justified ">
                        <thead>
                            <tr>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Addon_Name', $siteLangId); ?>
                                </th>
                                <th>
                                    <?php echo Labels::getLabel('LBL_Amount', $siteLangId); ?>
                                </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php echo $addonAmountHtml; ?>
                        </tbody>
                    </table>
                </div>
                <div class="modal-footer px-0">
                    <div class="row w-100">
                        <div class="col">
                            <span>
                                <?php echo Labels::getLabel('LBL_Total_Amount', $siteLangId); ?> :
                            </span>
                        </div>
                        <div class="col-auto">
                            <span>
                                <?php echo CommonHelper::displayMoneyFormat($addonTotal, true, false, true, false, true); ?>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php if (FatApp::getConfig('CONF_ENABLED_CHECKLIST_MODULE', FatUtility::VAR_INT, 0) == applicationConstants::YES) { ?>

    <?php if ((Shipping::FULFILMENT_PICKUP == $childOrder['opshipping_fulfillment_type']) && (!empty($orderDetail['checklistPoints']) && array_key_exists(7, $orderDetail['checklistPoints']))) { ?>
        <div class="modal fade" id="shipped_checklist_points_modal" role="dialog" aria-labelledby="shippedChecklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="shippedChecklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_DELIVERED])) { ?>
                                <table class="table">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId); ?></th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_DELIVERED] as $sku => $selectedChecklistPoints) {
                                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="modal-footer px-0">
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>


    <?php if (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_SHIPPED, $orderDetail['checklistPoints'])) { ?>
        <div class="modal fade" id="shipped_checklist_points_modal" role="dialog" aria-labelledby="shippedChecklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="shippedChecklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED])) { ?>
                                <table class="table">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId); ?></th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED] as $sku => $selectedChecklistPoints) {
                                            $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php

                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

    <?php if (!empty($orderDetail['checklistPoints']) && array_key_exists(OrderStatus::ORDER_RENTAL_RETURNED, $orderDetail['checklistPoints'])) { ?>
        <div class="modal fade" id="returned_checklist_points_modal" role="dialog" aria-labelledby="checklistModalLabel"
            aria-hidden="true" tabindex="-1">
            <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title" id="checklistModalLabel">
                            <?php echo Labels::getLabel('LBL_CHECKLIST_POINTS', $siteLangId); ?>
                        </h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                        </button>
                    </div>
                    <div class="modal-body p-0">
                        <div class="container">
                            <?php if (!empty($orderDetail['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED])) { ?>
                                <table class="table rental-returned">
                                    <thead>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_NAME', $siteLangId); ?></th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId) . ' (' . Labels::getLabel('LBL_SHIPPED', $siteLangId) . ')'; ?>
                                        </th>
                                        <th><?php echo Labels::getLabel('LBL_FIELD_VALUE', $siteLangId) . ' (' . Labels::getLabel('LBL_RENTAL_RETURNED', $siteLangId) . ')'; ?>
                                        </th>
                                    </thead>
                                    <tbody>

                                        <?php
                                        foreach ($orderDetail['checklistPoints'][OrderStatus::ORDER_RENTAL_RETURNED] as $key => $selectedChecklistPoints) {

                                            $shippedValue = "";
                                            if (array_key_exists(OrderStatus::ORDER_SHIPPED, $orderDetail['checklistPoints'])) {
                                                if ($orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                                    $shippedValue = implode(', ', explode(PHP_EOL, $orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value']));
                                                } else {
                                                    $shippedValue = $orderDetail['checklistPoints'][OrderStatus::ORDER_SHIPPED][$key]['opcp_cp_value'];
                                                }
                                            }

                                            $value = "";
                                            if ($selectedChecklistPoints['cp_type'] == ChecklistPoint::CHECKLISTTYPE_CHECKBOXES) {
                                                $value = implode(', ', explode(PHP_EOL, $selectedChecklistPoints['opcp_cp_value']));
                                            } else {
                                                $value = $selectedChecklistPoints['opcp_cp_value'];
                                            }
                                            ?>
                                            <tr>
                                                <td>
                                                    <span class="lable"><?php echo $selectedChecklistPoints['opcp_cp_name']; ?></span>
                                                </td>
                                                <td>
                                                    <?php if (!empty($shippedValue)) { ?>
                                                        <span class="value"><?php echo $shippedValue; ?></span>
                                                    <?php } ?>
                                                </td>
                                                <td>
                                                    <span class="value"><?php echo $value; ?></span>
                                                </td>
                                            </tr>
                                            <?php
                                        }
                                        ?>
                                    </tbody>
                                </table>
                            <?php } ?>
                        </div>
                    </div>
                    <div class="modal-footer px-0">
                    </div>
                </div>
            </div>
        </div>
    <?php } ?>

<?php } ?>

<?php

foreach ($arr as $childOrderRow) { 
if(!empty($childOrderRow['opd_price_bifurcation'])) { 
$childOpId = $childOrderRow['op_id'];
$rentalPriceDetail = json_decode(html_entity_decode($childOrderRow['opd_price_bifurcation']), true);
$quantity = $childOrderRow['op_qty'];
?>
	<div class="modal fade" id="price-bifurcation-<?php echo $childOpId; ?>" tabindex="-1" role="dialog" aria-labelledby="priceDetailLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="priceDetailLabel">
                        <?php echo Labels::getLabel('LBL_Price_Details', $siteLangId); ?>
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">

                    </button>
                </div>
                <div class="modal-body">
                    <?php 
					include(CONF_DEFAULT_THEME_PATH . '_partial/product/price-breakup.php'); 
					?>
                </div>
            </div>
        </div>
    </div>
	<script>
	var child_op_id = '<?php echo $childOpId; ?>';
	$('#price-bifurcation-'+child_op_id).insertAfter('.wrapper');
	</script>
<?php } } ?>

<script>
    var RENTAL_RETURN_STATUS_ID =
        <?php echo FatApp::getConfig('CONF_DEFAULT_READY_FOR_RENTAL_RETURN_BUYER_END', FatUtility::VAR_INT, 0); ?>;
    $(document).ready(function () {
        $('.orderReturnReson--js').hide();
        $('select[name="op_status_id"]').on('change', function () {
            if ($(this).val() == <?php echo FatApp::getConfig('CONF_RETURN_REQUEST_ORDER_STATUS'); ?>) {
                $('.orderReturnReson--js').show();
            } else {
                $('.orderReturnReson--js').hide();
            }
        });

        $('select[name="op_return_fullfillment_type"]').on('change', function () {
            if (parseInt($(this).val()) == '<?php echo OrderProduct::RENTAL_ORDER_RETURN_TYPE_SHIP; ?>') {
                $('.shipfield').removeClass('ship-fld--js');
                $('.dropfld').addClass('ship-fld--js');
                /* $('.dropfld input').val(""); */
            } else {
                $('.shipfield input').val("");
                $('.shipfield').addClass('ship-fld--js');
                $('.dropfld').removeClass('ship-fld--js');
            }
        }).change();
    });

    trackOrder = function (trackingNumber, courier, orderNumber) {
        $.facebox(function () {
            fcom.ajax(fcom.makeUrl('Buyer', 'orderTrackingInfo', [trackingNumber, courier, orderNumber]), '',
                function (res) {
                    $.facebox(res, 'medium-fb-width');
                });
        });
    };

    var FULLFILLMENT_SHIP = '<?php echo OrderProduct::RENTAL_ORDER_RETURN_TYPE_SHIP; ?>';

    $('#security_modal').insertAfter('.wrapper');
    $('#tax_modal').insertAfter('.wrapper');
    $('#shipping_modal').insertAfter('.wrapper');
    $('#volume_modal').insertAfter('.wrapper');
    $('#duration_discount_modal').insertAfter('.wrapper');
    $('#discount_modal').insertAfter('.wrapper');
    $('#addon_modal').insertAfter('.wrapper');
    $('#shipped_checklist_points_modal').insertAfter('.wrapper');
    $('#returned_checklist_points_modal').insertAfter('.wrapper');
</script>
<style>
    .ship-fld--js {
        display: none;
    }

    input[type="file"] {
        width: 100% !important;
    }

    .disabled-input {
        color: rgba(0, 0, 0, 0.38) !important;
        background-color: rgba(0, 0, 0, 0.12) !important;
        box-shadow: none;
        cursor: initial;
        border-color: transparent !important;
    }

    .blank-anchor:hover {
        text-decoration: none !important;
        cursor: auto !important;
    }

    #checklist_options .field-wraper {
        align-content: center;
    }

    .table tr td {
        position: relative;
        max-width: 5rem;
    }

    .table .sku-heading {
        font-weight: 600;
        line-height: 0.5;
        background: #efefef;
    }
</style>