<div class="cart-table-row <?php echo md5($product['key']); ?> <?php echo (!$product['in_stock']) ? 'disabled' : ''; ?>"
    data-cols="2">
    <div class="cart-table-col cart-table-col-1">
        <div class="product-profile">
            <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                <img class="img-fluid" src="<?php echo $imageUrl; ?>" alt="<?php echo $productTitle; ?>"
                    title="<?php echo $productTitle; ?>">
            </a>
            <div class="product-profile-data">
                <a class="title" href="<?php echo $productUrl; ?>">
                    <?php echo $productTitle; ?>
                </a>
                <div class="product-price">
                    <div class="products-price-new">
                        <?php echo CommonHelper::displayMoneyFormat($product['theprice'] * $product['quantity']); ?>
                    </div>
                </div>
                <?php if (isset($isShipPickable) && $isShipPickable == false) { ?>
                <div class="not-pick-ship">
                    <?php echo $label; ?>
                </div>
                <?php } ?>
                <?php
                if (isset($product['options']) && count($product['options'])) {
                    ?>
                <div class="options">
                    <p class="">
                        <?php

                            foreach ($product['options'] as $key => $option) {
                                echo (0 < $key) ? ' | ' : "";
                                echo $option['option_name'] . ':';
                                ?>
                        <span class="text--dark"><?php echo $option['optionvalue_name']; ?></span>
                        <?php
                            }

                            ?>
                    </p>
                </div>
                <?php } ?>
                <div class="dates">
                    <?php if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                    <svg class="svg" width="16" height="16">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#calendar">
                        </use>
                    </svg>
                    <span class="lable">
                        <?php echo date('M d, Y H:i ', strtotime($product['rentalStartDate'])); ?>
                        <?php echo Labels::getLabel('LBL_To', $siteLangId); ?>
                        <?php echo date('M d, Y H:i', strtotime($product['rentalEndDate'])); ?>
                    </span>
                    <?php } ?>
                </div>
                <!--  -->
                <ul class="actions">
                    <?php
                    $productAmount = ($product['theprice'] * $product['quantity']);

                    if ($product['sellerProdType'] != SellerProduct::PRODUCT_TYPE_ADDON && $cartType != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) { /* @TODO */
                        $showAddToFavorite = true;
                        if (UserAuthentication::isUserLogged() && (!User::isBuyer())) {
                            $showAddToFavorite = false;
                        }
                        if ($showAddToFavorite) {
                            $jsFunc = 0 < $product['ufp_id'] ? 'removeFromFavorite(' . $product['selprod_id'] . ')' : 'markAsFavorite(' . $product['selprod_id'] . ')';
                            ?>
                    <li class="actions-item">
                        <button data-toggle="tooltip"
                            class="actions-link heart-wrapper--js heart-wrapper <?php echo ($product['ufp_id']) ? 'is-active' : ''; ?>"
                            onclick="<?php echo $jsFunc; ?>" data-id="<?php echo $product['selprod_id']; ?>"
                            title="<?php echo ($product['ufp_id']) ? Labels::getLabel('LBL_Remove_product_from_favourite_list', $siteLangId) : Labels::getLabel('LBL_Add_Product_to_favourite_list', $siteLangId); ?>">
                            <svg class="svg icon-unchecked--js" height="18" width="18"
                                <?php if ($product['ufp_id']) { ?> style="display:none" <?php } ?>>
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#heart">
                                </use>
                            </svg>
                            <svg class="svg icon-checked--js" height="18" width="18" <?php if (!$product['ufp_id']) { ?>
                                style="display:none" <?php } ?>>
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#heart-fill">
                                </use>
                            </svg>
                        </button>
                    </li>
                    <?php } ?>
                    <li class="actions-item">
                        <button data-toggle="tooltip" class="actions-link"
                            onClick="moveToSaveForLater('<?php echo md5($product['key']); ?>',<?php echo $product['selprod_id']; ?>, <?php echo $fullfillmentType; ?>);"
                            title="<?php echo Labels::getLabel('LBL_Move_to_Save_For_Later', $siteLangId); ?>">
                            <svg class="svg" width="18" height="18" title="">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#saveforlater">
                                </use>
                            </svg>
                        </button>
                    </li>
                    <?php } ?>
                    <li class="actions-item">

                        <?php
                        if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) {
                            $duration = CommonHelper::getDifferenceBetweenDates($product['rentalStartDate'], $product['rentalEndDate'], $product['selprod_user_id'], $product['sprodata_duration_type']);

                            $label = Labels::getLabel('LBL_Details', $siteLangId);
                            if (isset($product['attachedAddonsList']) && count($product['attachedAddonsList']) > 0) {
                                $label = Labels::getLabel('LBL_Addons_and_Details', $siteLangId);
                            }
                            ?>
                        <div class="dropdown addons">
                            <button class="dropdown-toggle addons-btn" type="button" data-bs-toggle="dropdown"
                                data-bs-auto-close="outside" aria-expanded="false">
                                <span class="txt"><?php echo $label; ?> </span>
                            </button>
                            <div class="dropdown-menu addons-dropdown">
                                <?php
                                    $addonTotalAmount = 0;
                                    if (isset($product['attachedAddonsList']) && !empty($product['attachedAddonsList'])) {
                                        ?>
                                <ul class="addons-list scroll scroll-x">
                                    <?php
                                            $uncheckedAddons = [];
                                            foreach ($product['attachedAddonsList'] as $addonKey => $addVal) {
                                                $productKey = '';
                                                $checkedAddon = false;
                                                if (in_array($addVal['selprod_id'], $checkedAddonsArr)) {
                                                    $productKey = Cart::CART_KEY_PREFIX_PRODUCT . $addVal['selprod_id'] . $product['rentalStartDate'] . $product['rentalEndDate'];
                                                    $productKey = md5(base64_encode(json_encode($productKey)));
                                                    $checkedAddon = true;
                                                    $addonTotalAmount += ($addVal['selprod_price'] * $product['quantity']);
                                                } else {
                                                    $uncheckedAddons[$addonKey] = $addVal;
                                                    continue;
                                                }
                                                ?>
                                    <li class="addons-list-item">
                                        <label class="addons-list_label" for="">
                                            <div class="checkbox">
                                                <input type="checkbox" data-cartkey="<?php echo $productKey; ?>"
                                                    data-selprodid="<?php echo $addVal['selprod_id']; ?>"
                                                    data-mainproductkey="<?php echo md5($product['key']); ?>"
                                                    name="check_addons" onClick="addAddonToCart(this);"
                                                    id="check_addons_<?php echo $addVal['selprod_id']; ?>"
                                                    <?php echo ($checkedAddon) ? 'checked' : ''; ?> />
                                            </div>
                                            <div class="addons-list-detail">
                                                <div class="title">
                                                    <?php echo html_entity_decode($addVal['selprod_title']); ?>

                                                </div>
                                                <div class="price">
                                                    <strong><?php echo CommonHelper::displayMoneyFormat($addVal['selprod_price']); ?></strong>
                                                    / <?php echo Labels::getLabel('LBL_Per_Qty', $siteLangId); ?>
                                                </div>
                                            </div>
                                        </label>
                                    </li>
                                    <?php } ?>
                                    <?php
                                            if (!empty($uncheckedAddons)) {
                                                foreach ($uncheckedAddons as $addonKey => $addVal) {
                                                    ?>
                                    <li class="addons-list-item">
                                        <label class="addons-list_label" for="">
                                            <div class="checkbox">
                                                <input type="checkbox" data-cartkey="<?php echo $productKey; ?>"
                                                    data-selprodid="<?php echo $addVal['selprod_id']; ?>"
                                                    data-mainproductkey="<?php echo md5($product['key']); ?>"
                                                    name="check_addons" onClick="addAddonToCart(this);"
                                                    id="check_addons_<?php echo $addVal['selprod_id']; ?>" />
                                            </div>
                                            <div class="addons-list-detail">
                                                <div class="title">
                                                    <?php echo html_entity_decode($addVal['selprod_title']); ?>
                                                </div>
                                                <div class="price">
                                                    <strong><?php echo CommonHelper::displayMoneyFormat($addVal['selprod_price']); ?></strong>
                                                    / <?php echo Labels::getLabel('LBL_Per_Qty', $siteLangId); ?>
                                                </div>
                                            </div>
                                        </label>
                                    </li>
                                    <?php
                                                }
                                            }
                                            ?>
                                </ul>
                                <?php } ?>
                                <ul class="list-addons-specification">
                                    <li class="list-addons-specification-item" data-bs-toggle="tooltip"
                                        data-placement="top"
                                        title="<?php echo Labels::getLabel('LBL_Duration', $siteLangId); ?>">
                                        <svg class="svg" width="14" height="14">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#calendar">
                                            </use>
                                        </svg>
                                        <span class="lable">
                                            <?php echo CommonHelper::displayProductRentalDuration($duration, $product['sprodata_duration_type'], $siteLangId); ?>
                                        </span>
                                    </li>
                                    <li class="list-addons-specification-item" data-bs-toggle="tooltip"
                                        data-placement="top"
                                        title="<?php echo Labels::getLabel('LBL_Price_', $siteLangId); ?>">
                                        <svg class="svg" width="14" height="14">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#price">
                                            </use>
                                        </svg>
                                        <span class="lable">
                                            <?php echo CommonHelper::displayMoneyFormat($productAmount + $addonTotalAmount, $siteLangId); ?>
                                        </span>
                                    </li>
                                    <li class="list-addons-specification-item" data-bs-toggle="tooltip"
                                        data-placement="top"
                                        title="<?php echo Labels::getLabel('LBL_Security', $siteLangId); ?>">
                                        <svg class="svg" width="14" height="14">
                                            <use
                                                xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#seurity-amount">
                                            </use>
                                        </svg>
                                        <span class="lable">
                                            <?php echo CommonHelper::displayMoneyFormat(($product['sprodata_rental_security'] * $product['quantity']), $siteLangId); ?>
                                        </span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                        <?php } ?>
                    </li>
                </ul>
            </div>
        </div>
    </div>
    <div class="cart-table-col cart-table-col-2">
        <?php
        $enableQuantityUpdate = false;
        if (($product['productFor'] == applicationConstants::PRODUCT_FOR_SALE && $product['selprod_stock'] > $product['quantity']) || ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT && $product['sprodata_rental_stock'] > $product['quantity']) && $cartType != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
            $enableQuantityUpdate = true;
        }
        ?>
        <div class="product-quantity">
            <div class="quantity quantity-2 quantity--js"
                data-rentalstock="<?php echo $product['sprodata_rental_stock']; ?>"
                data-stock="<?php echo $product['selprod_stock']; ?>"
                data-minsaleqty="<?php echo $product['selprod_min_order_qty']; ?>"
                data-minrentqty="<?php echo $product['sprodata_minimum_rental_quantity']; ?>">
                <button type="button" class="quantity-btn decrease decrease-js">
                    <svg class="svg" width="14" height="14">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#minus"></use>
                    </svg>
                </button>
                <div class="qty-input-wrapper" data-stock="<?php echo $product['selprod_stock']; ?>">
                    <input class="qty-input cartQtyTextBox productQty-js" name="qty_<?php echo md5($product['key']); ?>"
                        data-key="<?php echo md5($product['key']); ?>" value="<?php echo $product['quantity']; ?>"
                        type="text" <?php echo (!$enableQuantityUpdate) ? "disabled" : " "; ?> />
                </div>
                <button type="button"
                    class="quantity-btn increase <?php echo ($enableQuantityUpdate) ? " increase-js " : "not-allowed "; ?>">
                    <svg class="svg" width="14" height="14">
                        <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#plus"></use>
                    </svg>
                </button>
            </div>
            <ul class="actions">
                <li class="actions-item">
                    <button data-toggle="tooltip" class="actions-link btn-remove"
                        onclick="cart.remove('<?php echo md5($product['key']); ?>', 'cart')"
                        title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                        <svg class="svg" width="24" height="24"
                            title="<?php echo Labels::getLabel('LBL_Remove', $siteLangId); ?>">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#remove"></use>
                        </svg>
                    </button>
                </li>
            </ul>

        </div>

    </div>

    <?php
                    if(isset($product['seller_product_upfront_percentage']) && $product['seller_product_upfront_percentage'] != 100){                        
                        ?>

    <label class="checkbox checkbox-sm flexi-pay" for="switch<?php echo md5($product['key']); ?>"><input value="1"
            <?php echo !empty($product['isParialPaymentEnabled'])?'checked':'' ?>
            name="partial_payment_<?php echo md5($product['key']) ?>" type="checkbox"
            id="switch<?php echo md5($product['key']); ?>"
            onclick="cart.updatePaymentMethod('<?php echo md5($product['key']); ?>', 'cart')">
        <span class="flexi-pay-data">
            <strong><?php echo Labels::getLabel('LBL_Avail_Partial_Payment_Option', $siteLangId); ?></strong>
            <?php echo Labels::getLabel('LBL_(_Pay_just_the_upfront_amount_and_spread_the_remaining_balance_into_convenient_installments._)', $siteLangId); ?>
        </span>
    </label>

    <?php
                    }
                     ?>
</div>