<?php
foreach ($categoriesArr as $category) {
    $totalProduct = (isset($category['totalProducts'])) ? $category['totalProducts'] : 0;
    if ((!empty($category['children']))) {
        $childArr = $category['children'];
        $childProductColArr = array_column($childArr, 'totalProducts');
        $totalProduct = array_sum($childProductColArr);
    }
    ?>

<div class="categories">
    <div class="categories-head">
        <?php $fileRow = CommonHelper::getImageAttributes(AttachedFile::FILETYPE_CATEGORY_BANNER, $category['prodcat_id']); ?>
        <img class="categories-main-img"
            src="<?php echo UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('Category', 'banner', array($category['prodcat_id'], $siteLangId, 'MEDIUM', applicationConstants::SCREEN_DESKTOP)), CONF_IMG_CACHE_TIME, '.jpg'); ?>"
            alt="<?php echo (!empty($fileRow['afile_attribute_alt'])) ? $fileRow['afile_attribute_alt'] : $category['prodcat_name']; ?>"
            title="<?php echo (!empty($fileRow['afile_attribute_title'])) ? $fileRow['afile_attribute_title'] : $category['prodcat_name']; ?>">
        <a class="categories-main-link"
            href="<?php echo UrlHelper::generateUrl('category', 'view', array($category['prodcat_id'])); ?>">
            <?php echo $category['prodcat_name']; ?>
        </a>
    </div>
    <div class="categories-body">

        <ul class="categories-list">
            <?php if (!empty($category['children'])) { ?>

            <?php foreach ($category['children'] as $subcat) { ?>

            <li class="categories-list-item">
                <a class="categories-list-link"
                    href="<?php echo UrlHelper::generateUrl('category', 'view', array($subcat['prodcat_id'])); ?>">
                    <?php echo $subcat['prodcat_name']; ?>
                </a>

                <!-- [ 3RD LEVEL CATEGORIES LISTING -->
                <?php if (!empty($subcat['children'])) { ?>
                <ul class="categories-list-bullet">
                    <?php foreach ($subcat['children'] as $subChildCat) { ?>
                    <li class="categories-list-bullet-item">
                        <a class="categories-list-bullet-link"
                            href="<?php echo UrlHelper::generateUrl('category', 'view', array($subChildCat['prodcat_id'])); ?>">
                            <?php echo $subChildCat['prodcat_name'] ?>
                        </a>
                    </li>
                    <?php } ?>
                </ul>
                <?php } ?>
            </li>
            <?php } ?>

            <?php }
                ?>
        </ul>
    </div>
</div>
<?php

}
?>