<?php defined('SYSTEM_INIT') or die('Invalid Usage.');
if (!empty($orderShippingData)) {
    ?>
    <div class="modal-dialog modal-lg modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">
                    <?php echo Labels::getLabel('LBL_Shipping', $siteLangId); ?>
                </h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"> </button>
            </div>
            <div class="modal-body">
                <ul class="list-group">
                    <?php foreach ($orderShippingData as $shipData) { ?>
                        <li class="list-group-item">
                            <div class="shipping-data">
                                <ul class="media-more media-more-sm show">
                                    <?php foreach ($shipData as $data) { ?>
                                        <li class="media-more-item">
                                            <span class="circle" data-bs-toggle="tooltip" data-placement="top"
                                                title="<?php echo $data['op_selprod_title']; ?>"
                                                data-original-title="<?php echo $data['op_selprod_title']; ?>">
                                                <?php
                                                if ($data['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                                    $imgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'addonProduct', array($data['op_selprod_id'], "THUMB", 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                } else {
                                                    $imgUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($data['selprod_product_id'], "THUMB", $data['op_selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                                                }
                                                ?>
                                                <img src="<?php echo $imgUrl; ?>" alt="<?php echo $data['op_selprod_title']; ?>">
                                            </span>
                                        </li>
                                    <?php } ?>
                                    <li class="media-more-item media-more-txt shipping-data_title">
                                        <?php
                                        if ($data['opd_product_type'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                                            echo Labels::getLabel('LBL_Rental_Service(No_Shipping_Required)', $siteLangId);
                                        } else {
                                            echo $data['opshipping_label'];
                                        }
                                        ?>
                                    </li>
                                </ul>

                            </div>

                        </li>
                    <?php } ?>
                </ul>
            </div>
            <div class="modal-footer">
                <button class="btn btn-brand btn-wide ms-auto" type="button"
                    onClick="ShippingSummaryData();"><?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?></button>
            <?php } else { ?>
                <div class="pop-up-title"><?php echo Labels::getLabel('LBL_No_Pick_Up_address_added', $siteLangId); ?></div>
            <?php } ?>
        </div>
    </div>
</div>

<script>
    ShippingSummaryData = function () {
        /* $("#facebox .close").trigger('click'); */
        $("#exampleModal .btn-close").click();
        loadShippingSummaryDiv();
    }
</script>