<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>

<div id="shipping-summary" class="step">
    <?php
    if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
    ?>
    <div class="step-section">
        <div class="step-body">
            <ul class="review-block">
                <li>
                    <div class="review-block-head">
                        <div class="review-block-title">
                            <?php
                            if ($hasPhysicalProd) {
                                echo Labels::getLabel('LBL_Shipping_to:', $siteLangId);
                            } else {
                                echo Labels::getLabel('LBL_Billing_to:', $siteLangId);
                            }
                            ?>
                        </div>
                        
                        <div class="review-block-action">
                            <button class="link-underline" type="button"
                                title="<?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>"
                                onClick="showAddressList()">
                                <?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>
                            </button>
                            <button class="link-underline" onclick="showAddressFormDiv(0);" type="button"
                                title="<?php echo Labels::getLabel('LBL_Add_New_Address', $siteLangId); ?>"
                                name="addNewAddress">
                                <?php echo Labels::getLabel('LBL_Add_New_Address', $siteLangId); ?>
                            </button>
                        </div>
                       
                    </div>
                    <div class="review-block-body">
                        <address class="delivery-address">
                            <p>
                                <?php echo $addresses['addr_name'] . ', ' . $addresses['addr_address1']; ?>
                                <?php
                                if (strlen($addresses['addr_address2']) > 0) {
                                    echo ", " . $addresses['addr_address2'];
                                    ?>
                                <?php } ?>
                            </p>
                            <p>
                                <?php echo $addresses['addr_city'] . ", " . $addresses['state_name'] . ", " . $addresses['country_name'] . ", " . $addresses['addr_zip']; ?>
                            </p>

                            <?php if (strlen($addresses['addr_phone']) > 0) { ?>
                            <p class="phone-txt">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                    </use>
                                </svg>
                                <?php echo $addresses['addr_dial_code'] . ' ' . $addresses['addr_phone']; ?>
                            </p>
                            <?php } ?>
                        </address>
                    </div>
                </li>
            </ul>
        </div>
    </div>
    <?php } ?>

    <!-- REMOVED SIGNATURE CODE FROM HERE -->
    <div class="step-section">
        <div class="step-head">
            <h5 class="step-title">
                <?php
                $cartObj = new Cart();
                if ($cartObj->hasPhysicalProduct()) {
                    echo Labels::getLabel('LBL_Shipping_Summary', $siteLangId);
                } else {
                    echo Labels::getLabel('LBL_REVIEW_CHECKOUT', $siteLangId);
                }
                ?>
            </h5>
        </div>
        <div class="step-body p-0">
            <?php
            ksort($shippingRates);
            if (!empty($shippingRates)) {
                foreach ($shippingRates as $shippedBy => $shippedByItemArr) {
                    $shopLevelTotalAmount = (isset($shippedByItemArr['shopTotalAmount'])) ? $shippedByItemArr['shopTotalAmount'] : 0;

                    ksort($shippedByItemArr);
                    foreach ($shippedByItemArr as $shipLevel => $items) {
                        switch ($shipLevel) {
                            case Shipping::LEVEL_ORDER:
                            case Shipping::LEVEL_SHOP:
                                if (isset($items['products']) && !empty($items['products'])) {
                                    $productData = $items['products'];
                                    $shippingCharges = $items['rates'];
                                    $productInfo = current($productData);
                                    require('shipping-summary-group.php');
                                }
                                break;
                            case Shipping::LEVEL_PRODUCT:
                                if (isset($items['products']) && !empty($items['products'])) {
                                    foreach ($items['products'] as $selProdid => $product) {
                                        $isFreeShipEnable = $product['shop_is_free_ship_active'];
                                        $isFreeShipAmount = $product['shop_free_shipping_amount'];
                                        require('shipping-summary-product.php');
                                    }
                                }
                                if (isset($items['digital_products']) && !empty($items['digital_products'])) {
                                    foreach ($items['digital_products'] as $selProdid => $product) {
                                        require('shipping-summary-product.php');
                                    }
                                }
                                break;
                        }
                    }
                }
            } else if (empty($shippingRates) && $cart_type == applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
                $shipLevel = Shipping::LEVEL_PRODUCT;
                foreach ($products as $product_key => $product) {
                    $isFreeShipEnable = $product['shop_is_free_ship_active'];
                    $isFreeShipAmount = $product['shop_free_shipping_amount'];
                    require('shipping-summary-product.php');
                }
            } else {
                echo Labels::getLabel('LBL_Products_is_not_eligible_for_shipping', $siteLangId);
            }
            ?>
        </div>
        <div class="step-foot">
            <?php
            if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
            ?>
            <button class="btn btn-outline-brand btn-wide" onclick="showAddressList();" type="button">
                <?php echo Labels::getLabel('LBL_Back', $siteLangId); ?>
            </button>
            <?php }else{
                echo "<span></span>";
            } ?>
            <?php if (!empty($shippingRates)) { ?>
            <?php if ($hasPhysicalProd) { ?>
            <button class="btn btn-brand btn-wide " onClick="setUpShippingMethod();" type="button">
                <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
            </button>
            <?php } else { ?>
            <button class="btn btn-brand btn-wide " onClick="loadPaymentSummary();" type="button">
                <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
            </button>
            <?php } ?>
            <?php } else if (empty($shippingRates) && $cart_type == applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) { ?>
                 <button class="btn btn-brand btn-wide " onClick="setUpShippingMethod();" type="button">
                    <?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?>
                </button>
            <?php } ?>

        </div>

    </div>