<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div id="shipping-summary" class="step">
    <?php
    if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
    ?>
    <div class="step-section">
        <div class="step-body">
            <ul class="list-group review-block">
                <li class="">
                    <div class="review-block-head">
                        <div class="review-block-title">
                            <?php echo Labels::getLabel('LBL_Billing_to:', $siteLangId); ?>
                        </div>
                        <div class="review-block-action" role="cell">
                            <button class="link-underline" onClick="showAddressList()" type="button">
                                <?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>
                            </button>
                        </div>
                    </div>
                    <div class="review-block-body" role="cell">
                        <address class="delivery-address">
                            <p>
                                <?php echo $addresses['addr_name'] . ', ' . $addresses['addr_address1']; ?>
                                <?php
                    if (strlen($addresses['addr_address2']) > 0) {
                        echo ", " . $addresses['addr_address2'];
                    ?>
                                <?php } ?>
                            </p>
                            <p><?php echo $addresses['addr_city'] . ", " . $addresses['state_name'] . ", " . $addresses['country_name'] . ", " . $addresses['addr_zip']; ?>
                            </p>
                            <?php
                if (strlen($addresses['addr_phone']) > 0) {
                    $addrPhone = $addresses['addr_dial_code'] . ' ' . $addresses['addr_phone'];
                ?>
                            <p class="phone-txt">
                                <svg class="svg" width="16" height="16">
                                    <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                    </use>
                                </svg>
                                <?php echo $addrPhone; ?>
                            </p>
                            <?php } ?>
                        </address>
                    </div>

                </li>
            </ul>
        </div>
    </div>
    <?php } ?>
    <div class="step-section">
        <div class="step-head">
            <h5 class="step-title">
                <?php
                $cartObj = new Cart();
                if ($cartObj->hasPhysicalProduct()) {
                    echo Labels::getLabel('LBL_Pickup_Summary', $siteLangId);
                } else {
                    echo Labels::getLabel('LBL_REVIEW_CHECKOUT', $siteLangId);
                }
                ?>
            </h5>
        </div>
        <div class="step-body p-0">
            <div class="cart-table list-shippings">
                <?php
                $shopId = 0;
                $srNo = 1;
                foreach ($products as $cartKey => $product) {
                    if (isset($product['sellerProdType']) && $product['sellerProdType'] == SellerProduct::PRODUCT_TYPE_ADDON) {
                        continue;
                    }
                    $productUrl = UrlHelper::generateUrl('Products', 'View', array($product['selprod_id']));
                    //$shopUrl = UrlHelper::generateUrl('Shops', 'View', array($product['shop_id']));
                    $imageUrl = UrlHelper::getCachedUrl(UrlHelper::generateFileUrl('image', 'product', array($product['product_id'], "THUMB", $product['selprod_id'], 0, $siteLangId)), CONF_IMG_CACHE_TIME, '.jpg');
                    $selProdId = $product['selprod_id'];
                    if ($shopId != $product['shop_id']) {
                        $shopId = $product['shop_id'];
                ?>
                <div class="cart-table-head shipping-select shipping-select-row">
                    <div class="shop-name">
                        <h6 class="h6">
                            <svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#manage-shop">
                                </use>
                            </svg>
                            <?php echo $product['shop_name']; ?>
                        </h6>
                    </div>
                </div>
                <?php } ?>
                <div class="cart-table-row list--js_<?php echo $srNo; ?>" data-cols="2">
                    <div class="cart-table-col cart-table-col-1">
                        <div class="product-profile product-profile-sm">
                            <a class="product-profile-thumbnail" href="<?php echo $productUrl; ?>">
                                <img class="img-fluid" src="<?php echo $imageUrl; ?>"
                                    alt="<?php echo $product['product_name']; ?>"
                                    title="<?php echo $product['product_name']; ?>">
                            </a>
                            <div class="product-profile-data">
                                <a class="title"
                                    href="<?php echo $productUrl; ?>"><?php echo ($product['selprod_title']) ? $product['selprod_title'] : $product['product_name']; ?>
                                </a>
                                <?php 
                                if (isset($product['options']) && count($product['options'])) {
                                ?>
                                <div class="options">
                                    <p class="">
                                        <?php
                                            $optionStr = '';
                                            foreach ($product['options'] as $option) {
                                                $optionStr .= $option['optionvalue_name'] . '|';
                                            }
                                            echo rtrim($optionStr, '|');
                                       
                                        ?>
                                    </p>
                                </div>
                                <?php } ?>
                                <?php
                                    if ($product['productFor'] == applicationConstants::PRODUCT_FOR_RENT) {
                                        $duration = CommonHelper::getDifferenceBetweenDates($product['rentalStartDate'], $product['rentalEndDate'], $product['selprod_user_id'], $product['sprodata_duration_type']);
                                    ?>

                                <div class="dates">
                                    <?php echo Labels::getLabel("LBL_From_:", $siteLangId) . ' ' . date('M d, Y H:i ', strtotime($product['rentalStartDate'])); ?>

                                    <?php echo Labels::getLabel("LBL_To_:", $siteLangId) . ' ' . date('M d, Y H:i', strtotime($product['rentalEndDate'])); ?>
                                </div>

                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div class="cart-table-col cart-table-col-2">
                        <input type="hidden" name="<?php echo $cartKey; ?>" class="pickup-address-js"
                            id="product-js-<?php echo $srNo; ?>"
                            value="<?php echo (!empty($shippingRates[$cartKey])) ? $shippingRates[$cartKey]['addr_id'] : ""; ?>" />

                        <?php if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) { ?>
                        <?php if (empty($shippingRates[$cartKey])) { ?>
                        <div class="shipping-edit pickupAddJs">
                            <button class="link-brand link-underline" type="button"
                                onclick="displayPickupAddress('<?php echo $selProdId; ?>', '<?php echo $shopId; ?>', '<?php echo $srNo; ?>')"><?php echo Labels::getLabel('LBL_SELECT_PICKUP', $siteLangId); ?>
                            </button>
                        </div>
                        <?php } ?>
                        <div class="shipping-edit">
                            <button class="link-brand link-underline" type="button"
                                <?php if (empty($shippingRates[$cartKey])) { ?>style="display:none" <?php } ?>
                                id="pickup-address-edit-js-<?php echo $srNo; ?>"
                                onclick="displayPickupAddress('<?php echo $selProdId; ?>', '<?php echo $shopId; ?>', '<?php echo $srNo; ?>')">
                                <?php echo Labels::getLabel('LBL_Edit', $siteLangId); ?>
                            </button>
                        </div>
                        <?php } ?>
                    </div>
                </div>
                <div class="cart-table-row delivery-address js-address-detail-<?php echo $srNo; ?>"
                    style="<?php echo (empty($shippingRates[$cartKey])) ? 'display: none;' : ""; ?>" data-cols="1">
                    <address class="delivery-address">
                        <?php if (!empty($shippingRates[$cartKey])) { ?>
                        <p class="">
                            <?php
                                            $address = $shippingRates[$cartKey];
                                            echo $address['addr_name'] . ', ' . $address['addr_address1'];
                                            if (strlen($address['addr_address2']) > 0) {
                                                echo ", " . $address['addr_address2'];
                                            }

                                            echo $address['addr_city'] . ", " . $address['state_name'];
                                            echo $address['country_name'] . ", " . $address['addr_zip'];
                                            ?>
                            <svg class="svg" width="16" height="16">
                                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#mobile">
                                </use>
                            </svg>
                            <?php echo $address['addr_dial_code'] . ' ' . $address['addr_phone']; ?>
                        </p>
                        <?php } ?>
                    </address>
                </div>
                <?php
                    $srNo++;
                }
                    ?>
            </div>
        </div>
        <div class="step-foot">
            <div class="checkout-actions">
            <?php
            if ($cart_type != applicationConstants::PRODUCT_FOR_EXTEND_RENTAL) {
            ?>
                <button class="btn btn-outline-brand btn-wide" type="button"
                    onclick="showAddressList();"><?php echo Labels::getLabel('LBL_Back', $siteLangId); ?></button>
                    <?php } else{
                echo "<span></span>";
            } ?>
                <button class="btn btn-brand btn-wide " type="button"
                    onClick="setUpPickup();"><?php echo Labels::getLabel('LBL_Continue', $siteLangId); ?></button>
            </div>
        </div>
    </div>
</div>