<main id="body" class="body">
    <div class="bg-brand pt-3 pb-3">
        <div class="container">
            <div class="row align-items-center justify-content-center">
                <div class="col-md-8">
                    <div class="section-head section-head-white justify-content-center mb-0">
                        <div class="section-heading">
                            <h2>
                                <?php echo Labels::getLabel('LBL_SITEMAP', $siteLangId); ?>
                            </h2>
                            <div class="breadcrumbs breadcrumbs-white  breadcrumbs-center">
                                <?php $this->includeTemplate('_partial/custom/header-breadcrumb.php'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <section class="section" data-collection="collection-name">
        <div class="container">
            <!-- static -->
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="site-map">
                        <?php if (!empty($contentPages)) { ?>
                            <div class="site-map-item">
                                <h4 class="site-map-title">
                                    <?php echo Labels::getLabel('LBL_CONTENT_PAGES', $siteLangId); ?>
                                </h4>
                                <ul>
                                    <?php
                                    foreach ($contentPages as $contentId => $contentPageName) {

                                        ?>
                                        <li>
                                            <a href="<?php echo UrlHelper::generateUrl('cms', 'view', array($contentId)); ?>">
                                                <?php echo $contentPageName; ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php
                        }
                        if (!empty($allShops)) { ?>
                            <div class="site-map-item">
                                <h4 class="site-map-title">
                                    <?php echo Labels::getLabel('LBL_Shops', $siteLangId); ?>
                                </h4>
                                <ul>
                                    <?php foreach ($allShops as $shop) {
                                        ?>
                                        <li>
                                            <a
                                                href="<?php echo UrlHelper::generateUrl('Shops', 'view', array($shop['shop_id'])); ?>">
                                                <?php echo $shop['shop_name']; ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php
                        }
                        if (!empty($allBrands)) { ?>
                            <div class="site-map-item">
                                <h4 class="site-map-title">
                                    <?php echo Labels::getLabel('LBL_Brands', $siteLangId); ?>
                                </h4>
                                <ul>
                                    <?php foreach ($allBrands as $brands) {
                                        ?>
                                        <li>
                                            <a
                                                href="<?php echo UrlHelper::generateUrl('Brands', 'view', array($brands['brand_id'])); ?>">
                                                <?php echo $brands['brand_name']; ?>
                                            </a>
                                        </li>
                                    <?php } ?>
                                </ul>
                            </div>
                            <?php
                        }
                        if ($categoriesArr) {
                            ?>
                            <div class="site-map-item">
                                <h4 class="site-map-title">
                                    <?php echo Labels::getLabel('LBL_Categories', $siteLangId); ?>
                                </h4>
                                <?php $this->includeTemplate('_partial/custom/categories-list.php', array('categoriesArr' => $categoriesArr), false); ?>
                            </div>
                            <?php
                        }
                        ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
</main>