<?php if ('' != FatApp::getConfig("CONF_FACEBOOK_PIXEL_ID", FatUtility::VAR_STRING, '')) { ?>
    <img alt="Facebook Pixel" height="1" width="1" style="display:none"
        src="https://www.facebook.com/tr?id=<?php echo $pixelId; ?>&ev=PageView&noscript=1" />
    <?php
}
?>
<?php if (FatApp::getConfig('CONF_ENABLE_NEWSLETTER_SUBSCRIPTION', FatUtility::VAR_INT, 0)) { ?>
    <section class="section collection-newsletter no-print" data-collection="collection-name">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-lg-8">
                    <div class="section-head section-head-center">
                        <div class="section-heading text-center">
                            <h5>
                                <?php echo (FatApp::getConfig('CONF_ENABLE_NEWSLETTER_SUBSCRIPTION', FatUtility::VAR_INT, 0)) ? Labels::getLabel('LBL_Subscribe_to_our_newsletter', $siteLangId) : Labels::getLabel('LBL_Contact_us', $siteLangId); ?>
                            </h5>
                            <?php if (FatApp::getConfig('CONF_ENABLE_NEWSLETTER_SUBSCRIPTION', FatUtility::VAR_INT, 0)) { ?>
                                <h2>
                                    <?php echo Labels::getLabel('LBL_Let_\'s_Stay_in_touch', $siteLangId); ?>
                                </h2>
                                <?php
                            }
                            ?>
                        </div>
                    </div>
                    <div class="subscribers">
                        <?php $this->includeTemplate('_partial/footerNewsLetterForm.php'); ?>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php } ?>
<footer class="footer no-print abcc">
    <?php if (!$isUserDashboard) { ?>
        <section class="footer-top">
            <div class="container">
                <div class="footer-links">
                    <?php Navigation::footerNavigation();  //$this->includeTemplate('_partial/footerNavigation.php'); 
                        ?>
                    <?php $this->includeTemplate('_partial/footerSocialMedia.php'); ?>
                </div>
            </div>
        </section>
        <div class="copyright text--center">
            <?php
            $productName = (CommonHelper::demoUrl()) ? "Yo!Rent" : FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, "");
            $defaultLangId = FatApp::getConfig("CONF_DEFAULT_SITE_LANG", FatUtility::VAR_INT, 1);

            $productName = (trim($productName) == '') ? FatApp::getConfig('CONF_WEBSITE_NAME_' . $defaultLangId, FatUtility::VAR_STRING, "") : $productName;

            $siteUrl = (CommonHelper::demoUrl()) ? "https://yo-rent.com" : UrlHelper::generateFullUrl();
            $replacements = array(
                '{YEAR}' => '&copy; ' . date("Y"),
                '{PRODUCT}' => '<a target="_blank" href="' . $siteUrl . '" rel="noopener">' . $productName . '</a>',
                '{OWNER}' => '<a target="_blank" href="https://www.fatbit.com" rel="noopener">FATbit Technologies</a>',
            );
            echo CommonHelper::replaceStringData(Labels::getLabel('LBL_COPYRIGHT_TEXT', $siteLangId), $replacements);
            ?>
        </div>
    <?php } ?>
    <div class="back-to-top">
        <a href="#top">
            <svg class="svg" width="16" height="16">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/retina/sprite.svg#up-arrow"></use>
            </svg>
            <span>Top</span>
        </a>
    </div>
</footer>

<?php if (FatApp::getConfig('CONF_ENABLE_COOKIES', FatUtility::VAR_INT, 1) && !CommonHelper::getUserCookiesEnabled()) { ?>
    <div class="cookies-notice">
        <?php if (FatApp::getConfig('CONF_COOKIES_TEXT_' . $siteLangId, FatUtility::VAR_STRING, '')) { ?>
            <div class="cookies-notice-content">
                <span id="cookieconsent:desc" class="cc-message">
                    <?php echo FatUtility::decodeHtmlEntities(mb_substr(FatApp::getConfig('CONF_COOKIES_TEXT_' . $siteLangId, FatUtility::VAR_STRING, ''), 0, 500)); ?>
                    <a
                        href="<?php echo UrlHelper::generateUrl('cms', 'view', array(FatApp::getConfig('CONF_COOKIES_BUTTON_LINK', FatUtility::VAR_INT))); ?>">
                        <?php echo Labels::getLabel('LBL_Read_More', $siteLangId); ?>
                    </a>
                </span>
                <div class="cookies-notice-buttons">
                    <span class="cc-close cc-cookie-accept-js">
                        <?php echo Labels::getLabel('LBL_Accept_Cookies', $siteLangId); ?>
                    </span>
                </div>
            </div>
        <?php } ?>
    </div>
<?php } ?>

<?php if (!isset($_SESSION['geo_location']) && FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, '') != '') { ?>
    <script src='https://maps.google.com/maps/api/js?key=<?php echo FatApp::getConfig('CONF_GOOGLEMAP_API_KEY', FatUtility::VAR_STRING, ''); ?>&libraries=places&loading=async
    '></script>
    <?php
}

if (FatApp::getConfig('CONF_ENABLE_LIVECHAT', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_LIVE_CHAT_CODE', FatUtility::VAR_STRING, '');
}

if (FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '')) {
    echo FatApp::getConfig('CONF_SITE_TRACKER_CODE', FatUtility::VAR_STRING, '');
}
?>

<div class="no-print">
    <?php
    if (FatApp::getConfig('CONF_AUTO_RESTORE_ON', FatUtility::VAR_INT, 1) && CommonHelper::demoUrl()) {
        $this->includeTemplate('restore-system/page-content.php');
    }


    if (FatApp::getConfig('CONF_PWA_SERVICE_WORKER', FatUtility::VAR_INT, 1)) {
        ?>
        <script>
            $(document).ready(function () {
                if ('serviceWorker' in navigator) {
                    window.addEventListener('load', function () {
                        navigator.serviceWorker.register(
                            '<?php echo CONF_WEBROOT_URL; ?>sw.js?t=<?php echo filemtime(CONF_INSTALLATION_PATH . 'public/sw.js'); ?>&f'
                        ).then(function (registration) { });
                    });
                }
            });
        </script>
    <?php } ?>
</div>
</div>
</div>


<?php
if (FatApp::getConfig("CONF_ENABLE_ENGAGESPOT_PUSH_NOTIFICATION", FatUtility::VAR_STRING, '') && UserAuthentication::getLoggedUserId(true) > 0) { ?>
    <script>
        if ($("#engagespotUI").length > 0) {
            $.getScript("https://cdn.engagespot.co/engagespot-client.min.js", function (data, textStatus, jqxhr) {
                Engagespot.render('#engagespotUI', {
                    apiKey: "<?php echo FatApp::getConfig("CONF_ENGAGESPOT_API_KEY", FatUtility::VAR_STRING, ''); ?>",
                    userId: "<?php echo UserAuthentication::getLoggedUserAttribute("user_email", true); ?>",
                    userSignature: "<?php echo base64_encode(hash_hmac('sha256', UserAuthentication::getLoggedUserAttribute("user_email", true), FatApp::getConfig("CONF_ENGAGESPOT_SECRET_KEY", FatUtility::VAR_STRING, ''), true)); ?>"
                });
            });
        }
    </script>
<?php } ?>
</body>

</html>
<?php
//$content  = ob_get_clean();
//echo CommonHelper::minifyHtml($content);
?>