<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<?php
if (0 < $withPhone) {
    $frm->setFormTagAttribute('onsubmit', 'getOtpForm(this); return(false);');
}
?>
<main id="body" class="body enter-page forgotPwForm">
    <section class="form-sign">
        <div class="form-sign-body">
            <?php
            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);

            $sizeType = 'CUSTOM';
            $extraClass = 'logo-custom';

            if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                $sizeType = '16X9';
                $extraClass = '';
            } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                $sizeType = '1X1';
                $extraClass = '';
            }

            $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
            $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

            ?>
            <div class="form-sign-logo">
                <a href="<?php echo UrlHelper::generateFullFileUrl(); ?>">
                    <img class="<?php echo $extraClass; ?>" src="<?php echo $siteLogo; ?>"
                        alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                        title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                </a>
            </div>
            <div class="card-sign" id="otpFom">
                <div class="card-sign_head">
                    <div class="section-head">
                        <div
                            class="section-heading <?php if (isset($smsPluginStatus) && true === $smsPluginStatus) { ?>otp-heading<?php } ?>">
                            <h1>
                                <?php echo Labels::getLabel('LBL_Forgot_Password', $siteLangId); ?>
                            </h1>
                            <?php if (isset($smsPluginStatus) && true === $smsPluginStatus) {
                                if (isset($withPhone) && 1 > $withPhone) { ?>
                                    <button type="button" onClick="forgotPwdForm(<?php echo applicationConstants::YES; ?>)"
                                        class="link-underline">
                                        <?php echo Labels::getLabel('LBL_USE_PHONE_NUMBER_INSTEAD', $siteLangId); ?>
                                    </button>
                                <?php } else { ?>
                                    <button type="button" onClick="forgotPwdForm(<?php echo applicationConstants::NO; ?>)"
                                        class="link-underline">
                                        <?php echo Labels::getLabel('LBL_USE_EMAIL_INSTEAD', $siteLangId); ?>
                                    </button>
                                <?php } ?>
                            <?php } ?>
                        </div>
                    </div>

                </div>
                <div class="card-sign_body">
                    <?php
                    $frm->setFormTagAttribute('class', 'form form--normal');
                    $frm->developerTags['colClassPrefix'] = 'col-lg-12 col-md-12 col-sm-';
                    $frm->developerTags['fld_default_col'] = 12;
                    $frm->setFormTagAttribute('id', 'frmPwdForgot');
                    $frm->setFormTagAttribute('autocomplete', 'off');
                    $frm->setValidatorJsObjectName('forgotValObj');
                    $frm->setFormTagAttribute('action', UrlHelper::generateUrl('GuestUser', 'forgotPassword'));
                    $btnFld = $frm->getField('btn_submit');
                    $btnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
                    if (1 > $withPhone) {
                        $frmFld = $frm->getField('user_email_username');
                        $frmFld->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Username_or_email', $siteLangId));
                    } else {
                        $frmFld = $frm->getField('user_phone');
                    }
                    $frmFld->developerTags['noCaptionTag'] = true;

                    $frmFld = $frm->getField('btn_submit');
                    $frmFld->developerTags['noCaptionTag'] = true;
                    echo $frm->getFormHtml(); ?>

                </div>
                <div class="card-sign_foot">
                    <ul class="others">
                        <li class="others-item">
                            <?php echo Labels::getLabel('LBL_Already_have_an_account?', $siteLangId); ?>
                            <a class="others-links link-brand link-underline"
                                href="<?php echo UrlHelper::generateUrl('GuestUser', 'loginForm'); ?>"
                                class="link-underline">
                                <?php echo Labels::getLabel('LBL_Log_in', $siteLangId); ?>
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>

</main>


<?php
$siteKey = FatApp::getConfig('CONF_RECAPTCHA_SITEKEY', FatUtility::VAR_STRING, '');
$secretKey = FatApp::getConfig('CONF_RECAPTCHA_SECRETKEY', FatUtility::VAR_STRING, '');
if (!empty($siteKey) && !empty($secretKey)) { ?>
    <script src='https://www.google.com/recaptcha/api.js?onload=googleCaptcha&render=<?php echo $siteKey; ?>'></script>
<?php } ?>