<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$userIdFld = $frm->getField('user_id');
$userId = $userIdFld->value;

$frm->setFormTagAttribute('class', 'form form--normal');
$frm->developerTags['fld_default_col'] = 2;

$frm->setFormTagAttribute('class', 'form form-otp');
$frm->setFormTagAttribute('name', 'frmGuestLoginOtp');
$frm->setFormTagAttribute('id', 'frmGuestLoginOtp');
$frm->setFormTagAttribute('onsubmit', 'return validateOtp(this);');

$btnFld = $frm->getField('btn_submit');
$btnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
?>
<main id="body" class="body enter-page otpForm-js">
    <section class="form-sign">
        <div class="form-sign-body">
            <?php
            $fileData = AttachedFile::getAttachment(AttachedFile::FILETYPE_FRONT_LOGO, 0, 0, $siteLangId, true);
            $aspectRatioArr = AttachedFile::getRatioTypeArray($siteLangId, true);

            $sizeType = 'CUSTOM';
            $logoClass = "logo-custom";
            if ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_RECTANGULAR) {
                $sizeType = '16X9';
                $extraClass = '';
            } elseif ($fileData['afile_aspect_ratio'] == AttachedFile::RATIO_TYPE_SQUARE) {
                $sizeType = '1X1';
                $extraClass = '';
            }

            $uploadedTime = AttachedFile::setTimeParam($fileData['afile_updated_at']);
            $siteLogo = UrlHelper::getCachedUrl(UrlHelper::generateFullFileUrl('Image', 'siteLogo', array($siteLangId, $sizeType), CONF_WEBROOT_FRONT_URL) . $uploadedTime, CONF_IMG_CACHE_TIME, '.jpg');

            ?>
            <div class="form-sign-logo">
                <a href="<?php echo UrlHelper::generateFullFileUrl(); ?>">
                    <img class="<?php echo $logoClass; ?>" src="<?php echo $siteLogo; ?>"
                        alt="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>"
                        title="<?php echo FatApp::getConfig('CONF_WEBSITE_NAME_' . $siteLangId, FatUtility::VAR_STRING, '') ?>">
                </a>
            </div>

            <div class="card-sign">
                <div class="card-sign_head">
                    <div class="section-head">
                        <div class="section-heading">
                            <h1>
                                <?php echo Labels::getLabel('LBL_VERIFY_YOUR_PHONE_NUMBER', $siteLangId); ?>
                            </h1>
                            <p>
                                <?php echo Labels::getLabel("LBL_ENTER_THE_OTP_YOU_RECEIVED_ON_YOUR_PHONE_NUMBER", $siteLangId); ?>
                            </p>
                        </div>
                    </div>
                </div>
                <div class="card-sign_body">
                    <?php echo $frm->getFormTag(); ?>
                    <div class="otp-row mb-3">
                        <?php for ($i = 0; $i < User::OTP_LENGTH; $i++) { ?>
                        <div class="otp-col otpCol-js">
                            <?php
                                $fld = $frm->getField('upv_otp[' . $i . ']');
                                $fld->setFieldTagAttribute('class', 'otpVal-js');
                                echo $frm->getFieldHtml('upv_otp[' . $i . ']'); ?>
                            <?php if ($i < (User::OTP_LENGTH - 1)) { ?>
                            <?php } ?>
                        </div>
                        <?php } ?>
                    </div>
                    <?php /* ?>
                    <!--div class="my-3">
              <button type="button" class="link resendOtp-js d-none"
                  onClick="resendOtp(<?php echo $userId; ?>, <?php echo applicationConstants::YES; ?>)">
                  <?php echo Labels::getLabel('LBL_RESEND_OTP', $siteLangId); ?>
              </button>
              <small>
                  <?php
                  $msg = Labels::getLabel('LBL_PLEASE_WAIT_{SECONDS}_SECONDS_TO_RESEND', $siteLangId);
                  echo CommonHelper::replaceStringData($msg, ['{SECONDS}' => '<b><span class="intervalTimer-js">' . User::OTP_INTERVAL . '</span></b>']);
                  ?>
              </small>
          </div-->
                    <?php */ ?>
                    <?php echo $frm->getFieldHtml('user_id'); ?>
                    <div class="row">
                        <div class="col">
                            <?php echo $frm->getFieldHtml('btn_submit'); ?>
                        </div>
                    </div>
                    </form>
                    <?php echo $frm->getExternalJs(); ?>
                </div>
                <div class="card-sign_foot">
                    <ul class="others">
                        <li class="others-item">
                            <button type="button" class="others-links link-brand link-underline resendOtp-js d-none"
                                onClick="resendOtp(<?php echo $userId; ?>, <?php echo applicationConstants::YES; ?>)">
                                <?php echo Labels::getLabel('LBL_RESEND_OTP', $siteLangId); ?>
                            </button>
                            <span>
                                <?php
                                $msg = Labels::getLabel('LBL_PLEASE_WAIT_{SECONDS}_SECONDS_TO_RESEND_OTP', $siteLangId);
                                echo CommonHelper::replaceStringData($msg, ['{SECONDS}' => '<b><span class="intervalTimer-js">' . User::OTP_INTERVAL . '</span></b>']);
                                ?>
                            </span>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </section>
</main>