<?php defined('SYSTEM_INIT') or die('Invalid Usage.'); ?>
<div class="scroll scroll-x js-scrollable table-wrap">
    <?php
    $arr_flds = array(
        'listserial' => Labels::getLabel('LBL_#', $siteLangId),
        'afile_physical_path' => Labels::getLabel('LBL_Location', $siteLangId),
        'afile_name'    => Labels::getLabel('LBL_File_Name', $siteLangId),
        'files'    => Labels::getLabel('LBL_Files_Inside', $siteLangId),
        'action'    => '',
    );
    $tableClass = '';
    if (0 < count($arr_listing)) {
        $tableClass = "table-justified";
    }
    $tbl = new HtmlElement('table', array('width' => '100%', 'class' => 'table ' . $tableClass));
    $th = $tbl->appendElement('thead')->appendElement('tr');
    foreach ($arr_flds as $val) {
        $e = $th->appendElement('th', array(), $val);
    }

    $sr_no = ($page > 1) ? $recordCount - (($page - 1) * $pageSize) : $recordCount;
    foreach ($arr_listing as $sn => $row) {
        $tr = $tbl->appendElement('tr', array());

        foreach ($arr_flds as $key => $val) {
            $td = $tr->appendElement('td');
            switch ($key) {
                case 'listserial':
                    $td->appendElement('plaintext', array(), $sr_no);
                    break;
                case 'afile_physical_path':
                    $path = AttachedFile::FILETYPE_BULK_IMAGES_PATH . $row['afile_physical_path'];
                    $td->appendElement('plaintext', array(), $path, true);
                    break;
                case 'files':
                    $fullPath = CONF_UPLOADS_PATH . AttachedFile::FILETYPE_BULK_IMAGES_PATH . $row['afile_physical_path'];
                    $count = Labels::getLabel('LBL_NA', $siteLangId);
                    if (file_exists($fullPath)) {
                        $allFiles = scandir($fullPath);
                        $files_count = array_diff($allFiles, array('..', '.'));
                        $count = count($files_count);
                    }

                    $td->appendElement('plaintext', array(), $count);
                    break;
                case 'action':
                    $ul = $td->appendElement("ul", array("class" => "actions actions--centered"));

                    $li = $ul->appendElement("li");
                    $li->appendElement(
                        'button',
                        array(
                            'type'=>'button',
                            'class' => 'button small green actions-link',
                            'title' => Labels::getLabel('LBL_Delete', $siteLangId), "onclick" => "removeDir('" . base64_encode($row['afile_physical_path']) . "')"
                        ),
                        '<i class="fa fa-trash"></i>',
                        true
                    );
                    $li = $ul->appendElement("li");
                    $li->appendElement('button', array('type'=>'button','class' => 'button small green actions-link', 'title' => Labels::getLabel('LBL_Download', $siteLangId), "onclick" => "downloadPathsFile('" . base64_encode($fullPath) . "')"), '<i class="fa fa-download"></i>', true);
                    break;
                default:
                    $td->appendElement('plaintext', array(), $row[$key], true);
                    break;
            }
        }
        $sr_no--;
    }
    if (count($arr_listing) == 0) {
        $tbl->appendElement('tr')->appendElement('td', array('colspan' => count($arr_flds)), Labels::getLabel('LBL_No_Records_Found', $siteLangId));
    }
    echo $tbl->getHtml(); ?>
</div>
<?php $postedData['page'] = $page;
echo FatUtility::createHiddenFormFromData($postedData, array(
    'name' => 'frmSearchPaging'
));
$pagingArr = array('pageCount' => $pageCount, 'page' => $page, 'pageSize' => $pageSize, 'recordCount' => $recordCount, 'adminLangId' => $siteLangId, 'siteLangId' => $siteLangId);
$this->includeTemplate('_partial/pagination.php', $pagingArr, false);