<?php
defined('SYSTEM_INIT') or die('Invalid Usage.');

$frm->setFormTagAttribute('class', 'form form--horizontal layout--ltr');
$frm->developerTags['colClassPrefix'] = 'col-md-';
$frm->developerTags['fld_default_col'] = 12;
$frm->setFormTagAttribute('onsubmit', 'generateInvoice(this); return(false);');

$btnFld = $frm->getField('btn_submit');
$btnFld->setFieldTagAttribute('class', 'btn btn-brand');

$this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <h5 class="content-header-heading">
                    <a class="btn btn-back" title="<?php echo Labels::getLabel('LBL_Back_to_orders', $siteLangId); ?>"
                        href="<?php echo UrlHelper::generateUrl('RequestForQuotes', 'rfqOrder'); ?>">
                        <svg class="svg" width="24" height="24">
                            <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#back">
                            </use>
                        </svg>
                    </a>
                    <?php echo Labels::getLabel('LBL_Invoice_For:', $siteLangId); ?> #
                    <?php echo $orderId; ?>
                </h5>
            </div>
        </div>
        <div class="content-form"></div>
        <div class="content-body">
            <div class="row mb-4">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-table">
                            <div class="scroll scroll-x js-scrollable table-wrap">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th><?php echo Labels::getLabel('LBL_Date', $siteLangId); ?></th>
                                            <th><?php echo Labels::getLabel('LBL_Product_Info', $siteLangId); ?></th>
                                            <th><?php echo Labels::getLabel('LBL_Stock', $siteLangId); ?></th>
                                            <th><?php echo Labels::getLabel('LBL_Price', $siteLangId); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <tr>
                                            <td> <?php echo FatDate::Format($orderDetails['rfq_added_on']); ?></td>
                                            <td>
                                                <div class="product-profile">
                                                    <div class="product-profile-data">
                                                        <span class="product-profile-title">
                                                            <a
                                                                href="<?php echo UrlHelper::generateUrl('Products', 'View', array($orderDetails['selprod_id']), CONF_WEBROOT_FRONTEND); ?>">
                                                                <?php echo $orderDetails['selprod_title']; ?>
                                                            </a>

                                                        </span>
                                                        <?php if (!empty($selProdOptions)) { ?>
                                                            <ul class="list-options">
                                                                <?php
                                                                foreach ($selProdOptions as $option) {
                                                                    echo '<li class="list-options-item"><span>' . $option["option_name"] . ':</span> ' . $option["optionvalue_name"] . '</li>';
                                                                }
                                                                ?>
                                                            </ul>
                                                        <?php } ?>
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                    <?php
                                                    if ($orderDetails['rfq_request_type'] == applicationConstants::PRODUCT_FOR_RENT) {
                                                        if ($orderDetails['rent_in_stock']) {
                                                            echo '<span class="badge badge-pill badge-success">'.Labels::getLabel('LBL_In_Stock', $siteLangId).'</span>';
                                                        } else {
                                                            echo '<span class="badge badge-pill badge-danger">'.Labels::getLabel('LBL_Out_Of_Stock', $siteLangId).'</span>';
                                                        }
                                                    } else {
                                                        if ($orderDetails['in_stock']) {
                                                            echo '<span class="badge badge-pill badge-success">'.Labels::getLabel('LBL_In_Stock', $siteLangId).'</span>';
                                                        } else {
                                                            echo '<span class="badge badge-pill badge-danger">'.Labels::getLabel('LBL_Out_Of_Stock', $siteLangId).'</span>';
                                                        }
                                                    }

                                                    ?>
                                            </td>
                                            <td>
                                                <?php
                                                if ($orderDetails['rfq_request_type'] == applicationConstants::PRODUCT_FOR_RENT) {
                                                    echo CommonHelper::displayMoneyFormat($orderDetails['sprodata_rental_price']);
                                                } else {
                                                    echo CommonHelper::displayMoneyFormat($orderDetails['selprod_price']);
                                                }

                                                ?>
                                            </td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>

                        </div>

                    </div>
                </div>
            </div>
            <div class="row mb-4">
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-head">
                            <h5 class="card-title">
                                <?php echo Labels::getLabel('LBL_Buyer_Info', $siteLangId); ?>
                            </h5>
                        </div>
                        <div class="card-table">
                            <table class="table table-specification">
                                <tbody>
                                    <tr>
                                        <th>
                                            <?php echo Labels::getLabel('LBL_Name', $siteLangId); ?>:
                                        </th>
                                        <td>
                                            <?php echo $orderDetails['buyer_name']; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <?php
                                        if (Shipping::FULFILMENT_PICKUP != $orderDetails['rfq_fulfilment_type']) {
                                            $addr = Labels::getLabel('LBL_Delivery_Address', $siteLangId);
                                        } else {
                                            $addr = Labels::getLabel('LBL_Pickup_Address', $siteLangId);
                                        }
                                        ?>
                                        <th>
                                            <?php echo $addr; ?>:
                                        </th>
                                        <td>
                                            <?php
                                            $deliveryAddress = '';
                                            $deliveryAddress .= $addresses['addr_address1'] . '<br>';
                                            $deliveryAddress .= $addresses['addr_address2'] . '<br>';
                                            $deliveryAddress .= $addresses['addr_city'] . ', ';
                                            $deliveryAddress .= $addresses['state_name'] . '<br>';
                                            $deliveryAddress .= $addresses['country_name'] . ', ' . $addresses['addr_zip'];
                                            echo $deliveryAddress;
                                            ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <?php echo Labels::getLabel('LBL_Contact_No.', $siteLangId); ?>:
                                        </th>
                                        <td>
                                            <?php echo $addresses['addr_dial_code'] . ' ' . $addresses['addr_phone']; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <?php echo Labels::getLabel('LBL_Order_Type', $siteLangId); ?>:
                                        </th>
                                        <td>
                                            <?php
                                            $orderArr = applicationConstants::getOrderTypeArr($siteLangId);
                                            echo $orderArr[$orderDetails['rfq_request_type']]; ?>
                                        </td>
                                    </tr>
                                    <tr>
                                        <th>
                                            <?php echo Labels::getLabel('LBL_FULFILLMENT_TYPE', $siteLangId); ?>:
                                        </th>
                                        <td>
                                            <?php
                                            $fulfilmetArr = Shipping::getFulFillmentArr($siteLangId);
                                            echo $fulfilmetArr[$orderDetails['rfq_fulfilment_type']]; ?>
                                        </td>
                                    </tr>
                                    <?php if ($orderDetails['rfq_request_type'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                                        <tr>
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Rent_Start_Date', $siteLangId); ?>
                                            </th>
                                            <td>
                                                <?php echo FatDate::Format($orderDetails['opd_rental_start_date'], true); ?>
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>
                                                <?php echo Labels::getLabel('LBL_Rent_End_Date', $siteLangId); ?>
                                            </th>
                                            <td>
                                                <?php echo FatDate::Format($orderDetails['opd_rental_end_date'], true); ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="card h-100">
                        <div class="card-table">
                            <table class="table table-specification">
                                <tr>
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Product_Total_Cost', $siteLangId); ?>
                                    </th>
                                    <td>
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'] - $orderDetails['op_actual_shipping_charges'] - $orderDetails['order_tax_charged'], true, true, true, false, true); ?>
                                    </td>
                                </tr>
                                <tr>
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Tax_Charges:', $siteLangId); ?>
                                    </th>
                                    <td>
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_tax_charged'], true, true, true, false, true); ?>
                                    </td>
                                </tr>
                                <?php if ($orderDetails['rfq_fulfilment_type'] == Shipping::FULFILMENT_SHIP) { ?>
                                    <tr>
                                        <th>
                                            <?php echo Labels::getLabel('LBL_Shipping_Charges:', $siteLangId); ?>
                                        </th>
                                        <td>
                                            <?php echo CommonHelper::displayMoneyFormat($orderDetails['op_actual_shipping_charges'], true, true, true, false, true); ?>
                                        </td>
                                    </tr>
                                <?php } ?>
                                <tr>
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Order_Total_Amount:', $siteLangId); ?>
                                    </th>
                                    <td>
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'], true, true, true, false, true); ?>
                                    </td>
                                </tr>

                                <tr>
                                    <th>
                                        <?php echo Labels::getLabel('LBL_Balance_Amount:', $siteLangId); ?>
                                    </th>
                                    <td>
                                        <?php echo CommonHelper::displayMoneyFormat($orderDetails['order_net_amount'] - $orderDetails['total_paid_amount'], true, true, true, false, true); ?>
                                    </td>
                                </tr>

                            </table>
                        </div>
                    </div>

                </div>

            </div>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <?php echo $frm->getFormHtml(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<style>
    .table tr td {
        padding: 20px !important;
    }
</style>
<script>
    $(document).ready(function () {
        $('.delivery-date-picker--js').datepicker({
            minDate: new Date(),
            <?php if ($orderDetails['rfq_request_type'] == applicationConstants::PRODUCT_FOR_RENT) { ?>
                                maxDate: '<?php echo date('Y-m-d', strtotime($orderDetails['opd_rental_start_date'])) ?>',
            <?php } ?>
        dateFormat: 'yy-mm-dd',
        });
    });
</script>