<?php defined('SYSTEM_INIT') or die('Invalid Usage.');

$translatorSubscriptionKey = FatApp::getConfig('CONF_TRANSLATOR_SUBSCRIPTION_KEY', FatUtility::VAR_STRING, '');
if (!empty($translatorSubscriptionKey)) { ?>
<div class="row justify-content-end">
    <div class="col-auto mb-4">
        <button type="button" class="btn btn-outline-gray btn-icon btn-language" title="<?php echo Labels::getLabel('LBL_AUTOFILL_LANGUAGE_DATA', $siteLangId); ?>" onClick="autofillLangData($(this), $('form#frmOptionValues'))" data-action="<?php echo UrlHelper::generateUrl('OptionValues', 'getTranslatedData'); ?>">
            <svg class="svg" width="24" height="24">
                <use xlink:href="<?php echo CONF_WEBROOT_URL; ?>images/dashboard/retina/sprite.svg#translate"></use>
            </svg>
        </button>
    </div>
</div>
<?php }
$optionValueFrm->setFormTagAttribute('class', 'form form--horizontal');
$optionValueFrm->setFormTagAttribute('onsubmit', 'setUpOptionValues(this); return(false);');
$optionValueFrm->developerTags['colClassPrefix'] = 'col-md-';
$optionValueFrm->developerTags['fld_default_col'] = 6;

$btnSubmit = $optionValueFrm->getField('btn_submit');
$btnSubmit->developerTags['col'] = '3';
$btnSubmit->addWrapperAttribute('class', 'col-6');
$btnSubmit->setFieldTagAttribute('class', 'btn btn-block btn-brand');

$btnClear = $optionValueFrm->getField('btn_clear');
$btnClear->developerTags['col'] = '3';
$btnClear->addWrapperAttribute('class', 'col-6');
$btnClear->setFieldTagAttribute('class', 'btn btn-block btn-outline-brand');
?>
<div class="box-head">
    <h6 class="h6"><?php echo isset($optionName) ? Labels::getLabel('LBL_CONFIGURE_OPTION_VALUES_FOR', $langId) . ' ' . $optionName : Labels::getLabel('LBL_CONFIGURE_OPTION_VALUES', $langId); ?></h6>
</div>
<div class="box-body">
    <?php
        echo $optionValueFrm->getFormHtml();
        ?>
    <div id="optionValuesListing"></div>
</div>