<?php defined('SYSTEM_INIT') or die ('Invalid Usage.'); ?>
<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<?php
$frmSearch->setFormTagAttribute('class', 'form form-search');
$frmSearch->setFormTagAttribute('onsubmit', 'search(this); return(false);');
$frmSearch->developerTags['colClassPrefix'] = 'col-md-';
$frmSearch->developerTags['fld_default_col'] = 4;

$startDate = $frmSearch->getField('start_date');
$startDate->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_Start_Date', $siteLangId));
$startDate->setFieldTagAttribute('class', 'date_js field--calender');

$endDate = $frmSearch->getField('end_date');
$endDate->setFieldTagAttribute('placeholder', Labels::getLabel('LBL_End_Date', $siteLangId));
$endDate->setFieldTagAttribute('class', 'date_js field--calender');

$submitBtnFld = $frmSearch->getField('btn_submit');
$submitBtnFld->setFieldTagAttribute('class', 'btn btn-brand btn-search btn-block');
$submitBtnFld->developerTags['col'] = 2;

$cancelBtnFld = $frmSearch->getField('btn_clear');
$cancelBtnFld->setFieldTagAttribute('onclick', 'clearSearch();');
$cancelBtnFld->setFieldTagAttribute('class', 'btn btn-gray btn-clear');
$cancelBtnFld->developerTags['col'] = 2;
?>


<?php $this->includeTemplate('_partial/seller/sellerDashboardNavigation.php'); ?>
<main id="main-area" class="main" role="main">
    <div class="content content-wrapper">
        <div class="content-header">
            <div class="content-header-title">
                <?php $this->includeTemplate('_partial/dashboardTop.php'); ?>
                <h2 class="content-header-heading">
                    <?php echo Labels::getLabel('LBL_Product_Returns', $siteLangId); ?>
                </h2>
            </div>
        </div>
        <div class="content-body">
            <div class="card card-tabs">
                <div class="card-head">
                    <ul class="nav nav-tabs tabs-grcustom navTabsJs">
                        <li class="nav-item <?php
                        if (FatApp::getAction() == 'upcomingProductReturns') {
                            echo "is-active";
                        }
                        ?>">
                            <a class="nav-link"
                                href="<?php echo UrlHelper::generateUrl('ProductReturns', 'upcomingProductReturns'); ?>">
                                <?php echo Labels::getLabel('LBL_Upcoming_product_returns', $siteLangId); ?>
                            </a>
                        </li>
                        <li class="nav-item <?php
                        if (FatApp::getAction() == 'overdueProductReturns') {
                            echo "is-active";
                        }
                        ?>">
                            <a class="nav-link"
                                href="<?php echo UrlHelper::generateUrl('ProductReturns', 'overdueProductReturns'); ?>">
                                <?php echo Labels::getLabel('LBL_Overdue_returns', $siteLangId); ?>
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body">
                    <?php echo $frmSearch->getFormHtml(); ?>
                </div>
                <div class="divider my-0"></div>
                <div class="card-table">
                    <div id="ordersListing"></div>
                    <?php /* <div id="loaderImage" style="display: none;">
               <div class="loader"></div>
               </div> */
                    ?>

                </div>
            </div>
        </div>
    </div>
</main>
<script>
$(document).ready(function() {
    $('.date_js').datepicker('option', {
        minDate: new Date()
    });
});
</script>